


c-------------------------------------------------------------------------
c AVS Interface  software suite
c developed by J. Kraak
c              University of Groningen
c              The Netherlands
c              J.Kraak@rc.rug.nl
c-------------------------------------------------------------------------

c****************************************************************************
c                 INTERNATIONAL AVS CENTER
c       (This disclaimer must remain at the top of all files)
c
cWARRANTY DISCLAIMER
c
cThis module and the files associated with it are distributed free of charge.
cIt is placed in the public domain and permission is granted for anyone to use,
c duplicate, modify, and redistribute it unless otherwise noted.  Some modules
c may be copyrighted.  You agree to abide by the conditions also included in
c the AVS Licensing Agreement, version 1.0, located in the main module
c directory located at the International AVS Center ftp site and to include
c the AVS Licensing Agreement when you distribute any files downloaded from
c that site.

c The International AVS Center, MCNC, the AVS Consortium and the individual
c submitting the module and files associated with said module provide absolutely
c NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
c the quality and performance of this software is with the user.  IN NO EVENT
c WILL The International AVS Center, MCNC, the AVS Consortium and the individual
c submitting the module and files associated with said module BE LIABLE TO
c ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
c WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
c SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

c This AVS module and associated files are public domain software unless
c otherwise noted.  Permission is hereby granted to do whatever you like with
c it, subject to the conditions that may exist in copyrighted materials. Should
c you wish to make a contribution toward the improvement, modification, or
c general performance of this module, please send us your comments:  why you
c liked or disliked it, how you use it, and most important, how it helps your
c work. We will receive your comments at avs@ncsc.org.
c 
c Please send AVS module bug reports to avs@ncsc.org.

c*****************************************************************************


c ********************************************************************
       subroutine AVSI_1D_scalar_real_uniform
     + (mthd, idnt, dim1, s)
c ********************************************************************
c visualize 1D data set s1(dim1) at uniform grid using the Graph Viewer
c mthd = visualisation method
c idnt   = first part of name of field files and network file
c mthd(1:1) = cnot (default '_') : no network, no AVS, only field
c idnt(1:1)  = cnot (default '_') : no AVS
c dim1               = 0           : no field
c dim1               < 0           : no .data generated, assumed
 
       INCLUDE 'AVSI_inc'
       integer dim1
       dimension s(dim1)
cmf$   layout s (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
c test parameters:
       call AVSI_tst('AVSI_1D_scalar_real_uniform',
     + mthd, idnt, method,ident,1,dim1,0,0,0)
       if(ierror.eq.1)                           RETURN

c generate AVS field <ident>.fld:
       call AVSI_1D1vf1cu (ident, dim1, s)

c generate module ?
       if(ident(1:2).eq.'_M')
     + call AVSI_modgen_u(ident, 1, dim1, 0,0,0)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end


c ********************************************************************
       subroutine AVSI_1D_scalar_real_rectilinear
     + (mthd, idnt, dim1, s, x)
c ********************************************************************
c Graph Viewer ...

       INCLUDE 'AVSI_inc'
       integer dim1
       dimension s(dim1), x(dim1)
cmf$   layout s (:serial)
cmf$   layout x (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_1D_scalar_real_rectilinear',
     + mthd, idnt, method,ident,1,dim1,0,0,0)
       if(ierror.eq.1)                           RETURN

c write ASCII input file for Graph Viewer with 2 columns ...
       call AVSI_1D1vf1cr (ident, dim1, s, x)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end

c ********************************************************************
       subroutine AVSI_2D_scalar_real_uniform
     + (mthd, idnt, dim1, dim2, s)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1, dim2)
cmf$   layout s (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_scalar_real_uniform',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_2D1vf2cu(ident, dim1, dim2, s)

c generate module ?
       if(ident(1:2).eq.'_M')
     + call AVSI_modgen_u(ident, 2, dim1, dim2,0,0)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end

c ********************************************************************
       subroutine AVSI_2D_scalar_real_rectilinear
     + (mthd, idnt, dim1, dim2, s, x, y)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1, dim2), x(dim1), y(dim2)
cmf$   layout s (:serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_scalar_real_rectilinear',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_2D1vf2cr(ident, dim1, dim2, s, x, y)


c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_2D_scalar_real_irregular
     + (mthd, idnt, dim1, dim2, s, xi, yi, zi)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1, dim2), xi(dim1, dim2), yi(dim1, dim2)
cmf$   layout s (:serial, :serial)
cmf$   layout xi (:serial, :serial)
cmf$   layout yi (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_scalar_real_irregular',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_2D1vf2ci(ident, dim1, dim2, s, xi, yi)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_scalar_real_uniform
     + (mthd, idnt, dim1, dim2, dim3, s)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3)
cmf$   layout s (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_scalar_real_uniform',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D1vf3cu( ident, dim1, dim2, dim3, s)

c generate module ?
       if(ident(1:2).eq.'_M')
     + call AVSI_modgen_u(ident, 3, dim1, dim2, dim3,0)


c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_scalar_real_rectilinear
     + (mthd, idnt, dim1, dim2, dim3, s, x, y, z)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3),
     + x(dim1), y(dim2), z(dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_scalar_real_rectilinear',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D1vf3cr( ident, dim1, dim2, dim3, s, x, y, z)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_scalar_real_irregular
     + (mthd, idnt, dim1, dim2, dim3, s, xi, yi, zi)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3),
     + xi(dim1, dim2, dim3), yi(dim1, dim2, dim3), zi(dim1, dim2, dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_scalar_real_irregular',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D1vf3ci( ident, dim1, dim2, dim3, s, xi, yi, zi)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_4D_scalar_real_uniform
     + (mthd, idnt, dim1, dim2, dim3, dim4, s4)
c ********************************************************************
c module time sampler

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3, dim4
       dimension s4(dim1, dim2, dim3, dim4)
cmf$   layout s4 (:serial, :serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_4D_scalar_real_uniform',
     + mthd, idnt, method,ident,4,dim1,dim2,dim3,dim4)

       if(ierror.eq.1)                           RETURN

       call AVSI_4D1vf4cu(ident,
     + dim1, dim2, dim3, dim4, s4)

c generate module ?
       if(ident(1:2).eq.'_M')
     + call AVSI_modgen_u(ident, 4, dim1, dim2, dim3, dim4)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end


c ***********************************************************************
       subroutine AVSI_2D_vector_real_uniform
     + (mthd, idnt, dim1, dim2, vx, vy)
c ***********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx( dim1, dim2), vy(dim1, dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_vector_real_uniform',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_TDTvf3cu( ident, dim1, dim2, vx, vy)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end


c ***********************************************************************
       subroutine AVSI_2D_vector_real_rectilinear
     + (mthd, idnt, dim1, dim2, vx, vy, x, y)
c ***********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx( dim1, dim2), vy(dim1, dim2), x(dim1), y(dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_vector_real_rectilinear',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_TDTvf3cr( ident, dim1, dim2, vx, vy, x, y)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end


c ***********************************************************************
       subroutine AVSI_2D_vector_real_irregular
     + (mthd, idnt, dim1, dim2, vx, vy, xi, yi)
c ***********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx( dim1, dim2), vy(dim1, dim2),
     + xi(dim1, dim2), yi(dim1, dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
cmf$   layout xi (:serial, :serial)
cmf$   layout yi (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_vector_real_irregular',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_TDTvf3ci( ident, dim1, dim2, vx, vy, xi, yi)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10
  
       end


c **********************************************************************
       subroutine AVSI_3D_vector_real_uniform
     + (mthd, idnt, dim1, dim2, dim3, vx, vy, vz)
c **********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1, dim2, dim3), vy(dim1, dim2, dim3),
     + vz(dim1, dim2, dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_vector_real_uniform',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D3vf3cu( ident, dim1, dim2, dim3, vx, vy, vz)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c **********************************************************************
       subroutine AVSI_3D_vector_real_rectilinear
     + (mthd, idnt, dim1, dim2, dim3, vx, vy, vz, x, y, z)
c **********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1, dim2, dim3), vy(dim1, dim2, dim3),
     + vz(dim1, dim2, dim3),
     + x(dim1), y(dim2), z(dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) mthd,idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_vector_real_rectilinear',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D3vf3cr( ident, dim1, dim2, dim3, vx, vy, vz,x,y,z)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c **********************************************************************
       subroutine AVSI_3D_vector_real_irregular
     + (mthd, idnt, dim1, dim2, dim3, vx, vy, vz, xi, yi, zi)
c **********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1, dim2, dim3), vy(dim1, dim2, dim3),
     + vz(dim1, dim2, dim3),
     + xi(dim1, dim2, dim3), yi(dim1, dim2, dim3), zi(dim1, dim2, dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_vector_real_irregular',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

       call AVSI_3D3vf3cu( ident, dim1, dim2, dim3,vx,vy,vz,xi,yi,zi)

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_2D_ss_real_uniform
     + (mthd, idnt, dim1, dim2, s1, s2)
c ********************************************************************
c 2 scalaire grootheden
c s1 via mesh en s2 via een kleur op mesh
c hiervoor moet speciaal een module geschreven worden ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s1(dim1, dim2), s2(dim1, dim2)
cmf$   layout s1 (:serial, :serial)
cmf$   layout s2 (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_ss_real_uniform',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_2D1vf2cu( ident, dim1, dim2, s1)

c write second scalar field ident//'1.fld' :
       i=length(ident)
       call AVSI_2D1vf2cu( ident(1:i)//'1', dim1, dim2, s2)
       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_2D_ss_real_rectilinear
     + (mthd, idnt, dim1, dim2, s1, s2, x, y)
c ********************************************************************
c 2 scalaire grootheden
c s1 via mesh en s2 via een kleur op mesh
c hiervoor moet speciaal een module geschreven worden ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s1(dim1, dim2), s2(dim1, dim2), x(dim1), y(dim2)
cmf$   layout s1 (:serial, :serial)
cmf$   layout s2 (:serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_ss_real_rectilinear',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_2D1vf2cr( ident, dim1, dim2, s1, x, y)
c write second scalar field ident//'1.fld' :
       i=length(ident)
       call AVSI_2D1vf2cr( ident(1:i)//'1', 
     + dim1, dim2, s2, x, y)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_2D_ss_real_irregular
     + (mthd, idnt, dim1, dim2, s1, s2, xi, yi)
c ********************************************************************
c 2 scalaire grootheden
c s1 via mesh en s2 via een kleur op mesh
c hiervoor moet speciaal een module geschreven worden ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s1(dim1, dim2), s2(dim1, dim2), xi(dim1, dim2),
     +  yi(dim1,dim2)
cmf$   layout s1 (:serial, :serial)
cmf$   layout s2 (:serial, :serial)
cmf$   layout xi (:serial, :serial)
cmf$   layout yi (:serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_2D_ss_real_irregular',
     + mthd, idnt, method,ident,2,dim1,dim2,0,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_2D1vf2ci( ident, dim1, dim2, s1, xi, yi)

c write second scalar field ident//'1.fld' :
       i=length(ident)
       call AVSI_2D1vf2ci( ident(1:i)//'1', 
     + dim1, dim2, s2, xi, yi)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_ss_real_uniform
     + (mthd, idnt, dim1, dim2, dim3, s1, s2)
c ********************************************************************
c 2 scalaire grootheden via isofurface en kleur daarop ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s1(dim1, dim2, dim3), s2(dim1, dim2, dim3)
cmf$   layout s1 (:serial, :serial, :serial)
cmf$   layout s2 (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_ss_real_uniform',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write field ident//'.fld' :
       call AVSI_3D1vf3cu( ident, dim1, dim2, dim3, s1)
c write field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D1vf3cu( ident(1:i)//'1', 
     + dim1, dim2, dim3, s2)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_ss_real_rectilinear
     + (mthd, idnt, dim1, dim2, dim3, s1, s2, x, y, z)
c ********************************************************************
c 2 scalaire grootheden via isofurface en kleur daarop ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s1(dim1, dim2, dim3), s2(dim1, dim2, dim3),
     + x(dim1), y(dim2), z(dim3)
cmf$   layout s1 (:serial, :serial, :serial)
cmf$   layout s2 (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_ss_real_rectilinear',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write field ident//'.fld' :
       call AVSI_3D1vf3cr( ident, dim1, dim2, dim3, s1, x, y, z)
c write field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D1vf3cr( ident(1:i)//'1', 
     + dim1, dim2, dim3, s2, x, y, z)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_ss_real_irregular
     + (mthd, idnt, dim1, dim2, dim3, s1, s2, xi, yi, zi)
c ********************************************************************
c 2 scalaire grootheden via isofurface en kleur daarop ...

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s1(dim1, dim2, dim3), s2(dim1, dim2, dim3),
     + xi(dim1, dim2, dim3), yi(dim1, dim2, dim3), zi(dim1, dim2, dim3)
cmf$   layout s1 (:serial, :serial, :serial)
cmf$   layout s2 (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

10     continue
       call AVSI_tst('AVSI_3D_ss_real_irregular',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write field ident//'.fld' :
       call AVSI_3D1vf3ci( ident, dim1, dim2, dim3, s1, xi, yi, zi)
c write field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D1vf3ci( ident(1:i)//'1', 
     + dim1, dim2, dim3, s2, xi, yi, zi)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_sv_real_uniform
     + (mthd, idnt, dim1, dim2, dim3, s, vx, vy, vz)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3), vx(dim1, dim2, dim3),
     + vy(dim1, dim2, dim3), vz(dim1, dim2, dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

c not for CM5:
c      entry AVSI_3Dsvru
c    + (method, ident, dim1, dim2, dim3, s, vx, vy, vz)

10     continue
       call AVSI_tst('AVSI_3D_sv_real_uniform',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_3D1vf3cu( ident, dim1, dim2, dim3, s)
c write vector field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D3vf3cu( ident(1:i)//'1', 
     + dim1, dim2, dim3,vx,vy,vz)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_sv_real_rectilinear
     + (mthd, idnt, dim1, dim2, dim3, s, vx, vy, vz, x, y, z)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3), vx(dim1, dim2, dim3),
     + vy(dim1, dim2, dim3), vz(dim1, dim2, dim3),
     + x(dim1), y(dim1), z(dim1)
cmf$   layout s  (:serial, :serial, :serial)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

c      entry AVSI_3Dsvrr
c    + (method, ident, dim1, dim2, dim3, s, vx, vy, vz, x, y, z)

10     continue
       call AVSI_tst('AVSI_3D_sv_real_rectilinear',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_3D1vf3cr( ident, dim1, dim2, dim3, s, x, y, z)
c write field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D3vf3cr( ident(1:i)//'1', 
     + dim1, dim2, dim3,vx,vy,vz,
     + x, y, z)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

       end


c ********************************************************************
       subroutine AVSI_3D_sv_real_irregular
     + (mthd, idnt, dim1, dim2, dim3, s, vx, vy, vz, xi, yi, zi)
c ********************************************************************
       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1, dim2, dim3), vx(dim1, dim2, dim3),
     + vy(dim1, dim2, dim3), vz(dim1, dim2, dim3),
     + xi(dim1, dim2, dim3), yi(dim1, dim2, dim3),
     + zi(dim1, dim2, dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) mthd, idnt
       character *(MAXS) method, ident

c      entry AVSI_3Dsvri
c    + (method, ident, dim1, dim2, dim3, s, vx, vy, vz, xi, yi, zi)

10     continue
       call AVSI_tst('AVSI_3D_sv_real_irregular',
     + mthd, idnt, method,ident,3,dim1,dim2,dim3,0)
       if(ierror.eq.1)                           RETURN

c write scalar field ident//'.fld' :
       call AVSI_3D1vf3ci( ident, dim1, dim2, dim3, s, xi, yi, zi)
c write vector field ident//'1.fld' :
       i=length(ident)
       call AVSI_3D3vf3ci( ident(1:i)//'1', 
     + dim1, dim2, dim3,vx,vy,vz
     + xi, yi, zi)

       iflds=2

c no module generation ...
       call AVSI_no_mod_gen(ident)

c display data according to method ...
       call AVSI_display(ident)
       if(irpt.eq.1)                           go to 10

c *0 vervangen door ./ident//.fld, *1 door ./ident//1.fld :

       end

   

c ********************************************************************
        subroutine AVSI_no_mod_gen(ident)
c ********************************************************************
        character *(*) ident
        if(ident(1:2).eq.'_M')
     +  print *,'>>> no module generation <<<'
        end


c ********************************************************************
        subroutine AVSI_initialize(ndir,fdir,disp,avsop)
c ********************************************************************
c initialize AVS Interface Routines
c ndir    = network directory
c fdir    = file        ,,
c disp    = IP address workstation
c avsop   = AVS command line options

       INCLUDE 'AVSI_inc'
       character *(*) ndir,disp,avsop,fdir


       print *  
       print *,'******** AVS Interface Routines **********'
c      print *,'********    Copyright (c) 1994  **********'
       print *,'************** version 3.0 ***************'
       print *,'******** University of Groningen *********'
       print *,'******* Groningen, The Netherlands *******'
       print *

10     continue
       if(ndir.eq.'*') then
          print *
          print *,'>>> enter name AVSI network directory : '
          read (*,'(a)') buf 
          ipr=1
       else
          buf = ndir
          ipr=0
       end if

c imd = length of network/ macro directory
       imd=length(buf)

c      if(buf.eq.'.') then
c nets in current directory, see AVSI_net
c         print *,'*** AVSI_error: networks in current directory'
c         print *,'***             not allowed ...'
c         if(ipr.eq.1) then
c                                                   go to 10
c         else
c            print *,'*** STOP'
c                                                   STOP
c         end if
c      end if

c network directory:
c      if(imd.eq.0) then
c         print *,'*** AVSI_intialize error :'
c         print *,'*** name AVSI network directory empty'
c         if(ipr.eq.1) then
c                                                   go to 10
c         else
c            print *,'*** STOP'
c                                                   STOP
c         end if
c      end if  

       cmacrodir=buf

c enquire AVSI network/macro directory:

       call AVSI_enquire_networks(buf,
c choice 1
     + cmacrodir,
c choice 2: $HOME/avsi/networks
     + '/avsi/networks',
c choice 3
     + '/usr/avs/AVSI_networks',
c choice 4, environment variable:
c define in C shell with setenv AVSI_NETWORKS <directory path>
     + 'AVSI_NETWORKS', ier)

       if(ier.eq.0 ) then

         print *,'*** AVSI_networks etc. from directory : ',
     +   buf(1:length(buf))

       else

         print *
         print *, '*** no AVSI_networks found in directory:'
         print *, '*** - ',
     +   cmacrodir(1:length(cmacrodir)),' (defined by AVSI_initialize)'
         call grgenv('HOME',buf,lbuf)
         if(lbuf.gt.0) 
     +   print *, '*** - ',buf(1:lbuf),'/avsi/networks'
         print *, '*** - /usr/avs/networks'
         print *, '*** - defined by environment variable AVSI_NETWORKS'
         call grgenv('AVSI_NETWORKS',buf,lbuf)
         if(lbuf.gt.0) then
            print *, '>>> AVSI_NETWORKS = ', buf(1:lbuf)
         else
            print *, '>>> AVSI_NETWORKS not defined'
         end if  

         print *
         
         if(ipr.eq.1) then
                                                    go to 10
         else
             print *,'*** STOP'
             print *
                                                    STOP
         end if
       end if
 
c imd = length of network/ macro directory
       imd=length(buf)
       cmacrodir=buf
       netdir=buf(1:imd)// '/'
       ind=length(netdir)

c local file directory 

20     continue
       if(fdir.eq.'*') then
          print *
          print *,'>>> enter name AVSI local file directory : '
          read (*,'(a)') buf 
          ipr=1
       else
          buf = fdir
          ipr=0
       end if

       ifd=length(buf)
       if(ifd.eq.0) then
          print *,'*** AVSI_intialize error :'
          print *,'*** local file directory name empty'
          if(ipr.eq.1) then
                                                    go to 20
          else
             print *,'*** STOP'
                                                    STOP
          end if
       end if  
       ldir=buf(1:ifd)// '/'
       ild=length(ldir)

c (optional) DISPLAY environment variable
       if(disp.eq.'*') then
          print *
          print *,'>>> enter DISPLAY name workstation : '
       print *,'(if not defined by DISPLAY environment variable)'
          read (*,'(a)') cdisp
          ipr=1
       else
          cdisp =disp
          ipr=0
       end if

       idp=length(cdisp)

c (optional) avs command line options:
c server option?
       if(avsop.eq.'*') then
          print *
          print *,'>>> enter AVS option(s), optional : '
          print *,'>>> (e.g. -nohw for AVS a remote X client,'
          print *,'>>>  or when you are using an X-terminal)'

          read (*,'(a)') cavsop
       else
         cavsop=avsop
       end if

       iop=length(cavsop)


c no transpose (for C and PASCAL, use AVSI_transpose):
       itranspose=0
c see AVSI_rcp:, AVSI_local_remove, AVSI_remote_remove :
       ilocrm=0
       iremrm=0
c local remove command:
       clocrm='rm'
       ilrm=length(clocrm)
c remote remove command:
       cremrm='rm'
       irrm=length(cremrm)
c initialize flag:
       init=1
c remote shell command , for HP remsh other : rsh ????
       crsh='rsh'
       irs=length(crsh)
c file(1:1)=cnot: do not start AVS,
c method(1:1)=cnot : no network, start AVS, only field:
       cnot='_' 
c no remote AVS host:
       chost=cnot
c nr. fields:
       iflds=1
c # texts
       itxt=0
c scrfipt file flag
       iscript=0
c parameter substiution in macro:
       cpar='&'
c unformatted field format :
       ibinary=1
c see AVSI_fld:
c computer dependant ????????? (works for SGI)
c but not according to AVS description of unformatted
       ibias=0
       ibts=4
c see AVSI_test
       mindim=2
       maxdim=1024
       maxstrl=80
c unit numbers:
c ask unit numbers free ?????
       idev=50
       idev1=idev+1
c unit # script file
       iunscr=idev+2
c add min_val and max_val to .fld file
       iminmax=0
c define debug output
       idebug=0
c network editor closed, see AVSI_def_network
c because of problems at the HP/math/rug/nl 
c Network not standard open (sorry)
c see AVSI_tst: make network visible in menu choice
       inetwork=0
c no server option
c to be changed by AVSI_init_client ...
       iserver=0
c repeat for method='*'
       irpt=0
       end
 

c --------------------------------------------------
       subroutine AVSI_enquire_networks(nwfl, first, second,
     + third, env, ier)
c --------------------------------------------------
c ENQUIRE network file, nwfl = first available network file
c first = first choice
c second = second choice
c third  = third choice
c env  = fourth choice , environment variable

      character *(*) nwfl, first, second,third, env
      logical q

      ier = 0

      nwfl=first(1:length(first))
c     print *,nwfl(1:length(nwfl))
c A3Dbar.net is just some file in the network directory ...
      INQUIRE(file=nwfl(1:length(nwfl))//'/A3Dbar.net', exist=q, err=10)
      if(q)                            return

      call GRGENV('HOME', nwfl, n)
c     print *,'HOME=',nwfl(1:length(nwfl))
      if(n.ne.0) then
         nwfl = nwfl(1:length(nwfl))//second(1:length(second))
c        print *,nwfl(1:length(nwfl))
         INQUIRE(file=nwfl(1:length(nwfl))//'/A3Dbar.net', exist=q,
     +   err=10)
         if(q)                            return
      end if

      nwfl=third(1:length(third))
c     print *,nwfl(1:length(nwfl))
      INQUIRE(file=nwfl(1:length(nwfl))//'/A3Dbar.net', exist=q, err=10)
      if(q)                            return

c get nwfl from environment variable env
      call GRGENV(env, nwfl, n)
c     print *,nwfl(1:length(nwfl))
      if(n.ne.0) then
         INQUIRE(file=nwfl(1:length(nwfl))//'/A3Dbar.net', exist=q,
     +   err=10)
         if(q)                            return
      end if

10    continue 
      ier = 1
      end


c ********************************************************************
        subroutine AVSI_init_client_local(ndir,fdir,process)
c ********************************************************************

c initialize AVS Interface Routines with AVS server at LOCAL HOST...
c ndir    = network directory
c fdir    = file        ,,
c process = AVS server process number

c start AVS  with -server option in sperate window ...
c use AVSI_close to stop AVS in server mode ...

       INCLUDE 'AVSI_inc'
       character *(*) ndir, fdir, process

c DISPLAY variable and AVS options specified by startup of
c AVS server:
       call AVSI_initialize(ndir,fdir,' ',' ')

       if(length(process).eq.0) then
          print *
          print *,'>>> AVSI_init_client_local error:'
          print *,'>>> server process number empty, STOP'
          print *
          STOP
       end if

       if(process.eq.'*') then
         print *
         print *,'*** AVSI_init_client_local'
         print *,
     +   '*** startup AVS server at LOCAL HOST '
         print *,
     +   '*** in seperate window with command: '
         print *,'*** avs -server <options>  '
         print *
         print *,'>>> enter AVS server process number :'
         read (*,'(a)') pid
       else
         pid=process
       end if

c set server flag:
       iserver=1
c no pause after AVSI_call:
       ipause=0

c open TCP connection to server:
c see file avsi_client.c or no_serverop.f
       call AVSI_build('localhost',pid)

       end


c **************************************************************
        subroutine AVSI_init_client_remote
     +  (ndir, dir, host,port,user,fdir)
c **************************************************************
c define remote AVS-server
c ndir    = local network directory
c  dir    = local working directory
c host    = remote host name
c          werkt '_' ? 
c port    = port number of remote AVS server
c user    = user name at remote host
c fdir    = remote file directory  
 
        INCLUDE 'AVSI_inc'
        character *(*) ndir, dir,host,port,user,fdir

c DISPLAY variable and AVS options specified by startup of
c AVS server:
       call AVSI_initialize(ndir,dir,' ',' ')

       if(host.eq.'*'.or.length(host).eq.0) then
         print *
         print *,'*** AVSI_init_client_remote'
         print *,
     +   '*** startup AVS server at REMOTE HOST '
         print *,
     +   '*** in seperate window with command: '
         print *,'*** avs -server <options>  '
          print *
          print *,'>>> enter remote host name : '
          read (*,'(a)') chost
       else
          chost=host
       end if
       ilh=length(chost)

       if(port.eq.'*'.or.length(port).eq.0) then
          print *
          print *,'>>> enter port number of remote AVS server : '
          read (*,'(a)') pid 
       else
          pid=port 
       end if

       if(user.eq.'*'.or.length(user).eq.0) then
          print *
          print *,'>>> enter user name for remote AVS host : '
          read (*,'(a)') cuser
       else
          cuser=user
       end if
       ilu=length(cuser)

       if(fdir.eq.'*'.or.length(fdir).eq.0) then
          print *
          print *,'>>> enter name remote AVSI file directory : '
          read (*,'(a)') buf 
       else
          buf = fdir
       end if

       ifd=length(buf)
       rdir=buf(1:ifd)// '/'
c ???????????????????
       if(rdir.eq.'~/') rdir='./'
       ird=length(rdir)

c set server flag:
       iserver=1
c no pause after AVSI_call:
       ipause=0

c open TCP connection to server:
c see file avsi_client.c
       call AVSI_build(chost,pid)

       end

c **************************************************************
        subroutine AVSI_close
c **************************************************************
c quit AVS in server mode
        INCLUDE 'AVSI_inc'
        if(iserver.gt.0) then
           if(ipause.eq.1) then
              print *
              print *,'>>> press Enter to close AVSI'
              read *
           end if
           call AVSI_client('quit')
        end if
        end
 
 
c **************************************************************
        subroutine AVSI_def_network(i)
c **************************************************************
c define network, i=0 : closed, i=1 : open 
c You can also open then Ntework Editor in the
c visualization menu, see section 3.1 of AVSI.txt.
c see AVSI_network
        INCLUDE 'AVSI_inc'
        inetwork=i
        end


c **************************************************************
        subroutine AVSI_def_pause(i)
c **************************************************************
c ipause=1 : prompt to cantinue for AVS server option,
c only for FORTRAN sure working ....
        INCLUDE 'AVSI_inc'
        ipause=i
        end

c **************************************************************
        subroutine AVSI_def_rsh(c)
c **************************************************************
c define remote shell command
c c='remsh' for HP platforms ....
        INCLUDE 'AVSI_inc'
        character *(*) c
        crsh=c
        irs=length(crsh)
        end

c **************************************************************
        subroutine AVSI_def_device(idv)
c **************************************************************
c define  device number idev ... idev+2
        INCLUDE 'AVSI_inc'
        idev=idv
        end

c **************************************************************
        subroutine AVSI_remove_local(rm)
c **************************************************************
c  remove at remote host
        INCLUDE 'AVSI_inc'
        character *(*) rm
        clocrm=rm
        ilrm=length(clocrm)
        ilocrm=1
        end

c **************************************************************
        subroutine AVSI_remove_remote(rm)
c **************************************************************
c  remove at remote host
        INCLUDE 'AVSI_inc'
        character *(*) rm
        cremrm=rm
        irrm=length(cremrm)
        iremrm=1
        end


c **************************************************************
        subroutine AVSI_remove
c **************************************************************
c  remove at local and remote host
        INCLUDE 'AVSI_inc'
        iremrm=1
        ilocrm=1
        end

c **************************************************************
        subroutine AVSI_remote(host,user,fdir)
c **************************************************************
c define remote AVS
c host    = remote host name
c user    = user name at remote host
c fdir    = file directory at remote host  
c host(1:1)=cnot( default '_') : back to local AVS
 
        INCLUDE 'AVSI_inc'
        character *(*) host,user,fdir

       if(length(host).eq.0) then
         print *,'*** AVSI_remote error :'
         print *,'*** remote AVS host name = empty, STOP'
         STOP
       end if  

       if(host.eq.'*') then
          print *
          print *,'>>> enter remote AVS host name : '
          read (*,'(a)') chost
       else
          chost=host
       end if
       ilh=length(chost)

       if(length(user).eq.0) then
         print *,'*** AVSI_remote error :'
         print *,'*** remote AVS user name = empty, STOP'
         STOP
       end if  

       if(user.eq.'*') then
          print *
          print *,'>>> enter user name for remote AVS host : '
          read (*,'(a)') cuser
       else
          cuser=user
       end if
       ilu=length(cuser)

       if(length(fdir).eq.0) then
         print *,'*** AVSI_remote error :'
         print *,'*** remote AVSI file directory = empty, STOP'
         STOP
       end if  

       if(fdir.eq.'*') then
          print *
          print *,'>>> enter name remote AVSI file directory : '
          read (*,'(a)') buf 
       else
          buf = fdir
       end if
       ifd=length(buf)
       rdir=buf(1:ifd)// '/'
c ???????????????????
       if(rdir.eq.'~/') rdir='./'
       ird=length(rdir)

       end


c ********************************************************************
       subroutine AVSI_def_macrochar(c)
c ********************************************************************
c define macro character, see _script_macro
       INCLUDE 'AVSI_inc'  
       character *1 c
       cpar=c
       end 

c ********************************************************************
       subroutine AVSI_def_debug(i)
c ********************************************************************
c define debug output
c idebug=1 : _net
       INCLUDE 'AVSI_inc'  
       idebug=i
       end

c ********************************************************************
       subroutine AVSI_def_bias(i)
c ********************************************************************
c define ibias for unformatted field, see _fld
       INCLUDE 'AVSI_inc'  
       ibias=i
       end

c ********************************************************************
       subroutine AVSI_def_maxstrl(i)
c ********************************************************************
c max string lengtrh, see _testh
       INCLUDE 'AVSI_inc'  
       maxstrl=i
       end

c ********************************************************************
       subroutine AVSI_def_dev(i)
c ********************************************************************
c device #s, see _initialize 
       INCLUDE 'AVSI_inc'  
       idev=i
       end

c ********************************************************************
       subroutine AVSI_def_maxdim(i)
c ********************************************************************
c max dimension of field, see _test
       INCLUDE 'AVSI_inc'  
       maxdim=i
       end


c ********************************************************************
         subroutine AVSI_def_not(c)
c *******************************************************************
       INCLUDE 'AVSI_inc'
       character *(*) c
       cnot=c
       end


c ********************************************************************
       subroutine AVSI_def_minmax(rmin, rmax)
c ********************************************************************
c see AVSI_fld, add min_val and max_val for scalar field
c see _fld
       INCLUDE 'AVSI_inc'  

c >>>>>>>>>>>> because of buf in AVS ......
       if(abs(rmin).gt.1000000 .or. abs(rmax).gt.1000000) then
         print *,'*** AVSI_minmax error :'
         print *,'*** abs(min_val) and/or abs(max_val) > 1000000 '
                                                     RETURN
       end if   
       rmin_val=rmin
       rmax_val=rmax
       iminmax=1
       end

c ********************************************************************
       subroutine AVSI_def_fieldformat(form)
c ********************************************************************
       INCLUDE 'AVSI_inc'  
       character *(*) form
       if (form.eq.'ASCII') then
          ibinary=0
       else if (form.eq.'UNFORMATTED') then
          ibinary=1
       else
          print *,'*** AVSI_def_fieldformat error : illegal parameter'
          print *,'*** ASCII assumed '
          ibinary=0
       end if 
       end


c ********************************************************************
       subroutine AVSI_display(ident)
c ********************************************************************
       INCLUDE 'AVSI_inc'
       character *(*) ident
       if(imth.eq.0) then
          if(chost.ne.cnot.and.idmm1.ne.0) then
c remote copy of field 
             call AVSI_rmt('Field',ident,' ')
          end if
       else
c         print *,'AVSI_display'
          call AVSI_net(ident,netnm(imth),nettp(imth))
       end if
       end

c ********************************************************************
       subroutine AVSI_tst(sname,mthd,idnt,method, ident, ndim,
     + dim1, dim2, dim3, dim4)
c ********************************************************************
c prompt for string if = '*'
c test input parameters
c maxdim, mindim, maxstrl defined in initialize ...

       INCLUDE 'AVSI_inc'
       character *(*) sname, mthd, idnt, method, ident
       integer dim1, dim2, dim3, dim4, dims(4)

       irpt = 0
       ierror=0
c to be compatible ...
       ivispr=0

       sfile=netdir(1:ind)//sname//'.mth'
       open(1,file=sfile,err=900, status='old')

       i=0
1      continue
       i=i+1  

c MAXMTH in initialze + set routine ...
       if(i.gt.MAXMTH) then
          print *,'*** AVSI_error: '
          print *,'*** more than ', MAXMTH,' entries in'
          print *,'*** visualization method specification file ',
     +    sname,'.mth'
                                            go to 10000
       end if

c read methode_name, net_method, net_type
       read(1,'(a30, a30,i2)', end=1001) mthnm(i), netnm(i), nettp(i)
                                                        go to 1
1001   continue

       close(1)
       
       nmth=i-1
       if(nmth.eq.0) then
          print *,'*** AVSI_error: '
          print *,'*** Empty visualization method specification file ',
     +    sname,'.mth'
                                             go to 10000
       end if

       if(mthnm(1).eq.'*') then
          print *,'*** AVSI_error: '
          print *,'*** No visualization method available for ',
     +    sname
                                             go to 10000
       end if


123      continue

c menu of methods?
       if(mthd.eq.'*') then
c >>>>>>>>>>>>>>> menu
         irpt=1
c override _init setting <<<<<<<
         inetwork=0
         print *
         print *,'>>> Visualization methods for ', sname
         print *

         print *,'>>>           0 :    Continue, no visualization '

         do 2 i=1, nmth
           print *,'>>>',i,' : ',mthnm(i)
2        continue

         print *,'>>>',nmth+1,' :    Only field, no visualization'
3        continue
         print *
         print *,  '>>> Enter visualization number (0-',nmth+1,') : '

         print *,'    (add - sign for Network Editor)'
         print *
             
c imth used by AVSI_display ...
         read *,imt
         imth=abs(imt)
         if(imth.lt.0.or.imth.gt.nmth+1) then 
            print *,'*** Illegal visualization number, repeat ...'
                                                 go to 3
         end if

c Continue ?
         if(imth.eq.0) then
            print *,'*** Continue ...'
                                             go to 10000
         end if  
 
         if( imth.eq.nmth+1) then
            print *,'***  Only field generated ...'
            imth=0
            method=cnot  
         else
            method=mthnm(imth)
c make network visible
            if(imt.lt.0) inetwork=1
         end if

c <<<<<<<<<<<<<<< menu

       else
c >>>>>>>>>>>>>>> specify vis. tech as parameter :
         irpt=0
         method=mthd
c test method and compute visualisation number imth:
         if(method(1:1).eq.cnot) then
c remote copy of field ?:
            imth=0
         else
            do 4 i=1,nmth
              if(method.eq.mthnm(i)) then
c imth used by AVSI_display ...
                 imth=i
                                     go to 5
              end if
4           continue
            print *,'*** AVSI_error : '
            print *,'*** ', method(1:length(method)),
     +      'is unknown visualization method'
                                     go to 10000
5        continue
         end if
c <<<<<<<<<<<<<<< specify vis. tech as parameter :
       end if

       if(netnm(imth).eq.'*') then
         print *,'*** AVSI_error: '
         print *,'*** Visualization method ',mthnm(imth),
     +   ' not yet implemented'
c repeat ?
         if(mthd.eq.'*')                     go to 123
                                             go to 10000
       end if

8      continue
       if (idnt.eq.'*') then
         print *
         print *,'>>> ',sname(1:length(sname))
         print *,'>>> enter AVSI file name :'
         read(*,'(a)')  buf
         ident=buf
         ipr=1
       else
         ident=idnt
         ipr=0
       end if


c no network and no field?
       if(method(1:1).eq.cnot .and. dim1.le.0)              go to 100

c test test string lengths:
       if(idebug.eq.1) print *,maxstrl, length(method), method
       if(length(method).eq.0.or.length(method).gt.maxstrl) go to 101
       if(length(ident) .eq.0.or.length(ident) .gt.maxstrl) go to 102

       if(dim1 .le.0 ) then
c no field?
          if( dim1.eq.0) then
             print *
             print *,'>>> No field generated (dim1 = 0) <<<'
                                                          RETURN
          else
c no .data
             print *
             print *,'>>> No .data file generated (dim1 < 0) <<<'
          end if
       end if
 
c test dimensions:
       dims(1)=abs(dim1)
       dims(2)=dim2
       dims(3)=dim3
       dims(4)=dim4
       do 10 i=1,ndim
         if(idebug.eq.1) print *,'dims(',i,') ',dims(i)
         if(dims(i).lt.mindim.or.dims(i).gt.maxdim)       go to 103
10     continue
                                                         RETURN

100    continue
       print *,'>>> AVSI: no network (_) and no field'
                                                  go to 110
101    continue
       print *,'>>> AVSI: error in visualization technique'
                                                  go to 110
102    continue
       print *,'>>> AVSI: error in file name'
       if(ipr.eq.1)                               go to 8
                                                  go to 110
103    continue
       print *,'>>> AVSI: error in dimension(s)'
       print *,'>>> ', mindim,' <= dimension <= ', maxdim

110    continue
       print *
       print *,'>>> error(s) in parameters of AVSI_routine <<<'
       print *,'>>> subroutine  = ',sname
       print *,'>>> vis. techn. = ', method(1:length(method))
       print *,'>>> file        = ', ident (1:length(ident ))
                     print *,'>>> dim1        = ',dim1
       if(ndim.ge.2) print *,'>>> dim2        = ',dim2
       if(ndim.ge.3) print *,'>>> dim3        = ',dim3
       if(ndim.ge.4) print *,'>>> dim4        = ',dim4
       print *

c set error flag
                                                     go to 10000 

900    print *,'>>> AVSI_error :'
       print *,'>>> Visualization method specification file ',
     + sname,'.mth',' not found'

10000  ierror=1

       end



c ********************************************************************
       subroutine AVSI_test(sname,mthd,idnt,method, ident, ndim,
     + dim1, dim2, dim3, dim4)
c ********************************************************************
c prompt for string if = '*'
c test input parameters
c maxdim, mindim, maxstrl defined in initialize ...

       INCLUDE 'AVSI_inc'
       character *(*) sname, mthd, idnt, method, ident
       integer dim1, dim2, dim3, dim4, dims(4)

       ierror=0

1      continue
       if(mthd.eq.'*') then
         print *
         print *,'>>> ',sname(1:length(sname))
         print *,'>>> enter AVSI visualization technique :'
         read (*,'(a)')  buf
         method=buf
         ivispr=1
c ierror=2 : error in tev. technique, see AVSI_else
       else
         method=mthd
         ivispr=0
       end if

2      continue
       if(idnt.eq.'*') then
         print *
         print *,'>>> ',sname(1:length(sname))
         print *,'>>> enter AVSI file name :'
         read(*,'(a)')  buf
         ident=buf
         ipr=1
       else
         ident=idnt
         ipr=0
       end if


c no network and no field?
       if(method(1:1).eq.cnot .and. dim1.le.0)              go to 100

c test test string lengths:
       if(idebug.eq.1) print *,maxstrl, length(method), method
       if(length(method).eq.0.or.length(method).gt.maxstrl) go to 101
       if(length(ident) .eq.0.or.length(ident) .gt.maxstrl) go to 102

c no field?
       if(dim1.eq.0)                                     RETURN

c test dimensions: 
       dims(1)=abs(dim1)
       dims(2)=dim2
       dims(3)=dim3
       dims(4)=dim4
       do 10 i=1,ndim
         if(idebug.eq.1) print *,'dims(',i,') ',dims(i)  
         if(dims(i).lt.mindim.or.dims(i).gt.maxdim)       go to 103
10     continue
                                                         RETURN

100    continue
       print *,'>>> AVSI: no network (_) + no field'
       if(ivispr.eq.1)                            go to 1
                                                  go to 110
101    continue
       print *,'>>> AVSI: error in visualization technique'
       if(ivispr.eq.1)                            go to 1
                                                  go to 110
102    continue
       print *,'>>> AVSI: error in file name'
       if(ipr.eq.1)                               go to 2
                                                  go to 110
103    continue
       print *,'>>> AVSI: error in dimension(s)'

110    continue 
       print *
       print *,'>>> error(s) in parameters of AVSI_routine <<<'
       print *,'>>> subroutine  = ',sname 
       print *,'>>> vis. techn. = ', method(1:length(method))
       print *,'>>> file        = ', ident (1:length(ident ))
                     print *,'>>> dim1       = ',dim1
       if(ndim.ge.2) print *,'>>> dim2       = ',dim2
       if(ndim.ge.3) print *,'>>> dim3       = ',dim3
       if(ndim.ge.4) print *,'>>> dim4       = ',dim4
       print *

c set error flag
       ierror=1

       end


c ********************************************************************
       subroutine AVSI_else(method, ident)
c ********************************************************************

       INCLUDE 'AVSI_inc'
       character *(*) method, ident

       if( method(1:3).eq. 'ZZZ' ) then
         i=length(method)
         call AVSI_net (ident, method(1:i)//'.net', -2)
       else if( method(1:1).eq.cnot ) then
c remote copy of field ?
         if(chost.ne.cnot.and.idmm1.ne.0)
     +   call AVSI_rmt('Field',ident,' ')        
       else
         print *,'*** AVSI_error: ', method(1:length(method)),
     +   ' is unknown visualization technique '
c ivispr defined by AVSI_test ...
         if(ivispr.eq.1) then
           print *,'>>> repeat ...'
           ierror=2
         end if 
       end if
  
       end


c ********************************************************************
         subroutine AVSI_net(name,net,ir)
c *******************************************************************
c
c generate new network <name(1:len(name))>.net

c net is name of network in the AVSI network directory

c ir = -1 :
c replace *0 by the ./name(1:len(name)).fld and *1 by ./<name>1.flda
c ir= -2:
c modify networks generated by Network Editor
c ir >= 0 :
c add parm_set for read field of Data Viewer network
c abs(ir)= module number of read field.

       INCLUDE 'AVSI_inc'
       character *(*) net, name
       character *(MAXS) avsbuf,fdir

c define directory for field:
       if(chost.eq.cnot) then
c local
          fdir=ldir
       else
c remote
          fdir=rdir
       end if

c because of CM5 compiler error :
       in=length(name)
       ifd=length(fdir)

       if(idebug.eq.1) print *,'fdir1=',fdir

       if(ir.eq.-1) then

c >>>>>>> replace *0 in networks A*  (own made)
c no other parameters ....

       file= ldir(1:ild)//name(1:in)//'.net'
       print *,'*** AVS network file = ', file(1:length(file))

       call AVSI_opnfl(idev, name, '.net','f')

       sfile=netdir(1:ind)//net
       open(idev1,file= sfile,err=1000,status='old')

10     continue
       read(idev1,'(a)', end=2000) buf
       i=index(buf, '*')
       if(i.eq.0) then
c no parameter
          write(idev,'(a)') buf(1:length(buf))
c version?
c         if(index(buf,'version').ne.0) then
c          call AVSI_network
c         end if
        else
          kparm=ichar(buf(i+1:i+1))-ichar('0')
          if(kparm.eq.0) then
c replace *0 by  ./field name(1:len(name))
             buff= buf(1:i-1) // 
     +       fdir(1:ifd)//name(1:in)//'.fld'
          else if (kparm.eq.1) then
c add second field name(1:len(name)): (>>>>> 1 <<<<<<)
             buff= buf(1:i-1) // 
     +       fdir(1:ifd)//name(1:in)//'1.fld'
          else
             print *,' >>> AVSI_net error, kparm > 1, STOP'
             STOP
          end if
c of buff(1:i+19)???
          write(idev,'(a)') buff(1:length(buff))
        end if
                                                   go to 10
2000    continue
        close(idev)
        close(idev1)
c add ldir/rdir later ....
        snet=name(1:in)//'.net'
c >>>>>>>>>>>>>> replace *0

        else if(ir.eq.-2) then

C >>>>>>>>>>>>>>>>>>>>>>>>>>> modified network, replace fieldname(1:len(name))
c  for AVS nets ...

       file= ldir(1:ild)//name(1:in)//'.net'
       print *,'*** AVS network file = ', file(1:length(file))

       call AVSI_opnfl(idev, name, '.net','f')

       sfile=netdir(1:ind)//net
       open(idev1,file= sfile,err=1000,status='old')
       ifld=0

11     continue
       read(idev1,'(a)', end=3000) buf
       i=index(buf, 'parm_set "read field.user')
       if(i.eq.0) then
c no parm_set :
          write(idev,'(a)') buf(1:length(buf))
c version?
c         if(index(buf,'version').ne.0) then
c          call AVSI_network
c         end if
       else
c modify parm_set:
          ifld=ifld+1
          i=index(buf, 'Browser')
          if(ifld.eq.1) then
             buff= buf(1:i+8) // 
     +       fdir(1:ifd)//name(1:in)//'.fld'
          else
c add second field name(1:len(name)): (>>>>> 1 <<<<<<)
             buff= buf(1:i+7) // 
     +       fdir(1:ifd)//name(1:in)//'1.fld'
          end if
          write(idev,'(a)') buff(1:length(buff))
c            print *, buff
       end if
                                                   go to 11
3000   continue
       close(idev)
       close(idev1)
       snet=name(1:in)//'.net'

c >>>>>>>>>>>>>>>>>>>>>>>>>>> modified network

       else

c >>>>>>>>>>>>>> add parm_set .... for DV network


        call AVSI_opnfl(idev, name, '.scratch','f')

        buff=fdir(1:ifd)//name(1:in)//'.fld'

        if(ir.lt.10) then
          write(buf,'(
     +    ''parm_set "read field.user.'',i1,
     +    ''":"Read Field Browser" '', a)' ) ir,buff(1:length(buff))
        else
          write(buf,'(
     +    ''parm_set "read field.user.'',i2,
     +    ''":"Read Field Browser" '', a)' ) ir,buff(1:length(buff))
        end if

        write(idev,'(a)') buf(1:length(buf))
c       call AVSI_network

        close(idev)

        if(netdir.eq.ldir)  then
c networks in same directory, add S to name(1:length(name)):
           snet=name(1:in)//'S.net'
        else
           snet=name(1:in)//'.net'
        end if

        isn=length(snet)
        buff=ldir(1:ild)// snet(1:isn)
        ibuff=length(buff)
        print *,'*** AVS network file = ',
     +  buff(1:ibuff)

c use Data Viewer network from system directory /usr/avs/...
c in case op copyright problems ...
c mind remote use of AVS ...
        buff=ldir(1:ild)//name(1:in)//'.scratch'
        ibuff=length(buff)
        write(buf,'(''cat '',a,a,'' '',a,'' > '',a)')
     +  netdir(1:ind), net,
     +  buff(1:ibuff),
     +  ldir(1:ild)//snet(1:isn)
        call system(buf)

c >>>>>>>>>>>>>> add parm_set .... for DV network
        end if

c avs startup command line:

        isn=length(snet)
        if(inetwork.eq.0) then
c network closed
           avsbuf='avs -network '//
     +     fdir(1:ifd)//snet(1:isn)
        else
c network open
c 'present "Network Editor" -open'
           buff=ldir(1:ild)//name(1:in)//'.cli'
           ibuff=length(buff)
           print *,'*** AVS CLI-script file = ',
     +     buff(1:ibuff)

           call AVSI_opnfl(idev, name, '.cli','f')
           write(idev,'(''present "Network Editor" -open'')')
           write(idev,'(''net_read '',a)')
     +     fdir(1:ifd)//snet(1:isn) 
           close(idev)
           avsbuf='avs -cli "script -play '//
     +     fdir(1:ifd)//name(1:in)//'.cli'//'"'
        end if
         
c debug output ...
       if(idebug.eq.1) then
          print *,' fdir = ', fdir(1:length(fdir))
          print *,' snet = ', snet(1:length(snet))
          print *,' avsbuf = ', avsbuf(1:length(avsbuf))  
       end if  

c add display:
       iavs=length(avsbuf)
        if(cdisp.ne.' ') then
c only IP address? 
           if(index(cdisp,':').eq.0) then
c add :0 to be upward compatible
              cdisp=cdisp(1:idp)//':0'
              idp=idp+2
           end if
           avsbuf=avsbuf(1:iavs)//
     +     ' -display '//cdisp(1:idp)
        end if

c add avs command line options:
        iavs=length(avsbuf)
        if(cavsop.ne.' ')
     +  avsbuf=avsbuf(1:iavs)//
     +  ' '//cavsop(1:iop)
        iavs=length(avsbuf)

c no AVS ?
        if(name(1:1).eq.cnot)         RETURN

        if(iserver.eq.0) then
c >>>>>>>> no AVS server   
        if(chost.eq.cnot) then
c local
          print *, avsbuf(1:iavs)
          print *
          print *,'>>>>>>>> begin local AVS'
          print *
          call system(avsbuf)

          if(ilocrm.eq.1) then
            buf=clocrm(1:ilrm)//' '//
     +      ldir(1:ild)//name(1:in)//'*'
            call system(buf)
            print *,buf(1:length(buf))
          end if  

          print *
          print *,'<<<<<<<< end   local AVS'
          print *
        else
c remote
c put files to remote platform using rcp and 
c start AVS using rsh (remsh for HP):
c         print *,'.... remote, no server ....'
          call AVSI_rmt(' ',name,avsbuf)
        end if

c >>>>>>>>>>>>> no AVS server

        else

c >>>>>>>>>>>>> AVS server

        if(chost.eq.cnot) then
c >>>> local AVS server option
          print *,'....... local server ...'
            if(iserver.gt.1) then
               if(ipause.eq.1) then
                  print *
                  print *,'>>> press Enter to continue '
                  read *
               end if
               call AVSI_client('net_clear')
c after this command CLI has synchronization problems: 
c messages like 'Server command failed' appear,
c but the working of AVS is o.k. 
c so, ignore these messages for the moment .....
c 
            end if
            if(inetwork.eq.1)
     +      call AVSI_client('present "Network Editor" -open')
            isn=length(snet)
            call AVSI_client('net_read '//
     +      fdir(1:length(fdir))//snet(1:isn))
            iserver=iserver+1
c <<<< local AVS server option

          else
c >>>>>>>>>>>> remote AVS server
             print *,'........ remote server'
             call AVSI_rmt(' ',name,avsbuf)
c <<<<<<<<<<<< remote AVS server
         end if  

         end if

c <<<<

                                          return
1000    continue
        print *,'*** AVSI_net error : unknown network ',net
        end


c ********************************************************************
         subroutine AVSI_rcp(fn)
c *******************************************************************
c rcp fn in directory ldir to remote host in directory rdir
c NOTE : rdir = ~ changed to rdir = .
c I forgot the reason .... JK 16-11-1994

       INCLUDE 'AVSI_inc'
       character *(*)  fn

       buff='rcp '// 
     + ldir(1:ild)//fn//' '//cuser(1:ilu)//
     + '@'//chost(1:ilh)//':'//
     + rdir(1:ird)// fn
       print *,buff(1:length(buff))
       call system(buff)

c remove local files?
       if (ilocrm.eq.1) then
         buf=clocrm(1:ilrm)//' '//
     +   ldir(1:ild)//fn
         call system(buf)
         print *,buf(1:length(buf))
       end if

       end


c ********************************************************************
         subroutine AVSI_rmt(method,name,avsbuf)
c *******************************************************************
c send AVSI_files to remote computer using  rcp
c method(1:1) = cnot : only field, no net, avs startup file.
c avsbuf             : avs starup command line

       INCLUDE 'AVSI_inc'
       character *(*)  method,name,avsbuf

       in=length(name)
       iavs=length(avsbuf)

          if(idmm1.ne.0) then
c >>>>>>>>>>>>> write field
c >>>>>>>>>>>>> write first field
          print *
          call AVSI_rcp(name(1:in)//'.fld')
c write data?
          if(idmm1.gt.0)
     +    call AVSI_rcp(name(1:in)//'.data')

c igrid defined in AVSI_hdr, igrid=0 : uniform
          if(igrid.eq.1) then
c rectilinear grid:
             call AVSI_rcp(name(1:in)//'.rect')
          else if (igrid.eq.2) then
c irregular grid:
             call AVSI_rcp(name(1:in)//'.irreg')
          end if
c <<<<<<<<<<<<<< write first field

          if(iflds.eq.2) then
c >>>>>>>>>>>>> write second field
          print *
          call AVSI_rcp(name(1:in)//'1.fld')
c write data?
          if(idmm1.gt.0)
     +    call AVSI_rcp(name(1:in)//'1.data')

c igrid defined in AVSI_hdr, igrid=0 : uniform
          if(igrid.eq.1) then
c rectilinear grid:
             call AVSI_rcp(name(1:in)//'1.rect')
          else if (igrid.eq.2) then
c irregular grid:
             call AVSI_rcp(name(1:in)//'1.irreg')
          end if
c <<<<<<<<<<<<<< write second field
          end if
c <<<<<<<<<<<<<< write field
          end if 

c only remote field?? 
c see AVSI_else
          if(method.eq.'Field')               RETURN

          call AVSI_rcp(name(1:in)//'.net')

c no  remote AVS start?
          if(name(1:1).eq.cnot)                   RETURN

        if(iserver. eq.0 ) then

c >>>>>>>>>>> no verser option

c generate remote avs startup file: 

         call AVSI_opnfl(idev1,name,'.avs','f')  

c remote avs startup command line:
         write(idev1,'(a)') avsbuf(1:iavs)


c remove remote files?
         if(iremrm.eq.1) then
            buf=cremrm(1:irrm)//' '//
     +      rdir(1:ird) // name(1:in)//'*'
            write(idev1,'(a)') buf(1:length(buf))
         end if

         close(idev1)
         call AVSI_rcp(name(1:in)//'.avs')
         
c with network?
         if(inetwork.eq.1) then
            call AVSI_rcp(name(1:in)//'.cli')
         end if


c start AVS using remote shell command in root
c add '~/' ???????/
          file=crsh(1:irs)//' '//
     +    chost(1:ilh)//' -l '//
     +    cuser(1:ilu)//
     +    ' ''chmod +x '
     +    //rdir(1:ird)//name(1:in)//'.avs'''
          print *,file(1:length(file))
          call system(file)

          file=crsh(1:irs)//' '//
     +    chost(1:ilh)//' -l '//
     +    cuser(1:ilu)//
     +    ' '//rdir(1:ird)//name(1:in)//'.avs'
          print *,file(1:length(file))


c print avs startup file: 
          print *
          print *,'>>>>>>>> begin remote AVS'
          print *
          print *,avsbuf(1:iavs)
          print *

c execute remote call:
          call system(file)

c <<<<<<<<<< no verser option

          else

c >>>>>>>>>> server option
         if(iserver.gt.1) then
            if(ipause.eq.1) then
               print *
               print *,'>>> press Enter to continue '
               read *
            end if
            call AVSI_client('net_clear')
c after this comm/
c and CLI has synchronization problems: 
c messages like 'Server command failed' appear,
c but the working of AVS is o.k. 
c so, ignore these messages for the moment .....
c 
         end if

         if(inetwork.eq.1)
     +   call AVSI_client('present "Network Editor" -open')

         isn=length(snet)
c        print *,'CLI server command = '
         call AVSI_client('net_read '//
     +   rdir(1:length(rdir))//name(1:in)//'.net')
         iserver=iserver+1

c <<<<<<<<<< server option

          end if

          if(iremrm.eq.1) then
c >>> begin remove
          print *
          print *,'*** remote remove :'
          buf=cremrm(1:irrm)//' '//
     +    rdir(1:ird) // name(1:in)//'*'
          print *, buf(1:length(buf))
c <<< end remove
          else
             print *
             print *,'no remote files removed'
          end if
          print *
          print *,'<<<<<<<< end remote AVS'
          print *

        end

c **************************************************************
       integer function length(c)
c **************************************************************
       character *(*) c
       i=len(c)+1
10     i=i-1
       if(i.eq.0)                 go to 100
       if(c(i:i).ne.' ')          go to 100
                                  go to 10 
100    length=i
       end 


c --------------------------------------------------------------
      SUBROUTINE ZPRMDS(A)
c --------------------------------------------------------------
c called by example programs ...
      DIMENSION A(20,20),P(10,10),H(4)
c     DATA H / 1.5,2.0,1.0,0.5 /
C      CONSTRUCT PYRAMID IN P ---
      NN=10
       H(1)=1.5
       H(2)=2.0
       H(3)=1.0
       H(4)=0.5
       NMIN=0
       NMAX=NN+1
       KMAX=NN/2
       KSTEP=1
       Z=-1.
       DO 200 K=1,KMAX,KSTEP
           Z=Z+1.
           NMI=NMIN+K
           NMA=NMAX-K
           DO 200 I=NMI,NMA
           DO 200 J=NMI,NMA
               P(I,J)=Z
200    CONTINUE
C      END PYRAMID ---
C
C      FOUR PYRAMIDS IN A USING THE PYRAMID IN P AND THE HEIGHTS IN H
      M=0
      DO 500 K=1,2
      DO 500 L=1,2
         M=M+1
         LX=(K-1)*NN
         DO 400 I=1,NN
            LX=LX+1
            LY=(L-1)*NN
            DO 400 J=1,NN
               LY=LY+1
               A(LX,LY)=P(I,J)*H(M)
400      CONTINUE
500   CONTINUE
C
      END

C ***********************************************************************
       subroutine AVSI_script_open(fle)
C ***********************************************************************
c open script file (fle) for CLI commands
c macros in netdir defined by AVSI_initialize

       INCLUDE 'AVSI_inc'
       character *(*)  fle
c parameter substiution in macro:
c      cpar='&'
c see AVSI_initialize and def_macro_char ....
       iscript=1
c iunscr defined in AVSI_initialize
       open(iunscr,file=fle(1:length(fle)),status='unknown')

       end
 
C ***********************************************************************
       subroutine AVSI_script_string(string)
C ***********************************************************************
c write string to script file

       INCLUDE 'AVSI_inc'
       character *(*)  string
       write(iunscr,'(a)') string(1:length(string))
       end


C ***********************************************************************
       subroutine AVSI_script_macro (macro, nparm, parm)
C ***********************************************************************
c insert parameters in CLI macro (in cmacrodir)
c and add macro to script file specified by AVSI_open_script
c >>>>>> empty parameters allowed ....
c    form &1,...,&9, &10&, &11&, .......
c    pas op by kparm >=10 aan einde extra & toevoegen ......


       INCLUDE 'AVSI_inc'
       character *(*) macro 
c      character *(MAXS) buf,buff
       character *(*) parm(*)

       if(iscript.eq.0) then
          print *,'*** AVSI_macro error : no script file open'
          print *,'*** macro = ',macro 
                                               RETURN
       end if 

       imc=length(macro)
c cmacrodir defined in AVSI_initialize ....
       buf=cmacrodir(1:imd)//'/'//
     + macro(1:imc)
c      print *,'macro=', buf
       open(idev, file=buf, status='old',err=2000)

c read line of macro:
10     continue
       read(idev,'(a)',end=1000) buf

20     continue
       lbuf=length(buf)

       i=index(buf,cpar)
c no parameter (left) to be substituted?
       if(i.eq.0) then
c write line to script file:
          write(iunscr,'(a)') buf(1:length(buf))
c read next line of macro
                                               go to 10
       end if

       kparm=ichar(buf(i+1:i+1))-ichar('0')
       if(kparm.lt.1.or.kparm.gt.9) then
         print *,'*** AVSI_error :'
         print *,'*** illegal use of parameter character ',
     +   cpar, ' in line :'
         print *,buf(1:length(buf))
         print *,'macro = ',macro(1:imc)
                                              go to 1000
       end if
       idel=0
c 9< parameter  < 99 closed by second $ ?
       if(i+3.le.lbuf) then
          if(buf(i+2:i+2).ge.'0'.and.buf(i+2:i+2).le.'9'
     +       .and. buf(i+3:i+3).eq.cpar) then
             idel=2
             kparm=10*kparm+ ichar(buf(i+2:i+2))-ichar('0')
          end if
       end if
  
       if(kparm.gt.nparm) then
          print *,'*** AVSI_macro error : illegal parameter '
          print *,'*** macro = ',macro,kparm,' > ',nparm 
                                               go to 1000
       end if

       lparm=length(parm(kparm))
       if(lparm.eq.0) then
          buff=buf(1:i-1)
          ilbff=length(buff)
          if(lbuf.gt.i+1+idel) buff=buff(1:ilbff)//   
     +    buf(i+2+idel:lbuf)
          buf=buff
                                                go to 20
       end if
       if(lbuf+lparm-(2+idel).gt.MAXS) then
          print *,'*** AVSI_macro error : string overflow'
          print *,'*** macro = ',macro 
                                               go to 1000
       end if

       buff=buf(1:i-1)//parm(kparm)(1:lparm)
       if(lbuf.gt.i+1+idel) then
           ilbff=length(buff)
           buff=buff(1:ilbff)//buf(i+2+idel:lbuf)       
       end if
       buf=buff

c substitute possible next parameter:
                                               go to 20                                                
c end of macro:
1000   continue
       close(idev)
                                               return
2000   print *,'*** AVSI_script_macro error :'
       print *,' unknown macro ',macro(1:imc)

       end        

c ****************************************************************
       subroutine AVSI_image_label( img,txt, tx, ty, height, r, g, b,
     + ifont, ibold, italic, ijustify)
c ****************************************************************
c .........obsolete  .............

c image label, using macro imlab.mcr
c txt <= 80

c image_label_name -image $12$ -label "$1"
c image_label_transformation -image $12$ -label "$1" -tx $2 -ty $3
c image_label_height -image $12$ -label "$1"  $4
c image_label_color -image $12$ -label "$1"  $5 $6 $7
c image_label_attributes -image $12$ -label "$1" -font_num  $8
c image_label_attributes -image $12$ -label "$1" -bold $9
c image_label_attributes -image $12$ -label "$1" -italic  $10$
c image_label_attributes -image $12$ -label "$1" -justify $11$

       parameter (MAXL=80)
       INCLUDE 'AVSI_inc'
       character *(*) img, txt
       character *(MAXL) parm(12)

       ltxt=length(txt)
       if(ltxt.gt.MAXL) then
          print *,'*** error in AVSI_image_label :'
          print *,'*** label > ',MAXL,' characters'
                                                RETURN
       end if 
       parm(1)=txt(1:ltxt)
c tx, ty
       write(parm(2),'(f10.2)') tx
       write(parm(3),'(f10.2)') ty
c height
       write(parm(4),'(f10.2)')  height
c r,g,b
       write(parm(5),'(f10.2)') r
       write(parm(6),'(f10.2)') g
       write(parm(7),'(f10.2)') b
c label attributes
       write(parm(8),'(i3)') ifont
       write(parm(9),'(i3)') ibold
       write(parm(10),'(i3)') italic
       write(parm(11),'(i3)') ijustify
       parm(12)=img(1:length(img))

       call AVSI_script_macro('imlab.mcr',12,parm)

       end

C ***********************************************************************
       subroutine AVSI_script_close
C ***********************************************************************
 
       INCLUDE 'AVSI_inc'
 
       if(iscript.eq.1) then
          close (iunscr)
          iscript=0
       end if  
 
       end

c --------------------------------------------------------------------
         subroutine AVSI_fields_to_images(name,i1,i2,net,ir,iwf)
c --------------------------------------------------------------------

c this routine applies the AVSI_script routines ...
c concept ....

c This subroutine converts a series of AVS-fields  to a
c a series of images for video recording using some
c SELF defined network. Internally, this routine
c generates a script (name.cli) for a network (net) 
c consisting of parm_settings for READ FIELD and WRITE IMAGE.
c After that, AVS is started using this script file.

c mdir is the macro directory used by AVSI_script_open

c name, i1, i2 define the series of AVS fields generated by 
c (previous) AVSI_calls:
c name.<i1>.fld, name.<i1+1>.fld, ..., name.<i2>.fld
c These fields are converted to the image series:
c name.<i1>.x, name.<i1+1>.x, ..., name.<i2>.x

c net, ir, iwf define the network to convert the fields to a
c a series of images 
c net is the name of the network starting with READ FIELD
c and ending with WRITE IMAGE or WRITE_ANY_IMAGE .....

c                  READ FIELD
c                     |
c                ...........
c                     |
c                 WRITE IMAGE  

c ir              is the module number    READ FIELD  in net
c abs(iwf) (<100) is the module number of WRITE IMAGE in net   
c iwf > 0 : network is copied from (local) network directory as
c defined by AVSI_initialize. This network is sent to
c remote host for remote use.
c iwf < 0 : network must allready be in your local or remote
c 'working' directory
 
c net(1:1)='_' : no AVS execution

         character *(*) name, net
         integer ir,iwf,i1,i2
         INCLUDE 'AVSI_inc'
         character *(MAXS)  avsbuf,parm(2)
         character *(20) avsopt

c do not use the next AVS options in your AVSI_intialize call :
         avsopt='-nohw -cli'

         if(.not.(i1.ge.1000.and.i2.ge.1000)) then
           print *,'*** AVSI_fields_to_images error :'
           print *,'*** ibegin / iend < 1000 '
                                                RETURN
         end if

         in=length(name)
         ilnet=length(net)
         iw=abs(iwf)

c open script file :

         call AVSI_script_open(name(1:in)//'.cli')

c define network :

         if(iwf.lt.0) then
c network in same directory as fields ....
            if(chost.eq.cnot) then
c local
               parm(1)=ldir(1:ild)//net
            else
c remote 
               parm(1)=rdir(1:ird)//net
            end if
        else
c networks in local network directory
            if(chost.ne.cnot) then
c copy network to local directory for AVSI_rcp ...
             buf='cp '//netdir(1:ind)//
     +                  net(1:ilnet)//' '//
     +             ldir(1:ild)//net(1:ilnet)
             print *,buf(1:length(buf))
             call system (buf)
c rcp network to directory rdir of remote host ...
c _rcp does optionally a local remove ...
             call AVSI_rcp(net(1:ilnet))
             parm(1)=rdir(1:ird)//net
           else
             parm(1)=netdir(1:ind)//net
           end if
        end if   

c CLI command to read network :

        call AVSI_script_macro('read_net.mcr',1,parm(1))

c generate parm settings of READ FIELD and WRITE IMAGE for network :

         do 100 i=i1,i2
           buf=name(1:in)//'.'
           lbf=length(buf)
c  READ FIELD
           if(ir.lt.10) then
              write(parm(1),'(i1)') ir
           else
              write(parm(1),'(i2)') ir
           end if
           write(parm(2),'(a,i4,''.fld'')') buf(1:lbf),i
           call AVSI_script_macro('read_fld.mcr',2,parm)

c   WRITE IMAGE:
           if(ir.lt.10) then
              write(parm(1),'(i1)') iw
           else
              write(parm(1),'(i2)') iw
           end if
c image file name:
           write(parm(2),'(a,i4,''.x'')') buf(1:lbf),i
           call AVSI_script_macro('wrim.mcr',2,parm)

c this is macro wrim.mcr :
c parm_set "write image.user.&1":"Write Image Browser" ./&2

100      continue

         call AVSI_script_close

       if(net(1:1).eq.cnot)                     RETURN

c generate avsbuf to start AVS:

c  avs .... -cli "script -play <script file name>"
       avsbuf='avs '

c add display:
       iavs=length(avsbuf)
        if(cdisp.ne.' ')
     +  avsbuf=avsbuf(1:iavs)//
     +  ' -display '//cdisp(1:idp)//':0'
       iavs=length(avsbuf)
c add avs command line options:
        if(cavsop.ne.' ')
     +  avsbuf=avsbuf(1:iavs)//
     +  ' '//cavsop(1:iop)

c >>>> avsopt defined above, application dependent ......

       iavs=length(avsbuf)
       iopt=length(avsopt)

       avsbuf=avsbuf(1:iavs)//' '//
     +  avsopt(1:iopt)//
     +  ' "script -play '//
     +  name(1:in)//'.cli -q"'

       iavs=length(avsbuf)

        if(chost.eq.cnot) then
c >>>>>>>>>>>>>>>>>>>>> local AVS
          print *, avsbuf(1:iavs)
          print *
          print *,'>>>>>>>> begin local AVS'
          print *
          call system(avsbuf)

          if(ilocrm.eq.1) then
            buf=clocrm(1:ilrm)//' '//
     +      ldir(1:ild)//name(1:in)//'*'
            call system(buf)
            print *,buf(1:length(buf))
          end if

          print *
          print *,'<<<<<<<< end   local AVS'
          print *

c <<<<<<<<<<<<<<<<<<<<<<< local AVS

        else

c >>>>>>>>>>>>>>>>>>>>>>> remote AVS

c put files to remote platform using rcp and
c start AVS using rsh (remsh for HP):

        call AVSI_rcp(name(1:in)//'.cli')

c generate remote avs startup file:
         call AVSI_opnfl(idev1,name,'.avs','f')

c remote avs startup command line:
         iavs=length(avsbuf)
         write(idev1,'(a)') avsbuf(1:iavs)
         print *,avsbuf(1:iavs)

c remove remote files?
         if(iremrm.eq.1) then
            buf=cremrm(1:irrm)//' '//
     +      rdir(1:ird) // name(1:in)//'*'
            write(idev1,'(a)') buf(1:length(buf))
            print *,buf
         end if

         close(idev1)
         call AVSI_rcp(name(1:in)//'.avs')

c start AVS using remote shell command in root
          file=crsh(1:irs)//' '//
     +    chost(1:ilh)//' -l '//
     +    cuser(1:ilu)//
     +    ' ''chmod +x '
     +    //rdir(1:ird)//name(1:in)//'.avs'''
          print *,file(1:length(file))
          call system(file)

          file=crsh(1:irs)//' '//
     +    chost(1:ilh)//' -l '//
     +    cuser(1:ilu)//
     +    ' '//rdir(1:ird)//name(1:in)//'.avs'
          print *,file(1:length(file))

c print avs startup file:
          print *
          print *,'>>>>>>>> begin remote AVS'
          print *
          print *,avsbuf(1:length(avsbuf))
          print *

c execute remote call:
          call system(file)

          if(iremrm.eq.1) then
c >>> begin remove
             print *
             print *,'*** remote remove :'
             buf=cremrm(1:irrm)//' '//
     +       rdir(1:ird) // name(1:in)//'*'
             print *, buf(1:length(buf))
c <<< end remove
          else
             print *
             print *,'no remote files removed'
          end if
          print *
          print *,'<<<<<<<< end remote AVS'
          print *
c <<<<<<<<<<<<<<<<<<<<<<<<<<<< remote AVS
         end if

         end

c --------------------------------------------------------------------
         subroutine AVSI_modgen_u(module, 
     +   ndim, dim1, dim2, dim3, dim4)
c --------------------------------------------------------------------
c generate AVS module for 1D, 2D, 3D, 4D scalar data at uniform grid ...

         INCLUDE 'AVSI_inc'
c        parameter (MAXS=79)
         character *(MAXS)  parm(10)

         character *(*) module
         integer dim1, dim2, dim3, dim4, ndim

         parm(1)=module
c flddes generated by _hdr
         parm(2)=flddes(1:length(flddes))

         il1=length(parm(1))
         call AVSI_script_open(
     +   parm(1)(1:il1)//'.f')

         print *
         print *,'>>> module file = ',
     +   parm(1)(1:il1)//'.f'
         print *,'>>> Add source code to subroutine ',
     +   parm(1)(1:il1)//'_dat'
         
         write(parm(3),'(i1)') ndim

         write(parm(4),'(''dims(1)= '',i5)') dim1

         if(dim2.ne.0) then
            write(parm(5),'(''dims(2)= '',i5)') dim2
         else
            parm(5)=' '
         end if

         if(dim3.ne.0) then
            write(parm(6),'(''dims(3)= '',i5)') dim3
         else
            parm(6)=' '
         end if

         if(dim4.ne.0) then
            write(parm(7),'(''dims(4)= '',i5)') dim4
         else
            parm(7)=' '
         end if

c call &1_dat:
        write(buf,'(''call '',a,''_dat(dims(1)'')') 
     +  parm(1) (1:il1) 
        ilb=length(buf)
        if(dim2.ne.0) buf=buf(1:ilb)//', dims(2)'
        ilb=length(buf)
        if(dim3.ne.0) buf=buf(1:ilb)//', dims(3)'
        ilb=length(buf)
        if(dim4.ne.0) buf=buf(1:ilb)//', dims(4)'
        ilb=length(buf)
        buf=buf(1:ilb)//', %val(data))'
        parm(8)=buf
        ilb=length(buf)
        
c subroutine &1_dat:
        il1=length(parm(1))
        write(buf,'(''subroutine '',a,''_dat(dim1'')') 
     +  parm(1) (1:il1) 
        ilb=length(buf)
        if(dim2.ne.0) buf=buf(1:ilb)//', dim2'
        ilb=length(buf)
        if(dim3.ne.0) buf=buf(1:ilb)//', dim3'
        ilb=length(buf)
        if(dim4.ne.0) buf=buf(1:ilb)//', dim4'
        ilb=length(buf)
        buf=buf(1:ilb)//', s)'
        parm(9)=buf
        ilb=length(buf)
        
c dimension s(...):
        buf='dimension s (dim1'
        ilb=length(buf)
        if(dim2.ne.0) buf=buf(1:ilb)//', dim2'
        ilb=length(buf)
        if(dim3.ne.0) buf=buf(1:ilb)//', dim3'
        ilb=length(buf)
        if(dim4.ne.0) buf=buf(1:ilb)//', dim4'
        ilb=length(buf)
        buf=buf(1:ilb)//')'
        parm(10)=buf
        ilb=length(buf)
        
        call AVSI_script_macro('mod_u.mcr',10,parm)
        call AVSI_script_close

c generate Makefile &1.make
        call AVSI_script_open(parm(1)(1:il1)//'.make')
        call AVSI_script_macro('make.mcr',1,parm)
        call AVSI_script_close

         print *,'>>> module makefile = ',
     +   parm(1)(1:il1)//'.make'
         print *,'>>> Use the next command to make AVS module ',
     +   parm(1)(1:il1), ' :'
         print *,'>>> make -f ',
     +   parm(1)(1:il1)//'.make'
         print *,'>>> Replace module READ FIELD in network ',
     +   parm(1)(1:il1)//'.net'
         print *,'>>> by the module ',
     +   parm(1)(1:il1),' in the Network Editor.'
         print *

         

        end





c-------------------------------------------------------------------------
c AVS Interface  software suite
c developed by J. Kraak
c              University of Groningen
c              The Netherlands
c              J.Kraak@rc.rug.nl
c-------------------------------------------------------------------------

c****************************************************************************
c                 INTERNATIONAL AVS CENTER
c       (This disclaimer must remain at the top of all files)
c
c WARRANTY DISCLAIMER
c
c This module and the files associated with it are distributed free of charge.
c It is placed in the public domain and permission is granted for anyone to use,
c duplicate, modify, and redistribute it unless otherwise noted.  Some modules
c may be copyrighted.  You agree to abide by the conditions also included in
c the AVS Licensing Agreement, version 1.0, located in the main module
c directory located at the International AVS Center ftp site and to include
c the AVS Licensing Agreement when you distribute any files downloaded from
c that site.

c The International AVS Center, MCNC, the AVS Consortium and the individual
c submitting the module and files associated with said module provide absolutelyc NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
c the quality and performance of this software is with the user.  IN NO EVENT
c WILL The International AVS Center, MCNC, the AVS Consortium and the individualc submitting the module and files associated with said module BE LIABLE TO
c ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
c WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
c SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

c This AVS module and associated files are public domain software unless
c otherwise noted.  Permission is hereby granted to do whatever you like with
c it, subject to the conditions that may exist in copyrighted materials. Should
c you wish to make a contribution toward the improvement, modification, or
c general performance of this module, please send us your comments:  why you
c liked or disliked it, how you use it, and most important, how it helps your
c work. We will receive your comments at avs@ncsc.org.
c
c Please send AVS module bug reports to avs@ncsc.org.

c*****************************************************************************





c ********************************************************************
         subroutine AVSI_1D_scalar_real(name,dim1,s)
c *******************************************************************
c write only field data 

       INCLUDE 'AVSI_inc'
       integer dim1
       dimension s(dim1)
cmf$   layout s (:serial)
       character *(*) name

       print *
       write(*,'('' *** AVS data  file = '',a,
     + ''.data (unformatted)'')')
     + name(1:length(name))
       call AVSI_w1s(name,dim1,s)
       if(chost.ne.cnot) call AVSI_rcp(name(1:length(name))//'.data')

       end


c ********************************************************************
         subroutine AVSI_2D_scalar_real(name,dim1,dim2,s)
c *******************************************************************
c write only field data 

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1,dim2)
cmf$   layout s (:serial, :serial)
       character *(*) name

       print *
       write(*,'('' *** AVS data  file = '',a,
     + ''.data (unformatted)'')')
     + name(1:length(name))
       call AVSI_exch2(dim1, dim2, idim1, idim2)
       call AVSI_w2s(name,idim1,idim2,s)
       if(chost.ne.cnot) call AVSI_rcp(name(1:length(name))//'.data')

       end 


c ********************************************************************
         subroutine AVSI_3D_scalar_real(name,dim1,dim2,dim3,s)
c *******************************************************************
c write only field data 

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1,dim2,dim3)
cmf$   layout s (:serial, :serial, :serial)
       character *(*) name

       print *
       write(*,'('' *** AVS data  file = '',a,
     + ''.data (unformatted)'')')
     + name(1:length(name))
       call AVSI_exch3(dim1, dim2, dim3, idim1, idim2, idim3)
       call AVSI_w3s(name,idim1,idim2,idim3,s)
       if(chost.ne.cnot) call AVSI_rcp(name(1:length(name))//'.data')

       end


c ********************************************************************
         subroutine AVSI_1D1vf1cu(name,dim1,s)
c *******************************************************************
c field 1D 1-vector float 1-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1
       dimension s(dim1)
cmf$   layout s (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_1D1vf1cu',name)
c no field?
       if(dim1.eq.0)                     RETURN
       if(dim1.gt.0) call AVSI_w1s(name, dim1, s)
       call AVSI_fld(name,1,1,1,'float','uniform',dm1,0,0,0)

       end

c ********************************************************************
         subroutine AVSI_1D1vf1cr(name,dim1,s,x)
c *******************************************************************
c field 1D 1-vector float 1-coord rectilinear

       INCLUDE 'AVSI_inc'
       integer dim1
       dimension s(dim1),x(dim1)
cmf$   layout s (:serial)
cmf$   layout x (:serial)
       character *(*) name
c      character *80 file

       idmm1=dim1
c      call AVSI_hdr('AVSI_1D1vf1cr',name)
       if(dim1.eq.0)                     RETURN
       if(dim1.gt.0) then
c >>>>>>>>>>>>> write data/fld
       file=ldir(1:length(ldir))//name(1:length(name))//'.fld'
c because Graph Viewer does NOT read
c field 1D 1-vector float 1-coord rectilinear
       print *,'*** data  file = ', file(1:length(file)),
     + ' (ascii)'
       call AVSI_opnfl(idev,name,'.fld','f')
       do 10 i=1, dim1
          write(idev,*) x(i), s(i)
10     continue
       close (idev)
c <<<<<<<<<<<<<<
       end if

c      call AVSI_hdr('AVSI_1D1vf1cr',name)
c      call AVSI_w1s(name,dim1,s)
c      call AVSI_w1r(name,dim1,x)
c      call AVSI_fld(name,1,1,1,'float','rectilinear',dim1,0,0,0)

       end

c ********************************************************************
         subroutine AVSI_2D1vf2cu(name,dim1,dim2,s)
c *******************************************************************
c field 2D 1-vector float 2-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1,dim2)
cmf$   layout s (:serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_2D1vf2cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w2s(name,idim1,idim2,s)
       call AVSI_fld(name,2,2,1,'float','uniform',dm1,dim2,0,0)

       end


c ********************************************************************
         subroutine AVSI_2D1vf2cr(name,dim1,dim2,s,x,y)
c *******************************************************************
c field 2D 1-vector float 2-coord rectilinear

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1,dim2),x(dim1),y(dim2)
cmf$   layout s (:serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_2D1vf2cr',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w2s(name,idim1,idim2,s)
       call AVSI_w2r(name,dm1,dim2,x,y)
       call AVSI_fld(name,2,2,1,'float','rectilinear',dm1,dim2,0,0)

       end


c ********************************************************************
         subroutine AVSI_2D1vf2ci(name,dim1,dim2,s,xi,yi)
c *******************************************************************
c field 2D 1-vector float 2-coord  irregular

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1,dim2),xi(dim1, dim2),yi(dim1, dim2)
cmf$   layout s (:serial, :serial)
cmf$   layout xi (:serial, :serial)
cmf$   layout yi (:serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_2D1vf2ci',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w2s(name,idim1,idim2,s)
       call AVSI_w2i(name,idim1,idim2,xi,yi)
       call AVSI_fld(name,2,2,1,'float','irregular',dm1,dim2,0,0)

       end


c ********************************************************************
         subroutine AVSI_3D1vf3cu(name,dim1,dim2,dim3,s)
c *******************************************************************

c generates a 3D 1-vector float 3-coord uniform field (name//'.fld')

c name ( type character *(*) ) specifies the first part of file names

c s(dim1, dim2, dim3,0) holds the scalar values at the gridpoints

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1,dim2,dim3)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D1vf3cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if (dim1.gt.0) call AVSI_w3s(name,idim1,idim2,idim3,s)
c AVSI_fld(name, ndim,nspace,veclen,.....)
       call AVSI_fld(name,3,3,1,'float','uniform',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3D1vf3cr(name,dim1,dim2,dim3,s,x,y,z)
c *******************************************************************
c field 3D 1-vector float 3-coord rectilinear

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1,dim2,dim3),x(dim1),y(dim2),z(dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D1vf3cr',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if(dim1.gt.0) call AVSI_w3s(name,idim1,idim2,idim3,s)
       call AVSI_w3r(name,dm1,dim2,dim3,x,y,z)
       call AVSI_fld(name,3,3,1,'float','rectilinear',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3D1vf3ci(name,dim1,dim2,dim3,s,xi,yi,zi)
c *******************************************************************
c field 3D 1-vector float 3-coord irregular

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension s(dim1,dim2,dim3), xi(dim1,dim2,dim3),
     + yi(dim1,dim2,dim3), zi(dim1,dim2,dim3)
cmf$   layout s (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D1vf3ci',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if(dim1.gt.0) call AVSI_w3s(name,idim1,idim2,idim3,s)
       call AVSI_w3i(name,idim1,idim2,idim3,xi,yi,zi)
       call AVSI_fld(name,3,3,1,'float','irregular',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_TD1vf3cu(name,dim1,dim2,s)
c *******************************************************************
c field 3D 1-vector float 3-coord uniform , add 3-ed z dimension

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension s(dim1,dim2)
cmf$   layout s (:serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_TD1vf3cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w23s(name,idim1,idim2,s)
       call AVSI_fld(name,3,3,1,'float','uniform',dm1,dim2,2,0)

       end


c ********************************************************************
         subroutine AVSI_4D1vf4cu(name,dim1,dim2,dim3,dim4,s)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3, dim4
       dimension s(dim1,dim2,dim3,dim4)
cmf$   layout s (:serial, :serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_4D1vf4cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch4(dm1, dim2, dim3, dim4,
     + idim1, idim2, idim3, idim4)
       if(dim1.gt.0) call AVSI_w4s(name,idim1,idim2,idim3,idim4,s)
       call AVSI_fld(name,4,4,1,'float','uniform',dm1,dim2,dim3,dim4)

       end

c *******************************************************************
         subroutine AVSI_3D3vf3cu(name,dim1,dim2,dim3,vx,vy,vz)
c *******************************************************************
c field 3D 3-vector float 3-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1,dim2,dim3), vy(dim1,dim2,dim3),
     + vz(dim1,dim2,dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D3vf3cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if(dim1.gt.0) call AVSI_w3v(name,idim1,idim2,idim3,vx,vy,vz)
       call AVSI_fld(name,3,3,3,'float','uniform',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3D3vf3cr(name,dim1,dim2,dim3,vx,vy,vz,
     + x,y,z)
c *******************************************************************
c field 3D 3-vector float 3-coord rectilinear

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1,dim2,dim3), vy(dim1,dim2,dim3),
     + vz(dim1,dim2,dim3), x(dim1),y(dim2),z(dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D3vf3cr',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if(dim1.gt.0) call AVSI_w3v(name,idim1,idim2,idim3,vx,vy,vz)
       call AVSI_w3r(name,dm1,dim2,dim3,x,y,z)
       call AVSI_fld(name,3,3,3,'float','rectilinear',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3D3vf3ci(name,dim1,dim2,dim3,vx,vy,vz,xi,
     + yi,zi)
c *******************************************************************
c field 3D 3-vector float 3-coord irregular

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       dimension vx(dim1,dim2,dim3), vy(dim1,dim2,dim3),
     + vz(dim1,dim2,dim3),
     + xi(dim1,dim2,dim3), yi(dim1,dim2,dim3), zi(dim1,dim2,dim3)
cmf$   layout vx (:serial, :serial, :serial)
cmf$   layout vy (:serial, :serial, :serial)
cmf$   layout vz (:serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3D3vf3ci',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       if(dim1.gt.0) call AVSI_w3v(name,idim1,idim2,idim3,vx,vy,vz)
       call AVSI_w3i(name,idim1,idim2,idim3,xi,yi,zi)
       call AVSI_fld(name,3,3,3,'float','irregular',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_TDTvf3cu(name,dim1,dim2,vx,vy)
c *******************************************************************
c 2D 2-vector float uniform , add dimension 3 and vz=0 !!:
c field 3D 2-vector float 3-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx(dim1,dim2), vy(dim1,dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_TDTvf3cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w23v(name,idim1,idim2,vx,vy)
       call AVSI_fld(name,3,3,3, 'float', 'uniform',dm1,dim2,2,0)

       end


c ********************************************************************
         subroutine AVSI_TDTvf3cr(name,dim1,dim2,vx,vy,x,y)
c *******************************************************************
c 2D 2-vector float rectlinear , add dimension 3 and vz=0 !!:
c field 3D 2-vector float 3-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx(dim1,dim2), vy(dim1,dim2), x(dim1), y(dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_TDTvf3cr',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w23v(name,idim1,idim2,vx,vy)
       call AVSI_w23r(name,dm1, dim2, x,y)
       call AVSI_fld(name,3,3,3, 'float', 'rectilinear',dm1,dim2,2,0)

       end


c ********************************************************************
         subroutine AVSI_TDTvf3ci(name,dim1,dim2,vx,vy,xi, yi)
c *******************************************************************
c 2D 2-vector float irrgular , add dimension 3 and vz=0 !!:
c field 3D 2-vector float 3-coord uniform

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       dimension vx(dim1,dim2), vy(dim1,dim2),
     + xi(dim1, dim2), yi(dim1, dim2)
cmf$   layout vx (:serial, :serial)
cmf$   layout vy (:serial, :serial)
cmf$   layout xi (:serial, :serial)
cmf$   layout yi (:serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_TDTvf3ci',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch2(dm1, dim2, idim1, idim2)
       if(dim1.gt.0) call AVSI_w23v(name,idim1,idim2,vx,vy)
       call AVSI_w23i(name, idim1, idim2, xi, yi)
       call AVSI_fld(name,3,3,3, 'float', 'irregular',dm1,dim2,2,0)

       end


c ********************************************************************
         subroutine AVSI_3Dnvf3cu(name,veclen,dim1,dim2,dim3,v)
c *******************************************************************
c field 3D <veclen>-vector float 3-coord uniform

c generate a AVS picture of a <veclen/>n-vector (float) specfied by
c v(veclen,dim1,dim2,dim3,0) at an 3D uniform grid

c name ( type character *(*) ) specifies the first part of file names

       INCLUDE 'AVSI_inc'
       integer veclen, dim1, dim2, dim3
       dimension v(veclen,dim1,dim2,dim3)
cmf$   layout v (:serial, :serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3Dnvf3cu',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch4(veclen, dm1, dim2, dim3,
     + iveclen,idim1,idim2,idim3)
       if(dim1.gt.0) call AVSI_wns(name,iveclen,idim1,idim2,idim3,v)
       call AVSI_fld(name,3,3,veclen,'float','uniform',dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3Dnvf3cr(name,veclen,dim1,dim2,dim3,
     + v,x,y,z)
c *******************************************************************
c field 3D <veclen>-vector float 3-coord rectilinear

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       integer veclen
       dimension v(veclen,dim1,dim2,dim3), x(dim1), y(dim2), z(dim3)
cmf$   layout v (:serial, :serial, :serial, :serial)
cmf$   layout x (:serial)
cmf$   layout y (:serial)
cmf$   layout z (:serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3Dnvf3cr',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch4(veclen, dm1, dim2, dim3,
     + iveclen,idim1,idim2,idim3)
       if(dim1.gt.0) call AVSI_wns(name,iveclen,idim1,idim2,idim3,v)
       call AVSI_w3r(name,dm1,dim2,dim3,x,y,z)
       call AVSI_fld(name,3,3,veclen,'float','rectilinear',
     + dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_3Dnvf3ci(name,veclen,dim1,dim2,dim3,v,
     + xi,yi,zi)
c *******************************************************************
c field 3D <veclen>-vector float 3-coord irregular

       INCLUDE 'AVSI_inc'
       integer veclen
       integer dim1, dim2, dim3
       dimension v(veclen,dim1,dim2,dim3), xi(dim1,dim2,dim3),
     + yi(dim1,dim2,dim3), zi(dim1,dim2,dim3)
cmf$   layout v  (:serial, :serial, :serial, :serial)
cmf$   layout xi (:serial, :serial, :serial)
cmf$   layout yi (:serial, :serial, :serial)
cmf$   layout zi (:serial, :serial, :serial)
       character *(*) name

       idmm1=dim1
       dm1=abs(dim1)
       call AVSI_hdr('AVSI_3Dnvf3ci',name)
       if(dim1.eq.0)                     RETURN
       call AVSI_exch4(veclen, dm1, dim2, dim3,
     + iveclen,idim1,idim2,idim3)
       if(dim1.gt.0) call AVSI_wns(name,iveclen,idim1,idim2,idim3,v)
       call AVSI_exch3(dm1, dim2, dim3, idim1, idim2, idim3)
       call AVSI_w3i(name,idim1,idim2,idim3,xi,yi,zi)
       call AVSI_fld(name,3,3,veclen,'float','irregular',
     + dm1,dim2,dim3,0)

       end


c ********************************************************************
         subroutine AVSI_hdr(sname,name)
c *******************************************************************
c print AVS-subroutine header
c igrid is used in AVSI_rmt

       INCLUDE 'AVSI_inc'
         character *(*) sname,name
         character *5 data
         character *11 gtype
c prestting in AVSI_net_dir
         if(init.ne.1) then
            print *,'*** AVSI_error:'
            print *,'*** no AVSI_net_dir call, STOP'
            STOP
         end if
  
         iflds=1
 

         if(sname(10:10).eq.'f') then
           data='float'
         else
           data='*****'
         end if

         if(sname(13:13).eq.'u') then
           gtype='uniform'
           igrid=0
         else if(sname(13:13).eq.'r') then
           gtype='rectilinear'
           igrid=1
         else if(sname(13:13).eq.'i') then
           gtype='irregular'
           igrid=2
         end if

         print *

c no field ?
         if(idmm1.eq.0)                             RETURN

         buf=ldir(1:length(ldir))//name(1:length(name)) 

         write(*,'('' *** AVS field file = '',a,''.fld'')')
     +   buf(1:length(buf))

         if(idmm1.gt.0) then
            if(ibinary.eq.0) then
               write(*,'('' *** AVS data  file = '',a,
     +         ''.data  (ascii)'' )')
     +         buf(1:length(buf))
            else
               write(*,'('' *** AVS data  file = '',a,
     +         ''.data  (unformatted)'' )')
     +         buf(1:length(buf))
            end if
         end if

         if(sname(13:13).eq.'r') then 
            if(ibinary.eq.0) then
               write(*,'('' *** AVS grid  file = '',a,
     +         ''.rect  (ascii)'')')
     +         buf(1:length(buf))
            else
               write(*,'('' *** AVS grid  file = '',a,
     +         ''.rect  (unformatted)'')')
     +         buf(1:length(buf))
            end if
         else if(sname(13:13).eq.'i') then
            if(ibinary.eq.0) then
               write(*,'('' *** AVS grid  file = '',a,
     +         ''.irreg (ascii)'')')
     +         buf(1:length(buf))
            else
               write(*,'('' *** AVS grid  file = '',a,
     +         ''.irreg (unformatted)'')')
     +         buf(1:length(buf))
            end if
         end if

         write(flddes,'(''field '',a,'' '',a,''-vector '',a,
     +   '' '',a,''-coord '',a)')
     +   sname(6:7), sname(8:8), data, sname(11:11), gtype
         print *,'*** ',flddes(1:length(flddes))

         end

c ********************************************************************
       subroutine AVSI_opnfl(idv,name,ext,f)
c *******************************************************************
c open file in directory ldir

       INCLUDE 'AVSI_inc'
       character *(*) name,ext,f
       character *11 frm

       if(f.eq.'f') frm='formatted'
       if(f.eq.'u') frm='unformatted'
       buf=ldir(1:length(ldir))//name(1:length(name))//ext 

       open(idv, file=buf, status='unknown', form=frm, err=100)
                                            RETURN
100    print *,'*** AVSI_error : unable to open file : '
       print *,buf(1:length(buf))
       print *,'*** STOP'
                                            STOP
       end
  

c ********************************************************************
       subroutine AVSI_w1s(name,dim1,s)
c *******************************************************************
c write s(dim1) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1
       character *(*) name
       dimension s(dim1)
cmf$   layout s  (:serial)

       call AVSI_dims(dim1,0,0,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       do 10 i=1, dim1
            write(idev,*) s(i)
10     continue
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       write(idev) s
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w2s(name,dim1,dim2,s)
c *******************************************************************
c write s(dim1,dim2) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension s(dim1,dim2)
cmf$   layout s  (:serial, :serial)

       call AVSI_dims(dim1,dim2,0,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if(itranspose.eq.1) then
          do 10 i=1, dim1
          do 10 j=1, dim2
              write(idev,*) s(i,j)
10        continue
       else
          do 20 j=1, dim2
          do 20 i=1, dim1
             write(idev,*) s(i,j)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) ((s(i,j),j=1,dim2), i=1,dim1)
       else
         write(idev) s
       end if
c <<<<<<<<<<<<< unformatted
       end if
       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w3s(name,dim1,dim2,dim3,s)
c *******************************************************************
c write s(dim1,dim2,dim3) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension s(dim1,dim2,dim3)
cmf$   layout s  (:serial, :serial, :serial)

       call AVSI_dims(dim1,dim2,dim3,0)
       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if(itranspose.eq.1) then
          do 20 i=1, dim1
          do 20 j=1, dim2
          do 20 k=1, dim3
            write(idev,*) s(i,j,k)
20        continue
       else
          do 10 k=1, dim3
          do 10 j=1, dim2
          do 10 i=1, dim1
            write(idev,*) s(i,j,k)
10        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) (((s(i,j,k),k=1,dim3), j=1,dim2), i=1,dim1)
       else
         write(idev) s
       end if
c <<<<<<<<<<<<< unformatted
       end if
       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w4s(name,dim1,dim2,dim3,dim4,s)
c *******************************************************************
c write s(dim1,dim2,dim3,0) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3, dim4
       character *(*) name
       dimension s(dim1,dim2,dim3,dim4)
cmf$   layout s  (:serial, :serial, :serial, :serial)

       call AVSI_dims(dim1,dim2,dim3,dim4)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 i=1, dim1
          do 10 j=1, dim2
          do 10 k=1, dim3
          do 10 l=1, dim4
               write(idev,*) s(i,j,k,l)
10        continue
       else
          do 20 l=1, dim4
          do 20 k=1, dim3
          do 20 j=1, dim2
          do 20 i=1, dim1
               write(idev,*) s(i,j,k,l)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) ((((s(i,j,k,l),
     +   l=1,dim4), k=1,dim3),j=1,dim2), i=1,dim1)
       else
         write(idev) s
       end if
c <<<<<<<<<<<<< unformatted
       end if
       close(idev)

       end

c ********************************************************************
       subroutine AVSI_wns(name,nv,dim1,dim2,dim3,s)
c *******************************************************************
c write s(nv,dim1,dim2,dim3) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension s(nv,dim1,dim2,dim3)
cmf$   layout s  (:serial, :serial, :serial, :serial)

       call AVSI_dims(dim1,dim2,dim3,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 iv=1,nv
          do 10 i =1, dim1
          do 10 j =1, dim2
          do 10 k =1, dim3
             write(idev,*) s(iv,i,j,k)
10        continue
       else
          do 20 k=1, dim3
          do 20 j=1, dim2
          do 20 i=1, dim1
          do 20 iv=1,nv
             write(idev,*) s(iv,i,j,k)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) ((((s(iv,i,j,k),
     +    k=1,dim3),j=1,dim2), i=1,dim1),iv=1,nv)
       else
         write(idev) s
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w23s(name,dim1,dim2,s)
c *******************************************************************
c add 3d dimension !!

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension s(dim1,dim2)
cmf$   layout s  (:serial, :serial)

       call AVSI_dims(dim1,dim2,2,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 i=1, dim1
          do 10 j=1, dim2
          do 10 k=1, 2
             write(idev,*) s(i,j)
10        continue
       else
          do 20 k=1, 2
          do 20 j=1, dim2
          do 20 i=1, dim1
             write(idev,*) s(i,j)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) ((( s(i,j),k=1,2),j=1, dim2), i=1, dim1)
       else
         write(idev) ((( s(i,j),i=1,dim1), j=1, dim2), k=1,2)
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end

c ********************************************************************
       subroutine AVSI_w2ns(name,nv,dim1,dim2,s)
c *******************************************************************
c write s(nv,dim1,dim2) to name//'.data'

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension s(nv,dim1,dim2)
cmf$   layout s  (:serial, :serial, :serial)

       call AVSI_dims(dim1,dim2,2,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 iv=1,nv
          do 10 i=1, dim1
          do 10 j=1, dim2
          do 10 k=1, 2
             write(idev,*) s(iv,i,j)
10        continue
       else
          do 20 k=1, 2
          do 20 j=1, dim2
          do 20 i=1, dim1
          do 20 iv=1,nv
             write(idev,*) s(iv,i,j)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) (((( s(iv,i,j),k=1,2),j=1, dim2),
     +   i=1, dim1),iv=1, nv)
       else
         write(idev) (((( s(iv,i,j),iv = 1, nv),i=1,dim1),
     +   j=1, dim2), k=1,2)
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w3v(name,dim1,dim2,dim3,vx,vy,vz)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension vx(dim1,dim2,dim3), vy(dim1,dim2,dim3),
     + vz(dim1,dim2,dim3)
cmf$   layout vx  (:serial, :serial, :serial)
cmf$   layout vy  (:serial, :serial, :serial)
cmf$   layout vz  (:serial, :serial, :serial)

       call AVSI_dims(dim1,dim2,dim3,0)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 i=1, dim1
          do 10 j=1, dim2
          do 10 k=1, dim3
             write(idev,*) vx(i,j,k), vy(i,j,k), vz(i,j,k)
10        continue
       else
          do 20 k=1, dim3
          do 20 j=1, dim2
          do 20 i=1, dim1
             write(idev,*) vx(i,j,k), vy(i,j,k), vz(i,j,k)
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) (((vx(i,j,k), vy(i,j,k), vz(i,j,k),
     +   k=1, dim3), j=1, dim2), i=1, dim1) 
       else
         write(idev) (((vx(i,j,k), vy(i,j,k), vz(i,j,k),
     +   i=1, dim1), j=1, dim2), k=1, dim3)
       end if
c <<<<<<<<<<<<< unformatted
       end if
       close(idev)

       end

c ********************************************************************
       subroutine AVSI_w23v(name,dim1,dim2,vx,vy)
c *******************************************************************
c called by  AVSI_2D2vf* , emulates 3d dimension !

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension vx(dim1,dim2), vy(dim1,dim2)
cmf$   layout vx  (:serial, :serial)
cmf$   layout vy  (:serial, :serial)

       call AVSI_dims(dim1,dim2,2,0)
       vz=0

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.data','f')
       if (itranspose.eq.1) then
          do 10 i=1, dim1
          do 10 j=1, dim2
          do 10 k=1, 2
             write(idev,*) vx(i,j), vy(i,j), vz
10        continue
       else
          do 20 k=1, 2
          do 20 j=1, dim2
          do 20 i=1, dim1
             write(idev,*) vx(i,j), vy(i,j), vz
20        continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.data','u')
       if(itranspose.eq.1) then
         write(idev) (((vx(i,j), vy(i,j), vz,
     +   k=1, 2), j=1, dim2), i=1, dim1) 
       else
         write(idev) (((vx(i,j), vy(i,j), vz,
     +   i=1, dim1), j=1, dim2), k=1, 2)
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end

c ********************************************************************
         subroutine AVSI_w1r(name,dim1,x)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1
       character *(*) name
       dimension x(dim1)
cmf$   layout x  (:serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.rect','f')
       do 40 i=1,dim1
40       write(idev,*) x(i)
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.rect','u')
       write(idev) x 
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
         subroutine AVSI_w2r(name,dim1,dim2,x,y)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension x(dim1),y(dim2)
cmf$   layout x  (:serial)
cmf$   layout y  (:serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.rect','f')
       do 40 i=1,dim1
40       write(idev,*) x(i)
       do 50 i=1,dim2
50       write(idev,*) y(i)
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.rect','u')
       write(idev) (x(i),i=1,dim1),(y(i),i=1,dim2)
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
         subroutine AVSI_w3r(name,dim1,dim2,dim3,x,y,z)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension x(dim1),y(dim2),z(dim3)
cmf$   layout x  (:serial)
cmf$   layout y  (:serial)
cmf$   layout z  (:serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.rect','f')
       do 40 i=1,dim1
40       write(idev,*) x(i)
       do 50 i=1,dim2
50       write(idev,*) y(i)
       do 60 i=1,dim3
60       write(idev,*) z(i)
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.rect','u')
       write(idev) (x(i),i=1,dim1),(y(i),i=1,dim2),(z(i),i=1,dim3) 
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
         subroutine AVSI_w23r(name,dim1,dim2,x,y)
c *******************************************************************
c add 3-ed coordinate

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension x(dim1),y(dim2)
cmf$   layout x  (:serial)
cmf$   layout y  (:serial)

c While installing this software at a DEC alpha
c I found the absence of the next statement:
       dim3=2
c 27 october 1994, the day after the funeral of our beloved
c collegue Gea van der Molen who died of cancer at the age of 38.
c This was a week after the cremation of another college
c Johan Krook, 50 years, a depressive programmer.

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.rect','f')
       do 40 i=1,dim1
40       write(idev,*) x(i)
       do 50 i=1,dim2
50       write(idev,*) y(i)
       do 60 i=1,dim3
60       write(idev,*) i-1
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.rect','u')
       write(idev) (x(i), i=1, dim1), (y(i), i=1, dim2),
     + (float(i-1), i=1, dim3) 
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end

c ********************************************************************
       subroutine AVSI_w2i(name,dim1,dim2,xi,yi)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension xi(dim1,dim2), yi(dim1,dim2)
cmf$   layout xi  (:serial, :serial)
cmf$   layout yi  (:serial, :serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.irreg','f')
       if( itranspose.eq.1) then
          do 100 i = 1, dim1
          do 100 j = 1, dim2
             write(idev,*) xi(i,j), yi(i,j)
100       continue
       else
          do 200 j = 1, dim2
          do 200 i = 1, dim1
             write(idev,*) xi(i,j), yi(i,j)
200       continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.irreg','u')
       if( itranspose.eq.1) then
          write(idev) ((xi(i,j), yi(i,j),
     +    j=1, dim2), i=1, dim1)
       else
          write(idev) ((xi(i,j), yi(i,j),
     +    i=1, dim1), j=1, dim2)
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w3i(name,dim1,dim2,dim3,xi,yi,zi)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3
       character *(*) name
       dimension xi(dim1,dim2,dim3), yi(dim1,dim2,dim3),
     + zi(dim1,dim2,dim3)
cmf$   layout xi  (:serial, :serial, :serial)
cmf$   layout yi  (:serial, :serial, :serial)
cmf$   layout zi  (:serial, :serial, :serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.irreg','f')
       if( itranspose.eq.1) then
          do 100 i = 1, dim1
          do 100 j = 1, dim2
          do 100 k = 1, dim3
             write(idev,*) xi(i,j,k), yi(i,j,k), zi(i,j,k)
100       continue
       else
          do 200 k = 1, dim3
          do 200 j = 1, dim2
          do 200 i = 1, dim1
             write(idev,*) xi(i,j,k), yi(i,j,k), zi(i,j,k)
200       continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.irreg','u')
       if( itranspose.eq.1) then
          write(idev) (((xi(i,j,k), yi(i,j,k), zi(i,j,k),
     +    k=1, dim3), j=1, dim2), i=1, dim1)
       else
          write(idev) (((xi(i,j,k), yi(i,j,k), zi(i,j,k),
     +    i=1, dim1), j=1, dim2),k=1, dim3)
       end if
c <<<<<<<<<<<<< unformatted
       end if

       close(idev)

       end


c ********************************************************************
       subroutine AVSI_w23i(name,dim1,dim2,xi,yi)
c *******************************************************************
c add 3-d coordinate ..

       INCLUDE 'AVSI_inc'
       integer dim1, dim2
       character *(*) name
       dimension xi(dim1,dim2), yi(dim1,dim2)
cmf$   layout xi  ( :serial, :serial)
cmf$   layout yi  ( :serial, :serial)

       if( ibinary.eq.0) then
c >>>>>>>>>>>>> ascii format
       call AVSI_opnfl(idev,name,'.irreg','f')
       if( itranspose.eq.1) then
         do 100 i = 1, dim1
         do 100 j = 1, dim2
         do 100 k = 1, 2
             write(idev,*) xi(i,j), yi(i,j), k-1
100      continue
       else
         do 200 k = 1, 2
         do 200 j = 1, dim2
         do 200 i = 1, dim1
             write(idev,*) xi(i,j), yi(i,j), k-1
200      continue
       end if
c >>>>>>>>>>>>> ascii format
       else
c >>>>>>>>>>>>> unformatted
       call AVSI_opnfl(idev,name,'.irreg','u')
       if( itranspose.eq.1) then
          write(idev) (((xi(i,j), yi(i,j), float(k-1),
     +    k=1, 2), j=1, dim2), i=1, dim1)
       else
          write(idev) (((xi(i,j), yi(i,j), float(k-1),
     +    i=1, dim1), j=1, dim2),k=1, 2)
       end if
c <<<<<<<<<<<<< unformatted
       end if
       close(idev)

       end


c ********************************************************************
       subroutine AVSI_fld(name,ndim,nspace,veclen,data,field,
     + dim1,dim2,dim3,dim4)
c *******************************************************************
c write field file nspace <=4

       INCLUDE 'AVSI_inc'
       character *(*) name, data, field
       integer ndim,nspace,veclen,dim1,dim2,dim3,dim4

       call AVSI_opnfl(idev,name,'.fld','f')

       write(idev,'(''# AVS field'')')
       write(idev,'(''ndim= '',i4)') ndim
       write(idev,'(''nspace= '',i4)') nspace
       write(idev,'(''veclen= '',i4)') veclen
       write(idev,'(''data= '',a)') data
       write(idev,'(''field= '',a)') field
       if(dim1.gt.0) write(idev,'(''dim1= '',i4)') dm1
       if(dim2.gt.0) write(idev,'(''dim2= '',i4)') dim2
       if(dim3.gt.0) write(idev,'(''dim3= '',i4)') dim3
       if(dim4.gt.0) write(idev,'(''dim4= '',i4)') dim4

       if(iminmax.eq.1) then
c add min_val, max_val to description ...
c         iminmax=0
c e12.4 not accepted by READ FIELD ...., so f12.4
          write(idev,'(''min_val = '',f12.4)') rmin_val
          write(idev,'(''max_val = '',f12.4)') rmax_val
        end if


c variable part:

       if(ibinary.eq.0) then
c >>>>>>>>>>>>>> ascii format
       do 10 i=1,veclen
         write(idev,'(''variable '',i2,'' file='',a,
     +   ''.data filetype=ascii '',
     +   ''offset='',i2,'' stride='',i2)')
     +   i, name(1:length(name)), i-1, veclen
10     continue

       if(nspace.eq.3.and. field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,''.rect filetype=ascii '',
     +   ''offset=0 stride=1'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')') name(1:length(name)),dim1
         write(idev,'(''coord 3 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')') 
     +   name(1:length(name)),dim1+dim2

       else if(nspace.eq.3.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,''.irreg filetype=ascii '',
     +   ''offset=0 stride=3'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.irreg filetype=ascii '',
     +   ''offset=1 stride=3'')') name(1:length(name))
         write(idev,'(''coord 3 file='',a,''.irreg filetype=ascii '',
     +   ''offset=2 stride=3'')') name(1:length(name))

       else if(nspace.eq.4.and. field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,''.rect filetype=ascii '',
     +   ''offset=0 stride=1'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')') name(1:length(name)),dim1
         write(idev,'(''coord 3 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')')
     +    name(1:length(name)),dim1+dim2
         write(idev,'(''coord 4 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')') 
     +   name(1:length(name)),dim1+dim2+dim3

       else if(nspace.eq.4.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,''.irreg filetype=ascii '',
     +   ''offset=0 stride=4'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.irreg filetype=ascii '',
     +   ''offset=1 stride=4'')') name(1:length(name))
         write(idev,'(''coord 3 file='',a,''.irreg filetype=ascii '',
     +   ''offset=2 stride=4'')') name(1:length(name))
         write(idev,'(''coord 4 file='',a,''.irreg filetype=ascii '',
     +   ''offset=3 stride=4'')') name(1:length(name))

       else if(nspace.eq.2.and.field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,''.rect filetype=ascii '',
     +   ''offset=0 stride=1'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.rect filetype=ascii '',
     +   ''offset='',i3,'' stride=1'')') name(1:length(name)),dim1

       else if(nspace.eq.2.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,''.irreg filetype=ascii '',
     +   ''offset=0 stride=2'')') name(1:length(name))
         write(idev,'(''coord 2 file='',a,''.irreg filetype=ascii '',
     +   ''offset=1 stride=2'')') name(1:length(name))

       else if(nspace.eq.1.and.field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,''.rect filetype=ascii '',
     +   ''offset=0 stride=1'')') name(1:length(name))
c irregular no meaning for 1D!
       end if
c <<<<<<<<<<<<< ascii format

       else

c >>>>>>>>>>>>> binary format

c ibias and ibts defined in initialize

       do 15 i=1,veclen
         write(idev,'(''variable '',i2,'' file='',a,
     +   ''.data filetype=unformatted '',
     +   ''skip= '',i2,'' stride='',i2)')
     +   i, name(1:length(name))
     +   ,ibias + ibts*(i-1), veclen
15     continue

       if(nspace.eq.3.and. field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i3,'' stride=1'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') name(1:length(name))
     +   ,ibias+ibts*dim1
         write(idev,'(''coord 3 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') 
     +   name(1:length(name))
     +   ,ibias + ibts*(dim1+dim2)

       else if(nspace.eq.3.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=3'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=3'')') name(1:length(name))
     +   ,ibias + ibts 
         write(idev,'(''coord 3 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=3'')') name(1:length(name))
     +   ,ibias + 2*ibts 

       else if(nspace.eq.4.and. field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') name(1:length(name))
     +   ,ibias+ ibts*dim1
         write(idev,'(''coord 3 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')')
     +   name(1:length(name))
     +   ,ibias +ibts*(dim1+dim2)
         write(idev,'(''coord 4 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') 
     +   name(1:length(name))
     +   ,ibias + ibts*(dim1+dim2+dim3)

       else if(nspace.eq.4.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=4'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=4'')') name(1:length(name))
     +   ,ibias+ibts
         write(idev,'(''coord 3 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=4'')') name(1:length(name))
     +   ,ibias+2*ibts
         write(idev,'(''coord 4 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=4'')') name(1:length(name))
     +   ,ibias+3*ibts

       else if(nspace.eq.2.and.field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i6,'' stride=1'')') name(1:length(name))
     +   ,ibias + ibts*dim1

       else if(nspace.eq.2.and.field.eq.'irregular') then

         write(idev,'(''coord 1 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=2'')') name(1:length(name))
     +   ,ibias
         write(idev,'(''coord 2 file='',a,
     +   ''.irreg filetype=unformatted '',
     +   ''skip='',i3,'' stride=2'')') name(1:length(name))
     +   ,ibias + ibts

       else if(nspace.eq.1.and.field.eq.'rectilinear') then

         write(idev,'(''coord 1 file='',a,
     +   ''.rect filetype=unformatted '',
     +   ''skip='',i3,'' stride=1'')') name(1:length(name))
     +   ,ibias  
c irregular no meaning for 1D!
       end if

c <<<<<<<<<<<<< binary format
       end if  

       close (idev)

       end

c ********************************************************************
       subroutine AVSI_dims(dim1, dim2, dim3, dim4)
c *******************************************************************

       INCLUDE 'AVSI_inc'
       integer dim1, dim2, dim3, dim4

       write(*,'('' *** dim1 = '',i4,'', dim2 = '',i4,'', dim3 = '',i4,
     + '', dim4 = '',i4 )') dim1,dim2,dim3, dim4

       end


c *******************************************************************
       subroutine AVSI_transpose
c *******************************************************************
c define transpose for C ans PASCAL routines (i=1)

       INCLUDE 'AVSI_inc'
       itranspose=1
       end


c *******************************************************************
       subroutine AVSI_exch2(i,j,ii,jj)
c *******************************************************************

       INCLUDE 'AVSI_inc'

       if( itranspose.eq.1) then
          ii=j
          jj=i
       else
          ii=i
          jj=j
       end if

       end


c *******************************************************************
       subroutine AVSI_exch3(i,j,k,ii,jj,kk)
c *******************************************************************

       INCLUDE 'AVSI_inc'

       if( itranspose.eq.1) then
          ii=k
          jj=j
          kk=i
       else
          ii=i
          jj=j
          kk=k
       end if

       end


c *******************************************************************
       subroutine AVSI_exch4(i,j,k,l,ii,jj,kk,ll)
c *******************************************************************

       INCLUDE 'AVSI_inc'

       if( itranspose.eq.1) then
          ii=l
          jj=k
          kk=j
          ll=i
       else
          ii=i
          jj=j
          kk=k
          ll=l
       end if

       end


c ********************************************************************
       subroutine AVSI_gv
c *******************************************************************
c call AVS Graph Viewer

       INCLUDE 'AVSI_inc'

       print *,'*** Graph Viewer'
       call system(
     + 'avs -graph -data . &')

       end

c ********************************************************************
       subroutine AVSI_avs
c *******************************************************************
c call AVS

       INCLUDE 'AVSI_inc'

       print *,'*** AVS'
       call system(
     + 'avs -data . &')

       end
