{ AVSI_routines called from PASCAL, at SGI workstations }

type
   arr10=array [1..10] of real;
   arr40_20=array [1..40,1..20] of real;
   arr10_10_10=array [1..10,1..10,1..10] of real;

procedure AVSI_initialize_(var txt1,txt2,txt3,txt4:string;
                           i1,i2,i3,i4:integer);                external;
procedure AVSI_transpose_;                                      external;
procedure AVSI_1D_scalar_real_uniform_(var txt1,txt2:string;
             var dim1:integer;var s:arr10;
             i1,i2:integer);                                    external;
procedure AVSI_2D_scalar_real_uniform_(var txt1,txt2:string;
             var dim1,dim2:integer;var s:arr40_20;
             i1,i2:integer);                                    external;
procedure AVSI_3D_scalar_real_uniform_(var txt1,txt2:string;
             var dim1,dim2,dim3:integer;var s:arr10_10_10;
             i1,i2:integer);                                    external;


program pdemo;
var
   s1:arr10;
   s2:arr40_20;
   s3:arr10_10_10;

function Length(txt:string):integer;
var
   i:integer;
begin
   i:=80;
   while (txt[i]=' ') and (i>1) do i:=i-1;
   Length:=i;
end;


procedure AVSI_initialize(txt1,txt2,txt3,txt4:string);
begin
   AVSI_initialize_(txt1,txt2,txt3,txt4,Length(txt1),Length(txt2),
   Length(txt3),Length(txt4));
end;


procedure AVSI_1D_scalar_real_uniform(mtxt,ftxt:string;
             dim1:integer;var s:arr10);
begin
   AVSI_1D_scalar_real_uniform_(mtxt,ftxt,dim1,s,Length(mtxt),Length(ftxt));
end;


procedure AVSI_2D_scalar_real_uniform(mtxt,ftxt:string;
             dim1,dim2:integer;var s:arr40_20);
begin
   AVSI_2D_scalar_real_uniform_(mtxt,ftxt,dim1,dim2,s,Length(mtxt),Length(ftxt));
end;


procedure AVSI_3D_scalar_real_uniform(mtxt,ftxt:string;
             dim1,dim2,dim3:integer;var s:arr10_10_10);
begin
   AVSI_3D_scalar_real_uniform_(mtxt,ftxt,dim1,dim2,dim3,s,Length(mtxt),Length(ftxt));
end;


var
   i,j,k:integer;
   z:real;


begin
{ initialize AVSI, with parameter prompting ('* ') : } 
   AVSI_initialize('./networks','. ','*  ' ,'* ');

{ define transposition for Pascal calls }
  AVSI_transpose_;

{ make XY_Graph of y=x*x for x=1,2,...,10 }
   for i:=1 to 10 do s1[i]:=i*i;
   AVSI_1D_scalar_real_uniform('* ','1Ds',10,s1);

{ make Image of 2D data in s2: }
   for i:=1 to 40 do for j:=1 to 20 do s2[i,j]:=i+j;
   AVSI_2D_scalar_real_uniform('* ','2Ds',40,20,s2);

{ make Isosurface of 3D data in s3: }
   for i:=1 to 10 do for j:=1 to 10 do for k:=1 to 10 do
   begin
      z:=      -0.4*i*i + 4*i;
      z:= z * (-0.4*j*j + 4*j);
      z:= z * (-0.4*k*k + 4*k);
      s3[i,j,k]:=z;
   end;
   AVSI_3D_scalar_real_uniform('* ','3Ds',10,10,10,s3);
end.
