/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Field Math" (Filter) (Coroutine)                        */
/* Author: Krzysztof Nowinski                                            */
/* Date Created: Mon Aug 16 12:47:22 1993                                */
/*                                                                       */
#include <string.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>

#include "field_math.h" 
#include "avs/avs_math.h"
#include "y.tab.h"

 
extern nam_item 	named_stack[MAXNAMED];

extern int 	oldndim, olddims[];           /* used to check if field reallocation is necessary*/
extern int 	oldveclen;

extern int 	Output_ndim;
extern int	Output_veclen;
extern int 	Output_space_dimension;
extern int 	Make_points;

extern char 	vars[MAXLABELLENGTH],*variables;
extern char 	*input_line;
extern char 	form[PROGRAMLENGTH],
	*formula;
extern char 	program[MAXPROGLINES][MAXPROGLINELENGTH];
extern int  	current_line, program_length;

extern char 	field_var[SINGLELABELLENGTH];
extern char 	*progline;



int field_changed(infield)
AVSfield *infield;
{
	int i,k;
	k=0;
	if (infield->ndim!=oldndim) k=1;
	oldndim=infield->ndim;
	if (infield->veclen!=oldveclen) k=1;
	oldveclen=infield->veclen;
	for (i=0;i<infield->ndim;i++)
	    {
	    if ((infield->dimensions)[i]!=olddims[i]) k=1;
	    olddims[i]=(infield->dimensions)[i];
	    }
	return (k);
}

add_line(current_line)
int *current_line;
{
int i;
if (*current_line>program_length) 
	*current_line=program_length;
if (*current_line<0) *current_line=0;
if ((++program_length)>MAXPROGLINES)
	{
	AVSerror("Program too long");
	program_length-=1;
	AVSmodify_parameter("edit",AVS_VALUE,"edit",NULL,NULL);
	return(0);
 	}
for (i=program_length-1;i>*current_line;i--)
	strcpy(program[i],program[i-1]);
	strcpy(program[*current_line],input_line);
return(1);
}
read_line(current_line,line)
int *current_line;
char*line;
{
int i;
if (*current_line>program_length) 
	*current_line=program_length;
if (*current_line<0) *current_line=0;
if ((++program_length)>MAXPROGLINES)
	{
	AVSerror("Program too long");
	program_length-=1;
	AVSmodify_parameter("edit",AVS_VALUE,"edit",NULL,NULL);
	return(0);
 	}
for (i=program_length-1;i>*current_line;i--)
	strcpy(program[i],program[i-1]);
	strcpy(program[*current_line],line);
return(1);
}

void update_formula()
{
int i;
strcpy (formula,"\0");
for (i=0;i<program_length;i++)
	{
	formula=strcat(formula,program[i]);
	formula=strcat(formula,";");
	}	
AVSmodify_parameter("program",AVS_VALUE|AVS_MINVAL,
	program[current_line],formula,NULL);
}

void make_inlabels(infield,variables,j)
AVSfield_float *infield;
char *variables;
int *j;
{
	int i;	
	char *in1,*in2;
	char newvar[30];
	in1=infield->labels+1;
	for (i=0;i<infield->veclen;i++,(*j)++)
	    {
	    if ((in2=strchr(in1,';'))==NULL) in2=strchr(in1,'\0');
	    sprintf(newvar,"\na%d = ",i);
	    variables=strcat(variables,newvar);
	    strncpy(newvar,in1,in2-in1);
	    newvar[in2-in1]='\0';
	    variables=strcat(variables,newvar);
	    in1=in2+1;
	    }
}


void make_labels(infield,field1,field2,field3,field4,infield_add,variables)
AVSfield_float *infield, *field1, *field2, *field3, *field4, *infield_add;
char *variables;
{
int i,n;
char newvar[30];
    n=6;
    strcpy(variables,"Parameters:              p0 p1 p2 p3 p4 p5\n");
    variables=strcat(variables,"Dimensions:              ");
    for (i=0;i<Output_ndim;i++,n++)
	{
	sprintf(newvar,"dim%d ",i);
	variables=strcat(variables,newvar);
	}
    if (infield!=NULL)
	{
        if (strlen( infield->labels )>1)
 	    {
	    variables = strcat(variables,
		"\nInput field components:\nIn formulas, use a0,a1,... as variables");
	    make_inlabels(infield,variables,&n);
	    }
  	else
	    {
  	    variables = strcat(variables,"\nInput field:                ");
	    for (i=0;i<infield->veclen;i++,n++)
		{
		sprintf(newvar,"a%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
	n=6+infield->veclen+infield->ndim;
	variables=strcat(variables,      "\nInput field coords:     ");
	for (i=0;i<infield->nspace;i++,n++)
	    {
	    sprintf(newvar,"x%d ",i);
	    variables=strcat(variables,newvar);
	    }
	if (field1!=NULL)
 	    {
  	    variables = strcat(variables,"\nInput field1:              ");
	    for (i=0;i<field1->veclen;i++,n++)
		{
		sprintf(newvar,"b%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
	if (field2!=NULL)
 	    {
  	    variables = strcat(variables,"\nInput field2:              ");
	    for (i=0;i<field2->veclen;i++,n++)
		{
		sprintf(newvar,"c%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
	if (field3!=NULL)
 	    {
  	    variables = strcat(variables,"\nInput field3:              ");
	    for (i=0;i<field3->veclen;i++,n++)
		{
		sprintf(newvar,"d%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
	if (field4!=NULL)
 	    {
  	    variables = strcat(variables,"\nInput field4:              ");
	    for (i=0;i<field4->veclen;i++,n++)
		{
		sprintf(newvar,"e%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
   	}
	if (infield_add!=NULL)
 	    {
  	    variables = strcat(variables,"\nAdditional field:         ");
	    for (i=0;i<infield_add->veclen;i++,n++)
		{
		sprintf(newvar,"f%d ",i);
	   	variables=strcat(variables,newvar);
		}
	    }
	variables=strcat(variables,"\nField indices:             ");
	for (i=0;i<Output_ndim;i++,n++)
	    {
	    sprintf(newvar,"i%d ",i);
	    variables=strcat(variables,newvar);
	    }
	variables=strcat(variables,"\nOutput field:             ");
	for (i=0;i<Output_veclen;i++,n++)
	    {
	    sprintf(newvar,"w%d ",i);
	    variables=strcat(variables,newvar);
	    }
	if (Make_points!=0)
	    {
	    variables=strcat(variables,"\nOutput field coords:  ");
	    for (i=0;i<Output_space_dimension;i++,n++)
	   	{
		sprintf(newvar,"y%d ",i);
	   	variables=strcat(variables,newvar);
	    	}
	    }
	AVSmodify_parameter("variables",AVS_VALUE,variables,NULL,NULL);
}

