/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/

/******************************************************************************
 *                                                                            *
 * AVS 5 Data Input Module - DIALSBOX                                         *
 *                                                                            *
 *  Andy R. Haas                                                              *
 *  R.O.W. Sciences, Inc.                                                     *
 *  National Center for Toxicological Research                                *
 *                                                                            *
 * Written:     8/95                                                          *
 *                                                                            *
 ******************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XInput.h>
#include <avs/avs.h>
#include <avs/geom.h>

/* start IAC code additions */
#include <limits.h>
#include <float.h>
#ifndef MAXINT
#define MAXINT INT_MAX
#endif
#ifndef MINFLOAT
#define MINFLOAT FLT_MIN
#endif
/* end IAC code additions */

#define MODULE_NAME "dialsbox"

#define DEVICE_NAME "dial+buttons"  /* <-- user may need to edit this if X
				       server does not recognize this device
				       name. */


dialsbox_desc()
{
  int parm, port;
  
  AVSset_module_name (MODULE_NAME, MODULE_DATA);

  AVSadd_parameter ("Object Name", "string", "top", NULL, NULL);

  parm = AVSadd_parameter ("Sensitivity Delay", "integer", 3, 1, 15);
  AVSconnect_widget (parm, "islider");

  AVScreate_output_port ("Transformation Geom" , "geom");
}


XID get_device_id (Display *display, char *device_name)
{
  int ndevices;
  XDeviceInfoPtr slist, list;
  int i;
  XID id;
  
  list = (XDeviceInfoPtr) XListInputDevices (display, &ndevices);
  slist = list;
  
  id = MAXINT;
  for (i=0; i < ndevices; i++, list++) {

    if (!strcmp (list->name, device_name)) {
      id = list->id;
      break;
    }
  }

  XFreeDeviceList (slist);
  return id;
}


main (int argc, char *argv[])
{
  Display *display;
  XDevice *device;
  unsigned int type;
  XEventClass eventclass;
  XDeviceMotionEvent event;
  XID id;
  char event_flag;
  int mask;
  GEOMedit_list geom = NULL;
  char *name;
  char object[32];
  int sensitivity;
  float scale_factor;
  int delay;
  Time last_time = 0;
  int dial_val;

  float    last_xrot   = 0,  abs_xrot   = 0;
  float    last_yrot   = 0,  abs_yrot   = 0;
  float    last_zrot   = 0,  abs_zrot   = 0;
  float    last_scale  = 0,  abs_scale  = 1;
  float    last_xtrans = 0,  abs_xtrans = 0;
  float    last_ytrans = 0,  abs_ytrans = 0;
  float    last_ztrans = 0,  abs_ztrans = 0;
  
  float matrix[4][4];


  AVScorout_init (argc, argv, dialsbox_desc);

  object[0] = '%';
  AVScorout_input (&name, &sensitivity); 
  strcpy (object+1, name);
  delay = sensitivity * 30;

  if (!(display = XOpenDisplay (NULL)) ||
      (id = get_device_id (display, DEVICE_NAME)) == MAXINT) {

    AVSmessage ("1.0", AVS_Fatal, NULL, "main()", NULL,
		"No dialsbox connected to display: %s\n\n", getenv ("DISPLAY"));
    AVScorout_wait();
  }
  
  device = XOpenDevice (display, id);

  DeviceMotionNotify (device, type, eventclass);
  XSelectExtensionEvent (display, RootWindow (display, DefaultScreen (display)),
			 &eventclass, 1);


  while (1) {

    mask = COROUT_WAIT;
    event_flag = AVScorout_X_wait (display, NULL, &mask);

    if (mask == COROUT_WAIT) {

      AVScorout_input (&name, &sensitivity);
      strcpy (object+1, name);
      delay = sensitivity * 30;
    }

    if (event_flag) {

      XNextEvent (display,  (XEvent *) &event);
      if (event.type == type) {

	if (event.time - last_time < delay) continue;

	last_time = event.time;

	dial_val = event.axis_data[0];
	switch (event.first_axis)
	  {
	  case 6:
	    abs_xrot = dial_val % 360;
	    mat_x_rotate (dial_val - last_xrot, matrix);
	    last_xrot = dial_val;
	    break;
	  case 4:
	    abs_yrot = dial_val % 360;
	    mat_y_rotate (dial_val - last_yrot, matrix);
	    last_yrot = dial_val;
	    break;
	  case 2:
	    abs_zrot = dial_val % 360;
	    mat_z_rotate (dial_val - last_zrot, matrix);
	    last_zrot = dial_val;
	    break;

	  case 1:
	    scale_factor = 1.0 + (dial_val - last_scale) / 50.0;
	    last_scale = dial_val;
	    if (scale_factor <= 0.0)
	      scale_factor = MINFLOAT;

	    mat_scale (matrix, scale_factor, scale_factor, scale_factor);

	    abs_scale = 1.0 + dial_val / 50.0;
	    if (abs_scale <= 0.0)
	      abs_scale = MINFLOAT;
	    break;
	    
	  case 7:
	    abs_xtrans = dial_val / 50.0;
	    mat_translate (matrix, (dial_val - last_xtrans) / 20.0, 0.0, 0.0);
	    last_xtrans = dial_val;
	    break;
	  case 5:
	    abs_ytrans = dial_val / 50.0;
	    mat_translate (matrix, 0.0, (dial_val - last_ytrans) / 20.0, 0.0);
	    last_ytrans = dial_val;
	    break;
	  case 3:
	    abs_ztrans = dial_val / 50.0;
	    mat_translate (matrix, 0.0, 0.0, (dial_val - last_ztrans) / 20.0);
	    last_ztrans = dial_val;
	    break;
	  }

	if (event.first_axis > 0) {

	  geom = GEOMinit_edit_list (geom);
	  GEOMedit_concat_matrix (geom, object, &matrix[0][0]);
	  
	  AVScorout_output (geom);
	}
	
      }
    }
  }
}
