/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*------------------------------------------------------------------------------
 *  life.c: Conway's Game of Life for AVS
 *          Adapted from life.c by Steve Thorpe, NCSC. ext 161
 * 
 *  AUTHOR: Chris Pudney,
 *          Dept. Pharmacology, Univ. of Western Australia, Nedlands, 6907.
 *          cpudney@alphapharm.uwa.edu.au
 *
 *  VERSION: DEC Alpha, OSF/1, AVS
 *
 *  STARTED: 31/01/96
 *
 *  UPDATED: 06/02/96
 */


#include <stdio.h>
#include <string.h>
#define MEM_DEFS_ENABLE 
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>


#define INDEX(i,j)	((i)+(j)*nx)


/*
 * Globals: populations 
 */
char           *world1, *world2;


/*
 * Forward declarations: 
 
int
life_spec();
int
life(int, int, int, int, AVSfield_char *);
void
life_compute(int, int, int, int);
*/

/*------------------------------------------------------------------------------
 * Module Specification
 */

int
life_spec()
{
	int             param;


	AVSset_module_name("life", MODULE_DATA);

	(void) AVScreate_output_port("image", "field 2D 2-space scalar byte");

	param = AVSadd_parameter("Width", "integer", 150, 3, 1024);
	AVSconnect_widget(param, "typein_integer");
	AVSadd_parameter_prop(param, "width", "integer", 3);

	param = AVSadd_parameter("Height", "integer", 150, 3, 1024);
	AVSconnect_widget(param, "typein_integer");
	AVSadd_parameter_prop(param, "width", "integer", 3);

	param = AVSadd_parameter("Generations", "integer", 50, 1, 1000);
	AVSconnect_widget(param, "typein_integer");
	AVSadd_parameter_prop(param, "width", "integer", 3);

	param = AVSadd_parameter("Display Every", "integer", 1, 1, 100);
	AVSconnect_widget(param, "typein_integer");
	AVSadd_parameter_prop(param, "width", "integer", 3);

	param = AVSadd_parameter("Go!", "oneshot", 0, 0, 0);
	AVSconnect_widget(param, "oneshot");
	AVSadd_parameter_prop(param, "width", "integer", 3);

}				/* end life_spec() */


/*------------------------------------------------------------------------------
 * Compute routine - set up memory and call life routine
 */

void
life_compute(int x,
	     int y,
	     int generations,
	     int frequency)
{
	int             dims[2];
	AVSfield_char  *image;


	/* Allocate memory */
	dims[0] = x;
	dims[1] = y;
	image = (AVSfield_char *)
		AVSdata_alloc("field 2D 2-space scalar byte uniform", dims);
	world1 = malloc((unsigned) (x * y));
	world2 = malloc((unsigned) (x * y));
	if (!image || !world1 || !world2)
	{
		AVSerror("%s", "Cannot allocate memory for simulation.");
		return;

	}			/* end if (!image ... */

	/* Life */
	if (!life(x, y, frequency, generations, image))
	{
		AVSerror("%s", "An error occurred during simulation.");
		return;

	}			/* end if (life ... */

	/* Clean up */
	free(world1);
	free(world2);
	AVSdata_free("field",(char *)image); 

}				/* end life_compute() */


/*------------------------------------------------------------------------------
 * Conway's game of life.
 */

int
life(int nx,
     int ny,
     int frequency,
     int generations,
     AVSfield_char * image)
{
	int             neighbs, i, j, k, cx, cy, gen, size;
	char           *tmpWorld, *currWorld, *prevWorld;
	unsigned char  *imagei;


	/* Initialize values */
	gen = 0;
	size = nx * ny;
	bzero((char *) world1, size);
	bzero((char *) world2, size);
	imagei = (unsigned char *) image->data;

	/* Turn on central cell and neighbours */
	cx = nx / 2;
	cy = ny / 2;
	world1[INDEX(cx, cy)] = 255;
	world1[INDEX(cx + 1, cy + 1)] = 255;
	world1[INDEX(cx, cy + 1)] = 255;
	world1[INDEX(cx, cy - 1)] = 255;
	world1[INDEX(cx - 1, cy)] = 255;

	/* Loop through the generations */
	currWorld = world2;
	prevWorld = world1;
	for (gen = 1;
	     gen <= generations;
	     gen++)
	{
		for (i = 1;
		     i < nx - 1;
		     i++)
		{
			for (j = 1;
			     j < ny - 1;
			     j++)
			{
				/* Count live neighbours. */
				neighbs =
					(prevWorld[INDEX(i - 1, j + 1)] != 0) +
					(prevWorld[INDEX(i, j + 1)] != 0) +
					(prevWorld[INDEX(i + 1, j + 1)] != 0) +
					(prevWorld[INDEX(i - 1, j)] != 0) +
					(prevWorld[INDEX(i + 1, j)] != 0) +
					(prevWorld[INDEX(i - 1, j - 1)] != 0) +
					(prevWorld[INDEX(i, j - 1)] != 0) +
					(prevWorld[INDEX(i + 1, j - 1)] != 0);

				currWorld[INDEX(i, j)] =
				/* If alive and 2 or 3 neighbs then survive */
					((prevWorld[INDEX(i, j)] && (neighbs == 2 || neighbs == 3))
					 ||
				/* If empty and 3 neighbs then create */
					(!prevWorld[INDEX(i, j)] && (neighbs == 3)))
					? 255 : 0;

			}	/* end for (j ... */
		}		/* end for (i ... */

		/* Create image of current world */
		if (!(gen % frequency))
		{
			for (k = 0;
			     k < size;
			     k++)
			{
				if (currWorld[k])
				{
					if (!imagei[k])
					{
						imagei[k] = 255;

					}
					/* end if (!imagei ... */
					else
					if (imagei[k] > 1)
					{
						imagei[k]--;

					}	/* end else if (image ... */
				} 		/* end if (currWorld ... */
				else
				{
					imagei[k] = 0;

				}	/* end else */
			}	/* end for (k ... */
		}		/* end if (!(gen ... */

		/* Send output */
		AVScorout_output(image);
		AVScorout_exec();

		/* Swap world pointers.  */
		tmpWorld = currWorld;
		currWorld = prevWorld;
		prevWorld = tmpWorld;

	}			/* for (gen ... */

	return 1;

}				/* end life() */


/*------------------------------------------------------------------------------
 * Main program
 */

int
main(int argc,
     char *argv[])
{
	int             x, y, generations, frequency, go;

	/*
	 * Initialise 
	 */
	AVScorout_init(argc, argv, life_spec);

	while (1)
	{
		AVScorout_wait();
		AVScorout_input(&x, &y, &generations, &frequency, &go);
		if (go == 1)
		{
			life_compute(x, y, generations, frequency);

		}		/* end if (go ... */
	}			/* end while(1) */

	return 1;

}				/* end of main() */
