/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/**********************************************************************

Copyright (C) 1995, 1996  E. O. Lawrence Berkeley National Laboratory.  
All Rights Reserved.  Permission to copy and modify this software and 
its documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution for 
joint exchange.   Thus it is experimental and scientific in nature, 
undergoing development, and is provided "as is" with no warranties of 
any kind whatsoever, no support, promise of updates or printed 
documentation.

This work is supported by the U. S. Department of Energy under contract 
number DE-AC03-76SF00098 between the U. S. Department of Energy and the 
University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

***********************************************************************/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include "vr_util.h"


AVSinit_modules()
{
    int event_thresh();
    AVSmodule_from_desc(event_thresh);
}

/* ----   module to perform thresholding on the event stream ---- */

int
event_thresh()
{
    int p,event_thresh_p();
    
    AVSset_module_name("event threshold",MODULE_FILTER);
    AVSset_compute_proc(event_thresh_p);
    
    AVScreate_input_port("in_event_stream",VR_FIELD_STRING,REQUIRED);
    AVScreate_output_port("out_event_stream",VR_FIELD_STRING);
    
    p = AVSadd_parameter("dummy1","string","Angular Constraints (degrees)","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_float_parameter("Angular Min",0.5,0.0,5.);
    AVSconnect_widget(p,"dial");
    p = AVSadd_float_parameter("Angular Max",5.0,0.1,10.);
    AVSconnect_widget(p,"dial");

    p = AVSadd_parameter("dummy2","string","Positional Constraints (cm)","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_float_parameter("Translation Min",1.,0.0,5.);
    AVSconnect_widget(p,"dial");
    p = AVSadd_float_parameter("Translation Max",5.0,0.1,10.);
    AVSconnect_widget(p,"dial");

    
}

int
event_thresh_p(inf,outf,dummy1,amin,amax,dummy2,tmin,tmax)
AVSfield *inf,**outf;
char *dummy1;
float *amin,*amax;
char *dummy2;
float *tmin,*tmax;
{
    AVSfield template;
    float tvec[3],rvec[3];

    if (*outf)
	AVSfield_free(*outf);
    
    memset((char *)&template,0,sizeof(AVSfield));
    MAKE_VR_AVS_FIELD_TEMPLATE(&template);
    *outf = (AVSfield *)AVSfield_alloc(&template,VR_field_dims);

    VR_COPY_ALL_DATA((*outf),inf);

    VR_GET_TRANS_VECTOR(tvec[0],tvec[1],tvec[2],inf);
    VR_GET_ROT_VECTOR(rvec[0],rvec[1],rvec[2],inf);

    notch_filter(tvec,tmin,tmax,3);
    notch_filter(rvec,amin,amax,3);

    VR_SET_ROT_VECTOR(rvec[0],rvec[1],rvec[2],*outf);
    VR_SET_TRANS_VECTOR(tvec[0],tvec[1],tvec[2],*outf);
    
    return(1);
}

int
notch_filter(vec,vmin,vmax,n)
float *vec;
float *vmin,*vmax;
int n;
{
    int i;
    register float v,min,max,sign;
    double d;

    min = *vmin;
    max = *vmax;

    for(i=0;i<n;i++)
    {
	v = vec[i];
	if (v >= 0.)
	    sign = 1.;
	else
	    sign = -1.;
	
	v = (v > 0.) ? v : -v;
	
	if (v < min)
	    v = 0.;
	if (v > max)
	    v = 0.;
	vec[i] = v * sign;
    }
}
