C
C this file contains portions of code from the LINPACK distribution,
C available from netlib@ornl.gov.  the routines necessary for perfomring
C matrix inversion, single precision floating-point, have been corralled
C into this file.
C
C wes bethel
C lawrence berkeley laboratory
C fall 1994
C
C***********************************************************************
      INTEGER FUNCTION ISAMAX(N,SX,INCX)                                
C                                                                       
C     FINDS THE INDEX OF ELEMENT HAVING MAX. ABSOLUTE VALUE.            
C     JACK DONGARRA, LINPACK, 3/11/78.                                  
C                                                                       
      REAL SX(1),SMAX                                                   
      INTEGER I,INCX,IX,N                                               
C                                                                       
      ISAMAX = 0                                                        
      IF( N .LT. 1 ) RETURN                                             
      ISAMAX = 1                                                        
      IF(N.EQ.1)RETURN                                                  
      IF(INCX.EQ.1)GO TO 20                                             
C                                                                       
C        CODE FOR INCREMENT NOT EQUAL TO 1                              
C                                                                       
      IX = 1                                                            
      SMAX = ABS(SX(1))                                                 
      IX = IX + INCX                                                    
      DO 10 I = 2,N                                                     
         IF(ABS(SX(IX)).LE.SMAX) GO TO 5                                
         ISAMAX = I                                                     
         SMAX = ABS(SX(IX))                                             
    5    IX = IX + INCX                                                 
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C        CODE FOR INCREMENT EQUAL TO 1                                  
C                                                                       
   20 SMAX = ABS(SX(1))                                                 
      DO 30 I = 2,N                                                     
         IF(ABS(SX(I)).LE.SMAX) GO TO 30                                
         ISAMAX = I                                                     
         SMAX = ABS(SX(I))                                              
   30 CONTINUE                                                          
      RETURN                                                            
      END                                                               
C***********************************************************************
      SUBROUTINE SAXPY(N,SA,SX,INCX,SY,INCY)                            
C                                                                       
C     CONSTANT TIMES A VECTOR PLUS A VECTOR.                            
C     USES UNROLLED LOOP FOR INCREMENTS EQUAL TO ONE.                   
C     JACK DONGARRA, LINPACK, 3/11/78.                                  
C                                                                       
      REAL SX(1),SY(1),SA                                               
      INTEGER I,INCX,INCY,IX,IY,M,MP1,N                                 
C                                                                       
      IF(N.LE.0)RETURN                                                  
      IF (SA .EQ. 0.0) RETURN                                           
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20                               
C                                                                       
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS                
C          NOT EQUAL TO 1                                               
C                                                                       
      IX = 1                                                            
      IY = 1                                                            
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1                                 
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1                                 
      DO 10 I = 1,N                                                     
        SY(IY) = SY(IY) + SA*SX(IX)                                     
        IX = IX + INCX                                                  
        IY = IY + INCY                                                  
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C        CODE FOR BOTH INCREMENTS EQUAL TO 1                            
C                                                                       
C                                                                       
C        CLEAN-UP LOOP                                                  
C                                                                       
   20 M = MOD(N,4)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        SY(I) = SY(I) + SA*SX(I)                                        
   30 CONTINUE
      IF( N .LT. 4 ) RETURN                                             
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,4                                                 
        SY(I) = SY(I) + SA*SX(I)                                        
        SY(I + 1) = SY(I + 1) + SA*SX(I + 1)                            
        SY(I + 2) = SY(I + 2) + SA*SX(I + 2)                            
        SY(I + 3) = SY(I + 3) + SA*SX(I + 3)                            
   50 CONTINUE                                                          
      RETURN                                                            
      END                                                               
C***********************************************************************
      SUBROUTINE SGEDI(A,LDA,N,IPVT,DET,WORK,JOB)                       
      INTEGER LDA,N,IPVT(1),JOB                                         
      REAL A(LDA,1),DET(2),WORK(1)                                      
C                                                                       
C     SGEDI COMPUTES THE DETERMINANT AND INVERSE OF A MATRIX            
C     USING THE FACTORS COMPUTED BY SGECO OR SGEFA.                     
C                                                                       
C     ON ENTRY                                                          
C                                                                       
C        A       REAL(LDA, N)                                           
C                THE OUTPUT FROM SGECO OR SGEFA.                        
C                                                                       
C        LDA     INTEGER                                                
C                THE LEADING DIMENSION OF THE ARRAY  A .                
C                                                                       
C        N       INTEGER                                                
C                THE ORDER OF THE MATRIX  A .                           
C                                                                       
C        IPVT    INTEGER(N)                                             
C                THE PIVOT VECTOR FROM SGECO OR SGEFA.                  
C                                                                       
C        WORK    REAL(N)                                                
C                WORK VECTOR.  CONTENTS DESTROYED.                      
C                                                                       
C        JOB     INTEGER                                                
C                = 11   BOTH DETERMINANT AND INVERSE.                   
C                = 01   INVERSE ONLY.                                   
C                = 10   DETERMINANT ONLY.                               
C                                                                       
C     ON RETURN                                                         
C                                                                       
C        A       INVERSE OF ORIGINAL MATRIX IF REQUESTED.               
C                OTHERWISE UNCHANGED.                                   
C                                                                       
C        DET     REAL(2)                                                
C                DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.           
C                OTHERWISE NOT REFERENCED.                              
C                DETERMINANT = DET(1) * 10.0**DET(2)                    
C                WITH  1.0 .LE. ABS(DET(1)) .LT. 10.0                   
C                OR  DET(1) .EQ. 0.0 .                                  
C                                                                       
C     ERROR CONDITION                                                   
C                                                                       
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     
C        A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.           
C        IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY      
C        AND IF SGECO HAS SET RCOND .GT. 0.0 OR SGEFA HAS SET           
C        INFO .EQ. 0 .                                                  
C                                                                       
C     LINPACK. THIS VERSION DATED 08/14/78 .                            
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      
C                                                                       
C     SUBROUTINES AND FUNCTIONS                                         
C                                                                       
C     BLAS SAXPY,SSCAL,SSWAP                                            
C     FORTRAN ABS,MOD                                                   
C                                                                       
C     INTERNAL VARIABLES                                                
C                                                                       
      REAL T                                                            
      REAL TEN                                                          
      INTEGER I,J,K,KB,KP1,L,NM1                                        
C                                                                       
C                                                                       
C     COMPUTE DETERMINANT                                               
C                                                                       
      IF (JOB/10 .EQ. 0) GO TO 70                                       
         DET(1) = 1.0E0                                                 
         DET(2) = 0.0E0                                                 
         TEN = 10.0E0                                                   
         DO 50 I = 1, N                                                 
            IF (IPVT(I) .NE. I) DET(1) = -DET(1)                        
            DET(1) = A(I,I)*DET(1)                                      
C        ...EXIT                                                        
            IF (DET(1) .EQ. 0.0E0) GO TO 60                             
   10       IF (ABS(DET(1)) .GE. 1.0E0) GO TO 20                        
               DET(1) = TEN*DET(1)                                      
               DET(2) = DET(2) - 1.0E0                                  
            GO TO 10                                                    
   20       CONTINUE                                                    
   30       IF (ABS(DET(1)) .LT. TEN) GO TO 40                          
               DET(1) = DET(1)/TEN                                      
               DET(2) = DET(2) + 1.0E0                                  
            GO TO 30                                                    
   40       CONTINUE                                                    
   50    CONTINUE                                                       
   60    CONTINUE                                                       
   70 CONTINUE                                                          
C                                                                       
C     COMPUTE INVERSE(U)                                                
C                                                                       
      IF (MOD(JOB,10) .EQ. 0) GO TO 150                                 
         DO 100 K = 1, N                                                
            A(K,K) = 1.0E0/A(K,K)                                       
            T = -A(K,K)                                                 
            CALL SSCAL(K-1,T,A(1,K),1)                                  
            KP1 = K + 1                                                 
            IF (N .LT. KP1) GO TO 90                                    
            DO 80 J = KP1, N                                            
               T = A(K,J)                                               
               A(K,J) = 0.0E0                                           
               CALL SAXPY(K,T,A(1,K),1,A(1,J),1)                        
   80       CONTINUE                                                    
   90       CONTINUE                                                    
  100    CONTINUE                                                       
C                                                                       
C        FORM INVERSE(U)*INVERSE(L)                                     
C                                                                       
         NM1 = N - 1                                                    
         IF (NM1 .LT. 1) GO TO 140                                      
         DO 130 KB = 1, NM1                                             
            K = N - KB                                                  
            KP1 = K + 1                                                 
            DO 110 I = KP1, N                                           
               WORK(I) = A(I,K)                                         
               A(I,K) = 0.0E0                                           
  110       CONTINUE                                                    
            DO 120 J = KP1, N                                           
               T = WORK(J)                                              
               CALL SAXPY(N,T,A(1,J),1,A(1,K),1)                        
  120       CONTINUE                                                    
            L = IPVT(K)                                                 
            IF (L .NE. K) CALL SSWAP(N,A(1,K),1,A(1,L),1)               
  130    CONTINUE                                                       
  140    CONTINUE                                                       
  150 CONTINUE                                                          
      RETURN                                                            
      END                                                               
C***********************************************************************
      SUBROUTINE SGEFA(A,LDA,N,IPVT,INFO)                               
      INTEGER LDA,N,IPVT(1),INFO                                        
      REAL A(LDA,1)                                                     
C                                                                       
C     SGEFA FACTORS A REAL MATRIX BY GAUSSIAN ELIMINATION.              
C                                                                       
C     SGEFA IS USUALLY CALLED BY SGECO, BUT IT CAN BE CALLED            
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.          
C     (TIME FOR SGECO) = (1 + 9/N)*(TIME FOR SGEFA).
C                                                                       
C     ON ENTRY                                                          
C                                                                       
C        A       REAL(LDA, N)                                           
C                THE MATRIX TO BE FACTORED.                             
C                                                                       
C        LDA     INTEGER                                                
C                THE LEADING DIMENSION OF THE ARRAY  A .                
C                                                                       
C        N       INTEGER                                                
C                THE ORDER OF THE MATRIX  A .                           
C                                                                       
C     ON RETURN                                                         
C                                                                       
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS         
C                WHICH WERE USED TO OBTAIN IT.                          
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE       
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER          
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.       
C                                                                       
C        IPVT    INTEGER(N)                                             
C                AN INTEGER VECTOR OF PIVOT INDICES.                    
C                                                                       
C        INFO    INTEGER                                                
C                = 0  NORMAL VALUE.                                     
C                = K  IF  U(K,K) .EQ. 0.0 .  THIS IS NOT AN ERROR       
C                     CONDITION FOR THIS SUBROUTINE, BUT IT DOES        
C                     INDICATE THAT SGESL OR SGEDI WILL DIVIDE BY ZERO  
C                     IF CALLED.  USE  RCOND  IN SGECO FOR A RELIABLE   
C                     INDICATION OF SINGULARITY.                        
C                                                                       
C     LINPACK. THIS VERSION DATED 08/14/78 .                            
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      
C                                                                       
C     SUBROUTINES AND FUNCTIONS                                         
C                                                                       
C     BLAS SAXPY,SSCAL,ISAMAX                                           
C                                                                       
C     INTERNAL VARIABLES                                                
C                                                                       
      REAL T                                                            
      INTEGER ISAMAX,J,K,KP1,L,NM1                                      
C                                                                       
C                                                                       
C     GAUSSIAN ELIMINATION WITH PARTIAL PIVOTING                        
C                                                                       
      INFO = 0                                                          
      NM1 = N - 1                                                       
      IF (NM1 .LT. 1) GO TO 70                                          
      DO 60 K = 1, NM1                                                  
         KP1 = K + 1                                                    
C                                                                       
C        FIND L = PIVOT INDEX                                           
C                                                                       
         L = ISAMAX(N-K+1,A(K,K),1) + K - 1                             
         IPVT(K) = L                                                    
C                                                                       
C        ZERO PIVOT IMPLIES THIS COLUMN ALREADY TRIANGULARIZED          
C                                                                       
         IF (A(L,K) .EQ. 0.0E0) GO TO 40                                
C                                                                       
C           INTERCHANGE IF NECESSARY                                    
C                                                                       
            IF (L .EQ. K) GO TO 10                                      
               T = A(L,K)                                               
               A(L,K) = A(K,K)                                          
               A(K,K) = T                                               
   10       CONTINUE                                                    
C                                                                       
C           COMPUTE MULTIPLIERS                                         
C                                                                       
            T = -1.0E0/A(K,K)                                           
            CALL SSCAL(N-K,T,A(K+1,K),1)                                
C                                                                       
C           ROW ELIMINATION WITH COLUMN INDEXING                        
C                                                                       
            DO 30 J = KP1, N                                            
               T = A(L,J)                                               
               IF (L .EQ. K) GO TO 20                                   
                  A(L,J) = A(K,J)                                       
                  A(K,J) = T                                            
   20          CONTINUE                                                 
               CALL SAXPY(N-K,T,A(K+1,K),1,A(K+1,J),1)                  
   30       CONTINUE                                                    
         GO TO 50                                                       
   40    CONTINUE                                                       
            INFO = K                                                    
   50    CONTINUE                                                       
   60 CONTINUE                                                          
   70 CONTINUE                                                          
      IPVT(N) = N                                                       
      IF (A(N,N) .EQ. 0.0E0) INFO = N                                   
      RETURN                                                            
      END                                                               
C***********************************************************************
      SUBROUTINE  SSCAL(N,SA,SX,INCX)                                   
C                                                                       
C     SCALES A VECTOR BY A CONSTANT.                                    
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO 1.                     
C     JACK DONGARRA, LINPACK, 3/11/78.                                  
C                                                                       
      REAL SA,SX(1)                                                     
      INTEGER I,INCX,M,MP1,N,NINCX                                      
C                                                                       
      IF(N.LE.0)RETURN                                                  
      IF(INCX.EQ.1)GO TO 20                                             
C                                                                       
C        CODE FOR INCREMENT NOT EQUAL TO 1                              
C                                                                       
      NINCX = N*INCX                                                    
      DO 10 I = 1,NINCX,INCX                                            
        SX(I) = SA*SX(I)                                                
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C        CODE FOR INCREMENT EQUAL TO 1                                  
C                                                                       
C                                                                       
C        CLEAN-UP LOOP                                                  
C                                                                       
   20 M = MOD(N,5)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        SX(I) = SA*SX(I)                                                
   30 CONTINUE                                                          
      IF( N .LT. 5 ) RETURN                                             
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,5                                                 
        SX(I) = SA*SX(I)                                                
        SX(I + 1) = SA*SX(I + 1)                                        
        SX(I + 2) = SA*SX(I + 2)                                        
        SX(I + 3) = SA*SX(I + 3)                                        
        SX(I + 4) = SA*SX(I + 4)                                        
   50 CONTINUE                                                          
      RETURN                                                            
      END                                                               
C***********************************************************************
      SUBROUTINE  SSWAP (N,SX,INCX,SY,INCY)                             
C                                                                       
C     INTERCHANGES TWO VECTORS.                                         
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO 1.                    
C     JACK DONGARRA, LINPACK, 3/11/78.                                  
C                                                                       
      REAL SX(1),SY(1),STEMP                                            
      INTEGER I,INCX,INCY,IX,IY,M,MP1,N                                 
C                                                                       
      IF(N.LE.0)RETURN                                                  
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20                               
C                                                                       
C       CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS NOT EQUAL       
C         TO 1                                                          
C                                                                       
      IX = 1                                                            
      IY = 1                                                            
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1                                 
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1                                 
      DO 10 I = 1,N                                                     
        STEMP = SX(IX)                                                  
        SX(IX) = SY(IY)                                                 
        SY(IY) = STEMP                                                  
        IX = IX + INCX                                                  
        IY = IY + INCY                                                  
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C       CODE FOR BOTH INCREMENTS EQUAL TO 1                             
C                                                                       
C                                                                       
C       CLEAN-UP LOOP                                                   
C                                                                       
   20 M = MOD(N,3)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        STEMP = SX(I)                                                   
        SX(I) = SY(I)                                                   
        SY(I) = STEMP                                                   
   30 CONTINUE                                                          
      IF( N .LT. 3 ) RETURN                                             
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,3                                                 
        STEMP = SX(I)                                                   
        SX(I) = SY(I)                                                   
        SY(I) = STEMP                                                   
        STEMP = SX(I + 1)                                               
        SX(I + 1) = SY(I + 1)                                           
        SY(I + 1) = STEMP                                               
        STEMP = SX(I + 2)                                               
        SX(I + 2) = SY(I + 2)                                           
        SY(I + 2) = STEMP                                               
   50 CONTINUE                                                          
      RETURN                                                            
      END                                                               
