// INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
// Please read the file DISCLAIMER for conditions associated with this file.
// avs@iavsc.org, www.iavsc.org

library ReadDICOMMods<build_dir="iac_proj/rd_dicom", cxx_hdr_files="fld/Xfld.h", out_src_file="gen.cxx", out_hdr_file="gen.h"> {
   // read_DCMLIST reads/creates/modifies a list of DICOM series'
   // present in the a the local directory
   module read_DCMLIST <cxx_hdr_files="read_DCMLIST.h", src_file="read_DCMLIST.cxx", cxx_members="int read_DCMLIST(int &npats, int &_nseries, int &_nfiles, dicom_pat_info **pats, dicom_file_info **dfiles);\nint rescan_dir(int &npats, int &_nseries, int &_nfiles, dicom_pat_info **pats, dicom_file_info **dfiles);\nint write_DCMLIST(int npats, int _nseries, int _nfiles, dicom_pat_info *pats, dicom_file_info *dfiles);\nint output_infos(int npats, int _nseries, int _nfiles, dicom_pat_info *pats, dicom_file_info *dfiles);">
   {
      string dirname<NEportLevels={2,1}>;
      int rescan<NEportLevels={2,0}>;
      int delete<NEportLevels={2,0}>;
      int nfiles<NEportLevels={0,2}>;
      string filenames<NEportLevels={0,2}>[nfiles];
      int nseries<NEportLevels={0,2}>;
      string series<NEportLevels={0,2}>[nseries];
      int series_st_en<NEportLevels={0,2}>[nseries][2];
      int selected_series<NEportLevels={2,0}>;
      cxxmethod+notify_inst+req read (
	 dirname+read+req+notify,
	 rescan+read+notify,
	 nfiles+write,
	 filenames+write,
	 nseries+write,
	 series+write,
	 series_st_en+write
      );
      cxxmethod+req remove (
	 delete+read+req+notify,
	 dirname+read+req,
	 selected_series+read+req,
	 nfiles+write,
	 filenames+write,
	 nseries+write,
	 series+write,
	 series_st_en+write
      );
   };

   // read_dicom_files reads in the given array of DICOM filenames
   // reconstructing a volume of data. The image are now transposed correctly
   module read_dicom_files <src_file="read_dicom_files.c", c_src_files="read_dicom_utils.c",
      hdr_dirs="./iac_proj/rd_dicom/Papyrus3 ./iac_proj/rd_dicom/Papyrus3/DicomDir ./iac_proj/rd_dicom/Papyrus3/JpegDir/JpgLless ./iac_proj/rd_dicom/Papyrus3/JpegDir/JpgLossy">
   {
      // Input: DICOM filename
      string+read+req filenames<NEportLevels={2,0}>[];
      int+notify trigger<NEportLevels={2,0}>;
      int+read flip<NEportLevels={2,0}>;
      // Outputs: Currently busy, header information & image data
      int+write+nonotify busy<NEportLevels={0,2}> = 0;
      int+write+nonotify done<NEportLevels={0,2}> = 0;
      IAC_PROJ.ReadDICOM.ReadDICOMData.DICOM_Header+write+nonotify header<NEportLevels={0,2}>;
      IAC_PROJ.ReadDICOM.ReadDICOMData.DICOM_Volume+write+nonotify volume<NEportLevels={0,2}>;
      // External C code function
      omethod+req dicom_update<status=1> = "Read_Dicom_Files";
   };
   
};
