/********************************************************************************/
/*										*/
/*	Project  : P A P Y R U S  Toolkit					*/
/*	File     : PapyFileSystem3.c						*/
/*	Function : contains machine specific calls to the different file systems*/
/*	Authors  : Christian Girard						*/
/*		   Marianne Logean						*/
/*								   	      	*/
/*	History  : 06.1995	version 3.0					*/
/*										*/
/*	(C) 1995 The University Hospital of Geneva      			*/
/*		       All Rights Reserved					*/
/*										*/
/********************************************************************************/

/* ------------------------- includes ------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>		/* open */


#ifndef _WINDOWS
#ifndef Mac
#ifdef hpux
#include <sys/unistd.h>
#else
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#endif
#endif
#endif

#ifndef PapyFileSystem3H
#include "PapyFileSystem3.h"
#endif

#ifndef __PapyError3__
#include "PapyError3.h"
#endif

/********************************************************************************/
/*										*/
/*	Papy3FCreate : overwrites the standard create file function		*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

int
Papy3FCreate (char *filename, PAPY_FILE volume, int kind, PAPY_FILE *fp, void **aFSSpec)
{
  int			err;
  
  
  if ((*fp = fopen (filename, "rb")) != NULL)
  {
    (void) fclose (*fp);
    RETURN (papFileAlreadyExist);
  }

  return 0;

} /* endof Papy3FCreate */


/********************************************************************************/
/*										*/
/*	Papy3FOpen : overwrites the standard open file function			*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

PapyShort
Papy3FOpen (char *filename, char permission, PAPY_FILE volumeNb, PAPY_FILE *fp,
	    void *aFSSpec)
/*## Start of IAC Modification */
/* permission r : read, w : write, a : read/write (all) */
/*## End of IAC Modification */
{
  switch (permission) {
    case 'r' : if ((*fp = fopen (filename, "rb")) == NULL) RETURN (papOpenFile); break;
    case 'w' : if ((*fp = fopen (filename, "wb")) == NULL) RETURN (papOpenFile); break;
    case 'a' : 
    default  : if ((*fp = fopen (filename, "r+")) == NULL) RETURN (papOpenFile);
/*## Start of IAC Modification */
  } /* endsandwich */
/*## End of IAC Modification */

  return 0;

} /* endof Papy3FOpen */


/********************************************************************************/
/*										*/
/*	Papy3FClose : overwrites the standard close file function		*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

int
Papy3FClose (PAPY_FILE *fp)
{
  fclose (*fp);
  
  return 0;
  
} /* endof Papy3FClose */


/********************************************************************************/
/*										*/
/*	Papy3FDelete : overwrites the standard delete file function		*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

int
Papy3FDelete (char *filename, void *identifier)
{
  return (unlink ((char *) filename));

} /* endof Papy3FDelete */



/********************************************************************************/
/*										*/
/*	Papy3FRead : overwrites the standard read from file function		*/
/*	return : error (0 if OK, negative value otherwise)			*/
/*										*/
/********************************************************************************/

PapyShort
Papy3FRead (PAPY_FILE fp, PapyULong *bytesToRead, PapyULong count, void *buffer)
{
  PapyShort		err = 0;
  
  err = (PapyShort)(fread ((char *) buffer, (size_t) *bytesToRead, count, fp));

  return err;

} /* endof Papy3FRead */


/********************************************************************************/
/*									 	*/
/*	Papy3FWrite : overwrite the standard write to file function		*/
/*	return : error (0 if OK, negative value otherwise)			*/
/*										*/
/********************************************************************************/

PapyShort
Papy3FWrite (PAPY_FILE fp, PapyULong *bytesToWrite, PapyULong count, void *buffer)
{
  PapyShort		err = 0;
  
  err = (PapyShort)(fwrite ((char *) buffer, (int)*bytesToWrite, count, fp));

  return err;

} /* endof Papy3FWrite */


/********************************************************************************/
/*									 	*/
/*	Papy3FSeek : Papyrus own build file pointer positioning function.	*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

int
Papy3FSeek (PAPY_FILE fp, int posMode, PapyLong offset)
{
  int err;
  
  err = fseek (fp, (long) offset, posMode);
  
  return err;

} /* endof Papy3FSeek */


/********************************************************************************/
/*									 	*/
/*	Papy3FTell : Papyrus function to get the current position of the file	*/
/*	pointer.								*/
/*	return : standard error message						*/
/*										*/
/********************************************************************************/

int
Papy3FTell (PAPY_FILE fp, PapyLong *filePos)
{
  int err = 0;
  
  *filePos = (PapyLong) ftell (fp);
  
  return err;

} /* endof Papy3FTell */


/********************************************************************************/
/*									 	*/
/*	Papy3FPrint : Papyrus function to set a string.				*/
/*										*/
/********************************************************************************/

void
Papy3FPrint (char *string, char *format, int value)
{
  
  sprintf (string, format, value);
        
} /* endof Papy3FPrint */
