#! /bin/sh

read_to_brace() {
	if [ -f tmp.txt ] 
	then 
		rm tmp.txt
	fi
	while read vline
	do
		if [ "$vline" != "};" ]
		then
			echo "$vline" >> tmp.txt 
		fi
	done < $1
}

read_iac_proj() {
	writehead=1;
	readnext=0;
	valid=0;
	while read installine;
	do
		if [ $valid != "1" ]
		then
			valid=`echo $installine | grep -c "^[:space:]*# IAC Project Installation Information"`
			echo $valid
		fi

		if [ $valid = "1" ]
		then
			if [ $writehead = "1" ]
			then
				read_to_brace iac_proj/iac_proj.v
				writehead=0;
			fi
			if [ $readnext = "0" ]
			then 
				readnext=`echo $installine | grep -c "^[:space:]*# Insert the following line into the iac_proj/iac_proj.v file"` 
				continue
			else
				readnext=`echo $installine | grep -c -v "^[:space:]*#"`
			fi 
			if [ $readnext = "1" ]
			then 
				allreadyIn=`grep -c "$installine" tmp.txt 2>/dev/null`
				if [ "$allreadyIn" = "0" ]
				then
					echo "$installine" >> tmp.txt
				fi
			fi
		fi
	done < $1
}

read_iac_lib() {
	err=0
	libFileName="0"
	readnext=0
	writenext=0
	while read installine 
	do 
		comment=`echo $installine | grep -c "^[:space:]*#"`
		if [ $comment = "1" ]
		then 
			readnext=0	
			writenext=0
		fi
		readcomment=`echo $installine | grep -c "^[:space:]*# In the following iac_lib file"` 
		if [ $readcomment = "1" ]
		then 
			readnext=1
			isLibFile=0
		fi
		writecomment=`echo $installine | grep -c "^[:space:]*# insert the following line"` 
		if [ $writecomment = "1" ]
		then 
			writenext=1
		fi
		if [ $readnext = "1" ] 
		then	
			if [ $comment = "0" ]
			then
				isLibFile=`ls iac_lib/ | grep -c $installine 2>/dev/null`
				if [ "$isLibFile" = "0" ]
				then
					echo "Invalid library-file ($installine) used in Project in $input_file" >>/dev/stderr
					err=`echo $err+1 | bc`;
					continue
				fi
				oldLibFileName="$libFileName"
				libFileName="$installine"
			fi
		fi
		if [ $writenext = "1" ] 
		then
			if [ $comment = "0" ] 
			then
				if [ "$oldLibFileName" != "$libFileName" ]
				then
					if [ "$oldLibFileName" != "0" ]
					then
						echo "};" >> tmp.txt
						mv tmp.txt iac_lib/$oldLibFileName
					fi
					oldLibFileName="$libFileName"
					read_to_brace iac_lib/$libFileName
				fi
				allreadyIn=`grep -c "$installine" tmp.txt 2>/dev/null`
				if [ "$allreadyIn" = "0" ]
				then
					echo "$installine" >> tmp.txt
				fi
			fi
		fi
		echo "$err iac_lib/$libFileName ";
	done < $input_file
}

for input_file in `find iac_proj/ -name INSTALL`; do
	touch iac_lib/0
	touch iac_lib/tmp.txt
	valid=`read_iac_proj $input_file`
	if [ "$valid" = "1" ]
	then
		echo "};" >> tmp.txt
		mv tmp.txt iac_proj/iac_proj.v
	else
		echo "Invalid INSTALL file in $input_file" >>/dev/stderr 
		continue
	fi
	res=`read_iac_lib $input_file | tail -1`
	err=`echo $res | cut -d" " -f1`
	FileName=`echo $res | cut -d" " -f2`
        echo "};" >> tmp.txt
        mv tmp.txt $FileName
	if [ $err -eq 0 ]
	then
		echo "Project $input_file successfully installed"
	else 
		echo "Project $input_file installed with $err errors"	
	fi
	if [ -f iac_lib/tmp.txt ]
	then
		rm iac_lib/tmp.txt
	fi
	if [ -f iac_lib/0 ]
	then
		rm iac_lib/0
	fi
done
