/*
 * INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
 * Please read the file DISCLAIMER for conditions associated with this file.
 * avs@iavsc.org, www.iavsc.org
 */

/* ----------------------------------------------------------------------
 * ArrayAToF Module
 * ----------------------------------------------------------------------
 * Description:
 *   
 *   Takes an array of strings in and produces array of floats out.
 * 
 * Authors: 
 *   Brian Selle, Leon Thrane, Advanced Visual Systems Inc.
 *   Documentation written by Ian Curington
 *
 * Revision: 9th February 2000 - Paul G. Lever, IAC
 *   Converted to IAC format.
 *
 * ----------------------------------------------------------------------
 * Note:
 *   The gen.h include file is generated by Express when the module is 
 *   compiled. It avoids including "user.h" or "express.h" directly, so 
 *   that the module may be moved across the processes by changing the V
 *   properties in the library.
 * ----------------------------------------------------------------------
 */

#include "iac_proj/arr_atof/gen.h"
#include "XP_OM_CALL.h"
#include <stdlib.h>

//----------------------------------------------------------------------------
//  prototypes for static functions                                           
//----------------------------------------------------------------------------

static void
FreeOnExit( char  *temp_string, 
            float *floats_out_ptr );

//----------------------------------------------------------------------------
//  external functions                                                        
//----------------------------------------------------------------------------

int
ArrayAToF_ArrayAToF::update(OMevent_mask ,int ) {
  int status;

  // Get the input string array size
  int  string_array_size = 0;
  string_array_size = strings_in.ret_array_size();  

  // Set the output float array size and get a pointer to the array
  OMCALLR_SUCCESS( "Set the size of the float array",
		    floats_out.set_array_size( string_array_size ) );    

  float *floats_out_ptr = NULL;
  OMCALLR_NONNULLPTR( "Get pointer to the floats_out array",
		      floats_out_ptr, 
		      (float *)floats_out.ret_array_ptr() );
  
  // Loop through the input string array converting each string to a float
  char  *temp_string = NULL;   
  for( int i = 0; i < strings_in.ret_array_size(); i++ )
  {
    OMCALLFR_NONNULLPTR( "Get next string in input string array",   
			 temp_string, 
			 strings_in.ret_str_array_val( i, NULL, 0 ),
			 FreeOnExit( temp_string, floats_out_ptr ) );
    
    floats_out_ptr[i] = (float)atof( temp_string );

    free( temp_string );
    temp_string = NULL;
  };
  
  // Clean up
  FreeOnExit( temp_string, floats_out_ptr );

  // Successful return
  return( XP_SUCCESS );
}

//----------------------------------------------------------------------------
//  static functions                                                           
//----------------------------------------------------------------------------

static void
FreeOnExit( char  *temp_string,
	    float *floats_out_ptr )
{

   if ( temp_string != (char *)NULL ) 
   {
      free( temp_string );
   }
   if ( floats_out_ptr != (float *)NULL ) 
   {
      ARRfree( floats_out_ptr );
   }

}

/* end of file */
