/*
 * INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
 * Please read the file DISCLAIMER for conditions associated with this file.
 * avs@iavsc.org, www.iavsc.org
 */

/* ----------------------------------------------------------------------
 * FindStringInArrayCore Module
 * ----------------------------------------------------------------------
 * Searches for the given string in an array of strings.  If
 * ignore_whitespace is non-zero, any white space padding is removed from
 * the beginning and end of the search string, and strings in the array.
 *
 * Authors: Brian Selle, Leon Thrane, Jon Davies, April 17, 2001
 *
 * ----------------------------------------------------------------------
 * Note:
 *   The gen.h include file is generated by Express when the module
 *   is compiled. It avoids including "user.h" or "express.h" directly,
 *   so that the module may be moved across the processes by changing the
 *   V properties in the library.
 * ----------------------------------------------------------------------
 */

//----------------------------------------------------------------------------
//  headers                                                                   
//----------------------------------------------------------------------------

#include "gen.h"
#include <ctype.h>
#include "xpomcall.h"

//----------------------------------------------------------------------------
//  prototypes for static functions                                           
//----------------------------------------------------------------------------

static void
SkipWhiteSpace( char  *input_string, 
                char **new_start );

//----------------------------------------------------------------------------
//  external functions                                                        
//----------------------------------------------------------------------------

int
FindStringInArray_FindStringInArrayMods_FindStringInArrayCore::update(OMevent_mask event_mask, int seq_num)
{
	int status;// Function return status 
	//active (OMXint read req)
	//ignore_whitespace (OMXint read req)
	//search_string (OMXstr read write req notify)
	//strings (OMXstr_array read write req notify)
	//selectedItem (OMXint write)

	/***********************/
	/* Function's Body     */
	/***********************/

	// Check for valid active
	if( active == 0 )
	{
		return( XP_SUCCESS );
	}

	// Check for data
	int array_size = strings.ret_array_size();  
	if( array_size == 0 )
	{
		return( XP_SUCCESS);
	}

	// Loop through each string in the array  
	char *search_string_local = (char *)search_string;
	char *current_string;
	char *current_string_local;
	

	if( ignore_whitespace )
	{
		SkipWhiteSpace( search_string_local, &search_string_local );
	}
	for( int i = 0; i < array_size; i++ )
	{
		OMCALLR_NONNULLPTR( "Get string from string array",
			current_string,
			strings.ret_str_array_val( i, NULL, 0 ) ); 
		current_string_local=(char*) current_string;
		if( ignore_whitespace )
		{
			SkipWhiteSpace( current_string_local, &current_string_local );
		}

		if( strcmp( search_string_local, current_string_local) == 0 )
		{
			selectedItem = i;
			return( XP_SUCCESS );     
		}
		free (current_string);
	}
	
	// Item not found, reset selectedItem
	OMset_obj_val(selectedItem, OMnull_obj, 0);
	return( XP_SUCCESS );
}

//-----------------------------------------------------------------------------
//  static functions                                                           
//-----------------------------------------------------------------------------

static void
SkipWhiteSpace( char  *input_string, 
                char **new_start )
{
	int   new_len   = strlen(input_string);
	char *new_end   = input_string + new_len - 1;
		  *new_start = input_string;

	while (new_len && isspace(*new_end))
	{
		*new_end = '\0';
		new_end--;
		new_len--;
	}

	while (isspace(**new_start))
	{
		(*new_start)++;
	}
}
