/*
 * INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
 * Please read the file DISCLAIMER for conditions associated with this file.
 * avs@iavsc.org, www.iavsc.org
 */

/* ----------------------------------------------------------------------
 * MakeArrayMod Module
 * ----------------------------------------------------------------------
 * Description:
 *   
 * This is an example of how to create an array of floats on the fly
 * using the C-API.  This utilizes the currently undocumented
 * OMset_array_dims ( I think the variables are like
 * OMget_array_dims....)
 * 
 * You can't create the object and then change the dimensions using
 * OMset_array_size because that required that the array to be changed
 * already BE an array.  The object created with OMcreate_obj_from_path
 * is not yet an array.
 * 
 * Author: Leigh J. Grundy - 18th December 1998
 *
 * Revision: Paul G. Lever - 1st February 2000
 *   Converted to basic IAC format.
 *
 * ----------------------------------------------------------------------
 * Note:
 *   The gen.h include file is generated by Express when the module is 
 *   compiled. It avoids including "user.h" or "express.h" directly, so 
 *   that the module may be moved across the processes by changing the V
 *   properties in the library.
 * ---------------------------------------------------------------------- */

#include "iac_proj/mk_array/gen.h"

int
mk_array( OMobj_id MkArray_id, OMevent_mask event_mask, int seq_num ) {

  /* Declare Variables */

  int dims[1];
  float arr[10];
  OMobj_id arrayId;
  OMobj_id grp_id;

  /* Find Obj_id of group and warn if can't */
  
  grp_id = OMfind_str_subobj( OMroot_obj,
			      "Applications.MakeArrayEg.group",
			      OM_OBJ_RW);

  if( OMis_null_obj(grp_id) )
    printf("Error finding group object id\n");	

  /* create the float object and set the dimensions */  
  
  arrayId = OMcreate_obj_from_path("float", "NewFloat",grp_id);
  dims[0] = sizeof(arr)/sizeof(float);
  OMset_array_dims(arrayId, 1, dims);  

  /***********************/
  /* Function's Body     */
  /***********************/
  
  ERRverror( "",ERR_NO_HEADER | ERR_INFO,
	     "I'm in function: mk_array generated from method: MkArray.update\n");

  return(1);
}

/* end of file */
