/*
 * INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
 * Please read the file DISCLAIMER for conditions associated with this file.
 * avs@iavsc.org, www.iavsc.org
 */

/* ----------------------------------------------------------------------
 * modStepCalc Module
 * ----------------------------------------------------------------------
 * Description:
 *   
 *   StepCalc performs a "step" data lookup based on the inputValue.
 *
 * Authors: 
 *   Brian Selle, Leon Thrane, Advanced Visual Systems Inc.
 *   Documentation written by Ian Curington
 *
 * Revision: 10th February 2000 - Paul G. Lever, IAC
 *   Converted to IAC format.
 *
 * ----------------------------------------------------------------------
 * Note:
 *   The gen.h include file is generated by Express when the module is 
 *   compiled. It avoids including "user.h" or "express.h" directly, so 
 *   that the module may be moved across the processes by changing the V
 *   properties in the library.
 * ----------------------------------------------------------------------
 */

#include "iac_proj/stepcalc/gen.h"
#include "XP_OM_CALL.h"

int
StepCalc_modStepCalc::update(OMevent_mask , int seq_num)
{
  int       status;       // Function return status
   
  // Check for valid active
  if( active == 0 )
  {
    return( XP_SUCCESS );
  }

  // Check for valid stepX and stepY data
  if( stepX.ret_array_size() != stepY.ret_array_size() )
  {
    printf( "modStepCalc: stepX array_size != stepY array_size\n" );
    return( XP_FAILURE);
  }
  
  // Get step array data
  float *stepX_arr = NULL;
  OMCALLR_NONNULLPTR( "Unable to get stepX pointer",
		      stepX_arr, (float*)stepX.ret_array_ptr(OM_GET_ARRAY_RD));
  float *stepY_arr = NULL;
  OMCALLR_NONNULLPTR( "Unable to get stepY pointer",
		      stepY_arr, (float*)stepY.ret_array_ptr(OM_GET_ARRAY_RD));
  
  // Look for proper step
  float input = inputValue;
  for( int i = 0; i < stepX.ret_array_size(); i++ )
  {
    if( input < stepX_arr[i] )
    {
      break;
    }
  }   
  outputValue = stepY_arr[i];
  ARRfree( stepX_arr );
  ARRfree( stepY_arr );

  // Successful return
  return( XP_SUCCESS );
}

/* end of file */
