#!/bin/perl
sub mmAbout {
  print "Usage: getFldMinMax -o <minMaxFile.fld> <file_1.fld> ... <file_n.fld>\n";
}

if ($#ARGV < 2 || !($ARGV[0] eq "-o")) {
  &mmAbout();
  exit(1);
}

if (!open(fldOUTFILE, ">$ARGV[1]")) {
  print "Couldn't open file $ARGV[1]: $! ... \n";
  exit;
}
$outFile = $ARGV[1];
$outFile =~ m/^(.*)\/([^\/]+)$/;
if (!($1 eq "")) {
  $outFile = $2;
}


shift;
shift;

@min;
@max;

$firstOpenFile = 1;
for ($i = 0; $i <= $#ARGV; $i++) {
  $fldFile = $ARGV[$i];
  $fldFile =~ m/^(.*)\/([^\/]+)$/;
  if (!($1 eq "")) {
    chdir $1;
    $fldFile = $2;
  }
  print "Getting min/max out of $fldFile\n";
  if (!open(fldFILE, "$fldFile")) {
    print "Couldn't open file $fldFile: $! ... ignoring file!\n";
    next;
  }
  $file = "";
  while (<fldFILE>) {
    $file .= $_;
  }
  $* = 1;

  # extract veclen

  if (!($file =~ m/^veclen\s*\=\s*(\d+)$\s*$/)) {
    print "Couldn't get veclen ... ignoring file $fldFile!\n";
    next;
  }
  if ($firstOpenFile) {
    $veclen = $1;
    for ($j = 0; $j < $veclen; $j++) {
      $min[$j] = 1e31;
      $max[$j] = -1e31;
    }
  } else {
    if ($veclen != $1) {
      print "Wrong veclen ... ignoring file $fldFile!\n";
      next;
    }
  }

  # extract dataype

  $data = "double";
  if (!($file =~ m/^data\s*\=\s*(\w+)$\s*$/)) {
    print "Couldn't get datatype ... set to double!\n";
  } else {
    $data = $1;
  }

  # extract labels

  if (!($file =~ m/^label\s*\=\s*(.+)$/)) {
    print "Couldn't get labels ... ignoring file $fldFile!\n";
    next;
  }
  $labels = $1;

  # extract dimension

  if (!($file =~ m/^ndim\s*\=\s*(.+)$/)) {
    print "Couldn't get dimension ... ignoring file! $fldFile\n";
    next;
  }
  $dim = $1;

  # extract field size
  
  $num = 1;
  for ($j = 1; $j <= $dim; $j++) {
    if (!($file =~ m/^dim$j\s*\=\s*(\w+)$\s*$/)) {
      print "Couldn't get dimension $j in $fldFile ... \n";
      print "exiting!\n";
      exit;
    }
    $num *= $1;
  }

  for ($j = 0; $j < $veclen; $j++) {

    # extract data filename skip offset and stride
    
    local($varIndex) = $j + 1;
    if (!($file =~ m/^variable $varIndex.*\sfile\s*\=\s*([^\s]+)\s/)) {
      print "Couldn't get file for attribute $j ... ignoring data file!\n";
      next;
    }
    $datFile = $1;
    if (!($file =~ m/^variable $varIndex.*\sskip\s*\=\s*([^\s]+)\s/)) {
      print "Couldn't get skip for attribute $j ... ignoring data file!\n";
      next;
    }
    local($skip) = $1;
    if (!($file =~ m/^variable $varIndex.*\soffset\s*\=\s*([^\s]+)\s/)) {
      print "Couldn't get offset for attribute $j ... ignoring data file!\n";
      next;
    }
    local($offset) = $1;
    if (!($file =~ m/^variable $varIndex.*\sstride\s*\=\s*([^\s]+)\s/)) {
      print "Couldn't get stride for attribute $j ... ignoring data file!\n";
      next;
    }
    local($stride) = $1;
    if (!open(datFILE, "$datFile")) {
      print "Couldn't open file $datFile: $! ... ignoring data file!\n";
      next;
    }
    for ($k = 0; $k < $skip; $k++) {
      $_ = <datFILE>;
    }
    $fdata = "";
    while (<datFILE>) {
      $fdata .= $_;
    }
    @fileData = split('\s+', $fdata);
    $fdata = "";
    for ($k = 0; $k < $num; $k++) {
      local($x) = $fileData[$offset + $k * $stride] . " ";
      if ($x < $min[$j]) { $min[$j] = $x; }
      if ($x > $max[$j]) { $max[$j] = $x; }
    }
    @fileData = "";
    close datFILE;
  }
  print "Max: ";
  for ($j = 0; $j < $veclen; $j++) {
    print $max[$j] . " ";
  }
  print "\n";
  print "Min: ";
  for ($j = 0; $j < $veclen; $j++) {
    print $min[$j] . " ";
  }
  print "\n";
  close fldFILE;
  $firstOpenFile = 0;
}

print fldOUTFILE 
  "# AVS output generated by getFldMinMax applied on the files:\n";
print fldOUTFILE "#   @ARGV\n";
print fldOUTFILE "ndim=1\n";
print fldOUTFILE "dim1=2\n";
print fldOUTFILE "nspace=1\n";
print fldOUTFILE "veclen=$veclen\n";
print fldOUTFILE "data=$data\n";
print fldOUTFILE "field=uniform\n";
print fldOUTFILE "label=$labels\n";

$skip = 9 + $veclen;
for ($i = 0; $i < $veclen; $i++) {
  $offset = 2 + $i;
  $stride = 2 + $veclen;
  $variable = $i + 1;
  print fldOUTFILE "variable $variable file=$outFile filetype=ascii skip=$skip offset=$offset stride=$stride\n";
}
print fldOUTFILE "# Min: ";
for ($i = 0; $i < $veclen; $i++) {
  print fldOUTFILE $min[$i] . " ";
}
print fldOUTFILE "\n";
print fldOUTFILE "# Max: ";
for ($i = 0; $i < $veclen; $i++) {
  print fldOUTFILE $max[$i] . " ";
}
print fldOUTFILE "\n";
close fldOUTFILE;
