C ****************************************
C Coroutine Main Routine
C ****************************************
	
       implicit none
       include '//usr/avs/include/avs.inc'
       external WAVES_desc
	INTEGER XYZ_COORDS,WHEIGHT,I,J,DIM,DATAOUT
	INTEGER DIMS(2),STOP,DIMS2(1)
	CHARACTER*60 FIELDDESC,FIELDDESC2
	REAL XMAX,YMAX,THETA,A,SPACING,XMIN,YMIN,F,Wafreq,HEADING
	REAL PI,K,G,L,C,Z,X,Y,X_OLD,Y_OLD,B,DATA(1),COORD(1),T
	REAL DOUT(1),U,SPEED,encfreq,waperiod
	INTEGER OCOORD,ZOUT,RESULT,ODOUT

	call AVScorout_init(WAVES_desc)

	call AVScorout_set_sync(1)  
	CALL AVSCOROUT_WAIT()    
	
	PI=3.14159
	G=9.80665
	X_OLD=1.0
	Y_OLD=1.0
	DIM=50

	
	FIELDDESC='field 2D 2-space 1-vector irregular float'
	FIELDDESC2='field 1D 0-space 1-vector irregular float'
	
	STOP=1
	do 100 WHILE(STOP.EQ.1)
	DIMS(1)=DIM
	DIMS(2)=DIM
	DIMS2(1)=7
	WHEIGHT=AVSDATA_ALLOC(FIELDDESC,DIMS)
	RESULT=AVSFIELD_DATA_OFFSET(WHEIGHT,DATA,ZOUT)
	RESULT=AVSFIELD_POINTS_OFFSET(WHEIGHT,COORD,OCOORD)

	DATAOUT=AVSDATA_ALLOC(FIELDDESC2,DIMS2)
	RESULT=AVSFIELD_DATA_OFFSET(DATAOUT,DOUT,ODOUT)
	call AVScorout_wait()

	RESULT=AVScorout_input(T,HEADING,A,SPACING,XMIN,
     c  YMIN,SPEED,waperiod)
	
	THETA=(HEADING/180.00)*PI
	U=SPEED*0.5144
	CALL CALC1 (F,T,Wafreq,PI,K,G,L,C,waperiod)
	ENCFREQ=Wafreq-(((Wafreq*Wafreq)*U)/G)*cos(THETA)
	CALL CALC2 (DATA(ZOUT+1),COORD(OCOORD+1),Z,A,K,X,THETA,
     c  Y,Wafreq,T,XMIN,YMIN,SPACING,B,DIM,Y_OLD,X_OLD,U,G)

	CALL DATOUT (Wafreq,T,A,SPEED,HEADING,THETA,ENCFREQ,DOUT(ODOUT+1))
	call AVSCOROUT_OUTPUT(WHEIGHT,DATAOUT)

	CALL AVSFIELD_FREE(DATAOUT)
	CALL AVSFIELD_FREE(WHEIGHT)
	CALL AVSCOROUT_WAIT

100     CONTINUE
	end

C ****************************************
C  Module Description
C ****************************************
       integer function WAVES_desc()
       implicit none
       include '//usr/avs/include/avs.inc'

       integer in_port,out_port,param,iresult

       call AVSset_module_name('WAVES', 'data')
       call AVSset_module_flags(single_arg_data + corout_unpack_args)

C       Input Port Specifications
	in_port = AVScreate_input_port('T','real',REQUIRED)

C       Output Port Specifications
       out_port = AVScreate_output_port('wheight', 
     $  'field 2D 2-space 1-vector irregular float')
       out_port = AVScreate_output_port('dataout', 
     $  'field 1D 0-space 1-vector irregular float')

C       Parameter Specifications
       param = AVSadd_parameter('HEADING','real', 180.000, -360.000, 
     $  360.000)
       call AVSconnect_widget(param, 'dial')
       param = AVSadd_parameter('A','real', 0.80000, 0.00000, 10.000)
       call AVSconnect_widget(param, 'dial')
       param = AVSadd_parameter('SPACING','real', 3.50000, 0.00000, 
     $  1000.00)
       call AVSconnect_widget(param, 'dial')
       param = AVSadd_parameter('XMIN','real', -85.0000, -100.0000, 
     $  100.000)
	 call AVSconnect_widget(param, 'dial') 
       param = AVSadd_parameter('YMIN','real', -85.0000, -100.000, 
     $  100.000)
	 call AVSconnect_widget(param, 'dial')
       param = AVSadd_parameter('SPEED','real', 5.00000, 0.00000, 
     $  100.000)
	 call AVSconnect_widget(param, 'dial')
	param = AVSadd_parameter('waperiod','real', 8.00000, 0.00000, 
     $  30.0000)
	 call AVSconnect_widget(param, 'dial')



C ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICA

       WAVES_desc = 1
       return
       end
 
C ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)

*******************************************************************
	SUBROUTINE CALC1 (F,T,Wafreq,PI,K,G,L,C,waperiod)

	REAL F,T,Wafreq,PI,K,G,L,C,waperiod

	F=1.0/waperiod
	Wafreq=2.0*PI*F
	K=(Wafreq*Wafreq)/G
	L=(2.0*PI)/K
	C=SQRT(G/K)

	RETURN
	END

*********************************************************************** 
	SUBROUTINE CALC2 (DATA,COORD,Z,A,K,X,THETA,
     c  Y,Wafreq,T,XMIN,YMIN,SPACING,B,DIM,Y_OLD,
     c  X_OLD,U,G)
	
        include '//usr/avs/include/avs.inc'

	INTEGER I,J,DIM
	REAL Z,A,K,X,THETA,Y,Wafreq,T,B
	REAL DATA(DIM,DIM,1),COORD(DIM,DIM,2)
	REAL SPACING,XMIN,YMIN,Y_OLD,X_OLD,U
	REAL G
	
	Y=YMIN
	X=XMIN

	DO 30 J=1,DIM
	DO 20 I=1,DIM
	B=(X*COS(THETA))+(Y*SIN(THETA))
	Z=A*(SIN((K*B)-(Wafreq*T)))
	COORD(I,J,1)=X
	COORD(I,J,2)=Y
	DATA(I,J,1)=Z
	X=X+spacing
20      CONTINUE
	Y=Y+spacing
	X=XMIN
30      CONTINUE

	RETURN
	END

************************************************************************
	SUBROUTINE DATOUT (Wafreq,T,A,SPEED,HEADING,THETA,ENCFREQ,DOUT)

	REAL Wafreq,T,A,SPEED,HEADING,THETA,ENCFREQ,DOUT(7)

	DOUT(1)=Wafreq
	DOUT(2)=T
	DOUT(3)=A
	DOUT(4)=SPEED
	DOUT(5)=HEADING
	DOUT(6)=THETA
	DOUT(7)=ENCFREQ
	RETURN
	END


C <---- END OF USER-SUPPLIED CODE SECTION #4
