// INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
// Please read the file DISCLAIMER for conditions associated with this file.
// avs@iavsc.org, www.iavsc.org

flibrary SheetMods <build_dir="iac_proj/sheet",
	            out_hdr_file="gen.h",
		    out_src_file="gen.cxx",
		    cxx_hdr_files="fld/Xfld.h",
                    cxx_name="",
		    libdeps="FLD"> {

  // define the parameter block group

  group SheetParams <NEportLevels={0,1}> {
    double ignore <NEportLevels={2,2}>;
    int plane <NEportLevels={2,2}>;
    int comp<NEportLevels={2,2}>;
    int reverse<NEportLevels={2,2}>;
    int invert<NEportLevels={2,2}>;
    int output_data <NEportLevels={2,2}>;
  };

  SheetParams &SheetParams_ref <NEportLevels={1,1}> {
    double ignore <NEportLevels={0,2}>;
    int plane <NEportLevels={0,2}>;
    int comp<NEportLevels={0,2}>;
    int reverse<NEportLevels={0,2}>;
    int invert<NEportLevels={0,2}>;
    int output_data <NEportLevels={0,2}>;
  };

  // define support groups/modules

  // define the low-level modules

  module SheetUnif <src_file="sheet.cxx"> {
    SheetParams_ref &params <NEportLevels={2,0}>;

    Mesh_Unif+Node_Data &in <NEportLevels={2,0}> {
      int ndim = 3;
    };

    double ignore => params.ignore;
    int plane => params.plane;
    int comp => params.comp;
    int output_data => params.output_data;

    Mesh_Struct out <NEportLevels={0,2}> {
      int ndim = 2;
      int nspace = 3;
    };

    cxxmethod+req update (
      in+read+notify+req,
      ignore+read+notify+req,
      plane+read+notify+req,
      comp+read+notify+req,
      output_data+read+notify+req,
      out+write );
  };

  module SheetRect <src_file="sheet.cxx"> {
    SheetParams_ref &params <NEportLevels={2,0}>;

    Mesh_Rect+Node_Data &in <NEportLevels={2,0}> {
      int ndim = 3;
    };

    double ignore => params.ignore;
    int plane => params.plane;
    int comp => params.comp;
    int reverse => params.reverse;
    int invert => params.invert;
    int output_data => params.output_data;

    Mesh_Struct+Node_Data out <NEportLevels={0,2}> {
      int ndim = 2;
      int nspace = 3;
    };
       
    cxxmethod+req update (
      in+read+notify+req,
      ignore+read+notify+req,
      plane+read+notify+req,
      comp+read+notify+req,
      reverse+read+notify+req,
      invert+read+notify+req,
      output_data+read+notify+req,
      out+write );
  };
};
