
#include "iac_proj/sheet/gen.h"


int
Sheet_SheetUnif::update(OMevent_mask event_mask, int seq_num)
{
  // in (Mesh_Unif+Node_Data read req notify)
  // in.ndim (int) 
  // in.dims (int []) 
  // in.nspace (int) 
  // in.npoints (int)
  // in.points (float [])
  // in.nnodes (int)
  // in.nnode_data (int)
  // in.node_data[in_data_comp].veclen (int) 
  // in.node_data[in_data_comp].values (char [])

  // out.ndim (int) 
  // out.dims (int []) 
  // out.nspace (int) 
  // out.nnodes (int)
  // out.coordinates.values (float [])
  // out.nnodes (int)

  // ignore (OMXdouble read req notify)
  // plane (OMXint read req notify)
  // comp (OMXint read req notify)
  // output_data (OMXint read req notify)
  // out (Mesh_Struct+Node_Data write)
  
  int *in_dims;
  float *in_points;
  int  in_data_comp;
  int  in_data_size, in_data_type;
  char *in_node_data;
  
  int  out_data_comp;
  int  out_data_size, out_data_type;
  int *out_dims;
  float *out_coords;
  char *out_node_data;

  int i, x, y, z;
  float *x_coords;
  float *y_coords;
  float *z_coords;

  int veclen;
  int out_index;
  int start, search, size, offset, count, max_count;
  int valid;
  
  /* get input uniform field dimensions	 */

  in_dims = (int *)in.dims.ret_array_ptr( OM_GET_ARRAY_RD );
  in_points = (float *)in.points.ret_array_ptr( OM_GET_ARRAY_RD );
  
  /* get write access to output dims */
  
  out_dims = (int *)out.dims.ret_array_ptr( OM_GET_ARRAY_WR );

  /* set output dims to input dims of selected plane	 */

  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    out_dims[0] = in_dims[0];
    out_dims[1] = in_dims[1];
    
    break;
  case 1:
    /* XZ-Plane	 */

    out_dims[0] = in_dims[0];
    out_dims[1] = in_dims[2];
    
    break;
  case 2:
    /* YZ-Plane	 */

    out_dims[0] = in_dims[1];
    out_dims[1] = in_dims[2];
    
    break;
  }

  /* free output dims array to set	 */

  if( out_dims )
    ARRfree( out_dims );

  /* generate local coordinate lookups */

  x_coords = (float *)malloc( sizeof(float) * in_dims[0]+1 );
  y_coords = (float *)malloc( sizeof(float) * in_dims[1]+1 );
  z_coords = (float *)malloc( sizeof(float) * in_dims[2]+1 );
  
  if( !x_coords || !y_coords || !z_coords ) {
    ERRverror( "",ERR_NO_HEADER | ERR_PRINT,
	       "SheetUnif::update\n  Cannot malloc local memory");
    return 1;
  }

  for( i=0; i<=(int)in_dims[0]; i++ ) {
    x_coords[i] = (float)in_points[0] + (float)i *
      (((float)in_points[3]-(float)in_points[0]) / ((float)in_dims[0]-1.0));
  }
  
  for( i=0; i<=(int)in_dims[1]; i++ ) {
    y_coords[i] = (float)in_points[1] + (float)i *
      (((float)in_points[4]-(float)in_points[1]) / ((float)in_dims[1]-1.0));
  }
  
  for( i=0; i<=(int)in_dims[2]; i++ ) {
    z_coords[i] = (float)in_points[2] + (float)i *
      (((float)in_points[5]-(float)in_points[2]) / ((float)in_dims[2]-1.0));
  }
  
  /* get input data for examination */

  in_node_data = (char *)in.node_data[comp].values.
    ret_array_ptr( OM_GET_ARRAY_RD, &in_data_size, &in_data_type );

  veclen = in.node_data[comp].veclen;
  
  /* get write access to output coordinates */

  out_coords =
    (float *)out.coordinates.values.ret_array_ptr( OM_GET_ARRAY_WR );
  
  if( !out_coords ) {
    printf( "SheetRect: Cannot get access to output coords array\n" );
    fflush(stdout);
    return 1;
  }
  
  /* set grid coordinates */

  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    out_index = 0;
    for( y=0; y<(int)out_dims[1]; y++ ) {
      for( x=0; x<(int)out_dims[0]; x++ ) {
	out_coords[out_index++] = x_coords[x];
	out_coords[out_index++] = y_coords[y];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  case 1:
    /* XZ-Plane	 */

    out_index = 0;
    for( z=0; z<(int)out_dims[1]; z++ ) {
      for( x=0; x<(int)out_dims[0]; x++ ) {
	out_coords[out_index++] = x_coords[x];
	out_coords[out_index++] = z_coords[z];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  case 2:
    /* YZ-Plane	 */

    out_index = 0;
    for( z=0; z<(int)out_dims[1]; z++ ) {
      for( y=0; y<(int)out_dims[0]; y++ ) {
	out_coords[out_index++] = y_coords[y];
	out_coords[out_index++] = z_coords[z];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  }

  /* examine the data and calculate 3rd coordinate of sheet	 */
  
  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    start = 0;
    search = 0;
    size = (int)in_dims[0] * (int)in_dims[1];
    offset = size * veclen;
    max_count = (int)in_dims[2];
    count = 0;

    out_index = 2;
    
    switch( in_data_type ) {
    case OM_TYPE_FLOAT:

      for( i=0; i<size; i++ ) {
	search = start;

	while( ((float)in_node_data[search] == (float)ignore) ) {
	  search += offset;
	  count++;
	  if( count == max_count )
	    break;
	}
	
	out_coords[out_index] = z_coords[count];
	out_index += 3;
      }

      start += veclen;
      
      break;
    case OM_TYPE_DOUBLE:
      
      break;
    case OM_TYPE_BYTE:
    case OM_TYPE_CHAR:

      char value_char;
      
      for( i=0; i<size; i++ ) {
	search = start;
	count = 0;
	valid = 1;

	while( valid ) {
	  value_char = in_node_data[search];
	  if( value_char != (unsigned char)ignore )
	    valid = 0;

	  if( valid ) {
	    search += offset;
	    count++;
	    if( count == max_count ) {
	      valid = 0;
	    }
	  }
	}
	
	out_coords[out_index] = z_coords[count];
	out_index += 3;

	start += veclen;
      
      }

      break;
    } /* end of data_type switch for XY-Plane */
    
    break;

  case 1:
    /* XZ-Plane	 */

    break;
  case 2:
    /* YZ-Plane	 */

    break;
  }
  
  /* free local memory for coords */

  if( x_coords )
    free( x_coords );
  if( y_coords )
    free( y_coords );
  if( z_coords )
    free( z_coords );

  /* free and set remaining field objects */
  
  if( in_dims )
    ARRfree( in_dims );
  if( in_points )
    ARRfree( in_points );
  
  if( in_node_data )
    ARRfree( in_node_data );
  
  if( out_coords )
    ARRfree( out_coords );

  /* return 1 for success	 */

  return(1);
}


int Sheet_SheetRect::update(OMevent_mask event_mask, int seq_num) {
  // in (Mesh_Rect+Node_Data read req notify)
  // in.ndim (int) 
  // in.dims (int []) 
  // in.nspace (int) 
  // in.npoints (int)
  // in.points (float [])
  // in.nnodes (int)
  // in.nnode_data (int)
  // in.node_data[in_data_comp].veclen (int) 
  // in.node_data[in_data_comp].values (char [])

  // out.ndim (int) 
  // out.dims (int []) 
  // out.nspace (int) 
  // out.nnodes (int)
  // out.coordinates.values (float [])
  // out.nnodes (int)

  // ignore (OMXdouble read req notify)
  // plane (OMXint read req notify)
  // comp (OMXint read req notify)
  // output_data (OMXint read req notify)
  // out (Mesh_Struct+Node_Data write)
  
  int *in_dims;
  float *in_points;
  int  in_data_comp;
  int  in_data_size, in_data_type;
  char *in_node_data;
  
  int  out_data_comp;
  int  out_data_size, out_data_type;
  int *out_dims;
  float *out_coords;
  char *out_node_data;

  int i, x, y, z;
  float *x_coords;
  float *y_coords;
  float *z_coords;

  int veclen;
  int out_index;
  int start, search, size, offset, count, max_count;
  int valid;
  
  /* get input uniform field dimensions	 */

  in_dims = (int *)in.dims.ret_array_ptr( OM_GET_ARRAY_RD );
  in_points = (float *)in.points.ret_array_ptr( OM_GET_ARRAY_RD );

  if( !in_dims ) {
    printf( "SheetRect: Cannot get input dims\n" );
    fflush(stdout);
    return 1;
  }
  
  if( !in_points ) {
    printf( "SheetRect: Cannot get input points array\n" );
    fflush(stdout);
    return 1;
  }
  
  /* get write access to output dims */
  
  out_dims = (int *)out.dims.ret_array_ptr( OM_GET_ARRAY_WR );

  if( !out_dims ) {
    printf( "SheetRect: Cannot get access to output dims array\n" );
    fflush(stdout);
    return 1;
  }
  
  /* set output dims to input dims of selected plane	 */

  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    out_dims[0] = in_dims[0];
    out_dims[1] = in_dims[1];
    
    break;
  case 1:
    /* XZ-Plane	 */

    out_dims[0] = in_dims[0];
    out_dims[1] = in_dims[2];
    
    break;
  case 2:
    /* YZ-Plane	 */

    out_dims[0] = in_dims[1];
    out_dims[1] = in_dims[2];
    
    break;
  }

  /* free output dims array to set	 */

  if( out_dims )
    ARRfree( out_dims );

  /* copy rectilinear points to local coordinate lookups */

  x_coords = (float *)malloc( sizeof(float) * in_dims[0]+1 );
  y_coords = (float *)malloc( sizeof(float) * in_dims[1]+1 );
  z_coords = (float *)malloc( sizeof(float) * in_dims[2]+1 );
  
  if( !x_coords || !y_coords || !z_coords ) {
    ERRverror( "",ERR_NO_HEADER | ERR_PRINT,
	       "SheetUnif::update\n  Cannot malloc local memory");
    return 1;
  }

  printf( "pre copy\n" ); fflush(stdout);

  for( i=0; i<(int)in_dims[0]; i++ ) {
    x_coords[i] = (float)in_points[i*3];
  }
  /* x_coords[(int)in_dims[0]] = x_coords[((int)in_dims[0]-1)*3] + 1.0; */
  x_coords[(int)in_dims[0]] = x_coords[(int)in_dims[0]-1] + 1.0;

  for( i=0; i<(int)in_dims[1]; i++ ) {
    y_coords[i] = (float)in_points[(int)in_dims[0]*3+i*3+1];
  }
  /* y_coords[(int)in_dims[1]] = y_coords[((int)in_dims[1]-1)*3+1] + 1.0; */
  y_coords[(int)in_dims[1]] = y_coords[(int)in_dims[1]-1] + 1.0;
  
  for( i=0; i<(int)in_dims[2]; i++ ) {
    z_coords[i] = (float)in_points[(int)in_dims[0]*3+(int)in_dims[1]*3+i*3+2];
  }
  /* z_coords[(int)in_dims[2]] = z_coords[((int)in_dims[2]-1)*3+2] + 1.0; */
  z_coords[(int)in_dims[2]] = z_coords[(int)in_dims[2]-1] + 1.0;
  
  printf( "post copy\n" ); fflush(stdout);

  /* get input data for examination */

  in_node_data = (char *)in.node_data[comp].values.
    ret_array_ptr( OM_GET_ARRAY_RD, &in_data_size, &in_data_type );

  veclen = in.node_data[comp].veclen;
  
  /* get write access to output coordinates */

  out_coords =
    (float *)out.coordinates.values.ret_array_ptr( OM_GET_ARRAY_WR );
  
  /* set grid coordinates */

  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    out_index = 0;
    for( y=0; y<(int)out_dims[1]; y++ ) {
      for( x=0; x<(int)out_dims[0]; x++ ) {
	out_coords[out_index++] = x_coords[x];
	out_coords[out_index++] = y_coords[y];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  case 1:
    /* XZ-Plane	 */

    out_index = 0;
    for( z=0; z<(int)out_dims[1]; z++ ) {
      for( x=0; x<(int)out_dims[0]; x++ ) {
	out_coords[out_index++] = x_coords[x];
	out_coords[out_index++] = z_coords[z];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  case 2:
    /* YZ-Plane	 */

    out_index = 0;
    for( z=0; z<(int)out_dims[1]; z++ ) {
      for( y=0; y<(int)out_dims[0]; y++ ) {
	out_coords[out_index++] = y_coords[y];
	out_coords[out_index++] = z_coords[z];
	out_coords[out_index++] = 0.0;
      }
    }
    
    break;
  }

  /* examine the data and calculate 3rd coordinate of sheet	 */
  
  switch( (int)plane ) {
  case 0:
    /* XY-Plane	 */

    size = (int)in_dims[0] * (int)in_dims[1];
    offset = size * veclen;
    max_count = (int)in_dims[2];

    if( !reverse ) {
      start = 0;
      count = 0;
    } else {
      start = size * veclen * ((int)in_dims[2]-1);
      count = max_count;
    }
    
    search = start;
    out_index = 2;
    
    switch( in_data_type ) {
    case OM_TYPE_FLOAT:

      float value_float;
      
      for( i=0; i<size; i++ ) {
	if( !reverse ) {
	  count = 0;
	} else {
	  count = max_count;
	}
	search = start;
	valid = 1;

	while( valid ) {
	  value_float = (float)(((float *)in_node_data)[search]);
	  if( !invert ) {
	    if( value_float != (float)ignore )
	      valid = 0;
	  } else {
	    if( value_float == (float)ignore )
	      valid = 0;
	  }

	  if( valid ) {
	    if( !reverse ) {
	      search += offset;
	      count++;
	      if( count == max_count ) {
		valid = 0;
	      }
	    } else {
	      search -= offset;
	      count--;
	      if( count == 0 ) {
		valid = 0;
	      }
	    }
	  }
	}
	
	out_coords[out_index] = z_coords[count];
	out_index += 3;

	start += veclen;
      
      }

      break;
    case OM_TYPE_DOUBLE:
      
      break;
    case OM_TYPE_BYTE:
    case OM_TYPE_CHAR:

      char value_char;
      
      for( i=0; i<size; i++ ) {
	search = start;
	count = 0;
	valid = 1;

	while( valid ) {
	  value_char = in_node_data[search];
	  if( value_char != (unsigned char)ignore )
	    valid = 0;

	  if( valid ) {
	    search += offset;
	    count++;
	    if( count == max_count ) {
	      valid = 0;
	    }
	  }
	}
	
	out_coords[out_index] = z_coords[count];
	out_index += 3;

	start += veclen;
      
      }

      break;
    } /* end of data_type switch for XY-Plane */
    
    break;

  case 1:
    /* XZ-Plane	 */

    break;
  case 2:
    /* YZ-Plane	 */

    break;
  }
  
  /* free local memory for coords */

  if( x_coords )
    free( x_coords );
  if( y_coords )
    free( y_coords );
  if( z_coords )
    free( z_coords );

  /* free and set remaining field objects */
  
  if( in_dims )
    ARRfree( in_dims );
  if( in_points )
    ARRfree( in_points );
  
  if( in_node_data )
    ARRfree( in_node_data );
  
  if( out_coords )
    ARRfree( out_coords );

  /* return 1 for success	 */

  return(1);
}
