#include "user.h"

int julia_set(OMobj_id julia_id, OMevent_mask event_mask, int seq_num)
{
  /***********************/
  /*  Declare variables  */
  /***********************/
  double  mandelx;
  double  mandely;
  int  max_iter;
  int  resx;
  int  resy;
  OMobj_id out_id;
  int out_ndim, *out_dims, out_nspace, out_npoints;
  float *out_points;
  int out_ncomp, out_comp_count, out_veclen;
  int    out_data_type, out_ndata;
  unsigned char  *out_data;
   
  int i, j, k, index;
  double dx, dy;
  double zx, zy;
  double tmp;
  double posy;
  int max_k;

   /***********************/
   /*  Get input values   */
   /***********************/
   /* Get mandelx's value */
  if (OMget_name_real_val(julia_id, OMstr_to_name("mandelx"), &mandelx) != 1)
    mandelx = 0.0;

   /* Get mandely's value */
  if (OMget_name_real_val(julia_id, OMstr_to_name("mandely"), &mandely) != 1)
    mandely = 0.0;

   /* Get max_iter's value */ 
  if (OMget_name_int_val(julia_id, OMstr_to_name("max_iter"), &max_iter) != 1) 
    max_iter = 0;

   /* Get resx's value */ 
  if (OMget_name_int_val(julia_id, OMstr_to_name("resx"), &resx) != 1) 
    resx = 0;

   /* Get resy's value */ 
  if (OMget_name_int_val(julia_id, OMstr_to_name("resy"), &resy) != 1) 
    resy = 0;


   /***********************/
   /* Function's Body     */
   /***********************/
  ERRverror("",ERR_NO_HEADER | ERR_INFO,"I'm in function: julia_set generated from method: julia.generate\n");

  if (max_iter<256) {
    max_k = max_iter;
  } else {
    max_k = 255;
  }

  dx = 4 / (double)(resx-1);
  dy = 4 / (double)(resy-1);
   
  index=0;
   
   /***********************/
   /*  Set output values  */
   /***********************/
    /* Set out uniform mesh */

   /*  Get mesh id */
  out_id = OMfind_subobj(julia_id, OMstr_to_name("out"), OM_OBJ_RW);

  /* Set mesh dimensionality, out_ndim can be 1,2 or 3 */
  out_ndim=2;
  FLDset_ndim (out_id, out_ndim);

   /* Set mesh dims array */
  out_dims = (int *)ARRalloc(NULL, DTYPE_INT, 
			     out_ndim, NULL);

  /*** fill in dims array with your values ***/
  out_dims[0]=resx;
  out_dims[1]=resy;
   
  FLDset_dims (out_id, out_dims);
  if (out_dims)
    ARRfree((char *)out_dims);

   /* Set mesh nspace, out_nspace can be 1,2 or 3 */
  out_nspace=2;
  FLDset_nspace (out_id, out_nspace);

   /* Set mesh extents */
  out_npoints = 2*out_nspace;
  out_points = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
				 out_npoints, NULL);

  /*** fill in points array with values for 2 points: low left and high right corners of the mesh ***/
   
  out_points[0]=-2;
  out_points[1]=-2;
  out_points[2]=2;
  out_points[3]=2;
   
  FLDset_points (out_id, out_points, out_npoints, 
		 OM_SET_ARRAY_FREE);
  /* set  out node data */

   /* Get field id */
  out_id = OMfind_subobj(julia_id, OMstr_to_name("out"), OM_OBJ_RW);

  /* Set number of node data components */
  out_ncomp=1;
  FLDset_node_data_ncomp (out_id, out_ncomp);

   /* For each node data component set veclen, type and data arry itself */
  for (out_comp_count=0; out_comp_count < out_ncomp; out_comp_count++) {

    /* Set veclen, assign out_veclen before next call */
    out_veclen=1;
    FLDset_node_data_veclen (out_id,out_comp_count,out_veclen);

    /* Set data array */
    /* data_type should be set to one of the following: 
       DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
       DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE) */

    out_data_type = DTYPE_BYTE;

    /* allocate out_data array first */
    /* assume float array and out_ndata is set to number of nodes */
    out_ndata=resx*resy;
    out_data = (unsigned char *)ARRalloc(NULL, out_data_type, 
					 out_veclen*out_ndata, NULL);
    for( j=0; j<resy; j++ )
    {
      posy = (double)(dy * j) - 2;
      for( i=0; i<resx; i++ )
      {
	zy = posy;
	zx = (double)(dx * i) - 2;

	for( k=0; k<max_k; k++ )
	{
	  tmp = (zx*zx) - (zy*zy) + mandelx;
	  zy = 2 * zx * zy + mandely;
	  zx = tmp;
	    
	  if( ((zx*zx) + (zy*zy)) > 4 )
	    break;
	}
       
	out_data[index++] = k;
      }
    }
    
    FLDset_node_data (out_id, out_comp_count, out_data, out_data_type,
		      out_ndata*out_veclen, OM_SET_ARRAY_FREE);

    /*  Other useful calls:

	FLDset_node_data_id()
	FLDset_node_null_data()
	FLDset_node_data_label()
	*/
  }
   
  return(1);
}
