typedef Pint bits[PC_NrbMax + 1];

static Pint bpos[31];
static Pint *bitarray={0};

/************************************/
void cleartags(C(Pint) M)
PreANSI(Pint M)
{
  Pint i;
  Pint xx = (M + 30) / 31;

  /* Changes added by M.Preston to make ANSI compatible */

  PR_knots* tmp;
  tmp = (PR_knots* )nrb_ptslist;

  bitarray = (Pint *) nrb_allocate(xx*4, (PR_knots*) bitarray ,&tmp , &nrb_ptstats);

  for (i = 0; i <= 30; i++) bpos[i] = 1L << i;
  for (i = 0; i <  xx; i++) bitarray[i] = 0;
}

/************************************/
void tag(C(Pint) M)
PreANSI(Pint M)
{ Pint iword,ibit,ipos;

  iword = M / 31;
  ibit  = M % 31;
  ipos  = bpos[ibit];

  bitarray[iword]  = bitarray[iword] | ipos;
}
/************************************/
boolean tagged(C(Pint) M)
PreANSI(Pint M)
{
  Pint iword,ibit,ipos;
  iword = M / 31;
  ibit  = M % 31;
  ipos  = bpos[ibit];
  return ((bitarray[iword] & ipos) != 0);
}
/************************************/
void pswap(C(Ppoint4 *)a, C(Ppoint4 *)b)
PreANSI(Ppoint4 *a)
PreANSI(Ppoint4 *b)
{
  Ppoint4 t;
  t = *a;
  *a = *b;
  *b = t;
}
/*------------------------------------------------------------------------*/
extern void nrb_Xtranspose(C(PR_nurb *)s1)
PreANSI(PR_nurb *s1)
{  /*Transpose the NURB*/
  Pint N,xx, Ndim;
  PR_knots *temp;
  Ppoint4 t1;

  /*transpose the knot vectors, swap pointers!*/
  temp = s1->pf_u.pf_kk;
  s1->pf_u.pf_kk = s1->pf_v.pf_kk;
  s1->pf_v.pf_kk = temp;

  swap(&s1->pf_u.pf_n,  &s1->pf_v.pf_n);   /*interchange # ctrl pts*/
  swap(&s1->pf_u.pf_nt, &s1->pf_v.pf_nt);  /*Interchange # knots*/
  swap(&s1->pf_u.pf_k,  &s1->pf_v.pf_k);   /*interchange order*/

  N = s1->pf_u.pf_n * s1->pf_v.pf_n - 1;   /*modulo of dim1*dim2 -1*/
  cleartags(N + 1);

  Ndim = s1->pf_u.pf_n;
  
  xx = (N+1 + 30) / 31;

  while (xx >= 0) {
    if (!tagged(xx)) {
      tag(xx);
      t1 = s1->pf_ppp->pts[xx];
_Lloop:
      xx = Ndim * xx % N;
      pswap(&t1, &s1->pf_ppp->pts[xx]);
      if (!tagged(xx)) {
	tag(xx);
	goto _Lloop;
      }
    }
    xx--;
  }
}
/*------------------------------------------------------------------------*/
