
// ------------------------------------------------------------------------
// A very simple SWIG Language module
//
// ------------------------------------------------------------------------

class JAVA : public Language {
private:
  char             *module;          // Name of the module
  char             *package;         // Name of the package
  char             *c_pkgstr;         // Name of the package
  char             *jni_pkgstr;         // Name of the package
  char		   *shadow_classname;
  FILE		   *f_java;
  FILE		   *f_shadow;
  int		   shadow;
  Hash		   shadow_classes;
  String	   shadow_classdef;
  char             *shadow_name;
  char	           *shadow_baseclass;
  int		   shadow_classdef_emitted;
  int		   member_func;            // Set to 1 when wrapping a member function


public :
  JAVA() {
    module = NULL;
    package = NULL;
    f_java = f_shadow = NULL;
    shadow = member_func = 0;
    shadow_name = shadow_baseclass = NULL;
  };

  // Virtual functions required by the SWIG parser

  void parse_args(int, char *argv[]);
  void parse();
  void create_function(char *, char *, DataType *, ParmList *);
  void link_variable(char *, char *, DataType *);
  void declare_const(char *, char *, DataType *, char *);
  void initialize(void);
  void headers(void);
  void close(void);
  void set_module(char *,char **);
  void create_command(char *, char *);

  void cpp_open_class(char *classname, char *rename, char *ctype, int strip);
  void cpp_close_class();
  void cpp_member_func(char *name, char *iname, DataType *t, ParmList *l); 
  void cpp_constructor(char *name, char *iname, ParmList *l);
  void cpp_destructor(char *name, char *newname);
  void cpp_class_decl(char *name, char *rename, char *type);
  void cpp_inherit(char **baseclass, int);
  void cpp_variable(char *name, char *iname, DataType *t);
  void cpp_declare_const(char *name, char *iname, DataType *type, char *value);

  /* Java Module methods */
  void emit_shadow_classdef();
};
