import test;
import Window;

public class test_main {
static {
  try {
    System.loadLibrary("jtest");
  } catch (Exception e) {
    System.err.println("Error loading library: " + e);
    System.exit(1);
  }
}

  public static void main(String argv[]) {
    System.err.println("\ntesting basic argument passing");
    System.out.println("fac 5 = " + test.fac(5));

    System.err.println("\ntesting basic argument return value");
    int result[] = {1};
    System.out.println("add(3,4) = " + test.add(3, 4,result));
    System.out.println("add(3,4) = " + result[0]);


    System.err.println("\ntesting string argument passing");
    System.out.println(test.hello("world"));

    System.err.println("\ntesting long array argument passing");
    long larray[] = new long[5];
    test.long_array_test(larray.length, larray);
    for(int i=0; i<larray.length; i++)
	System.out.println(larray[i]);

    System.err.println("\ntesting int array argument passing");
    int iarray[] = new int[5];
    test.int_array_test(iarray.length, iarray);
    for(int i=0; i<iarray.length; i++)
	System.out.println(iarray[i]);

    System.err.println("\ntesting short array argument passing");
    short sarray[] = new short[5];
    test.short_array_test(sarray.length, sarray);
    for(int i=0; i<iarray.length; i++)
	System.out.println(sarray[i]);

    System.err.println("\ntesting pointer argument passing");
    int w1 = test.newwin();
    int w2 = test.newwin();
    System.out.println("w1.x = " + test.get_Window_x(w1));
    System.out.println("w1.y = " + test.get_Window_y(w1));
    test.set_Window_x(w2, 0);
    test.set_Window_y(w2, 1);

    int wins[] = {w1, w2};
    test.print_wins(2, wins);

    System.err.println("\ntesting shadow classes");
    Window win1 = new Window();
    Window win2 = new Window();
    System.out.println("win1.x = " + win1.getX());
    System.out.println("win1.y = " + win1.getY());
    win2.setX(10);
    win2.setY(11);
    win2.print();
 }
}
