#! /bin/sh

maindir=`pwd`/..
maindir=`cd $maindir; pwd`

export SHELL=$DJDIR/bin/sh.exe

##################################################################
#  Edit the following lines to specify location of autoconf      #
#  Both versions (2.13 and 2.59 are required)                    #
#----------------------------------------------------------------#
#  Following 2 lines specify location of autoconf-2.13           #
#----------------------------------------------------------------#
# You must edit these lines according location of them on        #
# Your system (I build and installed them at prefix              #
#    /dev/env/DJDIR/old)                                         # 
#----------------------------------------------------------------#
AUTOCONF_OLD=autoconf-2.13
AUTOHEADER_OLD=autoheader-2.13
#AUTOCONF_OLD=/disk2/usr/bin/autoconf
#AUTOHEADER_OLD=/disk2/usr/bin/autoheader
#----------------------------------------------------------------#
#  Following 2 lines specify location of autoconf-2.57           #
#----------------------------------------------------------------#
AUTOCONF=autoconf
AUTOHEADER=autoheader
##################################################################


#
#  List of directories in which we should run autoconf or/and automake
#

automake_list=
aclocal_list=

#
#  Apply DJGPP related diffs and copy files 
#

for x in `(cd $maindir/diffs && find . -type f | sed -e 's/\.\///g')`; do
    case $x in 
       *.diff | *.diff.in)
           cd $maindir
           diff=`pwd`/$x;
           fname=`echo $x | sed -e 's/\.diff//g'`
           echo "Applying patch to $maindir/$fname ..."
           if [ -f $maindir/$fname ] ; then
              cp -f $maindir/$fname $maindir/${fname}~1 
              if ! patch --verbose $maindir/$fname <diffs/$x ; then
                  echo "Failed to apply patch for $maindir/$fname"
#                  exit 1
              fi
              case $fname in 
                  */acinclude.m4)
                     dir=`echo $maindir/$fname | sed -e 's/\/acinclude.m4//g'`
                      aclocal_list="$aclocal_list $dir"
                      ;;
                  */Makefile.am)
                      dir=`echo $maindir/$fname | sed -e 's/\/Makefile.am//g'`
                      automake_list="$automake_list $dir"
                      ;;
              esac
           else
              echo "File $maindir/$fname is not found"
           fi
           ;;
       *~*)
           ;;
       *)
           echo Copying $x
           mkdir -p `dirname $maindir/$x`		   	
           if ! cp -fv diffs/$x $maindir/$x ; then
              echo "Failed to copy diffs/$x to $maindir/$x"
              exit 1
           fi
           ;;
       esac
done

#
#  Run automake where needed
#

for dir in $automake_list; do
   if cd $dir ; then
      echo "Directory $dir: must run automake ...\n";
      if ! [ -f configure.in ] ; then
         if ! [ -f configure.ac ] ; then
            cd ..;
            if ! [ -f configure.in ] ; then
               if ! [ -f configure.ac ] ; then
                  cd ..
               fi
            fi
         fi
      fi
      echo "Running automake..."
      if ! automake; then
         echo "automake failed in directory `pwd`"
         cd $maindir
         exit 1
      fi
   fi
   cd $maindir
done

#
#  Run autoconf where needed
#

for c in `find $maindir -name 'configure.in' -o -name 'configure.ac'`; do
   d=`dirname $c`
   n=`basename $c`
   if cd $d ; then
      AC_PREREQ=`grep 'AC_PREREQ(' $n | sed 's#.*(##' | sed 's#)##'`;

      # They didn't tell us, guess based on the name and pray
      if [ "x$AC_PREREQ" == "x" ]; then
         if [ "configure.in" == "$n" ]; then
            AC_PREREQ=2.1x
         else
            AC_PREREQ=2.5x
         fi
      fi

      case $AC_PREREQ in 
          2.1*) echo Running autoconf-2.13 in `pwd` ...;
                if ! $AUTOCONF_OLD ; then 
                   echo "autoconf failed in directory `pwd`"
                   cd $maindir
                   exit 1
                fi
                ;;
          *2.5*) echo Running autoconf-2.5X in `pwd` ...;
                if ! $AUTOCONF ; then 
                   echo "autoconf failed in directory `pwd`"
                   cd $maindir
                   exit 1
                fi
                ;;
          # Something else...??
          *)    echo Unknown autoconf version $AC_PREREQ required
                exit 1
                ;;
      esac 
   fi
   cd $maindir
done

