#! /bin/sh

version=2.19
ver1=$(echo $version | sed -e 's:\.::2g')
ver2=$(echo $version | sed -e 's:\.::g')

target=i586-pc-msdosdjgpp

for exe in bin/*.exe; do
	strip $exe
done

mkdir -p lib/ldscripts
mv -fv $target/lib/ldscripts/* lib/ldscripts/
rm -fv info/dir
strip -g lib/*.a

doc_files="changes.dos COPYING COPYING.lib COPYING3 COPYING3.lib
           MAINTAINERS README bfd/COPYING bfd/MAINTAINERS bfd/PORTING
           bfd/TODO binutils/MAINTAINERS binutils/NEWS
           binutils/README elfcpp/README gas/CONTRIBUTORS
           gas/COPYING gas/MAINTAINERS gas/NEWS gas/README
           gold/NEWS gold/README gold/TODO 	
           gprof/MAINTAINERS gprof/README gprof/TEST
           gprof/TODO include/COPYING include/COPYING3
           include/MAINTAINERS ld/MAINTAINERS
           ld/NEWS ld/README ld/TODO libiberty/README
           opcodes/MAINTAINERS"

for fname in $doc_files; do
  src=../$fname
  dest=gnu/binutils-${ver1}/$fname	
  mkdir -p $(dirname $dest)
  cp -v $src $dest
done

cp -v ../build.djg/README.DJGPP gnu/binutils-${ver1}/

mkdir -p man/cat1

(
  cd man/man1 &&\
  for file in *.1; do
    groff -man -Tascii $file >../cat1/$file
  done
)  

fl_bin=
fl_lib=
fl_skipped=

touch manifest/bnu${ver2}b.mft
touch manifest/bnu${ver2}a.mft

for fname in $(find . -type f | sed -e 's:^\./::') ; do
  case $fname in
    include/*.h | lib/*.a | lib/*.la | manifest/bnu*a.* |\
    gnu/*/include/* | info/bfd.info )
       fl_lib="$fl_lib $fname"
       ;;

    bin/*.exe | info/*.info | lib/ldscripts/* |\
    man/cat1/* | manifest/bnu*b.* |\
    gnu/* )
       fl_bin="$fl_bin $fname"
       ;;

    *)
       fl_skipped="$fl_skipped $fname"
       ;;
  esac
done

( for file in $fl_bin; do echo $file; done ) | sort >manifest/bnu${ver2}b.mft
( for file in $fl_lib; do echo $file; done ) | sort >manifest/bnu${ver2}a.mft
( for file in $fl_skipped; do echo $file; done ) | sort >skipped.mft

cat manifest/bnu${ver2}b.mft | zip -9@ bnu${ver2}b.zip
cat manifest/bnu${ver2}a.mft | zip -9@ bnu${ver2}a.zip
