#! /bin/sh
#
#   BASH script for building DJGPP documentation archive for GCC-4.0.1
#   Tested only under Linux. You may need to modify settings of
#   SRCDIR and BUILDDIR.
#
VERSION=4.0.1
VER1=`echo $VERSION | sed -e 's:\.::2g'`
VER2=`echo $VERSION | sed -e 's:\.::g'`

SRCDIR=../gcc-$VER1
BUILDDIR=../build.gcc
#SRCDIR=../gnu/gcc-$VER1
#BUILDDIR=../djcross
DOCDIR=gnudocs/gcc-$VER1

mkdir -p $DOCDIR
( cd $BUILDDIR && make dvi || exit 1 )

for dvi_file in `find $BUILDDIR -name '*.dvi'`; do
    fn=`basename $dvi_file`
    cp -v $dvi_file $DOCDIR/
    ( cd $DOCDIR && dvips $fn )
    ( cd $DOCDIR && dvipdfm $fn )
done    

makeinfo --no-split --html -I $SRCDIR/gcc/doc/include -I $SRCDIR/gcc/fortran -o $DOCDIR/gfortran.html $SRCDIR/gcc/fortran/gfortran.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/cpp.html $SRCDIR/gcc/doc/cpp.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gcc.html $SRCDIR/gcc/doc/gcc.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gccinstall.html $SRCDIR/gcc/doc/install.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gccint.html $SRCDIR/gcc/doc/gccint.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/cppinternals.html $SRCDIR/gcc/doc/cppinternals.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gnat-style.html $SRCDIR/gcc/ada/gnat-style.texi
makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gnat_rm.html $SRCDIR/gcc/ada/gnat_rm.texi
#makeinfo --no-split --html -I $SRCDIR/gcc/doc -I $SRCDIR/gcc/doc/include -o $DOCDIR/gnat_ugn.html $SRCDIR/gcc/ada/gnat_ugn.texi
makeinfo --no-split --html -I$SRCDIR/libiberty -o $DOCDIR/libiberty.html $SRCDIR/libiberty/libiberty.texi

mkdir -p manifest
D_ADA=ada${VER2}d
D_GCC=gcc${VER2}d
D_GFOR=gfor${VER2}d
rm -vf manifest/$D_ADA.*
rm -vf manifest/$D_GCC.*
rm -vf manifest/$D_GFOR.*
echo "$D_ADA.zip - GCC-$VERSION : Ada documentation (DVI, PS, PDF, HTML)" >manifest/$D_ADA.ver
echo "$D_GCC.zip - GCC-$VERSION : C compiler documentation (DVI, PS, PDF, HTML)" >manifest/$D_GCC.ver
echo "$D_GFOR.zip - GCC-$VERSION : Fortran compiler documentation (DVI, PS, PDF, HTML)" >manifest/$D_GFOR.ver

for file in gnudocs/gcc-$VER1/* ; do
    echo $file
    case $file in 
	*/gnat*)
	    echo $file >>manifest/$D_ADA.mft
	    ;;
	*/gfor*)
	    echo $file >>manifest/$D_GFOR.mft
	    ;;    
	*) 
	    echo $file >>manifest/$D_GCC.mft
	    ;;
    esac
done

echo manifest/$D_ADA.mft >>manifest/$D_ADA.mft
echo manifest/$D_ADA.ver >>manifest/$D_ADA.mft
echo manifest/$D_GCC.mft >>manifest/$D_GCC.mft
echo manifest/$D_GCC.ver >>manifest/$D_GCC.mft
echo manifest/$D_GFOR.mft >>manifest/$D_GFOR.mft
echo manifest/$D_GFOR.ver >>manifest/$D_GFOR.mft

zip -9@ $D_ADA.zip <manifest/$D_ADA.mft
zip -9@ $D_GCC.zip <manifest/$D_GCC.mft
zip -9@ $D_GFOR.zip <manifest/$D_GFOR.mft
     