
The directory ./src contains "p2c", a Pascal to C translator.
The directory ./examples contains a few sample Pascal programs
and a Makefile to translate and compile them.


"p2c"  Copyright 1989, 1990, 1991  Free Software Foundation, Inc.

Written and maintained by:   Dave Gillespie
			     256-80 Caltech
			     Pasadena CA 91125
			     daveg@csvax.cs.caltech.edu, cit-vax!daveg

This program is distributed under the terms of the GNU License Agreement.
See the file src/COPYING for details.

The GNU License Agreement restrictions do _not_ apply to code generated
by p2c, nor to the p2c run-time files "p2clib.c" and "p2c.h".



============================================================================
Ported to DJGPP V2.02 by:	Waldemar Schultz
				Technische Universitaet Muenchen
				D 80333 Muenchen
				schultz@ma.tum.de


Installation:
-------------
Make sure to have a UNIX-like shell (e.g.: 'bash') as well as
the 'pwd', 'cp' and 'rm' commands on your path!
(available at your mirror: v2gnu/fil*b.zip v2gnu/bsh*b.zip v2gnu/shl*b.zip).

Edit ./src/Makefile.dj2 to accommodate your requirements.
type 'make'
Copy/move the file '$BINDIR/p2c.exe' to a place your path leads to;
copy/move the file '$LIBDIR/p2clib.a' to a place your compiler finds libraries;
copy/move the directory '$INCDIR/p2c/' to a place your compiler finds includes;
or use your compilers switches instead (-I -L) specifying full path names. 

Usage:
------
You are ready to translate your Pascal-file to a C-file using a command like

	p2c myprog.p
	or
	p2c myprog.pas -LTURBO -a

The resulting C-file (myprog.c) should compile with a command like

	gcc myprog.c -o myprog.exe -lp2c

The above stands as an example only.
For more information about how to use p2c use the command

	info p2c
	or
	man p2c
	or read the file %DJDIR%/man/man1/p2c.1 with an applicable reader.


Comments by Waldemar:
---------------------
The originial source is is available via anonymous ftp from,

ftp://csvax.cs.caltech.edu/pub/  in p2c-1.20.tar.Z (565KB)

It can be easily installed under the following premissions:

  a --	it is uncompressed, preserving the underlying directory structure
	and LongFileNames as well as multiple extensions
	like, for axample: loc.p2clib.c or loc.p2crc
	(I used 'WinZipClassic' in a Win95 DOS-box via 'p2c_1_20.tar')

  b --	the src/Makefile is modified to match your system requirements
	(My major changes: CC=gcc SHELL=bash ROFF=groff
	 the the various Directory references and
	 the object-extensions set to '.exe')
 
  c --	it is "make" 'd using a very UN*X-like shell in a LFN-environment
	(I used the DJGPP-port of "bash":
	 >bash
	 >cd src
	 >make install
	 >exit)
	 
	 
	 NO WARRANTY
	  W.S.
=============================================================================

./src:
------

The file "trans.c" includes an overview of the source files of p2c.
All p2c source files include the header "trans.h".

The file "dir.c" is intended to be modified by the user to install
code for custom translations of certain procedures.  To add your own
custom code to p2c, modify CUSTSRCS and CUSTDEFS in the Makefile,
then recompile dir.c.

The file "system.imp" (copied to %H/system.imp) contains declarations
for "predefined" functions like "sqrt".  These generally have custom
translation code in funcs.c.  Functions with irregular syntaxes have
their symbol table entries built directly in funcs.c; they do not
appear here.  The default sys.p2crc causes p2c to read system.imp at
the beginning of every job.

The file "system.m2" contains declarations for predefined Modula-2
functions.  It should be substituted for "system.imp" when translating
Modula-2 programs.

The file "turbo.imp" contains declarations for all the Turbo Pascal
standard units like dos and crt.  (These are very incomplete at
present.)  The default sys.p2crc causes p2c to read turbo.imp as
soon as any Turbo standard unit is used.

The file "string.pas" implements the Oregon Software dynamic strings
package.  These are translated pretty completely into native C strings
using only the FuncMacro mechanism of p2c---no custom C code was
written to support these functions.

The file "NOTES" contains the author's current bugs-and-plans list.
The file "HISTORY" contains the revision history of the program.

The "makeproto" program is an independent utility for scanning a large
C program with old-style declarations and building function prototypes
for all its functions.  The "trans.h" file #includes the prototype
files for all of p2c.

REMARKS:
--------
HP Pascal Workstation System users will want to copy all of ../HP/include
into the new p2c include directory, and copy all of ../HP/import into
the p2c home directory.  You will have to write emulations for the
functions you use out of these modules.  (The HP directories are
present in the ftp distribution only---they have been omitted from
the shar'd version to save space.)

Incomplete interface texts for standard Turbo units are included in
turbo.imp.  Turbo users will have to flesh these out and write emulations
for whatever parts of the Turbo runtime library they need.

If you wish to edit various system-wide configuration parameters, it is
better to put them in loc.p2crc than in sys.p2crc.  As an example, on a
Turbo-oriented environment you may wish to add

    Language Turbo

to the p2crc.loc file to replace the normal default (HP Pascal).



PORTABILITY
------------

P2c was originally developed on a homebrew C compiler on the HP Pascal
Workstation operating system.  Current development takes place on HP-UX,
which is System V based.  The translator has also been compiled and used
on Sun-3's, so presumably it is fairly portable among 32-bit Unix machines.

Many parts of the code will have to be adjusted in order for p2c to work
on a machine with 16-bit ints.  I have never had reason or opportunity to
track these down since I don't have access to such a machine.  Please note
that code _generated_ by p2c works with either size of int even though p2c
itself does not.

If your compiler supports ANSI prototypes, most of the 16-bit portability
problems will go away except for possible %d/%ld sloppiness in sprintf control
strings.  There may be places where p2c tries to cast a pointer into an
int, but I believe all such cases use longs consistently.  You will have
a problem if your long type is not large enough to store a pointer.

Because p2c was developed to run under Unix, it is sloppy about memory
allocation.  Some data structures are allocated but never freed.  Profiles
show that the waste is not too great in most cases, but if it is a problem
you may have to write a garbage collector (this shouldn't be too hard if you
only run the collector after translating each procedure).




NO WARRANTY:
   The program in this directory was developed for internal use at
   Caltech and thus absolutely no guarantee is made that the program
   will compile or run on other systems or that it will produce correct
   code.  P2c is _not_ a compiler, it is a translator; it strives to
   produce correct code but reserves the right to sacrifice correctness
   in extreme cases for readability in the general case.  P2c is designed
   to be extended (see funcs.c, hpmods.c and citmods.c for examples), but
   some of the main code is pretty messy since the translator has grown
   considerably beyond its original planned scale.  Bug reports are
   welcome at daveg@csvax.caltech.edu, but I may not have time to respond
   to them immediately.  Suggestions are welcome, too!

    D.G.
