;;; 87.7.15  modified for Nemacs Ver.2.0 by K.Handa
;;; 89.3.22  modified for Nemacs Ver.3.0 by K.Handa
;;; 90.2.28  modified for Nemacs Ver.3.3.0 by K.Handa
;;; 91/10/22 modified for Demacs 1.1.2 by Manabu Higashida

;Load up standardly loaded Lisp files for Emacs.
;; This is loaded into a bare Emacs to make a dumpable one.
;; Copyright (C) 1985, 1986 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


(load "subr")
(garbage-collect)
(load "loaddefs.el")  ;Don't get confused if someone compiled loaddefs by mistake.
(garbage-collect)
(load "simple")
(garbage-collect)
(load "help")
(garbage-collect)
(load "files")
(garbage-collect)
(load "indent")
(load "window")
(load "paths.el")  ;Don't get confused if someone compiled paths by mistake.
(garbage-collect)
(load "startup")
(load "lisp")
(garbage-collect)
(load "page")
(load "register")
(garbage-collect)
(load "paragraphs")
(load "lisp-mode")
(garbage-collect)
(load "text-mode")
(load "fill")
(garbage-collect)
(load "c-mode")
(garbage-collect)
(load "isearch")
(garbage-collect)
(load "replace")
(if (eq system-type 'vax-vms)
    (progn
      (garbage-collect)
      (load "vmsproc")))
(garbage-collect)
(load "abbrev")
(garbage-collect)
(load "buff-menu")
(if (eq system-type 'vax-vms)
    (progn
      (garbage-collect)
      (load "vms-patch")))
;;; patch by K.Handa  87.7.15
;;; modified by K.Handa  88.6.20, 89.3.22
(if (boundp 'NEMACS)
    (progn
      (load "kanji")
      (garbage-collect)
      (load "kinsoku")
      (garbage-collect)))
;;; end of patch
(if (eq system-type 'ms-dos)
    (progn
      (load "demacs")
      (garbage-collect)
      (load "dos-fns")
      (garbage-collect)
      (if (boundp 'NEMACS)
	  (progn
	    (load "fepctrl")
	    (garbage-collect)))))
;

;If you want additional libraries to be preloaded and their
;doc strings kept in the DOC file rather than in core,
;you may load them with a "site-load.el" file.
;But you must also cause them to be scanned when the DOC file
;is generated.  For VMS, you must edit ../etc/makedoc.com.
;For other systems, you must edit ../src/ymakefile.
(if (load "site-load" t)
    (garbage-collect))

(load "version.el")  ;Don't get confused if someone compiled version.el by mistake.

;; Note: all compiled Lisp files loaded above this point
;; must be among the ones parsed by make-docfile
;; to construct DOC.  Any that are not processed
;; for DOC will not have doc strings in the dumped Emacs.

(message "Finding pointers to doc strings...")
(if (fboundp 'dump-emacs)
    (if (not (eq system-type 'ms-dos))
	(let ((name emacs-version))
	  (while (string-match "[^-+_.a-zA-Z0-9]+" name)
	    (setq name (concat
			(downcase (substring name 0 (match-beginning 0)))
			"-"
			(substring name (match-end 0)))))
	  (copy-file (expand-file-name "../etc/DOC")
		     (concat (expand-file-name "../etc/DOC-") name)
		     t)
	  (Snarf-documentation (concat "DOC-" name)))
      (Snarf-documentation "DOC"))
  (Snarf-documentation "DOC"))
(message "Finding pointers to doc strings...done")

;;; 90.2.28  patch by K.Handa
;;; Now we load Nemacs related site configulation file.
(if (boundp 'NEMACS)
    (progn 
      (load "nemacs-init" t)
      (garbage-collect)))
;;; end of patch

;Note: You can cause additional libraries to be preloaded
;by writing a site-init.el that loads them.
;See also "site-load" above.
(load "site-init" t)
(garbage-collect)

(if (or (equal (nth 3 command-line-args) "dump")
	(equal (nth 4 command-line-args) "dump"))
    (if (eq system-type 'vax-vms)
	(progn 
	  (message "Dumping data as file temacs.dump")
	  (dump-emacs "temacs.dump" "temacs")
	  (kill-emacs))
      (let ((name (concat "emacs-" emacs-version)))
	(while (string-match "[^-+_.a-zA-Z0-9]+" name)
	  (setq name (concat (downcase (substring name 0 (match-beginning 0)))
			     "-"
			     (substring name (match-end 0)))))
        (if (eq system-type 'ms-dos)
            (message "Dumping under names demacs")
	  (message "Dumping under names xemacs and %s" name)))
      (condition-case ()
	  (delete-file (if (eq system-type 'ms-dos) "demacs" "xemacs"))
	(file-error nil))
      (dump-emacs (if (eq system-type 'ms-dos) "demacs" "xemacs") "temacs")
      ;; Recompute NAME now, so that it isn't set when we dump.
      (if (not (eq system-type 'ms-dos))
	  (let ((name (concat "emacs-" emacs-version)))
	    (while (string-match "[^-+_.a-zA-Z0-9]+" name)
	      (setq name (concat
			  (downcase (substring name 0 (match-beginning 0)))
			  "-"
			  (substring name (match-end 0)))))
	    (add-name-to-file "xemacs" name t)))
      (kill-emacs)))

;; Avoid error if user loads some more libraries now.
(setq purify-flag nil)

;; For machines with CANNOT_DUMP defined in config.h,
;; this file must be loaded each time Emacs is run.
;; So run the startup code now.

(or (fboundp 'dump-emacs)
    (eval top-level))
