/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PrimitiveNode
extends NodeProto {
    public static final int NORMAL = 0;
    public static final int SERPTRANS = 1;
    public static final int POLYGONAL = 2;
    public static final int MULTICUT = 3;
    private Technology.NodeLayer[] layers;
    private Technology.NodeLayer[] electricalLayers;
    private int userBits;
    private int primNodeIndex;
    private int specialType;
    private double[] specialValues;
    private double minWidth;
    private double minHeight;
    private String minSizeRule;
    private SizeOffset offset;
    private Dimension2D autoGrowth;
    private static int primNodeNumber = 0;
    private static HashMap defaultWidthPrefs = new HashMap();
    private static HashMap defaultHeightPrefs = new HashMap();

    private PrimitiveNode(String protoName, Technology tech, double defWidth, double defHeight, SizeOffset offset, Technology.NodeLayer[] layers) {
        this.protoName = protoName;
        this.tech = tech;
        this.layers = layers;
        this.electricalLayers = null;
        this.userBits = 0;
        this.specialType = 0;
        this.setFactoryDefSize(defWidth, defHeight);
        if (offset == null) {
            offset = new SizeOffset(0.0, 0.0, 0.0, 0.0);
        }
        this.offset = offset;
        this.autoGrowth = null;
        this.minHeight = -1.0;
        this.minWidth = -1.0;
        this.minSizeRule = "";
        this.primNodeIndex = primNodeNumber++;
        tech.addNodeProto(this);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, SizeOffset offset, Technology.NodeLayer[] layers) {
        if (tech.findNodeProto(protoName) != null) {
            System.out.println("Error: technology " + tech.getTechName() + " has multiple nodes named " + protoName);
            return null;
        }
        if (width < 0.0 || height < 0.0) {
            System.out.println("Error: technology " + tech.getTechName() + " node " + protoName + " has negative size");
            return null;
        }
        PrimitiveNode pn = new PrimitiveNode(protoName, tech, width, height, offset, layers);
        return pn;
    }

    public Technology.NodeLayer[] getLayers() {
        return this.layers;
    }

    public Iterator layerIterator() {
        return new NodeLayerIterator(this.layers);
    }

    public Technology.NodeLayer[] getElectricalLayers() {
        return this.electricalLayers;
    }

    public void setElectricalLayers(Technology.NodeLayer[] electricalLayers) {
        this.electricalLayers = electricalLayers;
    }

    public Technology.NodeLayer findNodeLayer(Layer layer) {
        for (int j = 0; j < this.layers.length; ++j) {
            Technology.NodeLayer oneLayer = this.layers[j];
            if (oneLayer.getLayer() != layer) continue;
            return oneLayer;
        }
        return null;
    }

    private Pref getNodeProtoWidthPref(double factoryWidth) {
        Pref pref = (Pref)defaultWidthPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultWidthFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryWidth);
            defaultWidthPrefs.put(this, pref);
        }
        return pref;
    }

    private Pref getNodeProtoHeightPref(double factoryHeight) {
        Pref pref = (Pref)defaultHeightPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultHeightFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factoryHeight);
            defaultHeightPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefSize(double defWidth, double defHeight) {
        this.getNodeProtoWidthPref(defWidth);
        this.getNodeProtoHeightPref(defHeight);
    }

    public void setDefSize(double defWidth, double defHeight) {
        this.getNodeProtoWidthPref(0.0).setDouble(defWidth);
        this.getNodeProtoHeightPref(0.0).setDouble(defHeight);
    }

    public double getDefWidth() {
        return this.getNodeProtoWidthPref(0.0).getDouble();
    }

    public double getDefHeight() {
        return this.getNodeProtoHeightPref(0.0).getDouble();
    }

    public SizeOffset getProtoSizeOffset() {
        return this.offset;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public String getMinSizeRule() {
        return this.minSizeRule;
    }

    public void setMinSize(double minWidth, double minHeight, String minSizeRule) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.minSizeRule = minSizeRule;
    }

    public void setSizeOffset(SizeOffset offset) {
        this.offset = offset;
    }

    public void setAutoGrowth(double dX, double dY) {
        this.autoGrowth = new Dimension2D.Double(dX, dY);
    }

    public Dimension2D getAutoGrowth() {
        return this.autoGrowth;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public void addPrimitivePorts(PrimitivePort[] ports) {
        for (int i = 0; i < ports.length; ++i) {
            ports[i].setParent(this);
            this.addPort(ports[i], null);
        }
    }

    public int getSpecialType() {
        return this.specialType;
    }

    public void setSpecialType(int specialType) {
        this.specialType = specialType;
    }

    public double[] getSpecialValues() {
        return this.specialValues;
    }

    public void setSpecialValues(double[] specialValues) {
        this.specialValues = specialValues;
    }

    public boolean isPin() {
        return this.getFunction() == NodeProto.Function.PIN;
    }

    public String describe() {
        String name = "";
        if (this.tech != Technology.getCurrent()) {
            name = name + this.tech.getTechName() + ":";
        }
        name = name + this.protoName;
        return name;
    }

    public final int getPrimNodeIndex() {
        return this.primNodeIndex;
    }

    public String toString() {
        return "PrimitiveNode " + this.describe();
    }

    private static class NodeLayerIterator
    implements Iterator {
        Technology.NodeLayer[] array;
        int pos;

        public NodeLayerIterator(Technology.NodeLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

