/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Quick {
    private static final double TINYDELTA = 0.001;
    private static final int SPACINGERROR = 1;
    private static final int MINWIDTHERROR = 2;
    private static final int NOTCHERROR = 3;
    private static final int MINSIZEERROR = 4;
    private static final int BADLAYERERROR = 5;
    private static final int LAYERSURROUNDERROR = 6;
    private HashMap checkInsts = null;
    private HashMap checkProtos = null;
    private HashMap networkLists = null;
    private List instanceInteractionList = new ArrayList();
    private List exclusionList = new ArrayList();
    private int numberOfThreads;
    private boolean onlyFirstError;
    private boolean ignoreCenterCuts;
    private double worstInteractionDistance;
    private int checkTimeStamp;
    private int checkNetNumber;
    private int totalErrorsFound;
    private NodeInst tinyNodeInst;
    private Geometric tinyGeometric;
    private HashMap goodDRCDate = new HashMap();
    private boolean haveGoodDRCDate;
    private ErrorLogger errorLogger;
    private static ErrorLogger errorLoggerIncremental = null;
    private Technology layersValidTech = null;
    private boolean[] layersValid;
    private Technology layerInterTech = null;
    private HashMap layersInterNodes = null;
    private HashMap layersInterArcs = null;

    public static int checkDesignRules(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity, boolean justArea) {
        Quick q = new Quick();
        return q.doCheck(cell, count, geomsToCheck, validity, justArea);
    }

    private int doCheck(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity, boolean justArea) {
        EditWindow wnd;
        this.onlyFirstError = DRC.isOneErrorPerCell();
        this.ignoreCenterCuts = DRC.isIgnoreCenterCuts();
        this.numberOfThreads = DRC.getNumberOfThreads();
        if (count > 0) {
            this.onlyFirstError = true;
            this.numberOfThreads = 1;
        }
        Technology tech = cell.getTechnology();
        this.cacheValidLayers(tech);
        this.buildLayerInteractions(tech);
        this.clearInstanceCache();
        this.worstInteractionDistance = DRC.getWorstSpacingDistance(tech);
        this.checkProtos = new HashMap();
        this.checkInsts = new HashMap();
        Netlist netlist = cell.getNetlist(false);
        CheckProto cp = this.checkEnumerateProtos(cell, netlist);
        if (cp.treeParameterized && this.numberOfThreads > 1) {
            System.out.println("Parameterized layout being used: multiprocessor decomposition disabled");
            this.numberOfThreads = 1;
        }
        cp.hierInstanceCount = 1;
        this.checkTimeStamp = 0;
        this.checkEnumerateInstances(cell);
        int totalNetworks = 0;
        this.networkLists = new HashMap();
        Iterator it = this.checkProtos.entrySet().iterator();
        while (it.hasNext()) {
            NodeProto np;
            NodeInst ni;
            Iterator nIt;
            Map.Entry e = it.next();
            Cell libCell = (Cell)e.getKey();
            CheckProto subCP = (CheckProto)e.getValue();
            if (subCP.hierInstanceCount > 0) {
                nIt = subCP.netlist.getNetworks();
                while (nIt.hasNext()) {
                    JNetwork net = (JNetwork)nIt.next();
                    Integer[] netNumbers = new Integer[subCP.hierInstanceCount];
                    for (int i = 0; i < subCP.hierInstanceCount; ++i) {
                        netNumbers[i] = new Integer(0);
                    }
                    this.networkLists.put(net, netNumbers);
                    totalNetworks += subCP.hierInstanceCount;
                }
            }
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                CheckProto ocp = this.getCheckProto((Cell)np);
                ci.offset = ocp.totalPerCell;
            }
            ++this.checkTimeStamp;
            nIt = libCell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                np = ni.getProto();
                if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
                CheckProto ocp = this.getCheckProto((Cell)np);
                if (ocp.timeStamp == this.checkTimeStamp) continue;
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                ocp.timeStamp = this.checkTimeStamp;
                ocp.totalPerCell += subCP.hierInstanceCount * ci.multiplier;
            }
        }
        this.checkTimeStamp = 0;
        this.checkNetNumber = 1;
        HashMap<JNetwork, Integer> enumeratedNets = new HashMap<JNetwork, Integer>();
        Iterator nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            JNetwork net = (JNetwork)nIt.next();
            enumeratedNets.put(net, new Integer(this.checkNetNumber));
            ++this.checkNetNumber;
        }
        this.checkEnumerateNetworks(cell, cp, 0, enumeratedNets);
        if (count <= 0) {
            System.out.println("Found " + this.checkNetNumber + " networks");
        }
        this.exclusionList.clear();
        this.accumulateExclusion(cell, DBMath.MATID);
        Rectangle2D bounds = null;
        if (justArea && (wnd = EditWindow.getCurrent()) != null) {
            bounds = Highlight.getHighlightedArea(wnd);
        }
        this.haveGoodDRCDate = false;
        this.errorLogger = null;
        int errorsFound = 0;
        if (count == 0) {
            this.errorLogger = ErrorLogger.newInstance("DRC (full)");
            this.checkThisCell(cell, 0, bounds);
            this.errorLogger.sortErrors();
        } else {
            if (validity == null) {
                if (errorLoggerIncremental == null) {
                    errorLoggerIncremental = ErrorLogger.newInstance("DRC (incremental)", true);
                }
                errorLoggerIncremental.clearErrors(cell);
                this.errorLogger = errorLoggerIncremental;
                errorsFound = errorLoggerIncremental.getNumErrors();
            }
            this.checkTheseGeometrics(cell, count, geomsToCheck, validity);
        }
        if (this.errorLogger != null) {
            this.errorLogger.termLogging(true);
            errorsFound = this.errorLogger.getNumErrors() - errorsFound;
        }
        if (this.haveGoodDRCDate && count == 0) {
            SaveDRCDates job = new SaveDRCDates(this.goodDRCDate);
        }
        return errorsFound;
    }

    private int checkThisCell(Cell cell, int globalIndex, Rectangle2D bounds) {
        Date lastChangeDate;
        Date lastGoodDate;
        boolean allSubCellsStillOK = true;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            Rectangle2D subBounds = bounds;
            if (subBounds != null) {
                if (!ni.getBounds().intersects(bounds)) continue;
                AffineTransform trans = ni.rotateIn();
                AffineTransform xTrnI = ni.translateIn();
                trans.preConcatenate(xTrnI);
                subBounds = new Rectangle2D.Double();
                subBounds.setRect(bounds);
                DBMath.transformRect(subBounds, trans);
            }
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.cellChecked && !cp.cellParameterized) continue;
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            int retval = this.checkThisCell((Cell)np, localIndex, subBounds);
            if (retval < 0) {
                return -1;
            }
            if (retval <= 0) continue;
            allSubCellsStillOK = false;
        }
        CheckProto cp = this.getCheckProto(cell);
        cp.cellChecked = true;
        if (allSubCellsStillOK && (lastGoodDate = DRC.getLastDRCDate(cell)) != null && lastGoodDate.after(lastChangeDate = cell.getRevisionDate())) {
            return 0;
        }
        System.out.println("Checking cell " + cell.describe());
        int errCount = 0;
        if (this.errorLogger != null) {
            errCount = this.errorLogger.numErrors();
        }
        this.totalErrorsFound = 0;
        Iterator it2 = cell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            if (bounds != null && !ni.getBounds().intersects(bounds)) continue;
            boolean ret = false;
            ret = ni.getProto() instanceof Cell ? this.checkCellInst(ni, globalIndex) : this.checkNodeInst(ni, globalIndex);
            if (!ret) continue;
            ++this.totalErrorsFound;
            if (!this.onlyFirstError) continue;
            break;
        }
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            if (bounds != null && !ai.getBounds().intersects(bounds) || !this.checkArcInst(cp, ai, globalIndex)) continue;
            ++this.totalErrorsFound;
            if (!this.onlyFirstError) continue;
            break;
        }
        if (this.errorLogger != null) {
            int localErrors = this.errorLogger.numErrors() - errCount;
            if (localErrors == 0) {
                this.goodDRCDate.put(cell, new Date());
                this.haveGoodDRCDate = true;
                System.out.println("   No errors found");
            } else {
                System.out.println("   FOUND " + localErrors + " ERRORS");
            }
        }
        return this.totalErrorsFound;
    }

    private boolean checkNodeInst(NodeInst ni, int globalIndex) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        NodeProto np = ni.getProto();
        Technology tech = np.getTechnology();
        AffineTransform trans = ni.rotateOut();
        NodeProto.Function fun = ni.getFunction();
        Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts);
        this.convertPseudoLayers(ni, nodeInstPolyList);
        int tot = nodeInstPolyList.length;
        boolean errorsFound = false;
        for (int j = 0; j < tot; ++j) {
            Poly poly = nodeInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null || layer.isNonElectrical()) continue;
            poly.transform(trans);
            int netNumber = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
            boolean ret = this.badBox(poly, layer, netNumber, tech, ni, trans, cell, globalIndex);
            if (ret) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ni, layer, poly, tech)) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layer.getIndex()]) continue;
            this.reportError(5, this.layersValidTech, null, cell, 0.0, 0.0, null, poly, ni, layer, -1, null, null, null, -1);
            if (this.onlyFirstError) {
                return true;
            }
            errorsFound = true;
        }
        DRC.NodeSizeRule sizeRule = DRC.getMinSize(np);
        if (sizeRule != null && (ni.getXSize() < sizeRule.sizeX || ni.getYSize() < sizeRule.sizeY)) {
            SizeOffset so = ni.getSizeOffset();
            double minSize = 0.0;
            double actual = 0.0;
            if (sizeRule.sizeX - ni.getXSize() > sizeRule.sizeY - ni.getYSize()) {
                minSize = sizeRule.sizeX - so.getLowXOffset() - so.getHighXOffset();
                actual = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            } else {
                minSize = sizeRule.sizeY - so.getLowYOffset() - so.getHighYOffset();
                actual = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            }
            this.reportError(4, tech, null, cell, minSize, actual, sizeRule.rule, null, ni, null, -1, null, null, null, -1);
        }
        return errorsFound;
    }

    private boolean checkArcInst(CheckProto cp, ArcInst ai, int globalIndex) {
        JNetwork net = cp.netlist.getNetwork(ai, 0);
        if (net == null) {
            return false;
        }
        Integer[] netNumbers = (Integer[])this.networkLists.get(net);
        Technology tech = ai.getProto().getTechnology();
        Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
        this.cropActiveArc(ai, arcInstPolyList);
        int tot = arcInstPolyList.length;
        boolean errorsFound = false;
        for (int j = 0; j < tot; ++j) {
            Poly poly = arcInstPolyList[j];
            Layer layer = poly.getLayer();
            if (layer == null || layer.isNonElectrical()) continue;
            int layerNum = layer.getIndex();
            int netNumber = netNumbers[globalIndex];
            boolean ret = this.badBox(poly, layer, netNumber, tech, ai, DBMath.MATID, ai.getParent(), globalIndex);
            if (ret) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (ret = this.checkMinWidth(ai, layer, poly, tech)) {
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
            if (tech != this.layersValidTech || this.layersValid[layerNum]) continue;
            this.reportError(5, tech, null, ai.getParent(), 0.0, 0.0, null, poly, ai, layer, 0, null, null, null, 0);
            if (this.onlyFirstError) {
                return true;
            }
            errorsFound = true;
        }
        return errorsFound;
    }

    private boolean checkCellInst(NodeInst ni, int globalIndex) {
        AffineTransform upTrans = ni.translateOut();
        AffineTransform rTrans = ni.rotateOut();
        upTrans.preConcatenate(rTrans);
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        Iterator it = ni.getParent().searchIterator(searchBounds);
        while (it.hasNext()) {
            NodeInst oNi;
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom).getNodeIndex() <= ni.getNodeIndex() || !(oNi.getProto() instanceof Cell) || this.checkInteraction(ni, oNi)) continue;
            Rectangle2D nearNodeBounds = oNi.getBounds();
            Rectangle2D.Double subBounds = new Rectangle2D.Double(nearNodeBounds.getMinX() - this.worstInteractionDistance, nearNodeBounds.getMinY() - this.worstInteractionDistance, nearNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nearNodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
            this.checkCellInstContents(subBounds, (Cell)ni.getProto(), upTrans, localIndex, oNi, globalIndex);
        }
        return false;
    }

    private boolean checkCellInstContents(Rectangle2D bounds, Cell cell, AffineTransform upTrans, int globalIndex, NodeInst oNi, int topGlobalIndex) {
        boolean errorsFound = false;
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            Geometric geom = (Geometric)it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                NodeProto np = ni.getProto();
                if (np instanceof Cell) {
                    Rectangle2D.Double subBounds = new Rectangle2D.Double();
                    ((Rectangle2D)subBounds).setRect(bounds);
                    AffineTransform rTransI = ni.rotateIn();
                    AffineTransform tTransI = ni.translateIn();
                    rTransI.preConcatenate(tTransI);
                    DBMath.transformRect(subBounds, rTransI);
                    AffineTransform subUpTrans = ni.translateOut();
                    AffineTransform rTrans = ni.rotateOut();
                    subUpTrans.preConcatenate(rTrans);
                    subUpTrans.preConcatenate(upTrans);
                    CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                    int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    this.checkCellInstContents(subBounds, (Cell)np, subUpTrans, localIndex, oNi, topGlobalIndex);
                    continue;
                }
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(upTrans);
                Technology tech = np.getTechnology();
                Poly[] primPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts);
                this.convertPseudoLayers(ni, primPolyList);
                int tot = primPolyList.length;
                for (int j2 = 0; j2 < tot; ++j2) {
                    Poly poly = primPolyList[j2];
                    Layer layer = poly.getLayer();
                    if (layer == null || layer.isNonElectrical()) continue;
                    poly.transform(rTrans);
                    int net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex);
                    boolean ret = this.badSubBox(poly, layer, net, tech, ni, rTrans, globalIndex, cell, oNi, topGlobalIndex);
                    if (!ret) continue;
                    if (this.onlyFirstError) {
                        return true;
                    }
                    errorsFound = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] arcPolyList = tech.getShapeOfArc(ai);
            int tot = arcPolyList.length;
            for (j = 0; j < tot; ++j) {
                arcPolyList[j].transform(upTrans);
            }
            this.cropActiveArc(ai, arcPolyList);
            for (j = 0; j < tot; ++j) {
                boolean ret;
                Poly poly = arcPolyList[j];
                Layer layer = poly.getLayer();
                if (layer == null || layer.isNonElectrical()) continue;
                JNetwork jNet = netlist.getNetwork(ai, 0);
                int net = -1;
                if (jNet != null) {
                    Integer[] netList = (Integer[])this.networkLists.get(jNet);
                    net = netList[globalIndex];
                }
                if (!(ret = this.badSubBox(poly, layer, net, tech, ai, upTrans, globalIndex, cell, oNi, topGlobalIndex))) continue;
                if (this.onlyFirstError) {
                    return true;
                }
                errorsFound = true;
            }
        }
        return errorsFound;
    }

    private boolean badSubBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, int globalIndex, Cell cell, NodeInst oNi, int topGlobalIndex) {
        double bound = DRC.getMaxSurround(layer);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        AffineTransform downTrans = oNi.rotateIn();
        AffineTransform tTransI = oNi.translateIn();
        downTrans.preConcatenate(tTransI);
        DBMath.transformRect(bounds, downTrans);
        double minSize = poly.getMinSize();
        AffineTransform upTrans = oNi.translateOut();
        AffineTransform rTrans = oNi.rotateOut();
        upTrans.preConcatenate(rTrans);
        CheckInst ci = (CheckInst)this.checkInsts.get(oNi);
        int localIndex = topGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = this.isMultiCut((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        boolean retval = this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, (Cell)oNi.getProto(), localIndex, oNi.getParent(), topGlobalIndex, upTrans, minSize, baseMulti, false);
        return retval;
    }

    private boolean badBox(Poly poly, Layer layer, int net, Technology tech, Geometric geom, AffineTransform trans, Cell cell, int globalIndex) {
        double bound = DRC.getMaxSurround(layer);
        if (bound < 0.0) {
            return false;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        ((Rectangle2D)bounds).setRect(poly.getBounds2D());
        double minSize = poly.getMinSize();
        boolean baseMulti = false;
        if (geom instanceof NodeInst) {
            baseMulti = this.isMultiCut((NodeInst)geom);
        }
        ((Rectangle2D)bounds).setRect(bounds.getMinX() - bound, bounds.getMinY() - bound, ((RectangularShape)bounds).getWidth() + bound * 2.0, ((RectangularShape)bounds).getHeight() + bound * 2.0);
        return this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, bounds, cell, globalIndex, cell, globalIndex, DBMath.MATID, minSize, baseMulti, true);
    }

    private boolean badBoxInArea(Poly poly, Layer layer, Technology tech, int net, Geometric geom, AffineTransform trans, int globalIndex, Rectangle2D bounds, Cell cell, int cellGlobalIndex, Cell topCell, int topGlobalIndex, AffineTransform topTrans, double minSize, boolean baseMulti, boolean sameInstance) {
        Rectangle2D.Double rBound = new Rectangle2D.Double();
        ((Rectangle2D)rBound).setRect(bounds);
        DBMath.transformRect(rBound, topTrans);
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        boolean count = false;
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric nGeom = (Geometric)it.next();
            if (sameInstance && nGeom == geom) continue;
            if (nGeom instanceof NodeInst) {
                NodeInst ni = (NodeInst)nGeom;
                NodeProto np = ni.getProto();
                if (np instanceof Cell) {
                    AffineTransform rTransI = ni.rotateIn();
                    AffineTransform tTransI = ni.translateIn();
                    rTransI.preConcatenate(tTransI);
                    Rectangle2D.Double subBound = new Rectangle2D.Double();
                    ((Rectangle2D)subBound).setRect(bounds);
                    DBMath.transformRect(subBound, rTransI);
                    CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                    int localIndex = cellGlobalIndex * ci.multiplier + ci.localIndex + ci.offset;
                    AffineTransform subTrans = ni.translateOut();
                    AffineTransform rTrans = ni.rotateOut();
                    subTrans.preConcatenate(rTrans);
                    subTrans.preConcatenate(topTrans);
                    this.badBoxInArea(poly, layer, tech, net, geom, trans, globalIndex, subBound, (Cell)np, localIndex, topCell, topGlobalIndex, subTrans, minSize, baseMulti, sameInstance);
                    continue;
                }
                if (np.getTechnology() != tech || !this.checkLayerWithNode(layer, np)) continue;
                boolean touch = this.objectsTouch(nGeom, geom);
                AffineTransform rTrans = ni.rotateOut();
                rTrans.preConcatenate(topTrans);
                Poly[] subPolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts);
                this.convertPseudoLayers(ni, subPolyList);
                int tot = subPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    subPolyList[i].transform(rTrans);
                }
                boolean multi = baseMulti;
                if (!multi) {
                    multi = this.isMultiCut(ni);
                }
                for (int j = 0; j < tot; ++j) {
                    String rule;
                    Rectangle2D nPolyRect;
                    Poly npoly = subPolyList[j];
                    Layer nLayer = npoly.getLayer();
                    if (nLayer == null || nLayer.isNonElectrical() || (nPolyRect = npoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                    int nNet = this.getDRCNetNumber(netlist, npoly.getPort(), ni, cellGlobalIndex);
                    boolean con = false;
                    if (nNet >= 0 && nNet == net) {
                        con = true;
                    }
                    if (con && touch) continue;
                    double nMinSize = npoly.getMinSize();
                    DRC.Rule dRule = this.getAdjustedMinDist(tech, layer, minSize, nLayer, nMinSize, con, multi);
                    DRC.Rule eRule = DRC.getEdgeRule(layer, nLayer);
                    if (dRule == null && eRule == null) continue;
                    double dist = -1.0;
                    boolean edge = false;
                    if (dRule != null) {
                        dist = dRule.distance;
                        rule = dRule.rule;
                    } else {
                        dist = eRule.distance;
                        rule = eRule.rule;
                        edge = true;
                    }
                    boolean ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, npoly, nLayer, nNet, nGeom, rTrans, cellGlobalIndex, con, dist, edge, rule);
                    if (!ret) continue;
                    return true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)nGeom;
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() != tech || !this.checkLayerWithArc(layer, ap)) continue;
            boolean touch = this.objectsTouch(nGeom, geom);
            JNetwork jNet = netlist.getNetwork(ai, 0);
            Integer[] netNumbers = (Integer[])this.networkLists.get(jNet);
            int nNet = netNumbers[cellGlobalIndex];
            boolean con = false;
            if (net >= 0 && nNet == net) {
                con = true;
            }
            if (con && touch) continue;
            Poly[] subPolyList = tech.getShapeOfArc(ai);
            int tot = subPolyList.length;
            for (int i = 0; i < tot; ++i) {
                subPolyList[i].transform(topTrans);
            }
            this.cropActiveArc(ai, subPolyList);
            boolean multi = baseMulti;
            for (int j = 0; j < tot; ++j) {
                String rule;
                Rectangle2D nPolyRect;
                Poly nPoly = subPolyList[j];
                Layer nLayer = nPoly.getLayer();
                if (nLayer == null || (nPolyRect = nPoly.getBounds2D()).getMinX() > rBound.getMaxX() || nPolyRect.getMaxX() < rBound.getMinX() || nPolyRect.getMinY() > rBound.getMaxY() || nPolyRect.getMaxY() < rBound.getMinY()) continue;
                double nMinSize = nPoly.getMinSize();
                DRC.Rule dRule = this.getAdjustedMinDist(tech, layer, minSize, nLayer, nMinSize, con, multi);
                DRC.Rule eRule = DRC.getEdgeRule(layer, nLayer);
                if (dRule == null && eRule == null) continue;
                double dist = -1.0;
                boolean edge = false;
                if (dRule != null) {
                    dist = dRule.distance;
                    rule = dRule.rule;
                } else {
                    dist = eRule.distance;
                    rule = eRule.rule;
                    edge = true;
                }
                boolean ret = this.checkDist(tech, topCell, topGlobalIndex, poly, layer, net, geom, trans, globalIndex, nPoly, nLayer, nNet, nGeom, topTrans, cellGlobalIndex, con, dist, edge, rule);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDist(Technology tech, Cell cell, int globalIndex, Poly poly1, Layer layer1, int net1, Geometric geom1, AffineTransform trans1, int globalIndex1, Poly poly2, Layer layer2, int net2, Geometric geom2, AffineTransform trans2, int globalIndex2, boolean con, double dist, boolean edge, String rule) {
        Rectangle2D isBox2;
        Rectangle2D trueBox2;
        this.tinyNodeInst = null;
        Poly origPoly1 = poly1;
        Poly origPoly2 = poly2;
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D trueBox1 = isBox1;
        if (trueBox1 == null) {
            trueBox1 = poly1.getBounds2D();
        }
        if ((trueBox2 = (isBox2 = poly2.getBox())) == null) {
            trueBox2 = poly2.getBounds2D();
        }
        boolean maytouch = false;
        if (tech.sameLayer(layer1, layer2)) {
            Layer.Function fun = layer1.getFunction();
            if (con) {
                if (!fun.isContact()) {
                    maytouch = true;
                }
            } else if (fun.isSubstrate()) {
                maytouch = true;
            }
        }
        double pd = 0.0;
        if (isBox1 != null && isBox2 != null) {
            DRC.Rule wRule;
            double pdx = Math.max(trueBox2.getMinX() - trueBox1.getMaxX(), trueBox1.getMinX() - trueBox2.getMaxX());
            double pdy = Math.max(trueBox2.getMinY() - trueBox1.getMaxY(), trueBox1.getMinY() - trueBox2.getMaxY());
            pd = Math.max(pdx, pdy);
            if (pdx == 0.0 && pdy == 0.0) {
                pd = 1.0;
            }
            if (maytouch && pd <= 0.0 && (wRule = DRC.getMinWidth(layer1)) != null) {
                double hyb;
                Point2D.Double highB;
                double minWidth = wRule.distance;
                String sizeRule = wRule.rule;
                double lxb = Math.max(trueBox1.getMinX(), trueBox2.getMinX());
                double hxb = Math.min(trueBox1.getMaxX(), trueBox2.getMaxX());
                double lyb = Math.max(trueBox1.getMinY(), trueBox2.getMinY());
                Point2D.Double lowB = new Point2D.Double(lxb, lyb);
                double actual = lowB.distance(highB = new Point2D.Double(hxb, hyb = Math.min(trueBox1.getMaxY(), trueBox2.getMaxY())));
                if (actual != 0.0 && actual < minWidth) {
                    Point2D.Double pt1;
                    if (hxb - lxb > hyb - lyb) {
                        pt1 = new Point2D.Double(lxb - 0.001, lyb - 0.001);
                        Point2D.Double pt2 = new Point2D.Double(lxb - 0.001, hyb + 0.001);
                        Point2D.Double pt3 = new Point2D.Double(hxb + 0.001, lyb - 0.001);
                        Point2D.Double pt4 = new Point2D.Double(hxb + 0.001, hyb + 0.001);
                        if (!this.lookForPoints(pt1, pt2, layer1, cell, true) && !this.lookForPoints(pt3, pt4, layer1, cell, true)) {
                            Poly rebuild = new Poly((lxb + hxb) / 2.0, ((lyb -= minWidth / 2.0) + (hyb += minWidth / 2.0)) / 2.0, hxb - lxb, hyb - lyb);
                            rebuild.setStyle(Poly.Type.FILLED);
                            this.reportError(2, tech, null, cell, minWidth, actual, sizeRule, rebuild, geom1, layer1, -1, null, null, null, -1);
                            return true;
                        }
                    } else {
                        pt1 = new Point2D.Double(lxb - 0.001, lyb - 0.001);
                        Point2D.Double pt2 = new Point2D.Double(hxb + 0.001, lyb - 0.001);
                        Point2D.Double pt3 = new Point2D.Double(lxb - 0.001, hyb + 0.001);
                        Point2D.Double pt4 = new Point2D.Double(hxb + 0.001, hyb + 0.001);
                        if (!this.lookForPoints(pt1, pt2, layer1, cell, true) && !this.lookForPoints(pt3, pt4, layer1, cell, true)) {
                            Poly rebuild = new Poly(((lxb -= minWidth / 2.0) + (hxb += minWidth / 2.0)) / 2.0, (lyb + hyb) / 2.0, hxb - lxb, hyb - lyb);
                            rebuild.setStyle(Poly.Type.FILLED);
                            this.reportError(2, tech, null, cell, minWidth, actual, sizeRule, rebuild, geom1, layer1, -1, null, null, null, -1);
                            return true;
                        }
                    }
                }
            }
            trueBox1 = new Rectangle2D.Double(trueBox1.getMinX(), trueBox1.getMinY(), trueBox1.getWidth(), trueBox1.getHeight());
            trueBox2 = new Rectangle2D.Double(trueBox2.getMinX(), trueBox2.getMinY(), trueBox2.getWidth(), trueBox2.getHeight());
            if (geom1 instanceof NodeInst ? this.cropNodeInst((NodeInst)geom1, globalIndex1, trans1, trueBox1, layer2, net2, geom2, trueBox2) : this.cropArcInst((ArcInst)geom1, layer1, trans1, trueBox1)) {
                return false;
            }
            if (geom2 instanceof NodeInst ? this.cropNodeInst((NodeInst)geom2, globalIndex2, trans2, trueBox2, layer1, net1, geom1, trueBox1) : this.cropArcInst((ArcInst)geom2, layer2, trans2, trueBox2)) {
                return false;
            }
            poly1 = new Poly(trueBox1);
            poly1.setStyle(Poly.Type.FILLED);
            poly2 = new Poly(trueBox2);
            poly2.setStyle(Poly.Type.FILLED);
            double lX1 = trueBox1.getMinX();
            double hX1 = trueBox1.getMaxX();
            double lY1 = trueBox1.getMinY();
            double hY1 = trueBox1.getMaxY();
            double lX2 = trueBox2.getMinX();
            double hX2 = trueBox2.getMaxX();
            double lY2 = trueBox2.getMinY();
            double hY2 = trueBox2.getMaxY();
            if (edge) {
                double pdedge = Math.min(Math.min(Math.min(Math.abs(lX1 - lX2), Math.abs(lX1 - hX2)), Math.min(Math.abs(hX1 - lX2), Math.abs(hX1 - hX2))), Math.min(Math.min(Math.abs(lY1 - lY2), Math.abs(lY1 - hY2)), Math.min(Math.abs(hY1 - lY2), Math.abs(hY1 - hY2))));
                pd = Math.max(pd, pdedge);
            } else {
                pdx = Math.max(lX2 - hX1, lX1 - hX2);
                pdy = Math.max(lY2 - hY1, lY1 - hY2);
                if (pdx == 0.0 && pdy == 0.0) {
                    pd = 1.0;
                } else {
                    pd = Math.max(pdx, pdy);
                    if (pd < dist && pd > 0.0) {
                        pd = poly1.separation(poly2);
                    }
                }
            }
        } else {
            Poly.Type style = poly1.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return false;
            }
            style = poly2.getStyle();
            if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
                return false;
            }
            pd = poly1.intersects(poly2) ? 0.0 : poly1.separation(poly2);
        }
        if (pd >= dist) {
            return false;
        }
        int errorType = 1;
        if (this.activeOnTransistor(poly1, layer1, net1, poly2, layer2, net2, tech, cell, globalIndex)) {
            return false;
        }
        if (tech.sameLayer(layer1, layer2) && maytouch) {
            if (pd <= 0.0) {
                return false;
            }
            Point2D.Double pt1 = new Point2D.Double();
            Point2D.Double pt2 = new Point2D.Double();
            int intervening = this.findInterveningPoints(poly1, poly2, pt1, pt2);
            if (intervening == 0) {
                return false;
            }
            boolean needBoth = true;
            if (intervening == 1) {
                needBoth = false;
            }
            if (this.lookForPoints(pt1, pt2, layer1, cell, needBoth)) {
                return false;
            }
            if (net1 == net2 && intervening == 1) {
                return false;
            }
            errorType = 3;
        }
        String msg = null;
        if (!(this.tinyNodeInst == null || this.tinyNodeInst != geom1 && this.tinyNodeInst != geom2 || this.tinyGeometric != geom1 && this.tinyGeometric != geom2)) {
            msg = this.tinyNodeInst.describe() + " is too small for the " + this.tinyGeometric.describe();
        }
        this.reportError(errorType, tech, msg, cell, dist, pd, rule, origPoly1, geom1, layer1, net1, origPoly2, geom2, layer2, net2);
        return true;
    }

    private void checkTheseGeometrics(Cell cell, int count, Geometric[] geomsToCheck, boolean[] validity) {
        boolean globalIndex = false;
        CheckProto cp = this.getCheckProto(cell);
        for (int i = 0; i < count; ++i) {
            Geometric geomToCheck = geomsToCheck[i];
            boolean errors = false;
            if (geomToCheck instanceof NodeInst) {
                NodeInst ni = (NodeInst)geomToCheck;
                errors = ni.getProto() instanceof Cell ? this.checkThisCellPlease(ni) : this.checkNodeInst(ni, 0);
            } else {
                ArcInst ai = (ArcInst)geomToCheck;
                errors = this.checkArcInst(cp, ai, 0);
            }
            if (validity == null) continue;
            validity[i] = !errors;
        }
    }

    private boolean checkThisCellPlease(NodeInst ni) {
        Cell cell = ni.getParent();
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        int globalIndex = 0;
        AffineTransform upTrans = ni.translateOut();
        AffineTransform rTrans = ni.rotateOut();
        upTrans.preConcatenate(rTrans);
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        Rectangle2D nodeBounds = ni.getBounds();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(nodeBounds.getMinX() - this.worstInteractionDistance, nodeBounds.getMinY() - this.worstInteractionDistance, nodeBounds.getWidth() + this.worstInteractionDistance * 2.0, nodeBounds.getHeight() + this.worstInteractionDistance * 2.0);
        Iterator it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Rectangle2D subNodeBounds;
            Rectangle2D.Double subBounds;
            NodeInst oNi;
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof ArcInst ? this.checkGeomAgainstInstance(netlist, geom, ni) : ((oNi = (NodeInst)geom).getProto() instanceof PrimitiveNode ? this.checkGeomAgainstInstance(netlist, geom, ni) : this.checkCellInstContents(subBounds = new Rectangle2D.Double((subNodeBounds = oNi.getBounds()).getMinX() - this.worstInteractionDistance, subNodeBounds.getMinY() - this.worstInteractionDistance, subNodeBounds.getWidth() + this.worstInteractionDistance * 2.0, subNodeBounds.getHeight() + this.worstInteractionDistance * 2.0), (Cell)ni.getProto(), upTrans, localIndex, oNi, globalIndex)))) continue;
            return true;
        }
        return false;
    }

    private boolean checkGeomAgainstInstance(Netlist netlist, Geometric geom, NodeInst ni) {
        NodeProto np = ni.getProto();
        int globalIndex = 0;
        Cell subCell = geom.getParent();
        boolean baseMulti = false;
        Technology tech = null;
        Poly[] nodeInstPolyList = null;
        AffineTransform trans = DBMath.MATID;
        if (geom instanceof NodeInst) {
            NodeInst oNi = (NodeInst)geom;
            tech = oNi.getProto().getTechnology();
            trans = oNi.rotateOut();
            nodeInstPolyList = tech.getShapeOfNode(oNi, null, true, this.ignoreCenterCuts);
            this.convertPseudoLayers(oNi, nodeInstPolyList);
            baseMulti = this.isMultiCut(oNi);
        } else {
            ArcInst oAi = (ArcInst)geom;
            tech = oAi.getProto().getTechnology();
            nodeInstPolyList = tech.getShapeOfArc(oAi);
        }
        if (nodeInstPolyList == null) {
            return false;
        }
        int tot = nodeInstPolyList.length;
        CheckInst ci = (CheckInst)this.checkInsts.get(ni);
        if (ci == null) {
            return false;
        }
        int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
        for (int j = 0; j < tot; ++j) {
            int net;
            double bound;
            Poly poly = nodeInstPolyList[j];
            Layer polyLayer = poly.getLayer();
            if (polyLayer == null || (bound = DRC.getMaxSurround(polyLayer)) < 0.0) continue;
            if (geom instanceof NodeInst) {
                net = this.getDRCNetNumber(netlist, poly.getPort(), (NodeInst)geom, globalIndex);
            } else {
                ArcInst oAi = (ArcInst)geom;
                JNetwork jNet = netlist.getNetwork(oAi, 0);
                Integer[] netNumbers = (Integer[])this.networkLists.get(jNet);
                net = netNumbers[globalIndex];
            }
            double minSize = poly.getMinSize();
            Rectangle2D polyBounds = poly.getBounds2D();
            Rectangle2D.Double subBounds = new Rectangle2D.Double(polyBounds.getMinX() - bound, polyBounds.getMinY() - bound, polyBounds.getWidth() + bound * 2.0, polyBounds.getHeight() + bound * 2.0);
            AffineTransform tempTrans = ni.rotateIn();
            AffineTransform tTransI = ni.translateIn();
            tempTrans.preConcatenate(tTransI);
            DBMath.transformRect(subBounds, tempTrans);
            AffineTransform subTrans = ni.translateOut();
            AffineTransform rTrans = ni.rotateOut();
            subTrans.preConcatenate(rTrans);
            if (!this.badBoxInArea(poly, polyLayer, tech, net, geom, trans, globalIndex, subBounds, (Cell)np, localIndex, subCell, globalIndex, subTrans, minSize, baseMulti, false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkInteraction(NodeInst ni1, NodeInst ni2) {
        CheckProto cp = this.getCheckProto((Cell)ni1.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        cp = this.getCheckProto((Cell)ni2.getProto());
        if (cp.cellParameterized) {
            return false;
        }
        if (ni1.getNodeIndex() < ni2.getNodeIndex()) {
            NodeInst swapni = ni1;
            ni1 = ni2;
            ni2 = swapni;
        } else if (ni1 == ni2) {
            int node1Orientation = ni1.getAngle();
            if (ni1.isMirroredAboutXAxis()) {
                node1Orientation += 3600;
            }
            if (ni1.isMirroredAboutYAxis()) {
                node1Orientation += 7200;
            }
            int node2Orientation = ni2.getAngle();
            if (ni2.isMirroredAboutXAxis()) {
                node2Orientation += 3600;
            }
            if (ni2.isMirroredAboutYAxis()) {
                node2Orientation += 7200;
            }
            if (node1Orientation < node2Orientation) {
                NodeInst swapNI = ni1;
                ni1 = ni2;
                ni2 = swapNI;
            }
        }
        InstanceInter dii = new InstanceInter();
        dii.cell1 = (Cell)ni1.getProto();
        dii.rot1 = ni1.getAngle();
        dii.mirrorX1 = ni1.isMirroredAboutXAxis();
        dii.mirrorY1 = ni1.isMirroredAboutYAxis();
        dii.cell2 = (Cell)ni2.getProto();
        dii.rot2 = ni2.getAngle();
        dii.mirrorX2 = ni2.isMirroredAboutXAxis();
        dii.mirrorY2 = ni2.isMirroredAboutYAxis();
        dii.dx = ni2.getAnchorCenterX() - ni1.getAnchorCenterX();
        dii.dy = ni2.getAnchorCenterY() - ni1.getAnchorCenterY();
        if (this.findInteraction(dii)) {
            return true;
        }
        this.instanceInteractionList.add(dii);
        return false;
    }

    private void clearInstanceCache() {
        this.instanceInteractionList.clear();
    }

    private boolean findInteraction(InstanceInter dii) {
        Iterator it = this.instanceInteractionList.iterator();
        while (it.hasNext()) {
            InstanceInter thisII = (InstanceInter)it.next();
            if (thisII.cell1 != dii.cell1 || thisII.cell2 != dii.cell2 || thisII.rot1 != dii.rot1 || thisII.rot2 != dii.rot2 || thisII.mirrorX1 != dii.mirrorX1 || thisII.mirrorX2 != dii.mirrorX2 || thisII.mirrorY1 != dii.mirrorY1 || thisII.mirrorY2 != dii.mirrorY2 || thisII.dx != dii.dx || thisII.dy != dii.dy) continue;
            return true;
        }
        return false;
    }

    private CheckProto checkEnumerateProtos(Cell cell, Netlist netlist) {
        CheckProto cp = this.getCheckProto(cell);
        if (cp != null) {
            return cp;
        }
        cp = new CheckProto();
        cp.instanceCount = 0;
        cp.timeStamp = 0;
        cp.hierInstanceCount = 0;
        cp.totalPerCell = 0;
        cp.cellChecked = false;
        cp.cellParameterized = false;
        cp.treeParameterized = false;
        cp.netlist = netlist;
        Iterator vIt = cell.getVariables();
        while (vIt.hasNext()) {
            Variable var = (Variable)vIt.next();
            if (!var.getTextDescriptor().isParam()) continue;
            cp.cellParameterized = true;
            cp.treeParameterized = true;
            break;
        }
        this.checkProtos.put(cell, cp);
        Iterator nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = (NodeInst)nIt.next();
            if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
            Cell subCell = (Cell)ni.getProto();
            CheckInst ci = new CheckInst();
            this.checkInsts.put(ni, ci);
            CheckProto subCP = this.checkEnumerateProtos(subCell, netlist.getNetlist(ni));
            if (!subCP.treeParameterized) continue;
            cp.treeParameterized = true;
        }
        return cp;
    }

    private final CheckProto getCheckProto(Cell cell) {
        return (CheckProto)this.checkProtos.get(cell);
    }

    private void checkEnumerateInstances(Cell cell) {
        NodeProto np;
        NodeInst ni;
        ++this.checkTimeStamp;
        ArrayList<CheckProto> subCheckProtos = new ArrayList<CheckProto>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            CheckProto cp = this.getCheckProto((Cell)np);
            if (cp.timeStamp != this.checkTimeStamp) {
                cp.timeStamp = this.checkTimeStamp;
                cp.instanceCount = 0;
                cp.nodesInCell = new ArrayList();
                subCheckProtos.add(cp);
            }
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            ++cp.instanceCount;
            ci.localIndex = ci.localIndex;
            cp.nodesInCell.add(ci);
        }
        it = subCheckProtos.iterator();
        while (it.hasNext()) {
            CheckProto cp = (CheckProto)it.next();
            cp.hierInstanceCount += cp.instanceCount;
            Iterator nIt = cp.nodesInCell.iterator();
            while (nIt.hasNext()) {
                CheckInst ci = (CheckInst)nIt.next();
                ci.multiplier = cp.instanceCount;
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            this.checkEnumerateInstances((Cell)np);
        }
    }

    private void checkEnumerateNetworks(Cell cell, CheckProto cp, int globalIndex, HashMap enumeratedNets) {
        Iterator nIt = cp.netlist.getNetworks();
        while (nIt.hasNext()) {
            JNetwork net = (JNetwork)nIt.next();
            Integer netNumber = (Integer)enumeratedNets.get(net);
            Integer[] netNumbers = (Integer[])this.networkLists.get(net);
            netNumbers[globalIndex] = netNumber;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || ni.isIconOfParent()) continue;
            CheckInst ci = (CheckInst)this.checkInsts.get(ni);
            int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
            Cell subCell = (Cell)np;
            CheckProto subCP = this.getCheckProto(subCell);
            HashMap<JNetwork, Integer> subEnumeratedNets = new HashMap<JNetwork, Integer>();
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                Export subPP = (Export)pi.getPortProto();
                JNetwork net = cp.netlist.getNetwork(ni, subPP, 0);
                if (net == null) continue;
                Integer netNumber = (Integer)enumeratedNets.get(net);
                JNetwork subNet = subCP.netlist.getNetwork(subPP, 0);
                subEnumeratedNets.put(subNet, netNumber);
            }
            Iterator nIt2 = subCP.netlist.getNetworks();
            while (nIt2.hasNext()) {
                JNetwork net = (JNetwork)nIt2.next();
                if (subEnumeratedNets.get(net) != null) continue;
                subEnumeratedNets.put(net, new Integer(this.checkNetNumber++));
            }
            this.checkEnumerateNetworks(subCell, subCP, localIndex, subEnumeratedNets);
        }
    }

    private boolean checkMinWidth(Geometric geom, Layer layer, Poly poly, Technology tech) {
        Cell cell = geom.getParent();
        DRC.Rule minWidthRule = DRC.getMinWidth(layer);
        if (minWidthRule == null) {
            return false;
        }
        double minWidth = minWidthRule.distance;
        Rectangle2D bounds = poly.getBox();
        if (bounds != null) {
            Point2D.Double right3;
            Point2D.Double right2;
            Point2D.Double right1;
            Point2D.Double left3;
            Point2D.Double left2;
            Point2D.Double left1;
            if (bounds.getWidth() >= minWidth && bounds.getHeight() >= minWidth) {
                return false;
            }
            double actual = 0.0;
            if (bounds.getWidth() < minWidth) {
                actual = bounds.getWidth();
                left1 = new Point2D.Double(bounds.getMinX() - 0.001, bounds.getMinY());
                left2 = new Point2D.Double(bounds.getMinX() - 0.001, bounds.getMaxY());
                left3 = new Point2D.Double(bounds.getMinX() - 0.001, bounds.getCenterY());
                right1 = new Point2D.Double(bounds.getMaxX() + 0.001, bounds.getMinY());
                right2 = new Point2D.Double(bounds.getMaxX() + 0.001, bounds.getMaxY());
                right3 = new Point2D.Double(bounds.getMaxX() + 0.001, bounds.getCenterY());
            } else {
                actual = bounds.getHeight();
                left1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY() - 0.001);
                left2 = new Point2D.Double(bounds.getMaxX(), bounds.getMinY() - 0.001);
                left3 = new Point2D.Double(bounds.getCenterX(), bounds.getMinY() - 0.001);
                right1 = new Point2D.Double(bounds.getMinX(), bounds.getMaxY() + 0.001);
                right2 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY() + 0.001);
                right3 = new Point2D.Double(bounds.getCenterX(), bounds.getMaxY() + 0.001);
            }
            boolean[] pointsFound = new boolean[3];
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.getMinX() - 0.001, bounds.getMinY() - 0.001, bounds.getWidth() + 0.002, bounds.getHeight() + 0.002);
            if (this.lookForLayer(cell, layer, DBMath.MATID, newBounds, left1, left2, left3, pointsFound)) {
                return false;
            }
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            if (this.lookForLayer(cell, layer, DBMath.MATID, newBounds, right1, right2, right3, pointsFound)) {
                return false;
            }
            this.reportError(2, tech, null, cell, minWidth, actual, minWidthRule.rule, poly, geom, layer, -1, null, null, null, -1);
            return true;
        }
        Poly.Type style = poly.getStyle();
        if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
            return false;
        }
        bounds = poly.getBounds2D();
        double actual = Math.min(bounds.getWidth(), bounds.getHeight());
        if (actual < minWidth) {
            this.reportError(2, tech, null, cell, minWidth, actual, minWidthRule.rule, poly, geom, layer, -1, null, null, null, -1);
            return true;
        }
        Point2D[] points = poly.getPoints();
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            Point2D to;
            Point2D from = i == 0 ? points[count - 1] : points[i - 1];
            if (from.equals(to = points[i])) continue;
            double ang = DBMath.figureAngleRadians(from, to);
            Point2D.Double center = new Point2D.Double((from.getX() + to.getX()) / 2.0, (from.getY() + to.getY()) / 2.0);
            double perpang = ang + 1.5707963267948966;
            for (int j = 0; j < count; ++j) {
                double fdy;
                double fdx;
                Point2D inter;
                double rOAng;
                Point2D oTo;
                Point2D oFrom;
                if (j == i || (oFrom = j == 0 ? points[count - 1] : points[j - 1]).equals(oTo = points[j])) continue;
                double oAng = DBMath.figureAngleRadians(oFrom, oTo);
                for (double rAng = ang; rAng > Math.PI; rAng -= Math.PI) {
                }
                for (rOAng = oAng; rOAng > Math.PI; rOAng -= Math.PI) {
                }
                if (DBMath.doublesEqual(oAng, rOAng) && (DBMath.isOnLine(from, to, oFrom) || DBMath.isOnLine(from, to, oTo) || DBMath.isOnLine(oFrom, oTo, from) || DBMath.isOnLine(oFrom, oTo, to)) || (inter = DBMath.intersectRadians(center, perpang, oFrom, oAng)) == null || inter.getX() < Math.min(oFrom.getX(), oTo.getX()) || inter.getX() > Math.max(oFrom.getX(), oTo.getX()) || inter.getY() < Math.min(oFrom.getY(), oTo.getY()) || inter.getY() > Math.max(oFrom.getY(), oTo.getY()) || !((actual = DBMath.smooth(Math.sqrt((fdx = ((Point2D)center).getX() - inter.getX()) * fdx + (fdy = ((Point2D)center).getY() - inter.getY()) * fdy))) < minWidth)) continue;
                if (poly.isInside(new Point2D.Double((((Point2D)center).getX() + inter.getX()) / 2.0, (((Point2D)center).getY() + inter.getY()) / 2.0))) {
                    this.reportError(2, tech, null, cell, minWidth, actual, minWidthRule.rule, poly, geom, layer, -1, null, null, null, -1);
                } else {
                    this.reportError(3, tech, null, cell, minWidth, actual, minWidthRule.rule, poly, geom, layer, -1, poly, geom, layer, -1);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isMultiCut(NodeInst ni) {
        NodeProto np = ni.getProto();
        if (np instanceof Cell) {
            return false;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        Technology tech = pnp.getTechnology();
        if (pnp.getSpecialType() != 3) {
            return false;
        }
        double[] specialValues = pnp.getSpecialValues();
        Technology.MultiCutData mcd = new Technology.MultiCutData(ni, specialValues);
        return mcd.numCuts() > 1;
    }

    private boolean objectsTouch(Geometric geom1, Geometric geom2) {
        if (geom1 instanceof NodeInst) {
            if (geom2 instanceof NodeInst) {
                return false;
            }
            Geometric temp = geom1;
            geom1 = geom2;
            geom2 = temp;
        }
        if (!(geom2 instanceof NodeInst)) {
            return false;
        }
        NodeInst ni = (NodeInst)geom2;
        ArcInst ai = (ArcInst)geom1;
        for (int i = 0; i < 2; ++i) {
            Connection con = ai.getConnection(i);
            if (con.getPortInst().getNodeInst() != ni) continue;
            return true;
        }
        return false;
    }

    private int findInterveningPoints(Poly poly1, Poly poly2, Point2D pt1, Point2D pt2) {
        Rectangle2D isBox1 = poly1.getBox();
        Rectangle2D isBox2 = poly2.getBox();
        if (isBox1 != null && isBox2 != null) {
            if (isBox1.getMinX() > isBox2.getMaxX() || isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() <= isBox2.getMaxY() && isBox2.getMinY() <= isBox1.getMaxY()) {
                    double yf1 = Math.max(isBox1.getMinY(), isBox2.getMinY());
                    double yf2 = Math.min(isBox1.getMaxY(), isBox2.getMaxY());
                    if (isBox1.getMinX() > isBox2.getMaxX()) {
                        double x = (isBox1.getMinX() + isBox2.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    } else {
                        double x = (isBox2.getMinX() + isBox1.getMaxX()) / 2.0;
                        pt1.setLocation(x, yf1);
                        pt2.setLocation(x, yf2);
                    }
                    return 2;
                }
            } else if (isBox1.getMinY() > isBox2.getMaxY() || isBox2.getMinY() > isBox1.getMaxY()) {
                if (isBox1.getMinX() <= isBox2.getMaxX() && isBox2.getMinX() <= isBox1.getMaxX()) {
                    double xf1 = Math.max(isBox1.getMinX(), isBox2.getMinX());
                    double xf2 = Math.min(isBox1.getMaxX(), isBox2.getMaxX());
                    if (isBox1.getMinY() > isBox2.getMaxY()) {
                        double y = (isBox1.getMinY() + isBox2.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    } else {
                        double y = (isBox2.getMinY() + isBox1.getMaxY()) / 2.0;
                        pt1.setLocation(xf1, y);
                        pt2.setLocation(xf2, y);
                    }
                    return 2;
                }
            } else if (isBox1.getMinX() == isBox2.getMaxX() || isBox2.getMinX() == isBox1.getMaxX() || isBox1.getMinY() == isBox2.getMaxY() || isBox2.getMinY() == isBox2.getMaxY()) {
                double xc = isBox2.getMinX();
                if (isBox1.getMinX() == isBox2.getMaxX()) {
                    xc = isBox1.getMinX();
                }
                double yc = isBox2.getMinY();
                if (isBox1.getMinY() == isBox2.getMaxY()) {
                    yc = isBox1.getMinY();
                }
                double xPlus = xc + 0.001;
                double yPlus = yc + 0.001;
                pt1.setLocation(xPlus, yPlus);
                pt2.setLocation(xPlus, yPlus);
                if ((xPlus < isBox1.getMinX() || xPlus > isBox1.getMaxX() || yPlus < isBox1.getMinY() || yPlus > isBox1.getMaxY()) && (xPlus < isBox2.getMinX() || xPlus > isBox2.getMaxX() || yPlus < isBox2.getMinY() || yPlus > isBox2.getMaxY())) {
                    return 1;
                }
                pt1.setLocation(xc + 0.001, yc - 0.001);
                pt2.setLocation(xc - 0.001, yc + 0.001);
                return 1;
            }
            if (isBox1.getMinX() > isBox2.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMaxY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMinX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMaxX(), isBox2.getMinY());
                    return 1;
                }
            }
            if (isBox2.getMinX() > isBox1.getMaxX()) {
                if (isBox1.getMinY() > isBox2.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMaxY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMinY());
                    return 1;
                }
                if (isBox2.getMinY() > isBox1.getMaxY()) {
                    pt1.setLocation(isBox1.getMaxX(), isBox1.getMinY());
                    pt2.setLocation(isBox2.getMinX(), isBox2.getMaxY());
                    return 1;
                }
            }
        }
        isBox1 = poly1.getBounds2D();
        isBox2 = poly2.getBounds2D();
        pt1.setLocation((isBox1.getMinX() + isBox1.getMaxX()) / 2.0, (isBox2.getMinY() + isBox2.getMaxY()) / 2.0);
        pt2.setLocation((isBox2.getMinX() + isBox2.getMaxX()) / 2.0, (isBox1.getMinY() + isBox1.getMaxY()) / 2.0);
        return 1;
    }

    private boolean lookForPoints(Point2D pt1, Point2D pt2, Layer layer, Cell cell, boolean needBoth) {
        Point2D.Double pt3 = new Point2D.Double((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0);
        double flx = Math.min(pt1.getX(), pt2.getX());
        double fhx = Math.max(pt1.getX(), pt2.getX());
        double fly = Math.min(pt1.getY(), pt2.getY());
        double fhy = Math.max(pt1.getY(), pt2.getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(flx, fly, fhx - flx, fhy - fly);
        boolean[] pointsFound = new boolean[3];
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        boolean allFound = this.lookForLayer(cell, layer, DBMath.MATID, bounds, pt1, pt2, pt3, pointsFound);
        return needBoth ? allFound : pointsFound[0] || pointsFound[1];
    }

    private boolean lookForLayer(Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound) {
        Iterator it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric g = (Geometric)it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (ni.getProto() instanceof Cell) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    Rectangle2D.Double newBounds = new Rectangle2D.Double();
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut();
                    AffineTransform rot = ni.rotateOut();
                    trans.preConcatenate(rot);
                    trans.preConcatenate(moreTrans);
                    if (!this.lookForLayer((Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(bound);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (!poly.isInside(pt3)) continue;
                    pointsFound[2] = true;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                Poly[] layerLookPolyList = tech.getShapeOfArc(ai);
                int tot = layerLookPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = layerLookPolyList[i];
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (!poly.isInside(pt3)) continue;
                    pointsFound[2] = true;
                }
            }
            if (!pointsFound[0] || !pointsFound[1] || !pointsFound[2]) continue;
            return true;
        }
        return false;
    }

    private boolean activeOnTransistor(Poly poly1, Layer layer1, int net1, Poly poly2, Layer layer2, int net2, Technology tech, Cell cell, int globalIndex) {
        if (net1 == net2) {
            return false;
        }
        Layer.Function fun = layer1.getFunction();
        int funExtras = layer1.getFunctionExtras();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        fun = layer2.getFunction();
        if (!(fun.isDiff() || fun.isContact() && (funExtras & 0x10000) != 0)) {
            return false;
        }
        Rectangle2D bounds1 = poly1.getBounds2D();
        Rectangle2D bounds2 = poly2.getBounds2D();
        Rectangle2D.union(bounds1, bounds2, bounds1);
        return this.activeOnTransistorRecurse(bounds1, net1, net2, cell, globalIndex, DBMath.MATID);
    }

    private boolean activeOnTransistorRecurse(Rectangle2D bounds, int net1, int net2, Cell cell, int globalIndex, AffineTransform trans) {
        Netlist netlist = this.getCheckProto((Cell)cell).netlist;
        Iterator sIt = cell.searchIterator(bounds);
        while (sIt.hasNext()) {
            Geometric g = (Geometric)sIt.next();
            if (!(g instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)g;
            NodeProto np = ni.getProto();
            if (np instanceof Cell) {
                AffineTransform rTransI = ni.rotateIn();
                AffineTransform tTransI = ni.translateIn();
                rTransI.preConcatenate(tTransI);
                Rectangle2D.Double subBounds = new Rectangle2D.Double();
                ((Rectangle2D)subBounds).setRect(bounds);
                DBMath.transformRect(subBounds, rTransI);
                CheckInst ci = (CheckInst)this.checkInsts.get(ni);
                int localIndex = globalIndex * ci.multiplier + ci.localIndex + ci.offset;
                boolean ret = this.activeOnTransistorRecurse(subBounds, net1, net2, (Cell)np, localIndex, trans);
                if (!ret) continue;
                return true;
            }
            if (!ni.isFET()) continue;
            Rectangle2D nodeBounds = ni.getBounds();
            double cX = nodeBounds.getCenterX();
            double cY = nodeBounds.getCenterY();
            if (cX < bounds.getMinX() || cX > bounds.getMaxX() || cY < bounds.getMinY() || cY > bounds.getMaxY()) continue;
            PortProto badport = np.getPort(0);
            JNetwork badNet = netlist.getNetwork(ni, badport, 0);
            boolean on1 = false;
            boolean on2 = false;
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                Integer[] netNumbers;
                int net;
                PortInst pi = (PortInst)it.next();
                JNetwork piNet = netlist.getNetwork(pi);
                if (piNet == badNet || (net = (netNumbers = (Integer[])this.networkLists.get(piNet))[globalIndex].intValue()) < 0) continue;
                if (net == net1) {
                    on1 = true;
                }
                if (net != net2) continue;
                on2 = true;
            }
            if (!on1 || !on2) continue;
            return true;
        }
        return false;
    }

    private int cropBox(Rectangle2D bounds, Rectangle2D PUBox) {
        double yoverlap;
        double bX = PUBox.getMinX();
        double uX = PUBox.getMaxX();
        double bY = PUBox.getMinY();
        double uY = PUBox.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (bX >= hX || bY >= hY || uX <= lX || uY <= lY) {
            return 0;
        }
        if (bX <= lX && uX >= hX && bY <= lY && uY >= hY) {
            return 1;
        }
        double xoverlap = Math.min(hX, uX) - Math.max(lX, bX);
        if (xoverlap > (yoverlap = Math.min(hY, uY) - Math.max(lY, bY))) {
            if (bX <= lX && uX >= hX) {
                if (uY >= hY) {
                    hY = bY;
                }
                if (bY <= lY) {
                    lY = uY;
                }
                if (hY <= lY) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        } else if (bY <= lY && uY >= hY) {
            if (uX >= hX) {
                hX = bX;
            }
            if (bX <= lX) {
                lX = uX;
            }
            if (hX <= lX) {
                return 1;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            return 0;
        }
        return -1;
    }

    private int halfCropBox(Rectangle2D bounds, Rectangle2D limit) {
        double bX = limit.getMinX();
        double uX = limit.getMaxX();
        double bY = limit.getMinY();
        double uY = limit.getMaxY();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        if (bX >= hX || bY >= hY || uX <= lX || uY <= lY) {
            return 0;
        }
        if (bX <= lX && uX >= hX && bY <= lY && uY >= hY) {
            double lxe = lX - bX;
            double hxe = uX - hX;
            double lye = lY - bY;
            double hye = uY - hY;
            double biggestExt = Math.max(Math.max(lxe, hxe), Math.max(lye, hye));
            if (biggestExt == 0.0) {
                return 1;
            }
            if (lxe == biggestExt) {
                if ((lX = (lX + uX) / 2.0) >= hX) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (hxe == biggestExt) {
                if ((hX = (hX + bX) / 2.0) <= lX) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (lye == biggestExt) {
                if ((lY = (lY + uY) / 2.0) >= hY) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
            if (hye == biggestExt) {
                if ((hY = (hY + bY) / 2.0) <= lY) {
                    return 1;
                }
                bounds.setRect(lX, lY, hX - lX, hY - lY);
                return 0;
            }
        }
        boolean crops = false;
        if (bX <= lX && uX >= hX) {
            if (uY >= hY) {
                hY = (hY + bY) / 2.0;
            }
            if (bY <= lY) {
                lY = (lY + uY) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (bY <= lY && uY >= hY) {
            if (uX >= hX) {
                hX = (hX + bX) / 2.0;
            }
            if (bX <= lX) {
                lX = (lX + uX) / 2.0;
            }
            bounds.setRect(lX, lY, hX - lX, hY - lY);
            crops = true;
        }
        if (!crops) {
            return -1;
        }
        return 0;
    }

    private boolean cropNodeInst(NodeInst ni, int globalIndex, AffineTransform trans, Rectangle2D nBound, Layer nLayer, int nNet, Geometric nGeom, Rectangle2D bound) {
        Technology tech = ni.getProto().getTechnology();
        Poly[] cropNodePolyList = tech.getShapeOfNode(ni, null, true, this.ignoreCenterCuts);
        this.convertPseudoLayers(ni, cropNodePolyList);
        int tot = cropNodePolyList.length;
        if (tot < 0) {
            return false;
        }
        for (int j = 0; j < tot; ++j) {
            cropNodePolyList[j].transform(trans);
        }
        boolean isConnected = false;
        Netlist netlist = this.getCheckProto((Cell)ni.getParent()).netlist;
        for (int j = 0; j < tot; ++j) {
            int net;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer) || nNet >= 0 && (poly.getPort() == null || (net = this.getDRCNetNumber(netlist, poly.getPort(), ni, globalIndex)) >= 0 && net != nNet)) continue;
            isConnected = true;
            break;
        }
        if (!isConnected) {
            return false;
        }
        boolean allgone = false;
        for (int j = 0; j < tot; ++j) {
            Rectangle2D polyBox;
            Poly poly = cropNodePolyList[j];
            if (!tech.sameLayer(poly.getLayer(), nLayer) || (polyBox = poly.getBox()) == null) continue;
            int temp = this.cropBox(bound, polyBox);
            if (temp > 0) {
                allgone = true;
                break;
            }
            if (temp >= 0) continue;
            this.tinyNodeInst = ni;
            this.tinyGeometric = nGeom;
        }
        return allgone;
    }

    private boolean cropArcInst(ArcInst ai, Layer lay, AffineTransform inTrans, Rectangle2D bounds) {
        for (int i = 0; i < 2; ++i) {
            Connection con = ai.getConnection(i);
            PortInst pi = con.getPortInst();
            NodeInst ni = pi.getNodeInst();
            NodeProto np = ni.getProto();
            PortProto pp = pi.getPortProto();
            AffineTransform trans = ni.rotateOut();
            trans.concatenate(inTrans);
            while (np instanceof Cell) {
                AffineTransform xTrans = ni.translateOut();
                trans.preConcatenate(xTrans);
                PortInst subPi = ((Export)pp).getOriginalPort();
                ni = subPi.getNodeInst();
                np = ni.getProto();
                pp = subPi.getPortProto();
                AffineTransform rTrans = ni.rotateOut();
                trans.preConcatenate(rTrans);
            }
            Technology tech = np.getTechnology();
            Poly[] cropArcPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts);
            int tot = cropArcPolyList.length;
            for (int j = 0; j < tot; ++j) {
                Poly poly = cropArcPolyList[j];
                if (!tech.sameLayer(poly.getLayer(), lay)) continue;
                poly.transform(trans);
                Rectangle2D polyBox = poly.getBox();
                if (polyBox == null) continue;
                int temp = this.halfCropBox(bounds, polyBox);
                if (temp > 0) {
                    return true;
                }
                if (temp >= 0) continue;
                this.tinyNodeInst = ni;
                this.tinyGeometric = ai;
            }
        }
        return false;
    }

    private void cropActiveArc(ArcInst ai, Poly[] pList) {
        int tot = pList.length;
        int diffPoly = -1;
        for (int j = 0; j < tot; ++j) {
            Layer.Function fun;
            Poly poly = pList[j];
            Layer layer = poly.getLayer();
            if (layer == null || !(fun = layer.getFunction()).isDiff()) continue;
            diffPoly = j;
            break;
        }
        if (diffPoly < 0) {
            return;
        }
        Poly poly = pList[diffPoly];
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        boolean cropped = false;
        boolean halved = false;
        for (int i = 0; i < 2; ++i) {
            Connection con = ai.getConnection(i);
            PortInst pi = con.getPortInst();
            NodeInst ni = pi.getNodeInst();
            if (!ni.isFET()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] activeCropPolyList = tech.getShapeOfNode(ni, null, false, this.ignoreCenterCuts);
            int nTot = activeCropPolyList.length;
            for (int k = 0; k < nTot; ++k) {
                Poly nPoly = activeCropPolyList[k];
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = halved ? this.cropBox(polyBounds, nPolyBounds) : this.halfCropBox(polyBounds, nPolyBounds);
                if (result == 1) {
                    poly.setLayer(null);
                    return;
                }
                cropped = true;
                halved = true;
            }
        }
        if (cropped) {
            Poly.Type style = poly.getStyle();
            Layer layer = poly.getLayer();
            poly = new Poly(polyBounds);
            poly.setStyle(style);
            poly.setLayer(layer);
            pList[diffPoly] = poly;
        }
    }

    private void convertPseudoLayers(NodeInst ni, Poly[] pList) {
        if (ni.getProto().getFunction() != NodeProto.Function.PIN) {
            return;
        }
        if (ni.getNumConnections() != 0) {
            return;
        }
        if (ni.getNumExports() == 0) {
            return;
        }
        int tot = pList.length;
        for (int i = 0; i < tot; ++i) {
            Poly poly = pList[i];
            Layer layer = poly.getLayer();
            if (layer == null) continue;
            poly.setLayer(layer.getNonPseudoLayer());
        }
    }

    private void cacheValidLayers(Technology tech) {
        Layer layer;
        int i;
        Object[] layers;
        if (tech == null) {
            return;
        }
        if (this.layersValidTech == tech) {
            return;
        }
        this.layersValidTech = tech;
        int numLayers = tech.getNumLayers();
        this.layersValid = new boolean[numLayers];
        for (int i2 = 0; i2 < numLayers; ++i2) {
            this.layersValid[i2] = false;
        }
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np.isNotUsed()) continue;
            layers = np.getLayers();
            for (i = 0; i < layers.length; ++i) {
                layer = ((Technology.NodeLayer)layers[i]).getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
        it = tech.getArcs();
        while (it.hasNext()) {
            PrimitiveArc ap = (PrimitiveArc)it.next();
            if (ap.isNotUsed()) continue;
            layers = ap.getLayers();
            for (i = 0; i < layers.length; ++i) {
                layer = ((Technology.ArcLayer)layers[i]).getLayer();
                this.layersValid[layer.getIndex()] = true;
            }
        }
    }

    private DRC.Rule getAdjustedMinDist(Technology tech, Layer layer1, double size1, Layer layer2, double size2, boolean con, boolean multi) {
        if (!con && layer1 == layer2) {
            Layer.Function fun = layer1.getFunction();
            if (!con && fun.isSubstrate()) {
                con = true;
            }
        }
        double wideLimit = DRC.getWideLimit(tech);
        boolean wide = false;
        if (size1 > wideLimit || size2 > wideLimit) {
            wide = true;
        }
        DRC.Rule rule = DRC.getSpacingRule(layer1, layer2, con, wide, multi);
        return rule;
    }

    private int getDRCNetNumber(Netlist netlist, PortProto pp, NodeInst ni, int globalIndex) {
        if (pp == null) {
            return -1;
        }
        JNetwork net = netlist.getNetwork(ni, pp, 0);
        Integer[] nets = (Integer[])this.networkLists.get(net);
        if (nets == null) {
            return -1;
        }
        return nets[globalIndex];
    }

    private void buildLayerInteractions(Technology tech) {
        Object[] layers;
        if (this.layerInterTech == tech) {
            return;
        }
        this.layerInterTech = tech;
        int numLayers = tech.getNumLayers();
        this.layersInterNodes = new HashMap();
        Iterator it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            boolean[] layersInNode = new boolean[numLayers];
            for (int i = 0; i < numLayers; ++i) {
                layersInNode[i] = false;
            }
            layers = np.getLayers();
            Technology.NodeLayer[] eLayers = np.getElectricalLayers();
            if (eLayers != null) {
                layers = eLayers;
            }
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = ((Technology.NodeLayer)layers[i]).getLayer();
                Iterator lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = (Layer)lIt.next();
                    if (!DRC.isAnyRule(layer, oLayer)) continue;
                    layersInNode[oLayer.getIndex()] = true;
                }
            }
            this.layersInterNodes.put(np, layersInNode);
        }
        this.layersInterArcs = new HashMap();
        it = tech.getArcs();
        while (it.hasNext()) {
            PrimitiveArc ap = (PrimitiveArc)it.next();
            boolean[] layersInArc = new boolean[numLayers];
            for (int i = 0; i < numLayers; ++i) {
                layersInArc[i] = false;
            }
            layers = ap.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = ((Technology.ArcLayer)layers[i]).getLayer();
                Iterator lIt = tech.getLayers();
                while (lIt.hasNext()) {
                    Layer oLayer = (Layer)lIt.next();
                    if (!DRC.isAnyRule(layer, oLayer)) continue;
                    layersInArc[oLayer.getIndex()] = true;
                }
            }
            this.layersInterArcs.put(ap, layersInArc);
        }
    }

    private boolean checkLayerWithNode(Layer layer, NodeProto np) {
        this.buildLayerInteractions(np.getTechnology());
        boolean[] validLayers = (boolean[])this.layersInterNodes.get(np);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private boolean checkLayerWithArc(Layer layer, ArcProto ap) {
        this.buildLayerInteractions(ap.getTechnology());
        boolean[] validLayers = (boolean[])this.layersInterArcs.get(ap);
        if (validLayers == null) {
            return false;
        }
        return validLayers[layer.getIndex()];
    }

    private void accumulateExclusion(Cell cell, AffineTransform trans) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (np == Generic.tech.drcNode) {
                DRCExclusion dex = new DRCExclusion();
                dex.cell = cell;
                dex.poly = new Poly(ni.getBounds());
                dex.poly.setStyle(Poly.Type.FILLED);
                boolean found = false;
                Iterator dIt = this.exclusionList.iterator();
                while (dIt.hasNext()) {
                    DRCExclusion oDex = (DRCExclusion)dIt.next();
                    if (oDex.cell != cell || !oDex.poly.polySame(dex.poly)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.exclusionList.add(dex);
                continue;
            }
            if (!(np instanceof Cell)) continue;
            AffineTransform tTrans = ni.translateOut();
            AffineTransform rTrans = ni.rotateOut();
            tTrans.preConcatenate(rTrans);
            this.accumulateExclusion((Cell)np, tTrans);
        }
    }

    private void reportError(int errorType, Technology tech, String msg, Cell cell, double limit, double actual, String rule, Poly poly1, Geometric geom1, Layer layer1, int net1, Poly poly2, Geometric geom2, Layer layer2, int net2) {
        if (this.errorLogger == null) {
            return;
        }
        if (this.exclusionList.size() > 0) {
            Rectangle2D polyBounds = poly1.getBounds2D();
            double lX = polyBounds.getMinX();
            double hX = polyBounds.getMaxX();
            double lY = polyBounds.getMinY();
            double hY = polyBounds.getMaxY();
            if (poly2 != null) {
                polyBounds = poly2.getBounds2D();
                if (polyBounds.getMinX() < lX) {
                    lX = polyBounds.getMinX();
                }
                if (polyBounds.getMaxX() > hX) {
                    hX = polyBounds.getMaxX();
                }
                if (polyBounds.getMinY() < lY) {
                    lY = polyBounds.getMinY();
                }
                if (polyBounds.getMaxY() > hY) {
                    hY = polyBounds.getMaxY();
                }
            }
            Iterator it = this.exclusionList.iterator();
            while (it.hasNext()) {
                Poly poly;
                DRCExclusion dex = (DRCExclusion)it.next();
                if (cell != dex.cell || !(poly = dex.poly).isInside(new Point2D.Double(lX, lY)) || !poly.isInside(new Point2D.Double(lX, hY)) || !poly.isInside(new Point2D.Double(hX, lY)) || !poly.isInside(new Point2D.Double(hX, hY))) continue;
                return;
            }
        }
        String errorMessage = "";
        Cell np1 = geom1.getParent();
        int sortLayer = 0;
        if (errorType == 1 || errorType == 3) {
            errorMessage = errorType == 1 ? errorMessage + "Spacing" : errorMessage + "Notch";
            if (layer1 == layer2) {
                errorMessage = errorMessage + " (layer " + layer1.getName() + ")";
            }
            errorMessage = errorMessage + ": ";
            Cell np2 = geom2.getParent();
            if (np1 != np2) {
                errorMessage = errorMessage + "cell " + np1.describe() + ", ";
            } else if (np1 != cell) {
                errorMessage = errorMessage + "[in cell " + np1.describe() + "] ";
            }
            errorMessage = geom1 instanceof NodeInst ? errorMessage + "node " + geom1.describe() : errorMessage + "arc " + geom1.describe();
            if (layer1 != layer2) {
                errorMessage = errorMessage + ", layer " + layer1.getName();
            }
            errorMessage = actual < 0.0 ? errorMessage + " OVERLAPS " : (actual == 0.0 ? errorMessage + " TOUCHES " : errorMessage + " LESS (BY " + TextUtils.formatDouble(limit - actual) + ") THAN " + TextUtils.formatDouble(limit) + " TO ");
            if (np1 != np2) {
                errorMessage = errorMessage + "cell " + np2.describe() + ", ";
            }
            errorMessage = geom2 instanceof NodeInst ? errorMessage + "node " + geom2.describe() : errorMessage + "arc " + geom2.describe();
            if (layer1 != layer2) {
                errorMessage = errorMessage + ", layer " + layer2.getName();
            }
            if (msg != null) {
                errorMessage = errorMessage + "; " + msg;
            }
            sortLayer = Math.min(layer1.getIndex(), layer2.getIndex());
        } else {
            switch (errorType) {
                case 2: {
                    errorMessage = errorMessage + "Minimum width error:";
                    break;
                }
                case 4: {
                    errorMessage = errorMessage + "Minimum size error:";
                    break;
                }
                case 5: {
                    errorMessage = errorMessage + "Invalid layer (" + layer1.getName() + "):";
                    break;
                }
                case 6: {
                    errorMessage = errorMessage + "Layer surround error:";
                }
            }
            errorMessage = errorMessage + " cell " + np1.describe();
            errorMessage = geom1 instanceof NodeInst ? errorMessage + ", node " + geom1.describe() : errorMessage + ", arc " + geom1.describe();
            if (errorType == 2) {
                errorMessage = errorMessage + ", layer " + layer1.getName();
                errorMessage = errorMessage + " LESS THAN " + limit + " WIDE (IS " + actual + ")";
            } else if (errorType == 4) {
                errorMessage = errorMessage + " LESS THAN " + limit + " IN SIZE (IS " + actual + ")";
            } else if (errorType == 6) {
                errorMessage = errorMessage + ", layer %" + layer1.getName();
                errorMessage = errorMessage + " NEEDS SURROUND OF LAYER " + layer2.getName() + " BY " + limit;
            }
            if (layer1 != null) {
                sortLayer = layer1.getIndex();
            }
        }
        if (rule != null && rule.length() > 0) {
            errorMessage = errorMessage + " [rule " + rule + "]";
        }
        ErrorLogger.ErrorLog err = this.errorLogger.logError(errorMessage, cell, sortLayer);
        boolean showGeom = true;
        if (poly1 != null) {
            showGeom = false;
            err.addPoly(poly1, true, cell);
        }
        if (poly2 != null) {
            showGeom = false;
            err.addPoly(poly2, true, cell);
        }
        err.addGeom(geom1, showGeom, cell, null);
        if (geom2 != null) {
            err.addGeom(geom2, showGeom, cell, null);
        }
    }

    private static class SaveDRCDates
    extends Job {
        HashMap goodDRCDate;

        protected SaveDRCDates(HashMap goodDRCDate) {
            super("Remember DRC Successes", DRC.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.goodDRCDate = goodDRCDate;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.goodDRCDate.keySet().iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                Date now = (Date)this.goodDRCDate.get(cell);
                DRC.setLastDRCDate(cell, now);
            }
            return true;
        }
    }

    private static class DRCExclusion {
        Cell cell;
        Poly poly;

        private DRCExclusion() {
        }
    }

    private static class InstanceInter {
        Cell cell1;
        Cell cell2;
        int rot1;
        boolean mirrorX1;
        boolean mirrorY1;
        int rot2;
        boolean mirrorX2;
        boolean mirrorY2;
        double dx;
        double dy;

        private InstanceInter() {
        }
    }

    private static class CheckProto {
        int timeStamp;
        int instanceCount;
        int hierInstanceCount;
        int totalPerCell;
        boolean cellChecked;
        boolean cellParameterized;
        boolean treeParameterized;
        List nodesInCell;
        Netlist netlist;

        private CheckProto() {
        }
    }

    private static class CheckInst {
        int localIndex;
        int multiplier;
        int offset;

        private CheckInst() {
        }
    }
}

