/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clipboard {
    private static Clipboard theClipboard = new Clipboard();
    private static Library clipLib = null;
    private static Cell clipCell;
    private static NodeInst lastDup;
    private static double lastDupX;
    private static double lastDupY;

    private Clipboard() {
    }

    public String toString() {
        return "Clipboard";
    }

    public static void editClipboard() {
        EditWindow wnd = EditWindow.getCurrent();
        wnd.setCell(clipCell, VarContext.globalContext, null);
    }

    public static void copy() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> highlightedGeoms = highlighter.getHighlightedEObjs(true, true);
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (highlightedGeoms.size() == 0 && highlightedText.size() == 0) {
            System.out.println("First select objects to copy");
            return;
        }
        Clipboard.copySelectedText(highlightedText);
        AffineTransform inPlace = new AffineTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n : nodes) {
                Orientation o = n.getOrient().inverse();
                inPlaceOrient = o.concatenate(inPlaceOrient);
            }
            AffineTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(highlightedGeoms, highlightedText, wnd);
            AffineTransform untranslate = AffineTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            AffineTransform retranslate = AffineTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        new CopyObjects(wnd.getCell(), highlightedGeoms, highlightedText, User.getAlignmentToGrid(), inPlace, inPlaceOrient);
    }

    public static void cut() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> highlightedGeoms = highlighter.getHighlightedEObjs(true, true);
        List<DisplayedText> highlightedText = highlighter.getHighlightedText(true);
        if (highlightedGeoms.size() == 0 && highlightedText.size() == 0) {
            System.out.println("First select objects to cut");
            return;
        }
        highlighter.clear();
        highlighter.finished();
        Clipboard.copySelectedText(highlightedText);
        AffineTransform inPlace = new AffineTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n : nodes) {
                Orientation o = n.getOrient().inverse();
                inPlaceOrient = o.concatenate(inPlaceOrient);
            }
            AffineTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(highlightedGeoms, highlightedText, wnd);
            AffineTransform untranslate = AffineTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            AffineTransform retranslate = AffineTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        new CutObjects(wnd.getCell(), highlightedGeoms, highlightedText, User.getAlignmentToGrid(), User.isReconstructArcsToDeletedCells(), inPlace, inPlaceOrient);
    }

    public static void paste() {
        int total;
        int nTotal = 0;
        int aTotal = 0;
        int vTotal = 0;
        if (clipCell != null) {
            nTotal = clipCell.getNumNodes();
            aTotal = clipCell.getNumArcs();
            vTotal = clipCell.getNumVariables();
            if (clipCell.getVar(User.FRAME_LAST_CHANGED_BY) != null) {
                --vTotal;
            }
        }
        if ((total = nTotal + aTotal + vTotal) == 0) {
            System.out.println("Nothing in the clipboard to paste");
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell parent = wnd.getCell();
        List<Geometric> geoms = highlighter.getHighlightedEObjs(true, true);
        if (geoms.size() > 0) {
            if (nTotal == 2 && aTotal == 1) {
                ArcInst ai = clipCell.getArcs().next();
                NodeInst niHead = ai.getHeadPortInst().getNodeInst();
                NodeInst niTail = ai.getTailPortInst().getNodeInst();
                Iterator<NodeInst> nIt = clipCell.getNodes();
                NodeInst ni1 = nIt.next();
                NodeInst ni2 = nIt.next();
                if (ni1 == niHead && ni2 == niTail || ni1 == niTail && ni2 == niHead) {
                    nTotal = 0;
                }
                total = nTotal + aTotal;
            }
            if (total > 1) {
                System.out.println("Can only paste a single object on top of selected objects");
                return;
            }
            for (Geometric geom : geoms) {
                if (geom instanceof NodeInst && nTotal == 1) {
                    NodeInst ni = (NodeInst)geom;
                    new PasteNodeToNode(ni, clipCell.getNodes().next());
                    continue;
                }
                if (!(geom instanceof ArcInst) || aTotal != 1) continue;
                ArcInst ai = (ArcInst)geom;
                new PasteArcToArc(ai, clipCell.getArcs().next());
            }
            return;
        }
        ArrayList<Geometric> geomList = new ArrayList<Geometric>();
        Iterator<Geometric> it = clipCell.getNodes();
        while (it.hasNext()) {
            geomList.add(it.next());
        }
        it = clipCell.getArcs();
        while (it.hasNext()) {
            geomList.add(it.next());
        }
        ArrayList<DisplayedText> textList = new ArrayList<DisplayedText>();
        Iterator<Variable> it2 = clipCell.getVariables();
        while (it2.hasNext()) {
            Variable var = it2.next();
            if (!var.isDisplay()) continue;
            textList.add(new DisplayedText(clipCell, var.getKey()));
        }
        if (geomList.size() == 0 && textList.size() == 0) {
            return;
        }
        AffineTransform inPlace = new AffineTransform();
        Orientation inPlaceOrient = Orientation.IDENT;
        if (wnd.isInPlaceEdit()) {
            List<NodeInst> nodes = wnd.getInPlaceEditNodePath();
            for (NodeInst n : nodes) {
                Orientation o = n.getOrient();
                inPlaceOrient = inPlaceOrient.concatenate(o);
            }
            AffineTransform justRotation = inPlaceOrient.pureRotate();
            Rectangle2D pasteBounds = Clipboard.getPasteBounds(geomList, textList, wnd);
            AffineTransform untranslate = AffineTransform.getTranslateInstance(-pasteBounds.getCenterX(), -pasteBounds.getCenterY());
            AffineTransform retranslate = AffineTransform.getTranslateInstance(pasteBounds.getCenterX(), pasteBounds.getCenterY());
            inPlace.preConcatenate(untranslate);
            inPlace.preConcatenate(justRotation);
            inPlace.preConcatenate(retranslate);
        }
        if (User.isMoveAfterDuplicate()) {
            EventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(wnd, geomList, textList, currentListener, inPlace, inPlaceOrient));
        } else {
            new PasteObjects(parent, geomList, textList, lastDupX, lastDupY, User.getAlignmentToGrid(), User.isDupCopiesExports(), User.isArcsAutoIncremented(), inPlace, inPlaceOrient);
        }
    }

    public static void duplicate() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<Geometric> geomList = highlighter.getHighlightedEObjs(true, true);
        ArrayList<DisplayedText> textList = new ArrayList<DisplayedText>();
        Iterator<Variable> it = clipCell.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (!var.isDisplay()) continue;
            textList.add(new DisplayedText(clipCell, var.getKey()));
        }
        if (geomList.size() == 0 && textList.size() == 0) {
            System.out.println("First select objects to duplicate");
            return;
        }
        if (User.isMoveAfterDuplicate()) {
            EventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(wnd, geomList, textList, currentListener, null, null));
        } else {
            new DuplicateObjects(wnd.getCell(), geomList, textList, User.getAlignmentToGrid());
        }
    }

    public static void nodeMoved(NodeInst ni, double lastX, double lastY) {
        if (ni != lastDup) {
            return;
        }
        lastDupX += ni.getAnchorCenterX() - lastX;
        lastDupY += ni.getAnchorCenterY() - lastY;
    }

    private static void copySelectedText(List<DisplayedText> highlightedText) {
        Variable.Key varKey;
        if (highlightedText.size() != 1) {
            return;
        }
        DisplayedText dt = highlightedText.get(0);
        ElectricObject eObj = dt.getElectricObject();
        Variable var = eObj.getVar(varKey = dt.getVariableKey());
        if (var == null) {
            return;
        }
        String selected = var.describe(-1);
        if (selected == null) {
            return;
        }
        java.awt.datatransfer.Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(selected);
        cb.setContents(transferable, null);
    }

    private static void init() {
        if (clipLib == null) {
            clipLib = Library.newInstance("Clipboard!!", null);
            clipLib.setHidden();
        }
        if (clipCell == null) {
            clipCell = Cell.newInstance(clipLib, "Clipboard!!");
        }
    }

    public static void clear() {
        Clipboard.init();
        ArrayList<ArcInst> arcsToDelete = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = clipCell.getArcs();
        while (it.hasNext()) {
            arcsToDelete.add(it.next());
        }
        for (ArcInst ai : arcsToDelete) {
            ai.kill();
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        Iterator<Export> it2 = clipCell.getExports();
        while (it2.hasNext()) {
            exportsToDelete.add(it2.next());
        }
        for (Export pp : exportsToDelete) {
            pp.kill();
        }
        ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
        Iterator<NodeInst> it3 = clipCell.getNodes();
        while (it3.hasNext()) {
            nodesToDelete.add(it3.next());
        }
        for (NodeInst ni : nodesToDelete) {
            ni.kill();
        }
        ArrayList varsToDelete = new ArrayList();
        Iterator<Variable> it4 = clipCell.getVariables();
        while (it4.hasNext()) {
            Variable var = it4.next();
            clipCell.delVar(var.getKey());
        }
    }

    public static NodeInst copyListToCell(Cell toCell, List<Geometric> geomList, List<DisplayedText> textList, List<Geometric> newGeomList, List<DisplayedText> newTextList, Point2D delta, boolean copyExports, boolean uniqueArcs, double alignment, AffineTransform inPlace, Orientation inPlaceOrient) {
        ArrayList<NodeInst> theNodes = new ArrayList<NodeInst>();
        ArrayList<ArcInst> theArcs = new ArrayList<ArcInst>();
        for (Geometric geom : geomList) {
            if (geom instanceof NodeInst && !theNodes.contains(geom)) {
                theNodes.add((NodeInst)geom);
            }
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            theArcs.add(ai);
            NodeInst head = ai.getHeadPortInst().getNodeInst();
            NodeInst tail = ai.getTailPortInst().getNodeInst();
            if (!theNodes.contains(head)) {
                theNodes.add(head);
            }
            if (theNodes.contains(tail)) continue;
            theNodes.add(tail);
        }
        if (theNodes.size() == 0 && textList.size() == 0) {
            return null;
        }
        for (NodeInst ni : theNodes) {
            Cell niCell;
            if (!ni.isCellInstance() || !Cell.isInstantiationRecursive(niCell = (Cell)ni.getProto(), toCell)) continue;
            System.out.println("Cannot: that would be recursive (" + toCell + " is beneath " + ni.getProto() + ")");
            return null;
        }
        DBMath.gridAlign(delta, alignment);
        double dX = delta.getX();
        double dY = delta.getY();
        Collections.sort(theNodes);
        NodeInst lastCreatedNode = null;
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
        HashMap<PortInst, Export> originalExports = new HashMap<PortInst, Export>();
        for (NodeInst ni : theNodes) {
            NodeInst newNi;
            if (ni.getProto() == Generic.tech.cellCenterNode && toCell.alreadyCellCenter()) continue;
            double width = ni.getXSize();
            double height = ni.getYSize();
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), toCell, NodeInst.class, false);
            }
            EPoint point = new EPoint(ni.getAnchorCenterX() + dX, ni.getAnchorCenterY() + dY);
            Orientation orient = ni.getOrient();
            if (inPlace != null) {
                Point2D.Double dst = new Point2D.Double(0.0, 0.0);
                inPlace.transform(new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), dst);
                point = new EPoint(((Point2D)dst).getX() + dX, ((Point2D)dst).getY() + dY);
                orient = orient.concatenate(inPlaceOrient);
            }
            if ((newNi = NodeInst.newInstance(ni.getProto(), point, width, height, toCell, orient, name, ni.getTechSpecific())) == null) {
                System.out.println("Cannot create node");
                return lastCreatedNode;
            }
            newNi.copyStateBits(ni);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            newNi.copyVarsFrom(ni);
            newNodes.put(ni, newNi);
            if (newGeomList != null) {
                newGeomList.add(newNi);
            }
            lastCreatedNode = newNi;
            if (!copyExports) continue;
            Iterator<Export> eit = ni.getExports();
            while (eit.hasNext()) {
                Export pp = eit.next();
                PortInst pi = ExportChanges.getNewPortFromReferenceExport(newNi, pp);
                portInstsToExport.add(pi);
                originalExports.put(pi, pp);
            }
        }
        if (copyExports) {
            ExportChanges.reExportPorts(toCell, portInstsToExport, true, true, false, originalExports);
        }
        HashMap<ArcInst, ArcInst> newArcs = new HashMap<ArcInst, ArcInst>();
        if (theArcs.size() > 0) {
            Collections.sort(theArcs);
            HashMap<String, String> newArcNames = new HashMap<String, String>();
            AffineTransform fixOffset = null;
            if (inPlaceOrient != null) {
                fixOffset = inPlaceOrient.pureRotate();
            }
            for (ArcInst ai : theArcs) {
                PortInst oldHeadPi = ai.getHeadPortInst();
                NodeInst headNi = (NodeInst)newNodes.get(oldHeadPi.getNodeInst());
                PortInst headPi = headNi.findPortInstFromProto(oldHeadPi.getPortProto());
                EPoint headP = oldHeadPi.getCenter();
                double headDX = ai.getHeadLocation().getX() - headP.getX();
                double headDY = ai.getHeadLocation().getY() - headP.getY();
                PortInst oldTailPi = ai.getTailPortInst();
                NodeInst tailNi = (NodeInst)newNodes.get(oldTailPi.getNodeInst());
                PortInst tailPi = tailNi.findPortInstFromProto(oldTailPi.getPortProto());
                EPoint tailP = oldTailPi.getCenter();
                double tailDX = ai.getTailLocation().getX() - tailP.getX();
                double tailDY = ai.getTailLocation().getY() - tailP.getY();
                if (fixOffset != null) {
                    Point2D.Double result = new Point2D.Double(0.0, 0.0);
                    fixOffset.transform(new Point2D.Double(headDX, headDY), result);
                    headDX = ((Point2D)result).getX();
                    headDY = ((Point2D)result).getY();
                    fixOffset.transform(new Point2D.Double(tailDX, tailDY), result);
                    tailDX = ((Point2D)result).getX();
                    tailDY = ((Point2D)result).getY();
                }
                String name = null;
                if (ai.isUsernamed()) {
                    name = ai.getName();
                    if (uniqueArcs) {
                        String newName = (String)newArcNames.get(name);
                        if (newName == null) {
                            newName = ElectricObject.uniqueObjectName(name, toCell, ArcInst.class, false);
                            newArcNames.put(name, newName);
                        }
                        name = newName;
                    }
                }
                headP = new EPoint(headPi.getCenter().getX() + headDX, headPi.getCenter().getY() + headDY);
                tailP = new EPoint(tailPi.getCenter().getX() + tailDX, tailPi.getCenter().getY() + tailDY);
                ArcInst newAr = ArcInst.newInstance(ai.getProto(), ai.getWidth(), headPi, tailPi, headP, tailP, name, ai.getAngle());
                if (newAr == null) {
                    System.out.println("Cannot create arc");
                    return lastCreatedNode;
                }
                newAr.copyPropertiesFrom(ai);
                newArcs.put(ai, newAr);
                if (newGeomList == null) continue;
                newGeomList.add(newAr);
            }
        }
        for (DisplayedText dt : textList) {
            ElectricObject eObj = dt.getElectricObject();
            if (!(eObj instanceof Cell)) continue;
            Variable.Key varKey = dt.getVariableKey();
            Variable var = eObj.getVar(varKey);
            double xP = var.getTextDescriptor().getXOff();
            double yP = var.getTextDescriptor().getYOff();
            Variable newv = toCell.newVar(varKey, var.getObject(), var.getTextDescriptor().withOff(xP + dX, yP + dY));
            if (newTextList == null) continue;
            newTextList.add(new DisplayedText(toCell, varKey));
        }
        return lastCreatedNode;
    }

    private static void showCopiedObjects(List<Geometric> newGeomList, List<DisplayedText> newTextList) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd != null) {
            Cell cell = wnd.getCell();
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            for (Geometric geom : newGeomList) {
                NodeInst ni;
                if (geom instanceof NodeInst && (ni = (NodeInst)geom).isInvisiblePinWithText()) {
                    Poly[] polys = ni.getAllText(false, wnd);
                    if (polys == null) continue;
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        if (poly == null) continue;
                        Highlight2 h = highlighter.addText(ni, cell, poly.getDisplayedText().getVariableKey());
                    }
                    continue;
                }
                highlighter.addElectricObject(geom, cell);
            }
            for (DisplayedText dt : newTextList) {
                highlighter.addText(dt.getElectricObject(), cell, dt.getVariableKey());
            }
            highlighter.finished();
        }
    }

    private static NodeInst pasteNodeToNode(NodeInst destNode, NodeInst srcNode) {
        if ((destNode = CircuitChangeJobs.replaceNodeInst(destNode, srcNode.getProto(), true, false)) == null) {
            return null;
        }
        destNode.clearExpanded();
        if (srcNode.isExpanded()) {
            destNode.setExpanded();
        }
        if (!destNode.isCellInstance() && !srcNode.isCellInstance() && srcNode.getProto().getTechnology() == destNode.getProto().getTechnology()) {
            Technology tech = srcNode.getProto().getTechnology();
            tech.setPrimitiveFunction(destNode, srcNode.getFunction());
        }
        if (!destNode.isCellInstance()) {
            double dX = srcNode.getXSize() - destNode.getXSize();
            double dY = srcNode.getYSize() - destNode.getYSize();
            if (dX != 0.0 || dY != 0.0) {
                destNode.resize(dX, dY);
            }
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            Iterator<Variable> it = destNode.getVariables();
            while (it.hasNext()) {
                Variable destVar = it.next();
                Variable.Key key = destVar.getKey();
                Variable srcVar = srcNode.getVar(key);
                if (srcVar != null) continue;
                destNode.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        destNode.copyVarsFrom(srcNode);
        destNode.copyStateBits(srcNode);
        destNode.clearExpanded();
        if (srcNode.isExpanded()) {
            destNode.setExpanded();
        }
        destNode.clearLocked();
        return destNode;
    }

    private static ArcInst pasteArcToArc(ArcInst destArc, ArcInst srcArc) {
        Variable.Key key;
        Iterator<Variable> it;
        if (destArc.getProto() != srcArc.getProto() && (destArc = destArc.replace(srcArc.getProto())) == null) {
            return null;
        }
        double dw = srcArc.getWidth() - destArc.getWidth();
        if (dw != 0.0) {
            destArc.modify(dw, 0.0, 0.0, 0.0, 0.0);
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            it = destArc.getVariables();
            while (it.hasNext()) {
                Variable destVar = it.next();
                key = destVar.getKey();
                Variable srcVar = srcArc.getVar(key);
                if (srcVar != null) continue;
                destArc.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        it = srcArc.getVariables();
        while (it.hasNext()) {
            Variable srcVar = it.next();
            key = srcVar.getKey();
            Variable destVar = destArc.newVar(key, srcVar.getObject(), srcVar.getTextDescriptor());
        }
        destArc.copyPropertiesFrom(srcArc);
        return destArc;
    }

    private static Rectangle2D getPasteBounds(List<Geometric> geomList, List<DisplayedText> textList, EditWindow wnd) {
        Rectangle2D bounds;
        Point2D llcorner = null;
        Point2D urcorner = null;
        for (DisplayedText dt : textList) {
            ElectricObject eObj = dt.getElectricObject();
            Poly poly = clipCell.computeTextPoly(wnd, dt.getVariableKey());
            bounds = poly.getBounds2D();
            if (llcorner == null) {
                llcorner = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                urcorner = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                continue;
            }
            if (bounds.getMinX() < llcorner.getX()) {
                llcorner.setLocation(bounds.getMinX(), llcorner.getY());
            }
            if (bounds.getMinY() < llcorner.getY()) {
                llcorner.setLocation(llcorner.getX(), bounds.getMinY());
            }
            if (bounds.getMaxX() > urcorner.getX()) {
                urcorner.setLocation(bounds.getMaxX(), urcorner.getY());
            }
            if (!(bounds.getMaxY() > urcorner.getY())) continue;
            urcorner.setLocation(urcorner.getX(), bounds.getMaxY());
        }
        for (Geometric geom : geomList) {
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                EPoint pt = ni.getAnchorCenter();
                if (llcorner == null) {
                    llcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    urcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    continue;
                }
                if (((Point2D)pt).getX() < llcorner.getX()) {
                    llcorner.setLocation(((Point2D)pt).getX(), llcorner.getY());
                }
                if (((Point2D)pt).getY() < llcorner.getY()) {
                    llcorner.setLocation(llcorner.getX(), ((Point2D)pt).getY());
                }
                if (((Point2D)pt).getX() > urcorner.getX()) {
                    urcorner.setLocation(((Point2D)pt).getX(), urcorner.getY());
                }
                if (!(((Point2D)pt).getY() > urcorner.getY())) continue;
                urcorner.setLocation(urcorner.getX(), ((Point2D)pt).getY());
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            double wid = ai.getWidth() - ai.getProto().getWidthOffset();
            Poly poly = ai.makePoly(wid, Poly.Type.FILLED);
            Rectangle2D bounds2 = poly.getBounds2D();
            if (llcorner == null) {
                llcorner = new Point2D.Double(bounds2.getMinX(), bounds2.getMinY());
                urcorner = new Point2D.Double(bounds2.getMaxX(), bounds2.getMaxY());
                continue;
            }
            if (bounds2.getMinX() < llcorner.getX()) {
                llcorner.setLocation(bounds2.getMinX(), llcorner.getY());
            }
            if (bounds2.getMinY() < llcorner.getY()) {
                llcorner.setLocation(llcorner.getX(), bounds2.getMinY());
            }
            if (bounds2.getMaxX() > urcorner.getX()) {
                urcorner.setLocation(bounds2.getMaxX(), urcorner.getY());
            }
            if (!(bounds2.getMaxY() > urcorner.getY())) continue;
            urcorner.setLocation(urcorner.getX(), bounds2.getMaxY());
        }
        double width = urcorner.getX() - llcorner.getX();
        double height = urcorner.getY() - llcorner.getY();
        bounds = new Rectangle2D.Double(llcorner.getX(), llcorner.getY(), width, height);
        return bounds;
    }

    static {
        lastDup = null;
        lastDupX = 10.0;
        lastDupY = 10.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PasteListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private EditWindow wnd;
        private List<Geometric> geomList;
        private List<DisplayedText> textList;
        private EventListener currentListener;
        private Rectangle2D pasteBounds;
        private double translateX;
        private double translateY;
        private Point2D lastMouseDB;
        private JPopupMenu popup;
        private AffineTransform inPlace;
        private Orientation inPlaceOrient;

        private PasteListener(EditWindow wnd, List<Geometric> geomList, List<DisplayedText> textList, EventListener currentListener, AffineTransform inPlace, Orientation inPlaceOrient) {
            this.wnd = wnd;
            this.geomList = geomList;
            this.textList = textList;
            this.currentListener = currentListener;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.pasteBounds = Clipboard.getPasteBounds(geomList, textList, wnd);
            this.translateY = 0.0;
            this.translateX = 0.0;
            this.initPopup();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            Point2D delta = this.getDelta(mouseDB, false);
            wnd.getHighlighter().pushHighlight();
            this.showList(delta);
        }

        private Point2D getDelta(Point2D mouseDB, boolean orthogonal) {
            if (mouseDB == null) {
                return null;
            }
            double alignment = User.getAlignmentToGrid();
            DBMath.gridAlign(mouseDB, alignment);
            Point2D.Double refPastePoint = new Point2D.Double(this.pasteBounds.getCenterX() + this.translateX, this.pasteBounds.getCenterY() + this.translateY);
            double deltaX = mouseDB.getX() - ((Point2D)refPastePoint).getX();
            double deltaY = mouseDB.getY() - ((Point2D)refPastePoint).getY();
            if (orthogonal) {
                if (Math.abs(deltaX) > Math.abs(deltaY)) {
                    deltaY = 0.0;
                } else {
                    deltaX = 0.0;
                }
            }
            ((Point2D)refPastePoint).setLocation(deltaX, deltaY);
            DBMath.gridAlign(refPastePoint, alignment);
            return refPastePoint;
        }

        private void showList(Point2D delta) {
            if (delta == null) {
                return;
            }
            double oX = delta.getX();
            double oY = delta.getY();
            Cell cell = this.wnd.getCell();
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            for (Geometric geom : this.geomList) {
                if (geom instanceof ArcInst) {
                    ArcInst ai = (ArcInst)geom;
                    Poly poly = ai.makePoly(ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
                    if (this.inPlace != null) {
                        poly.transform(this.inPlace);
                    }
                    Point2D[] points = poly.getPoints();
                    this.showPoints(points, oX, oY, cell, highlighter);
                    continue;
                }
                NodeInst ni = (NodeInst)geom;
                if (ni.isInvisiblePinWithText()) {
                    boolean found = false;
                    Iterator<Variable> vIt = ni.getVariables();
                    while (vIt.hasNext()) {
                        Variable var = vIt.next();
                        if (!var.isDisplay()) continue;
                        Point2D[] points = Highlighter.describeHighlightText(this.wnd, geom, var.getKey());
                        if (this.inPlace != null) {
                            this.inPlace.transform(points, 0, points, 0, points.length);
                        }
                        this.showPoints(points, oX, oY, cell, highlighter);
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                SizeOffset so = ni.getSizeOffset();
                AffineTransform trans = ni.rotateOutAboutTrueCenter();
                double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
                double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
                double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
                double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
                double nodeX = (nodeLowX + nodeHighX) / 2.0;
                double nodeY = (nodeLowY + nodeHighY) / 2.0;
                Poly poly = new Poly(nodeX, nodeY, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
                if (this.inPlace != null) {
                    poly.transform(this.inPlace);
                }
                poly.transform(trans);
                this.showPoints(poly.getPoints(), oX, oY, cell, highlighter);
            }
            Rectangle2D bounds = this.wnd.getDisplayedBounds();
            highlighter.addMessage(cell, "(" + (int)oX + "," + (int)oY + ")", new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
            double halfWidth = 0.5 * this.pasteBounds.getWidth();
            double halfHeight = 0.5 * this.pasteBounds.getHeight();
            if (Math.abs(this.translateX) > halfWidth || Math.abs(this.translateY) > halfHeight) {
                Rectangle2D.Double transBounds = new Rectangle2D.Double(this.pasteBounds.getX() + oX, this.pasteBounds.getY() + oY, this.pasteBounds.getWidth(), this.pasteBounds.getHeight());
                Poly p = new Poly(transBounds);
                if (this.inPlace != null) {
                    p.transform(this.inPlace);
                }
                Point2D endPoint = p.closestPoint(this.lastMouseDB);
                highlighter.addLine(this.lastMouseDB, endPoint, cell);
                int angle = GenMath.figureAngle(this.lastMouseDB, endPoint);
                int angleOfArrow = 300;
                int backAngle1 = (angle += 1800) - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                Point2D.Double p1 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle1), endPoint.getY() + DBMath.sin(backAngle1));
                Point2D.Double p2 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle2), endPoint.getY() + DBMath.sin(backAngle2));
                highlighter.addLine(endPoint, p1, cell);
                highlighter.addLine(endPoint, p2, cell);
            }
            highlighter.finished();
        }

        private void showPoints(Point2D[] points, double oX, double oY, Cell cell, Highlighter highlighter) {
            for (int i = 0; i < points.length; ++i) {
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                double fX = points[lastI].getX();
                double fY = points[lastI].getY();
                double tX = points[i].getX();
                double tY = points[i].getY();
                highlighter.addLine(new Point2D.Double(fX + oX, fY + oY), new Point2D.Double(tX + oX, tY + oY), cell);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isMetaDown()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isMetaDown()) {
                return;
            }
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.showList(delta);
            WindowFrame.setListener(this.currentListener);
            this.wnd.getHighlighter().popHighlight();
            Cell cell = WindowFrame.needCurCell();
            if (cell != null) {
                new PasteObjects(cell, this.geomList, this.textList, delta.getX(), delta.getY(), User.getAlignmentToGrid(), User.isDupCopiesExports(), User.isArcsAutoIncremented(), this.inPlace, this.inPlaceOrient);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.lastMouseDB = mouseDB;
            this.showList(delta);
            this.wnd.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            int chr = evt.getKeyCode();
            if (chr == 27) {
                this.abort();
            } else if (chr == 38) {
                this.moveObjectsUp();
            } else if (chr == 40) {
                this.moveObjectsDown();
            } else if (chr == 37) {
                this.moveObjectsLeft();
            } else if (chr == 39) {
                this.moveObjectsRight();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void abort() {
            this.wnd.getHighlighter().clear();
            this.wnd.getHighlighter().finished();
            WindowFrame.setListener(this.currentListener);
            this.wnd.repaint();
        }

        private void initPopup() {
            this.popup = new JPopupMenu();
            JMenuItem m = new JMenuItem("Move objects left");
            m.setAccelerator(KeyStroke.getKeyStroke(37, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsLeft();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects right");
            m.setAccelerator(KeyStroke.getKeyStroke(39, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsRight();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects up");
            m.setAccelerator(KeyStroke.getKeyStroke(38, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsUp();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects down");
            m.setAccelerator(KeyStroke.getKeyStroke(40, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsDown();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Abort");
            m.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.abort();
                }
            });
            this.popup.add(m);
        }

        private void moveObjectsLeft() {
            this.translateX += 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsRight() {
            this.translateX -= 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsUp() {
            this.translateY -= 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsDown() {
            this.translateY += 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PasteObjects
    extends Job {
        private Cell cell;
        private List<Geometric> geomList;
        private List<Geometric> newGeomList;
        private List<DisplayedText> textList;
        private List<DisplayedText> newTextList;
        private double dX;
        private double dY;
        private double alignment;
        private boolean copyExports;
        private boolean uniqueArcs;
        private NodeInst lastCreatedNode;
        private AffineTransform inPlace;
        private Orientation inPlaceOrient;

        protected PasteObjects(Cell cell, List<Geometric> geomList, List<DisplayedText> textList, double dX, double dY, double alignment, boolean copyExports, boolean uniqueArcs, AffineTransform inPlace, Orientation inPlaceOrient) {
            super("Paste", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.geomList = geomList;
            this.textList = textList;
            this.dX = dX;
            this.dY = dY;
            this.alignment = alignment;
            this.copyExports = copyExports;
            this.uniqueArcs = uniqueArcs;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            this.newGeomList = new ArrayList<Geometric>();
            this.newTextList = new ArrayList<DisplayedText>();
            this.lastCreatedNode = Clipboard.copyListToCell(this.cell, this.geomList, this.textList, this.newGeomList, this.newTextList, new Point2D.Double(this.dX, this.dY), this.copyExports, this.uniqueArcs, this.alignment, this.inPlace, this.inPlaceOrient);
            this.fieldVariableChanged("newGeomList");
            this.fieldVariableChanged("newTextList");
            this.fieldVariableChanged("lastCreatedNode");
            return true;
        }

        @Override
        public void terminateOK() {
            lastDup = this.lastCreatedNode;
            Clipboard.showCopiedObjects(this.newGeomList, this.newTextList);
        }
    }

    private static class PasteNodeToNode
    extends Job {
        private NodeInst src;
        private NodeInst dst;
        private NodeInst newNode;

        protected PasteNodeToNode(NodeInst dst, NodeInst src) {
            super("Paste Node to Node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.dst.getParent(), null, true) != 0) {
                return false;
            }
            this.newNode = Clipboard.pasteNodeToNode(this.dst, this.src);
            if (this.newNode == null) {
                System.out.println("Nothing was pasted");
            } else {
                this.fieldVariableChanged("newNode");
            }
            return true;
        }

        public void terminateOK() {
            Highlighter highlighter;
            EditWindow wnd;
            if (this.newNode != null && (wnd = EditWindow.getCurrent()) != null && (highlighter = wnd.getHighlighter()) != null) {
                highlighter.clear();
                highlighter.addElectricObject(this.newNode, this.newNode.getParent());
                highlighter.finished();
            }
        }
    }

    private static class PasteArcToArc
    extends Job {
        private ArcInst src;
        private ArcInst dst;
        private ArcInst newArc;

        protected PasteArcToArc(ArcInst dst, ArcInst src) {
            super("Paste Arc to Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.dst.getParent(), null, true) != 0) {
                return false;
            }
            this.newArc = Clipboard.pasteArcToArc(this.dst, this.src);
            if (this.newArc == null) {
                System.out.println("Nothing was pasted");
            } else {
                this.fieldVariableChanged("newArc");
            }
            return true;
        }

        public void terminateOK() {
            Highlighter highlighter;
            EditWindow wnd;
            if (this.newArc != null && (wnd = EditWindow.getCurrent()) != null && (highlighter = wnd.getHighlighter()) != null) {
                highlighter.clear();
                highlighter.addElectricObject(this.newArc, this.newArc.getParent());
                highlighter.finished();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DuplicateObjects
    extends Job {
        private Cell cell;
        private List<Geometric> geomList;
        private List<Geometric> newGeomList;
        private List<DisplayedText> textList;
        private List<DisplayedText> newTextList;
        private double alignment;
        private NodeInst lastCreatedNode;

        protected DuplicateObjects(Cell cell, List<Geometric> geomList, List<DisplayedText> textList, double alignment) {
            super("Duplicate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.geomList = geomList;
            this.textList = textList;
            this.alignment = alignment;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.newGeomList = new ArrayList<Geometric>();
            this.newTextList = new ArrayList<DisplayedText>();
            this.lastCreatedNode = Clipboard.copyListToCell(this.cell, this.geomList, this.textList, this.newGeomList, this.newTextList, new Point2D.Double(lastDupX, lastDupY), User.isDupCopiesExports(), User.isArcsAutoIncremented(), this.alignment, null, null);
            this.fieldVariableChanged("newGeomList");
            this.fieldVariableChanged("newTextList");
            this.fieldVariableChanged("lastCreatedNode");
            return true;
        }

        @Override
        public void terminateOK() {
            lastDup = this.lastCreatedNode;
            Clipboard.showCopiedObjects(this.newGeomList, this.newTextList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CutObjects
    extends Job {
        private Cell cell;
        private List<Geometric> geomList;
        private List<DisplayedText> textList;
        private double alignment;
        private boolean reconstructArcs;
        private AffineTransform inPlace;
        private Orientation inPlaceOrient;

        protected CutObjects(Cell cell, List<Geometric> geomList, List<DisplayedText> textList, double alignment, boolean reconstructArcs, AffineTransform inPlace, Orientation inPlaceOrient) {
            super("Cut", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.geomList = geomList;
            this.textList = textList;
            this.alignment = alignment;
            this.reconstructArcs = reconstructArcs;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Clipboard.clear();
            if (CircuitChangeJobs.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            ArrayList deleteList = new ArrayList();
            for (Geometric geom : this.geomList) {
                if (!(geom instanceof NodeInst)) continue;
                int errorCode = CircuitChangeJobs.cantEdit(this.cell, (NodeInst)geom, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode <= 0) continue;
            }
            Clipboard.copyListToCell(clipCell, this.geomList, this.textList, null, null, new Point2D.Double(0.0, 0.0), User.isDupCopiesExports(), User.isArcsAutoIncremented(), this.alignment, this.inPlace, this.inPlaceOrient);
            CircuitChangeJobs.eraseObjectsInList(this.cell, this.geomList, this.reconstructArcs);
            for (DisplayedText dt : this.textList) {
                ElectricObject owner = dt.getElectricObject();
                if (!(owner instanceof Cell)) continue;
                owner.delVar(dt.getVariableKey());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyObjects
    extends Job {
        private Cell cell;
        private List<Geometric> highlightedGeoms;
        private List<DisplayedText> highlightedText;
        private double alignment;
        private AffineTransform inPlace;
        private Orientation inPlaceOrient;

        protected CopyObjects(Cell cell, List<Geometric> highlightedGeoms, List<DisplayedText> highlightedText, double alignment, AffineTransform inPlace, Orientation inPlaceOrient) {
            super("Copy", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.highlightedGeoms = highlightedGeoms;
            this.highlightedText = highlightedText;
            this.alignment = alignment;
            this.inPlace = inPlace;
            this.inPlaceOrient = inPlaceOrient;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Clipboard.clear();
            Clipboard.copyListToCell(clipCell, this.highlightedGeoms, this.highlightedText, null, null, new Point2D.Double(0.0, 0.0), User.isDupCopiesExports(), User.isArcsAutoIncremented(), this.alignment, this.inPlace, this.inPlaceOrient);
            return true;
        }
    }
}

