/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.projectSettings;

import com.sun.electric.database.text.Pref;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjSettingsNode
implements Serializable {
    private LinkedHashMap<String, Object> data = new LinkedHashMap();

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public void putValue(String key, Pref pref) {
        Object v = this.data.get(key);
        Object previousVal = null;
        if (v instanceof UninitializedPref) {
            previousVal = ((UninitializedPref)v).value;
        }
        this.data.put(key, pref);
        if (previousVal != null && !ProjSettingsNode.equal(previousVal, pref)) {
            System.out.println("Warning: For key " + key + ": project setting value of " + previousVal + " overrides default of " + pref.getValue());
            if (previousVal instanceof Boolean) {
                pref.setBoolean((Boolean)previousVal);
            } else if (previousVal instanceof Integer) {
                pref.setInt((Integer)previousVal);
            } else if (previousVal instanceof Double) {
                pref.setDouble((Double)previousVal);
            } else if (previousVal instanceof String) {
                pref.setString(previousVal.toString());
            } else if (previousVal instanceof Long) {
                pref.setLong((Long)previousVal);
            }
        }
    }

    public Pref getValue(String key) {
        Object obj = this.data.get(key);
        if (obj instanceof Pref) {
            return (Pref)obj;
        }
        if (obj == null) {
            return null;
        }
        this.prIllegalRequestError(key);
        return null;
    }

    public void putNode(String key, ProjSettingsNode node) {
        this.data.put(key, node);
    }

    public ProjSettingsNode getNode(String key) {
        Object obj = this.data.get(key);
        if (obj == null) {
            obj = new ProjSettingsNode();
            this.data.put(key, obj);
        }
        if (obj instanceof ProjSettingsNode) {
            return (ProjSettingsNode)obj;
        }
        this.prIllegalRequestError(key);
        return null;
    }

    private void prIllegalRequestError(String key) {
        System.out.println("ERROR! Project Settings key conflict: " + key);
    }

    protected Object get(String key) {
        return this.data.get(key);
    }

    protected void put(String key, Object node) {
        this.data.put(key, node);
    }

    public static boolean equal(Object value, Pref pref) {
        if (value == null || pref.getValue() == null) {
            return false;
        }
        if (pref.getType() == Pref.PrefType.BOOLEAN && value instanceof Boolean) {
            return pref.getBoolean() == ((Boolean)value).booleanValue();
        }
        if (value.getClass() != pref.getValue().getClass()) {
            return false;
        }
        return value.equals(pref.getValue());
    }

    public boolean equals(Object node) {
        if (!(node instanceof ProjSettingsNode)) {
            return false;
        }
        ProjSettingsNode otherNode = (ProjSettingsNode)node;
        Set<String> myKeys = this.getKeys();
        Set<String> otherKeys = otherNode.getKeys();
        if (myKeys.size() != otherKeys.size()) {
            return false;
        }
        for (String myKey : myKeys) {
            if (!otherKeys.contains(myKey)) {
                return false;
            }
            Object myObj = this.get(myKey);
            Object otherObj = otherNode.get(myKey);
            if (myObj.getClass() != otherObj.getClass()) {
                return false;
            }
            if (myObj.equals(otherObj)) continue;
            return false;
        }
        return true;
    }

    public boolean printDifferences(Object node) {
        return this.printDifferences(node, new Stack<String>());
    }

    private boolean printDifferences(Object node, Stack<String> context) {
        if (!(node instanceof ProjSettingsNode)) {
            return true;
        }
        boolean differencesFound = false;
        ProjSettingsNode otherNode = (ProjSettingsNode)node;
        Set<String> myKeys = this.getKeys();
        Set<String> otherKeys = otherNode.getKeys();
        TreeSet<String> allKeys = new TreeSet<String>();
        allKeys.addAll(myKeys);
        allKeys.addAll(otherKeys);
        for (String key : allKeys) {
            if (!myKeys.contains(key)) {
                System.out.println("Warning: Key " + this.getKey(context, key) + " is missing from other settings");
                differencesFound = true;
                continue;
            }
            if (!otherKeys.contains(key)) {
                System.out.println("Warning: Key " + this.getKey(context, key) + " is missing from current settings");
                differencesFound = true;
                continue;
            }
            Object myObj = this.get(key);
            Object otherObj = otherNode.get(key);
            if (myObj.getClass() != otherObj.getClass()) {
                System.out.println("Warning: Value type mismatch for key " + this.getKey(context, key) + ": " + myObj.getClass().getName() + " vs " + otherObj.getClass().getName());
                differencesFound = true;
                continue;
            }
            if (myObj instanceof ProjSettingsNode) {
                context.push(key);
                if (((ProjSettingsNode)myObj).printDifferences(otherObj, context)) {
                    differencesFound = true;
                }
                context.pop();
                continue;
            }
            if (myObj.equals(otherObj)) continue;
            System.out.println("Warning: Values not equal for key " + this.getKey(context, key) + ": " + myObj + " vs " + otherObj);
            differencesFound = true;
        }
        return differencesFound;
    }

    private String getKey(Stack<String> context, String key) {
        return ProjSettingsNode.describeContext(context) + "." + key;
    }

    public static String describeContext(Stack<String> context) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String name : context) {
            if (first) {
                first = false;
            } else {
                buf.append(".");
            }
            buf.append(name);
        }
        if (buf.length() == 0) {
            return "RootContext";
        }
        return buf.toString();
    }

    public static class UninitializedPref {
        public final Object value;

        public UninitializedPref(Object value) {
            this.value = value;
        }
    }
}

