/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.projsettings.CIFTab;
import com.sun.electric.tool.user.dialogs.projsettings.DXFTab;
import com.sun.electric.tool.user.dialogs.projsettings.GDSTab;
import com.sun.electric.tool.user.dialogs.projsettings.LogicalEffortTab;
import com.sun.electric.tool.user.dialogs.projsettings.NetlistsTab;
import com.sun.electric.tool.user.dialogs.projsettings.ParasiticTab;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import com.sun.electric.tool.user.dialogs.projsettings.ScaleTab;
import com.sun.electric.tool.user.dialogs.projsettings.SkillTab;
import com.sun.electric.tool.user.dialogs.projsettings.TechnologyTab;
import com.sun.electric.tool.user.dialogs.projsettings.VerilogTab;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProjectSettingsFrame
extends EDialog {
    private JSplitPane splitPane;
    private JTree optionTree;
    private List<Object> originalContext = Setting.getContext();
    private List<Object> currentContext = new ArrayList<Object>(this.originalContext);
    JButton cancel;
    JButton ok;
    ProjSettingsPanel currentOptionPanel;
    private static String currentTabName = "Netlists";

    public static void projectSettingsCommand() {
        ProjectSettingsFrame dialog = new ProjectSettingsFrame((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public ProjectSettingsFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Project Settings");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProjectSettingsFrame.this.closeDialog(evt);
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Project Settings");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.optionTree = new JTree(treeModel);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        this.optionTree.addTreeExpansionListener(handler);
        rootNode.add(new DefaultMutableTreeNode("CIF"));
        rootNode.add(new DefaultMutableTreeNode("GDS"));
        rootNode.add(new DefaultMutableTreeNode("DXF"));
        rootNode.add(new DefaultMutableTreeNode("Logical Effort"));
        rootNode.add(new DefaultMutableTreeNode("Netlists"));
        rootNode.add(new DefaultMutableTreeNode("Parasitic"));
        rootNode.add(new DefaultMutableTreeNode("Scale"));
        if (IOTool.hasSkill()) {
            rootNode.add(new DefaultMutableTreeNode("Skill"));
        }
        rootNode.add(new DefaultMutableTreeNode("Technology"));
        rootNode.add(new DefaultMutableTreeNode("Verilog"));
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        this.openSelectedPath(rootNode);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)scrolledTree, gbc);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.helpActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)help, gbc);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.cancelActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.cancel, gbc);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsFrame.this.okActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        leftPanel.add((Component)this.ok, gbc);
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.splitPane = new JSplitPane(1);
        this.loadOptionPanel();
        this.splitPane.setLeftComponent(leftPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.pack();
        this.finishInitialization();
    }

    public List<Object> getContext() {
        return this.currentContext;
    }

    private boolean openSelectedPath(DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = node.getUserObject();
            if (o.toString().equals(currentTabName)) {
                this.optionTree.scrollPathToVisible(new TreePath(node.getPath()));
                return true;
            }
            if (!this.openSelectedPath(node)) continue;
            return true;
        }
        return false;
    }

    private void cancelActionPerformed() {
        this.closeDialog(null);
    }

    private void okActionPerformed() {
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        boolean checkAndRepair = false;
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
            this.currentOptionPanel = null;
        }
        for (Setting setting : Setting.getSettings()) {
            Object v = setting.getValue(this.currentContext);
            if (setting.getValue(this.originalContext).equals(v)) continue;
            changeBatch.add(setting, v);
            if (!(setting instanceof Technology.TechSetting)) continue;
            checkAndRepair = true;
        }
        if (changeBatch.changesForSettings.isEmpty()) {
            this.closeDialog(null);
            return;
        }
        new OKUpdate(this, changeBatch, true, checkAndRepair);
    }

    private void helpActionPerformed() {
        ManualViewer.showProjectSettingHelp(currentTabName);
        this.closeDialog(null);
    }

    private void loadOptionPanel() {
        ProjSettingsPanel ti = this.createOptionPanel(this.isModal());
        if (ti == null) {
            return;
        }
        if (this.currentOptionPanel != null) {
            this.currentOptionPanel.term();
        }
        this.currentOptionPanel = ti;
        ti.init();
        this.splitPane.setRightComponent(ti.getPanel());
    }

    private ProjSettingsPanel createOptionPanel(boolean modal) {
        if (currentTabName.equals("CIF")) {
            return new CIFTab(this, modal);
        }
        if (currentTabName.equals("GDS")) {
            return new GDSTab(this, modal);
        }
        if (currentTabName.equals("DXF")) {
            return new DXFTab(this, modal);
        }
        if (currentTabName.equals("Logical Effort")) {
            return new LogicalEffortTab(this, modal);
        }
        if (currentTabName.equals("Netlists")) {
            return new NetlistsTab(this, modal);
        }
        if (currentTabName.equals("Parasitic")) {
            return new ParasiticTab(this, modal);
        }
        if (currentTabName.equals("Scale")) {
            return new ScaleTab(this, modal);
        }
        if (currentTabName.equals("Skill")) {
            return new SkillTab(this, modal);
        }
        if (currentTabName.equals("Technology")) {
            return new TechnologyTab(this, modal);
        }
        if (currentTabName.equals("Verilog")) {
            return new VerilogTab(this, modal);
        }
        return null;
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed();
    }

    public static void updateProjectSettings(Setting.SettingChangeBatch changeBatch, EDialog dialogToClose) {
        new OKUpdate(dialogToClose, changeBatch, false, false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TreeHandler
    implements MouseListener,
    TreeExpansionListener {
        private ProjectSettingsFrame dialog;

        TreeHandler(ProjectSettingsFrame dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            currentTabName = (String)node.getUserObject();
            this.dialog.optionTree.expandPath(currentPath);
            if (!currentTabName.endsWith(" ")) {
                this.dialog.loadOptionPanel();
            }
            this.dialog.pack();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            this.dialog.pack();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            if (tp.getPathCount() == 2) {
                TreePath topPath = this.dialog.optionTree.getPathForRow(0);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)topPath.getLastPathComponent();
                int numChildren = node.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    TreePath descentPath = topPath.pathByAddingChild(child);
                    if (descentPath.getLastPathComponent().equals(tp.getLastPathComponent())) continue;
                    this.dialog.optionTree.collapsePath(descentPath);
                }
            }
            this.dialog.pack();
        }
    }

    private static class OKUpdate
    extends Job {
        private transient EDialog dialog;
        private Setting.SettingChangeBatch changeBatch;
        private boolean issueWarning;
        private boolean checkAndRepair;

        private OKUpdate(EDialog dialog, Setting.SettingChangeBatch changeBatch, boolean issueWarning, boolean checkAndRepair) {
            super("Update Project Settings", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.changeBatch = changeBatch;
            this.issueWarning = issueWarning;
            this.checkAndRepair = checkAndRepair;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Setting.implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.issueWarning) {
                if (ProjSettings.getLastProjectSettingsFile() != null) {
                    Job.getUserInterface().showInformationMessage("Warning: These changes are only valid for this session of Electric.\nTo save them permanently, use File -> Export -> Project Settings", "Saving Project Setting Changes");
                } else {
                    boolean saveAny = false;
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        Library lib = it.next();
                        if (lib.isHidden() || lib.isChanged()) continue;
                        saveAny = true;
                    }
                    if (saveAny) {
                        int saveSettings;
                        int markCurrent;
                        String defaultOption;
                        Object[] options;
                        Library curLib = Library.getCurrent();
                        if (curLib.isChanged()) {
                            options = new String[]{"Mark All Libs", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[2];
                            markCurrent = 1000;
                            saveSettings = 1;
                        } else {
                            options = new String[]{"Mark All Libs", "Mark Lib \"" + curLib.getName() + "\"", "Write Proj Settings file", "Do nothing"};
                            defaultOption = options[0];
                            markCurrent = 1;
                            saveSettings = 2;
                        }
                        int i = JOptionPane.showOptionDialog(this.dialog, "Warning: Changed settings must be saved to Library or Project Settings file.\nPlease choose which Libraries to mark for saving, or write project settings file:", "Saving Project Setting Changes", -1, 2, null, options, defaultOption);
                        if (i == 0) {
                            CircuitChangeJobs.markAllLibrariesForSavingCommand();
                        } else if (i == markCurrent) {
                            CircuitChangeJobs.markCurrentLibForSavingCommand();
                        } else if (i == saveSettings) {
                            ProjSettings.exportSettings();
                        }
                    }
                }
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
            if (this.checkAndRepair) {
                CircuitChanges.checkAndRepairCommand(true);
            }
        }
    }
}

