/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.EditWindowFocusBrowser;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SetFocus
extends EDialog {
    private EditWindow wnd;
    private JButton cancel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton ok;
    private JTextField unitsAcross;
    private JTextField xCenter;
    private JTextField yCenter;

    public static void showSetFocusDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        SetFocus dialog = new SetFocus((Frame)TopLevel.getCurrentJFrame(), wnd);
        dialog.setVisible(true);
    }

    public SetFocus(Frame parent, EditWindow wnd) {
        super(parent, true);
        this.wnd = wnd;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        Dimension sz = wnd.getSize();
        Point2D offset = wnd.getOffset();
        double scale = wnd.getScale();
        this.xCenter.setText(TextUtils.formatDouble(offset.getX()));
        this.yCenter.setText(TextUtils.formatDouble(offset.getY()));
        this.unitsAcross.setText(TextUtils.formatDouble(sz.getWidth() / scale));
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.xCenter = new JTextField();
        this.jLabel2 = new JLabel();
        this.yCenter = new JTextField();
        this.jLabel3 = new JLabel();
        this.unitsAcross = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Set Focus");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SetFocus.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetFocus.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetFocus.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("X Center:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.xCenter.setColumns(8);
        this.xCenter.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xCenter, gridBagConstraints);
        this.jLabel2.setText("Y Center:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.yCenter.setColumns(8);
        this.yCenter.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yCenter, gridBagConstraints);
        this.jLabel3.setText("Horizontal Grid Units:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.unitsAcross.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.unitsAcross, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        double xC = TextUtils.atof(this.xCenter.getText());
        double yC = TextUtils.atof(this.yCenter.getText());
        double across = TextUtils.atof(this.unitsAcross.getText());
        Dimension sz = this.wnd.getSize();
        this.wnd.setOffset(new Point2D.Double(xC, yC));
        this.wnd.setScale(sz.getWidth() / across);
        EditWindowFocusBrowser fb = this.wnd.getSavedFocusBrowser();
        fb.updateCurrentFocus();
        this.wnd.repaintContents(null, false);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

