/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParasiticTab
extends PreferencePanel {
    private JCheckBox backannotateLayout;
    private JRadioButton extractExemptedNets;
    private JCheckBox extractPowerGround;
    private JRadioButton ignoreExemptedNets;
    private JLabel maxDist;
    private JTextField maxDistValue;
    private JPanel parasiticPanel;
    private JPanel simpleParasiticOptions;
    private JPanel topPanel;
    private JCheckBox useExemptedNetsFile;
    private JCheckBox verboseNaming;

    public ParasiticTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getPanel() {
        return this.topPanel;
    }

    @Override
    public String getName() {
        return "Parasitic";
    }

    @Override
    public void init() {
        this.verboseNaming.setSelected(Simulation.isParasiticsUseVerboseNaming());
        this.backannotateLayout.setSelected(Simulation.isParasiticsBackAnnotateLayout());
        this.extractPowerGround.setSelected(Simulation.isParasiticsExtractPowerGround());
        this.extractPowerGround.setEnabled(false);
        this.useExemptedNetsFile.setSelected(Simulation.isParasiticsUseExemptedNetsFile());
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.ignoreExemptedNets.setSelected(Simulation.isParasiticsIgnoreExemptedNets());
        this.extractExemptedNets.setSelected(!Simulation.isParasiticsIgnoreExemptedNets());
        this.maxDistValue.setText(TextUtils.formatDouble(ParasiticTool.getMaxDistance()));
        this.parasiticPanel.setVisible(false);
    }

    @Override
    public void term() {
        ParasiticTool.setMaxDistance(Double.parseDouble(this.maxDistValue.getText()));
        boolean b = this.verboseNaming.isSelected();
        if (b != Simulation.isParasiticsUseVerboseNaming()) {
            Simulation.setParasiticsUseVerboseNaming(b);
        }
        if ((b = this.backannotateLayout.isSelected()) != Simulation.isParasiticsBackAnnotateLayout()) {
            Simulation.setParasiticsBackAnnotateLayout(b);
        }
        if ((b = this.extractPowerGround.isSelected()) != Simulation.isParasiticsExtractPowerGround()) {
            Simulation.setParasiticsExtractPowerGround(b);
        }
        if ((b = this.useExemptedNetsFile.isSelected()) != Simulation.isParasiticsUseExemptedNetsFile()) {
            Simulation.setParasiticsUseExemptedNetsFile(b);
        }
        if ((b = this.ignoreExemptedNets.isSelected()) != Simulation.isParasiticsIgnoreExemptedNets()) {
            Simulation.setParasiticsIgnoreExemptedNets(b);
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.parasiticPanel = new JPanel();
        this.maxDist = new JLabel();
        this.maxDistValue = new JTextField();
        this.simpleParasiticOptions = new JPanel();
        this.verboseNaming = new JCheckBox();
        this.backannotateLayout = new JCheckBox();
        this.extractPowerGround = new JCheckBox();
        this.useExemptedNetsFile = new JCheckBox();
        this.ignoreExemptedNets = new JRadioButton();
        this.extractExemptedNets = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new GridBagLayout());
        this.parasiticPanel.setLayout(new GridBagLayout());
        this.parasiticPanel.setBorder(BorderFactory.createTitledBorder("Parasitic Coupling Options"));
        this.parasiticPanel.setEnabled(false);
        this.maxDist.setText("Maximum distance (lambda)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDist, gridBagConstraints);
        this.maxDistValue.setColumns(6);
        this.maxDistValue.setText("20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDistValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.parasiticPanel, gridBagConstraints);
        this.simpleParasiticOptions.setLayout(new GridBagLayout());
        this.simpleParasiticOptions.setBorder(BorderFactory.createTitledBorder("Simple Parasitic Options"));
        this.verboseNaming.setText("Use Verbose Naming");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.verboseNaming, gridBagConstraints);
        this.backannotateLayout.setText("Back-Annotate Layout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.backannotateLayout, gridBagConstraints);
        this.extractPowerGround.setText("Extract Power/Ground");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractPowerGround, gridBagConstraints);
        this.useExemptedNetsFile.setText("Use exemptedNets.txt file");
        this.useExemptedNetsFile.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ParasiticTab.this.useExemptedNetsFileStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.useExemptedNetsFile, gridBagConstraints);
        this.ignoreExemptedNets.setText("Extract everything except exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.ignoreExemptedNets, gridBagConstraints);
        this.extractExemptedNets.setText("Extract only exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.extractExemptedNets, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.simpleParasiticOptions, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    private void useExemptedNetsFileStateChanged(ChangeEvent evt) {
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
    }

    public static void main(String[] args) {
        new ParasiticTab((Frame)new JFrame(), true).setVisible(true);
    }
}

