/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.user.ncc.ComparisonsPane;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

class ComparisonsTree
extends JTree
implements ActionListener,
TreeSelectionListener {
    public static final int MAX_COMP_NODES = 100;
    public static final int MAX_ZEROS = 100;
    public static final int MAX_CLASSES = 200;
    public static final int MAX_LIST_ELEMENTS = 200;
    public static final int MAX_NAME_LEN = 100;
    private ComparisonsPane parentPane;
    private DefaultMutableTreeNode root;
    private TreeNode rootTreeNode;
    private WireClassNode[][] wireClassNodes;
    protected JPopupMenu popup;
    protected String clipboard;
    private static Border border = BorderFactory.createEmptyBorder();
    private boolean updateInProgress = true;
    private NccGuiInfo[] mismatches;

    protected ComparisonsTree(ComparisonsPane pane, DefaultMutableTreeNode root) {
        super(root);
        this.root = root;
        this.rootTreeNode = (TreeNode)root.getUserObject();
        this.parentPane = pane;
        this.setMinimumSize(new Dimension(0, 0));
        this.setShowsRootHandles(true);
        this.addMouseListener(new TreeMouseAdapter());
        this.addTreeSelectionListener(this);
        this.createPopup();
        this.setCellRenderer(new MyRenderer());
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy Node Title To Clipboard");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
    }

    protected void update(NccGuiInfo[] misms) {
        this.updateInProgress = true;
        this.mismatches = misms;
        this.wireClassNodes = new WireClassNode[misms.length][];
        this.root.removeAllChildren();
        for (int compNdx = 0; compNdx < this.mismatches.length && compNdx < 100; ++compNdx) {
            NccGuiInfo cm = this.mismatches[compNdx];
            String[] titles = cm.getNames();
            String title0 = titles[0].substring(0, titles[0].length() - 5);
            String title1 = titles[1].substring(0, titles[1].length() - 5);
            String title = title1.equals(title0) ? title0 + "{sch,lay}" : titles[0] + " & " + titles[1];
            TreeNode compTreeNode = new TreeNode(this.rootTreeNode, title + " [" + cm.getTotalMismatchCount() + "]", compNdx, -1, 1);
            compTreeNode.setShortName(title);
            DefaultMutableTreeNode compNode = new DefaultMutableTreeNode(compTreeNode);
            this.root.add(compNode);
            int exportMismCount = cm.getValidExportMismatchCount();
            String exportsTitle = null;
            if (exportMismCount > 0) {
                if (exportMismCount > 200) {
                    exportsTitle = "Exports [first 200 of " + exportMismCount + "]";
                    exportMismCount = 200;
                } else if (exportMismCount > 0) {
                    exportsTitle = "Exports [" + exportMismCount + "]";
                }
                compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, exportsTitle, compNdx, -1, 2)));
            }
            boolean isHashChecked = cm.isHashFailuresPrinted();
            int size = cm.getWireRecReports().size() + cm.getPartRecReports().size();
            EquivRecReport[] mismEqRecs = new EquivRecReport[size];
            int i = 0;
            for (EquivRecReport r : cm.getPartRecReports()) {
                mismEqRecs[i++] = r;
            }
            for (EquivRecReport r : cm.getWireRecReports()) {
                mismEqRecs[i++] = r;
            }
            this.parentPane.setMismatchEquivRecs(compNdx, mismEqRecs);
            if (mismEqRecs != null && mismEqRecs.length > 0) {
                this.addPartClasses(compTreeNode, compNdx, compNode, mismEqRecs, isHashChecked);
                this.addWireClasses(compTreeNode, compNdx, compNode, mismEqRecs, isHashChecked);
            }
            int sizeMismCount = cm.getSizeMismatches().size();
            String sizeTitle = null;
            if (sizeMismCount > 200) {
                sizeTitle = "Sizes [first 200 of " + sizeMismCount + "]";
                sizeMismCount = 200;
            } else if (sizeMismCount > 0) {
                sizeTitle = "Sizes [" + sizeMismCount + "]";
            }
            if (sizeMismCount > 0) {
                compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, sizeTitle, compNdx, -1, 7)));
            }
            int exportAssrtCount = cm.getExportAssertionFailures().size();
            String exportAssrtTitle = null;
            if (exportAssrtCount > 200) {
                exportAssrtTitle = "Export Assertions [first 200 of " + exportAssrtCount + "]";
                exportAssrtCount = 200;
            } else if (exportAssrtCount > 0) {
                exportAssrtTitle = "Export Assertions [" + exportAssrtCount + "]";
            }
            if (exportAssrtCount > 0) {
                compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, exportAssrtTitle, compNdx, -1, 8)));
            }
            int exportNetConflictCount = cm.getNetworkExportConflicts().size();
            String exportNetConfTitle = null;
            if (exportNetConflictCount > 200) {
                exportNetConfTitle = "Export/Global Network Conflicts [first 200 of " + exportNetConflictCount + "]";
                exportNetConflictCount = 200;
            } else if (exportNetConflictCount > 0) {
                exportNetConfTitle = "Export/Global Network Conflicts [" + exportNetConflictCount + "]";
            }
            if (exportNetConflictCount > 0) {
                compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, exportNetConfTitle, compNdx, -1, 9)));
            }
            int exportChrConflictCount = cm.getCharactExportConflicts().size();
            String exportChrConfTitle = null;
            if (exportChrConflictCount > 200) {
                exportChrConfTitle = "Export/Global Characteristics Conflicts [first 200 of " + exportChrConflictCount + "]";
                exportChrConflictCount = 200;
            } else if (exportChrConflictCount > 0) {
                exportChrConfTitle = "Export/Global Characteristics Conflicts [" + exportChrConflictCount + "]";
            }
            if (exportChrConflictCount > 0) {
                compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, exportChrConfTitle, compNdx, -1, 10)));
            }
            int unrecPartsCount = cm.getUnrecognizedParts().size();
            String unrecPartsTitle = null;
            if (unrecPartsCount > 200) {
                unrecPartsTitle = "Unrecognized Parts [first 200 of " + unrecPartsCount + "]";
                unrecPartsCount = 200;
            } else if (unrecPartsCount > 0) {
                unrecPartsTitle = "Unrecognized Parts [" + unrecPartsCount + "]";
            }
            if (unrecPartsCount <= 0) continue;
            compNode.add(new DefaultMutableTreeNode(new TreeNode(compTreeNode, unrecPartsTitle, compNdx, -1, 11)));
        }
        this.setRootVisible(true);
        this.updateUI();
        this.expandRow(0);
        this.expandRow(1);
        this.setRootVisible(false);
        this.addSelectionRow(0);
        this.requestFocusInWindow();
        this.updateInProgress = false;
    }

    private void addPartClasses(TreeNode compTreeNode, int compNdx, DefaultMutableTreeNode inode, EquivRecReport[] mismEqRecs, boolean isHashChecked) {
        TreeNode partsNode = new TreeNode(compTreeNode, "Parts ", compNdx, -1, 0);
        DefaultMutableTreeNode parts = new DefaultMutableTreeNode(partsNode);
        inode.add(parts);
        int type = 3;
        int count = 0;
        boolean truncated = false;
        for (int i = 0; i < mismEqRecs.length; ++i) {
            if (!mismEqRecs[i].hasParts()) continue;
            if (++count > 200) {
                truncated = true;
                continue;
            }
            List<String> reasons = mismEqRecs[i].getReasons();
            StringBuffer nodeName = new StringBuffer("#" + count + " [");
            int size = mismEqRecs[i].maxSize();
            if (size > 200) {
                nodeName.append("first 200 of ");
            }
            nodeName.append(size + "]");
            Iterator<String> it = null;
            String reas = null;
            if (!isHashChecked) {
                int ind;
                it = reasons.iterator();
                if (it.hasNext() && (ind = (reas = it.next()).indexOf("type is ")) >= 0) {
                    nodeName.append(": " + reas.substring(ind + 8));
                    reas = null;
                }
                if (it.hasNext() || reas != null) {
                    if (reas == null) {
                        reas = it.next();
                        nodeName.append(", ");
                    } else {
                        nodeName.append(": ");
                    }
                    if (reas.endsWith("different Wires attached")) {
                        int a = reas.indexOf("has ") + 4;
                        int b = reas.indexOf(" different");
                        nodeName.append(reas.substring(a, b) + " Wires attached");
                        reas = null;
                    }
                }
            }
            TreeNode partTreeNode = new TreeNode(compTreeNode, nodeName.toString(), compNdx, i, type);
            partTreeNode.setShortName("Part Class #" + count);
            DefaultMutableTreeNode eclass = new DefaultMutableTreeNode(partTreeNode);
            parts.add(eclass);
            if (isHashChecked) continue;
            if (reasons.size() == 0) {
                eclass.add(new DefaultMutableTreeNode(new TreeNode(partTreeNode, "all Parts are indistinguishable", compNdx, i, 5)));
                continue;
            }
            if (reas != null) {
                eclass.add(new DefaultMutableTreeNode(new TreeNode(partTreeNode, reas, compNdx, i, 5)));
            }
            while (it.hasNext()) {
                eclass.add(new DefaultMutableTreeNode(new TreeNode(partTreeNode, it.next(), compNdx, i, 5)));
            }
        }
        if (count == 0) {
            inode.remove(parts);
        } else {
            StringBuffer buf = new StringBuffer("Parts ");
            if (isHashChecked) {
                buf.append("(hash code) ");
            }
            buf.append("[");
            if (truncated) {
                buf.append("first 200 of ");
            }
            buf.append(count + "]");
            partsNode.setFullName(buf.toString());
        }
    }

    private void addWireClasses(TreeNode compTreeNode, int compNdx, DefaultMutableTreeNode inode, EquivRecReport[] mismEqRecs, boolean isHashChecked) {
        TreeNode wiresNode = new TreeNode(compTreeNode, "Wires ", compNdx, -1, 0);
        DefaultMutableTreeNode wires = new DefaultMutableTreeNode(wiresNode);
        inode.add(wires);
        int type = 4;
        int count = 0;
        boolean truncated = false;
        for (int i = 0; i < mismEqRecs.length; ++i) {
            int j;
            if (mismEqRecs[i].hasParts()) continue;
            if (++count > 200) {
                truncated = true;
                continue;
            }
            TreeNode wireTreeNode = new TreeNode(compTreeNode, "Wire Class #" + count, compNdx, i, type);
            wireTreeNode.setShortName("Wire Class #" + count);
            wireTreeNode.setWireClassNum(count - 1);
            DefaultMutableTreeNode eclass = new DefaultMutableTreeNode(wireTreeNode);
            wires.add(eclass);
            if (isHashChecked) continue;
            String[] reasons = mismEqRecs[i].getReasons().toArray(new String[0]);
            if (reasons.length == 0) {
                eclass.add(new DefaultMutableTreeNode(new TreeNode(wireTreeNode, "all Wires are indistinguishable", compNdx, i, 6)));
            } else if (reasons.length > 1 && reasons[0].startsWith("0") && reasons[1].startsWith("0")) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new TreeNode(wireTreeNode, "0's", compNdx, i, 6));
                eclass.add(node);
                for (j = 0; j < reasons.length && reasons[j].startsWith("0"); ++j) {
                    if (j >= 100) continue;
                    int start = reasons[j].indexOf(" of ");
                    String reason = start >= 0 ? reasons[j].substring(start + 4) : reasons[j];
                    node.add(new DefaultMutableTreeNode(new TreeNode(wireTreeNode, reason, compNdx, i, 6)));
                }
            }
            while (j < reasons.length) {
                eclass.add(new DefaultMutableTreeNode(new TreeNode(wireTreeNode, reasons[j], compNdx, i, 6)));
                ++j;
            }
        }
        if (count == 0) {
            inode.remove(wires);
        } else {
            StringBuffer buf = new StringBuffer("Wires ");
            if (isHashChecked) {
                buf.append("(hash code) ");
            }
            buf.append("[");
            if (truncated) {
                buf.append("first 200 of ");
            }
            buf.append(count + "]");
            wiresNode.setFullName(buf.toString());
            this.wireClassNodes[compNdx] = new WireClassNode[count];
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.clipboard);
        cb.setContents(ss, ss);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = e.getPaths();
        boolean doAdded = false;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                if (e.isAddedPath(j) != doAdded) continue;
                if (paths[j] == null) {
                    this.parentPane.treeSelectionChanged(null, doAdded);
                    continue;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[j].getLastPathComponent();
                this.parentPane.treeSelectionChanged((TreeNode)node.getUserObject(), doAdded);
            }
            doAdded = true;
        }
        this.parentPane.updateRightPane();
    }

    private void createWireClassNodes(TreeNode data, boolean areLeaves) {
        int compNdx = data.compNdx;
        EquivRecReport[] mismEqRecs = this.parentPane.getMismatchEquivRecs(compNdx);
        int count = 0;
        int len = this.wireClassNodes[compNdx].length;
        int maxWidth0 = 0;
        int maxWidth1 = 0;
        int maxWidth2 = 0;
        int height = 0;
        Font font = this.getFont();
        for (int i = (isHashPrinted = this.mismatches[compNdx].isHashFailuresPrinted()) ? 0 : this.mismatches[compNdx].getPartRecReports().size(); i < mismEqRecs.length; ++i) {
            boolean isHashPrinted;
            if (isHashPrinted && mismEqRecs[i].hasParts()) continue;
            if (++count > len) break;
            List<List<NetObjReport>> mism = mismEqRecs[i].getNotMatchedNetObjs();
            JLabel[] labels = new JLabel[4];
            String[] descr = new String[2];
            String instDescr = null;
            for (int cell = 0; cell < 2; ++cell) {
                if (mism.get(cell).size() == 0) {
                    descr[cell] = "{ }";
                    continue;
                }
                if (mism.get(cell).size() <= 0) continue;
                instDescr = mism.get(cell).get(0).instanceDescription();
                descr[cell] = this.createFirstWireOverview(instDescr, mism.get(cell).size() > 1);
            }
            StringBuffer lab3Name = new StringBuffer(24);
            lab3Name.append("[");
            int size = isHashPrinted ? mismEqRecs[i].maxSize() : Math.max(mism.get(0).size(), mism.get(1).size());
            if (size > 200) {
                lab3Name.append("first 200 of ");
            }
            lab3Name.append(size + "]");
            StringBuffer name = new StringBuffer(32);
            labels[0] = new JLabel("#" + count + " : ");
            labels[0].setHorizontalAlignment(4);
            name.append(labels[0].getText() + " ");
            maxWidth0 = Math.max(labels[0].getPreferredSize().width, maxWidth0);
            labels[1] = new JLabel(descr[0]);
            name.append(descr[0] + " ");
            maxWidth1 = Math.max(labels[1].getPreferredSize().width, maxWidth1);
            labels[2] = new JLabel(descr[1]);
            name.append(descr[1] + " ");
            maxWidth2 = Math.max(labels[2].getPreferredSize().width, maxWidth2);
            labels[3] = new JLabel(lab3Name.toString());
            name.append(labels[3].getText());
            for (int j = 0; j < 4; ++j) {
                labels[j].setBorder(border);
                labels[j].setFont(font);
            }
            data.setFullName(name.toString());
            this.wireClassNodes[compNdx][count - 1] = new WireClassNode(labels, areLeaves);
            if (count != 1) continue;
            height = labels[0].getPreferredSize().height;
        }
        if (count > 0) {
            Dimension[] dim = new Dimension[]{new Dimension(maxWidth0, height), new Dimension(maxWidth1 + 10, height), new Dimension(maxWidth2 + 10, height)};
            for (int j = 0; j < count; ++j) {
                this.wireClassNodes[compNdx][j].setTextLabelDimension(dim);
            }
        }
    }

    private String createFirstWireOverview(String instDescr, boolean hasMore) {
        String descr = this.parentPane.cleanNetObjectName(instDescr);
        int ind = descr.indexOf(" in Cell: ");
        if (ind > 0) {
            descr = descr.substring(0, ind).trim();
        }
        if (descr.length() > 100) {
            descr = descr.substring(0, 100) + "...";
        }
        descr = hasMore ? "{ " + descr + ",...}" : "{ " + descr + " }";
        return descr;
    }

    private static class WireClassNode {
        private JPanel treeNodePanel;
        private JPanel textPanel;
        private JLabel iconLabel;
        private JLabel[] textLabels;
        private boolean isLeaf;
        private boolean expanded = false;
        private boolean selected = false;
        private static boolean inited = false;
        private static Color selBackgnd;
        private static Color deselBackgnd;
        private static Color selText;
        private static Color deselText;
        private static Icon leafIcon;
        private static Icon openIcon;
        private static Icon closedIcon;
        private static Border border;

        public WireClassNode(JLabel[] labels, boolean leaf) {
            if (!inited) {
                WireClassNode.init();
            }
            this.textLabels = labels;
            this.isLeaf = leaf;
            this.textPanel = new JPanel(new FlowLayout(0, 0, 0));
            this.textPanel.setBorder(border);
            this.textPanel.setBackground(deselBackgnd);
            for (int j = 0; j < 4; ++j) {
                this.textPanel.add(this.textLabels[j]);
            }
            this.treeNodePanel = new JPanel(new FlowLayout(0, 0, 0));
            this.treeNodePanel.setBorder(border);
            this.treeNodePanel.setBackground(deselBackgnd);
            this.iconLabel = this.isLeaf ? new JLabel(leafIcon) : new JLabel(closedIcon);
            this.iconLabel.setBorder(border);
            this.iconLabel.setText(" ");
            this.treeNodePanel.add(this.iconLabel);
            this.treeNodePanel.add(this.textPanel);
        }

        private static void init() {
            DefaultTreeCellRenderer defCellRenderer = new DefaultTreeCellRenderer();
            selBackgnd = defCellRenderer.getBackgroundSelectionColor();
            deselBackgnd = defCellRenderer.getBackgroundNonSelectionColor();
            selText = defCellRenderer.getTextSelectionColor();
            deselText = defCellRenderer.getTextNonSelectionColor();
            leafIcon = defCellRenderer.getDefaultLeafIcon();
            openIcon = defCellRenderer.getDefaultOpenIcon();
            closedIcon = defCellRenderer.getDefaultClosedIcon();
            inited = true;
        }

        public void select() {
            if (this.selected) {
                return;
            }
            this.textPanel.setBackground(selBackgnd);
            for (int i = 0; i < 4; ++i) {
                this.textLabels[i].setForeground(selText);
            }
            this.selected = true;
        }

        public void deselect() {
            if (!this.selected) {
                return;
            }
            this.textPanel.setBackground(deselBackgnd);
            for (int i = 0; i < 4; ++i) {
                this.textLabels[i].setForeground(deselText);
            }
            this.selected = false;
        }

        public void expand() {
            if (this.isLeaf || this.expanded) {
                return;
            }
            this.iconLabel.setIcon(openIcon);
            this.expanded = true;
        }

        public void collapse() {
            if (this.isLeaf || !this.expanded) {
                return;
            }
            this.iconLabel.setIcon(closedIcon);
            this.expanded = false;
        }

        public void setTextLabelDimension(Dimension[] dim) {
            for (int j = 0; j < dim.length; ++j) {
                this.textLabels[j].setMinimumSize(dim[j]);
                this.textLabels[j].setPreferredSize(dim[j]);
            }
        }

        public JPanel getPanel() {
            return this.treeNodePanel;
        }

        static {
            border = BorderFactory.createEmptyBorder();
        }
    }

    static class TreeNode {
        public static final int TITLE = 0;
        public static final int COMP_TITLE = 1;
        public static final int EXPORTS = 2;
        public static final int PART = 3;
        public static final int WIRE = 4;
        public static final int PARTLEAF = 5;
        public static final int WIRELEAF = 6;
        public static final int SIZES = 7;
        public static final int EXPORT_ASSERTS = 8;
        public static final int EXPORT_NET_CONF = 9;
        public static final int EXPORT_CHR_CONF = 10;
        public static final int UNRECOG_PART = 11;
        public final int compNdx;
        public final int eclass;
        public final int type;
        private TreeNode parent;
        private String fullName;
        private String shortName;
        private int wireClassNum = -1;

        public TreeNode(TreeNode parent, String fullName, int compNdx, int eclass, int type) {
            this.parent = parent;
            this.fullName = fullName;
            this.shortName = fullName;
            this.compNdx = compNdx;
            this.eclass = eclass;
            this.type = type;
        }

        public void setFullName(String n) {
            this.fullName = n;
        }

        public void setShortName(String n) {
            this.shortName = n;
        }

        public void setWireClassNum(int num) {
            if (this.type != 4) {
                return;
            }
            this.wireClassNum = num;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getWireClassNum() {
            return this.wireClassNum;
        }

        public String toString() {
            return this.fullName;
        }
    }

    private class TreeMouseAdapter
    extends MouseAdapter {
        private TreeMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 2 && e.getButton() != 3) {
                return;
            }
            JTree aTree = (JTree)e.getSource();
            if (aTree.getRowForLocation(e.getX(), e.getY()) != -1) {
                TreePath selPath = aTree.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                TreeNode data = (TreeNode)node.getUserObject();
                ComparisonsTree.this.clipboard = data.toString();
                ComparisonsTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNode data = (TreeNode)node.getUserObject();
            int compNdx = data.compNdx;
            int wclass = data.getWireClassNum();
            if (data.type == 4 && !ComparisonsTree.this.updateInProgress && compNdx < ComparisonsTree.this.wireClassNodes.length && ComparisonsTree.this.wireClassNodes[compNdx] != null && wclass < ComparisonsTree.this.wireClassNodes[compNdx].length) {
                if (ComparisonsTree.this.wireClassNodes[compNdx][wclass] == null) {
                    ComparisonsTree.this.createWireClassNodes(data, node.isLeaf());
                }
                if (selected) {
                    ComparisonsTree.this.wireClassNodes[compNdx][wclass].select();
                } else {
                    ComparisonsTree.this.wireClassNodes[compNdx][wclass].deselect();
                }
                if (!node.isLeaf()) {
                    if (expanded) {
                        ComparisonsTree.this.wireClassNodes[compNdx][wclass].expand();
                    } else {
                        ComparisonsTree.this.wireClassNodes[compNdx][wclass].collapse();
                    }
                }
                return ComparisonsTree.this.wireClassNodes[compNdx][wclass].getPanel();
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

