/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DesignRulesPanel
extends JPanel {
    private Technology curTech;
    private JList designRulesFromList;
    private JList designRulesToList;
    private JList designRulesNodeList;
    private DefaultListModel designRulesToModel;
    private DRCRules drRules;
    private boolean designRulesUpdating = false;
    private boolean[] designRulesValidLayers;
    private List<DRCTemplate> wideSpacingRules;
    private Foundry.Type foundry;
    private JPanel bottom;
    private JButton drAddRule;
    private JButton drDeleteRule;
    private JScrollPane drFromList;
    private JLabel drLayerALabel;
    private JTextField drLayerArea;
    private JTextField drLayerAreaRule;
    private JLabel drLayerEALabel;
    private JTextField drLayerEAreaRule;
    private JTextField drLayerEnclosure;
    private JLabel drLayerWLabel;
    private JTextField drLayerWidth;
    private JTextField drLayerWidthRule;
    private JTextField drLengths;
    private JLabel drLengthsLabel;
    private JTextField drMultiUnconnected;
    private JTextField drMultiUnconnectedRule;
    private JTextField drNodeHeight;
    private JScrollPane drNodeList;
    private JTextField drNodeRule;
    private JTextField drNodeWidth;
    private JTextField drNormalConnected;
    private JLabel drNormalConnectedLabel;
    private JTextField drNormalConnectedRule;
    private JTextField drNormalEdge;
    private JLabel drNormalEdgeLabel;
    private JTextField drNormalEdgeRule;
    private JTextField drNormalUnconnected;
    private JLabel drNormalUnconnectedLabel;
    private JTextField drNormalUnconnectedRule;
    private JCheckBox drShowOnlyLinesWithRules;
    private JTextField drSpacings;
    private JComboBox drSpacingsList;
    private JTextField drSpacingsRule;
    private JScrollPane drToList;
    private JTextField drWidths;
    private JLabel drWidthsLabel;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel multiCutNameLabel;
    private JLabel multiCutRuleLabel;
    private JLabel multiCutValueLabel;
    private JSeparator multiSeparator;
    private JLabel normalNameLabel;
    private JLabel normalRuleLabel;
    private JSeparator normalSeparator;
    private JLabel normalValueLabel;
    private JLabel ruleLabel;
    private JLabel toLabel;
    private JPanel top;
    private JLabel valueLabel;
    private JLabel wideNameLabel;
    private JLabel wideRuleLabel;
    private JSeparator wideSeparator;
    private JLabel wideValueLabel;

    public DesignRulesPanel() {
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.drNodeWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.drNodeHeight);
        EDialog.makeTextFieldSelectAllOnTab(this.drNodeRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerWidthRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerArea);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerAreaRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerEAreaRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drLayerEnclosure);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalConnected);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalConnectedRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalUnconnected);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalUnconnectedRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalEdge);
        EDialog.makeTextFieldSelectAllOnTab(this.drNormalEdgeRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drMultiUnconnected);
        EDialog.makeTextFieldSelectAllOnTab(this.drMultiUnconnectedRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drLengths);
        EDialog.makeTextFieldSelectAllOnTab(this.drSpacings);
        EDialog.makeTextFieldSelectAllOnTab(this.drSpacingsRule);
        EDialog.makeTextFieldSelectAllOnTab(this.drWidths);
    }

    public void init(Technology tech, Foundry.Type foun, DRCRules drcR) {
        this.curTech = tech;
        this.foundry = foun;
        this.drRules = drcR;
        if (this.drRules == null) {
            this.drShowOnlyLinesWithRules.setEnabled(false);
            this.drNormalConnected.setEnabled(false);
            this.drNormalConnectedRule.setEnabled(false);
            this.drNormalUnconnected.setEnabled(false);
            this.drNormalUnconnectedRule.setEnabled(false);
            this.drNormalEdge.setEnabled(false);
            this.drNormalEdgeRule.setEnabled(false);
            this.drWidths.setEnabled(false);
            this.drLengths.setEnabled(false);
            this.drSpacings.setEnabled(false);
            this.drMultiUnconnected.setEnabled(false);
            this.drMultiUnconnectedRule.setEnabled(false);
            return;
        }
        int numLayers = this.curTech.getNumLayers();
        this.designRulesValidLayers = new boolean[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            this.designRulesValidLayers[i] = false;
        }
        Iterator<Comparable<PrimitiveNode>> it = this.curTech.getNodes();
        while (it.hasNext()) {
            Technology.NodeLayer[] layers;
            PrimitiveNode np = it.next();
            if (np.isNotUsed()) continue;
            for (Technology.NodeLayer nl : layers = np.getLayers()) {
                Layer layer = nl.getLayer();
                this.designRulesValidLayers[layer.getIndex()] = true;
            }
        }
        it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            Iterator<Layer> lIt = ap.getLayerIterator();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                this.designRulesValidLayers[layer.getIndex()] = true;
            }
        }
        DefaultListModel<String> designRulesNodeModel = new DefaultListModel<String>();
        this.designRulesNodeList = new JList(designRulesNodeModel);
        this.designRulesNodeList.setSelectionMode(0);
        this.drNodeList.setViewportView(this.designRulesNodeList);
        this.designRulesNodeList.clearSelection();
        this.designRulesNodeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesPanel.this.designRulesGetSelectedNode();
            }
        });
        Iterator<PrimitiveNode> it2 = this.curTech.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode np = it2.next();
            designRulesNodeModel.addElement(np.getName());
        }
        this.designRulesNodeList.setSelectedIndex(0);
        DefaultListModel<String> designRulesFromModel = new DefaultListModel<String>();
        this.designRulesFromList = new JList(designRulesFromModel);
        this.designRulesFromList.setSelectionMode(0);
        this.drFromList.setViewportView(this.designRulesFromList);
        this.designRulesFromList.clearSelection();
        this.designRulesFromList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesPanel.this.designRulesGetSelectedLayerLoadDRCToList();
            }
        });
        for (int i = 0; i < this.designRulesValidLayers.length; ++i) {
            if (!this.designRulesValidLayers[i]) continue;
            designRulesFromModel.addElement(this.curTech.getLayer(i).getName());
        }
        this.designRulesFromList.setSelectedIndex(0);
        this.designRulesToModel = new DefaultListModel();
        this.designRulesToList = new JList(this.designRulesToModel);
        this.designRulesToList.setSelectionMode(0);
        this.drToList.setViewportView(this.designRulesToList);
        this.designRulesToList.clearSelection();
        this.designRulesToList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesPanel.this.designRulesShowSelectedLayerRules();
            }
        });
        this.drShowOnlyLinesWithRules.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DesignRulesPanel.this.designRulesGetSelectedLayerLoadDRCToList();
            }
        });
        this.drSpacingsList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesignRulesPanel.this.widePopupChanged(false);
            }
        });
        this.designRulesUpdating = false;
        DRCDocumentListener listener = new DRCDocumentListener(this, this.drNormalConnected, DRCDocType.SPACING);
        this.drNormalConnected.getDocument().addDocumentListener(listener);
        this.drNormalConnectedRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drNormalUnconnected, DRCDocType.SPACING);
        this.drNormalUnconnected.getDocument().addDocumentListener(listener);
        this.drNormalUnconnectedRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drNormalEdge, DRCDocType.SPACING);
        this.drNormalEdge.getDocument().addDocumentListener(listener);
        this.drNormalEdgeRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drLayerWidth, DRCDocType.MINIMUM);
        this.drLayerWidth.getDocument().addDocumentListener(listener);
        this.drLayerWidthRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drLayerArea, DRCDocType.MINIMUM);
        this.drLayerArea.getDocument().addDocumentListener(listener);
        this.drLayerAreaRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drLayerEnclosure, DRCDocType.MINIMUM);
        this.drLayerEnclosure.getDocument().addDocumentListener(listener);
        this.drLayerEAreaRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drSpacings, DRCDocType.SPACING);
        this.drWidths.getDocument().addDocumentListener(listener);
        this.drLengths.getDocument().addDocumentListener(listener);
        this.drSpacingsRule.getDocument().addDocumentListener(listener);
        this.drSpacings.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drMultiUnconnected, DRCDocType.SPACING);
        this.drMultiUnconnected.getDocument().addDocumentListener(listener);
        this.drMultiUnconnectedRule.getDocument().addDocumentListener(listener);
        listener = new DRCDocumentListener(this, this.drNodeWidth, DRCDocType.NODE);
        this.drNodeWidth.getDocument().addDocumentListener(listener);
        this.drNodeHeight.getDocument().addDocumentListener(listener);
        this.drNodeRule.getDocument().addDocumentListener(listener);
        this.designRulesGetSelectedLayerLoadDRCToList();
    }

    private int getLayerFromToIndex() {
        int layer1 = this.designRulesGetSelectedLayer(this.designRulesFromList);
        if (layer1 < 0) {
            return -1;
        }
        int layer2 = this.designRulesGetSelectedLayer(this.designRulesToList);
        if (layer2 < 0) {
            return -1;
        }
        return this.drRules.getRuleIndex(layer1, layer2);
    }

    private void editChangedOnNodeRules(JTextField field) {
        assert (this.drNodeWidth == field || this.drNodeHeight == field || this.drNodeRule == field);
        if (this.designRulesUpdating) {
            return;
        }
        this.designRulesUpdating = true;
        int nodeIndex = this.designRulesNodeList.getSelectedIndex();
        String widthText = this.drNodeWidth.getText().trim();
        String heightText = this.drNodeHeight.getText().trim();
        double width = -1.0;
        double height = -1.0;
        if (widthText.length() > 0 || heightText.length() > 0) {
            width = TextUtils.atof(widthText);
            height = TextUtils.atof(heightText);
        }
        double[] vals = new double[]{width, height};
        DRCTemplate tmp = new DRCTemplate(this.drNodeRule.getText(), DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.NODSIZ, 0.0, 0.0, null, null, vals, -1);
        this.drRules.addRule(nodeIndex, tmp, DRCTemplate.DRCRuleType.NONE, false);
        this.designRulesUpdating = false;
    }

    private void editChangedOnMinRules(JTextField field) {
        if (this.designRulesUpdating) {
            return;
        }
        this.designRulesUpdating = true;
        int layer1 = this.designRulesGetSelectedLayer(this.designRulesFromList);
        if (layer1 < 0) {
            return;
        }
        Layer layer = this.curTech.getLayer(layer1);
        if (field == this.drLayerWidth) {
            String minSizeText = this.drLayerWidth.getText().trim();
            double minSize = TextUtils.atof(minSizeText);
            String minSizeRuleName = this.drLayerWidthRule.getText().trim();
            if (minSizeText.length() > 0 && minSizeRuleName.length() > 0) {
                this.drRules.setMinValue(layer, minSizeRuleName, minSize, DRCTemplate.DRCRuleType.MINWID);
            }
        } else if (field == this.drLayerArea) {
            String minSizeText = this.drLayerArea.getText().trim();
            double minSize = TextUtils.atof(minSizeText);
            String minSizeRuleName = this.drLayerAreaRule.getText().trim();
            if (minSizeText.length() > 0) {
                this.drRules.setMinValue(layer, minSizeRuleName, minSize, DRCTemplate.DRCRuleType.MINAREA);
            }
        } else if (field == this.drLayerEnclosure) {
            String minSizeText = this.drLayerEnclosure.getText().trim();
            double minSize = TextUtils.atof(minSizeText);
            String minSizeRuleName = this.drLayerEAreaRule.getText().trim();
            if (minSizeText.length() > 0) {
                this.drRules.setMinValue(layer, minSizeRuleName, minSize, DRCTemplate.DRCRuleType.MINENCLOSEDAREA);
            }
        } else {
            System.out.println("Invalid field in editChangedOnMinRules");
        }
        this.designRulesUpdating = false;
    }

    private void designRulesEditChanged(JTextField field) {
        int curWid;
        if (this.designRulesUpdating) {
            return;
        }
        this.designRulesUpdating = true;
        int layer1 = this.designRulesGetSelectedLayer(this.designRulesFromList);
        if (layer1 < 0) {
            return;
        }
        int dindex = this.getLayerFromToIndex();
        if (dindex == -1) {
            return;
        }
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>();
        if (field == this.drNormalConnected) {
            double value = TextUtils.atof(this.drNormalConnected.getText());
            list.add(new DRCTemplate(this.drNormalConnectedRule.getText(), this.foundry.getMode(), DRCTemplate.DRCRuleType.CONSPA, 0.0, 0.0, null, null, new double[]{value}, -1));
            this.drRules.setSpacingRules(dindex, list, DRCTemplate.DRCRuleType.SPACING, false);
        } else if (field == this.drNormalUnconnected) {
            double value = TextUtils.atof(this.drNormalUnconnected.getText());
            list.add(new DRCTemplate(this.drNormalUnconnectedRule.getText(), this.foundry.getMode(), DRCTemplate.DRCRuleType.UCONSPA, 0.0, 0.0, null, null, new double[]{value}, -1));
            this.drRules.setSpacingRules(dindex, list, DRCTemplate.DRCRuleType.SPACING, false);
        } else if (field == this.drMultiUnconnected) {
            double value = TextUtils.atof(this.drMultiUnconnected.getText());
            list.add(new DRCTemplate(this.drMultiUnconnectedRule.getText(), this.foundry.getMode(), DRCTemplate.DRCRuleType.UCONSPA2D, 0.0, 0.0, null, null, new double[]{value}, 1));
            this.drRules.setSpacingRules(dindex, list, DRCTemplate.DRCRuleType.UCONSPA2D, false);
        } else if (field == this.drNormalEdge) {
            double value = TextUtils.atof(this.drNormalEdge.getText());
            list.add(new DRCTemplate(this.drNormalEdgeRule.getText(), this.foundry.getMode(), DRCTemplate.DRCRuleType.CONSPA, 0.0, 0.0, null, null, new double[]{value}, -1));
            this.drRules.setSpacingRules(dindex, list, DRCTemplate.DRCRuleType.SPACINGE, false);
        } else if (field == this.drSpacings && (curWid = this.drSpacingsList.getSelectedIndex()) >= 0 && curWid < this.wideSpacingRules.size()) {
            boolean diffN;
            DRCTemplate wr = this.wideSpacingRules.get(curWid);
            double maxW = TextUtils.atof(this.drWidths.getText().trim());
            double minL = TextUtils.atof(this.drLengths.getText().trim());
            double minV = TextUtils.atof(this.drSpacings.getText().trim());
            String newName = this.drSpacingsRule.getText().trim();
            boolean diffW = DBMath.isGreaterThan(maxW, 0.0) && !DBMath.areEquals(wr.maxWidth, maxW);
            boolean diffL = DBMath.isGreaterThan(minL, 0.0) && !DBMath.areEquals(wr.minLength, minL);
            boolean diffV = DBMath.isGreaterThan(minV, 0.0) && !DBMath.areEquals(wr.getValue(0), minV);
            boolean bl = diffN = !wr.ruleName.equals(newName);
            if (diffW || diffL || diffV || diffN) {
                if (diffW) {
                    wr.maxWidth = maxW;
                }
                if (diffL) {
                    wr.minLength = minL;
                }
                if (diffV) {
                    wr.setValue(0, minV);
                }
                if (diffN) {
                    wr.ruleName = newName;
                }
                this.drRules.setSpacingRules(dindex, this.wideSpacingRules, DRCTemplate.DRCRuleType.SPACING, true);
            }
        }
        this.designRulesUpdating = false;
    }

    private void designRulesGetSelectedNode() {
        this.designRulesUpdating = true;
        int nodeIndex = this.designRulesNodeList.getSelectedIndex();
        DRCTemplate nr = this.drRules.getRule(nodeIndex, DRCTemplate.DRCRuleType.NODSIZ);
        this.drNodeWidth.setText("");
        this.drNodeHeight.setText("");
        this.drNodeRule.setText("");
        if (nr != null) {
            this.drNodeWidth.setText(TextUtils.formatDouble(nr.getValue(0)));
            this.drNodeHeight.setText(TextUtils.formatDouble(nr.getValue(1)));
            this.drNodeRule.setText(nr.ruleName);
        }
        this.designRulesUpdating = false;
    }

    private void widePopupChanged(boolean delete) {
        int index = this.drSpacingsList.getSelectedIndex();
        if (index < 0 || index >= this.wideSpacingRules.size()) {
            return;
        }
        this.designRulesUpdating = true;
        DRCTemplate tmp = this.wideSpacingRules.get(index);
        this.drWidths.setText("");
        this.drLengths.setText("");
        this.drSpacingsRule.setText("");
        this.drSpacings.setText("");
        if (delete) {
            this.drRules.deleteRule(index, tmp);
            this.wideSpacingRules.remove(tmp);
            this.drSpacingsList.removeItemAt(index);
            if (this.wideSpacingRules.size() != 0) {
                this.drSpacingsList.setSelectedIndex(0);
            }
        } else {
            if (tmp.maxWidth != 0.0) {
                this.drWidths.setText(Double.toString(tmp.maxWidth));
            }
            if (tmp.minLength != 0.0) {
                this.drLengths.setText(Double.toString(tmp.minLength));
            }
            this.drSpacings.setText(Double.toString(tmp.getValue(0)));
            this.drSpacingsRule.setText(tmp.ruleName);
        }
        this.designRulesUpdating = false;
    }

    private void designRulesGetSelectedLayerLoadDRCToList() {
        Layer layer;
        DRCTemplate lr;
        this.designRulesUpdating = true;
        boolean onlyvalid = this.drShowOnlyLinesWithRules.isSelected();
        int j = this.designRulesGetSelectedLayer(this.designRulesFromList);
        if (j >= 0) {
            this.designRulesToModel.clear();
            int count = 0;
            for (int i = 0; i < this.designRulesValidLayers.length; ++i) {
                int dindex;
                String line;
                if (!this.designRulesValidLayers[i] || (line = this.drMakeToListLine(dindex = this.drRules.getRuleIndex(j, i), i, onlyvalid)).length() == 0) continue;
                this.designRulesToModel.addElement(line);
                ++count;
            }
            if (count > 0) {
                this.designRulesToList.setSelectedIndex(0);
            }
        }
        if ((lr = this.drRules.getMinValue(layer = this.curTech.getLayer(j), DRCTemplate.DRCRuleType.MINWID)) != null) {
            this.drLayerWidth.setText(TextUtils.formatDouble(lr.getValue(0)));
            this.drLayerWidthRule.setText(lr.ruleName);
        } else {
            this.drLayerWidth.setText("");
            this.drLayerWidthRule.setText("");
        }
        lr = this.drRules.getMinValue(layer, DRCTemplate.DRCRuleType.MINAREA);
        if (lr != null) {
            this.drLayerArea.setText(TextUtils.formatDouble(lr.getValue(0)));
            this.drLayerAreaRule.setText(lr.ruleName);
        } else {
            this.drLayerArea.setText("");
            this.drLayerAreaRule.setText("");
        }
        lr = this.drRules.getMinValue(layer, DRCTemplate.DRCRuleType.MINENCLOSEDAREA);
        if (lr != null) {
            this.drLayerEnclosure.setText(TextUtils.formatDouble(lr.getValue(0)));
            this.drLayerEAreaRule.setText(lr.ruleName);
        } else {
            this.drLayerEnclosure.setText("");
            this.drLayerEAreaRule.setText("");
        }
        this.designRulesUpdating = false;
        this.designRulesShowSelectedLayerRules();
    }

    private void designRulesShowSelectedLayerRules() {
        if (this.designRulesUpdating) {
            return;
        }
        this.designRulesUpdating = true;
        this.drNormalConnected.setText("");
        this.drNormalConnectedRule.setText("");
        this.drNormalUnconnected.setText("");
        this.drNormalUnconnectedRule.setText("");
        this.drMultiUnconnected.setText("");
        this.drMultiUnconnectedRule.setText("");
        this.drNormalEdge.setText("");
        this.drNormalEdgeRule.setText("");
        int dindex = this.getLayerFromToIndex();
        if (dindex != -1) {
            List<DRCTemplate> spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACING, false);
            for (DRCTemplate tmp : spacingRules) {
                if (tmp.ruleType == DRCTemplate.DRCRuleType.CONSPA) {
                    this.drNormalConnected.setText(Double.toString(tmp.getValue(0)));
                    this.drNormalConnectedRule.setText(tmp.ruleName);
                    continue;
                }
                if (tmp.ruleType != DRCTemplate.DRCRuleType.UCONSPA) continue;
                this.drNormalUnconnected.setText(Double.toString(tmp.getValue(0)));
                this.drNormalUnconnectedRule.setText(tmp.ruleName);
            }
            spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACING, true);
            Collections.sort(spacingRules, DRCTemplate.templateSort);
            this.wideSpacingRules = new ArrayList<DRCTemplate>();
            this.drSpacingsList.removeAllItems();
            for (DRCTemplate tmp : spacingRules) {
                if (tmp.ruleType != DRCTemplate.DRCRuleType.UCONSPA) continue;
                this.wideSpacingRules.add(tmp);
                this.drSpacingsList.addItem("Rule " + this.wideSpacingRules.size());
            }
            this.designRulesUpdating = true;
            this.drWidths.setText("");
            this.drLengths.setText("");
            this.drSpacingsRule.setText("");
            this.drSpacings.setText("");
            this.designRulesUpdating = false;
            if (this.wideSpacingRules.size() != 0) {
                this.drSpacingsList.setSelectedIndex(0);
            }
            spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.UCONSPA2D, false);
            assert (spacingRules.size() <= 1);
            if (spacingRules.size() == 1) {
                DRCTemplate cutTmp = spacingRules.get(0);
                this.drMultiUnconnected.setText(Double.toString(cutTmp.getValue(0)));
                this.drMultiUnconnectedRule.setText(cutTmp.ruleName);
            }
            spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACINGE, false);
            for (DRCTemplate tmp : spacingRules) {
                this.drNormalEdge.setText(Double.toString(tmp.getValue(0)));
                this.drNormalEdgeRule.setText(tmp.ruleName);
            }
            this.drAddRule.setEnabled(this.drRules.doesAllowMultipleWideRules(dindex));
        }
        this.designRulesUpdating = false;
    }

    private int designRulesGetSelectedLayer(JList theList) {
        int lineNo = theList.getSelectedIndex();
        if (lineNo < 0) {
            return -1;
        }
        String lName = (String)theList.getSelectedValue();
        int termPos = lName.indexOf(" (");
        if (termPos >= 0) {
            lName = lName.substring(0, termPos);
        }
        for (int layer = 0; layer < this.designRulesValidLayers.length; ++layer) {
            if (!lName.equals(this.curTech.getLayer(layer).getName())) continue;
            return layer;
        }
        return -1;
    }

    private String drMakeToListLine(int dindex, int lindex, boolean onlyValid) {
        boolean gotRule = false;
        List<DRCTemplate> spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACING, false);
        for (DRCTemplate tmp : spacingRules) {
            if (!(tmp.getValue(0) > 0.0)) continue;
            gotRule = true;
        }
        spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACING, true);
        for (DRCTemplate tmp : spacingRules) {
            if (!(tmp.getValue(0) > 0.0)) continue;
            gotRule = true;
        }
        spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.UCONSPA2D, false);
        assert (spacingRules.size() <= 1);
        for (DRCTemplate tmp : spacingRules) {
            if (!(tmp.getValue(0) > 0.0)) continue;
            gotRule = true;
        }
        spacingRules = this.drRules.getSpacingRules(dindex, DRCTemplate.DRCRuleType.SPACINGE, false);
        for (DRCTemplate tmp : spacingRules) {
            if (!(tmp.getValue(0) > 0.0)) continue;
            gotRule = true;
        }
        if (onlyValid && !gotRule) {
            return "";
        }
        return this.curTech.getLayer(lindex).getName();
    }

    private void initComponents() {
        this.bottom = new JPanel();
        this.drMultiUnconnectedRule = new JTextField();
        this.drMultiUnconnected = new JTextField();
        this.drNormalEdgeRule = new JTextField();
        this.drNormalEdge = new JTextField();
        this.drNormalUnconnected = new JTextField();
        this.drNormalConnectedRule = new JTextField();
        this.drNormalConnected = new JTextField();
        this.multiCutNameLabel = new JLabel();
        this.drNormalEdgeLabel = new JLabel();
        this.drNormalUnconnectedLabel = new JLabel();
        this.drNormalConnectedLabel = new JLabel();
        this.normalRuleLabel = new JLabel();
        this.normalValueLabel = new JLabel();
        this.normalNameLabel = new JLabel();
        this.drToList = new JScrollPane();
        this.drShowOnlyLinesWithRules = new JCheckBox();
        this.drFromList = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.toLabel = new JLabel();
        this.drWidths = new JTextField();
        this.drLengths = new JTextField();
        this.drSpacings = new JTextField();
        this.drSpacingsRule = new JTextField();
        this.drLengthsLabel = new JLabel();
        this.drWidthsLabel = new JLabel();
        this.drSpacingsList = new JComboBox();
        this.multiSeparator = new JSeparator();
        this.wideSeparator = new JSeparator();
        this.drLayerWLabel = new JLabel();
        this.drLayerWidth = new JTextField();
        this.drLayerWidthRule = new JTextField();
        this.wideNameLabel = new JLabel();
        this.wideValueLabel = new JLabel();
        this.wideRuleLabel = new JLabel();
        this.multiCutValueLabel = new JLabel();
        this.multiCutRuleLabel = new JLabel();
        this.drAddRule = new JButton();
        this.drDeleteRule = new JButton();
        this.drLayerALabel = new JLabel();
        this.drLayerAreaRule = new JTextField();
        this.ruleLabel = new JLabel();
        this.drLayerArea = new JTextField();
        this.normalSeparator = new JSeparator();
        this.valueLabel = new JLabel();
        this.drLayerEALabel = new JLabel();
        this.drLayerEAreaRule = new JTextField();
        this.drLayerEnclosure = new JTextField();
        this.drNormalUnconnectedRule = new JTextField();
        this.top = new JPanel();
        this.drNodeList = new JScrollPane();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.drNodeWidth = new JTextField();
        this.drNodeRule = new JTextField();
        this.drNodeHeight = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setMinimumSize(new Dimension(359, 556));
        this.setPreferredSize(new Dimension(359, 556));
        this.bottom.setLayout(new GridBagLayout());
        this.bottom.setBorder(BorderFactory.createTitledBorder("Layer Rules"));
        this.bottom.setPreferredSize(new Dimension(359, 452));
        this.drMultiUnconnectedRule.setColumns(9);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.bottom.add((Component)this.drMultiUnconnectedRule, gridBagConstraints);
        this.drMultiUnconnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.bottom.add((Component)this.drMultiUnconnected, gridBagConstraints);
        this.drNormalEdgeRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.bottom.add((Component)this.drNormalEdgeRule, gridBagConstraints);
        this.drNormalEdge.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.bottom.add((Component)this.drNormalEdge, gridBagConstraints);
        this.drNormalUnconnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.bottom.add((Component)this.drNormalUnconnected, gridBagConstraints);
        this.drNormalConnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.bottom.add((Component)this.drNormalConnectedRule, gridBagConstraints);
        this.drNormalConnected.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.bottom.add((Component)this.drNormalConnected, gridBagConstraints);
        this.multiCutNameLabel.setText("Multiple via cuts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.multiCutNameLabel, gridBagConstraints);
        this.drNormalEdgeLabel.setText("Edge:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 14, 4, 4);
        this.bottom.add((Component)this.drNormalEdgeLabel, gridBagConstraints);
        this.drNormalUnconnectedLabel.setText("Not connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 14, 0, 4);
        this.bottom.add((Component)this.drNormalUnconnectedLabel, gridBagConstraints);
        this.drNormalConnectedLabel.setText("When connected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 14, 4, 0);
        this.bottom.add((Component)this.drNormalConnectedLabel, gridBagConstraints);
        this.normalRuleLabel.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.normalRuleLabel, gridBagConstraints);
        this.normalValueLabel.setText("Distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.normalValueLabel, gridBagConstraints);
        this.normalNameLabel.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.normalNameLabel, gridBagConstraints);
        this.drToList.setOpaque(false);
        this.drToList.setPreferredSize(new Dimension(100, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drToList, gridBagConstraints);
        this.drShowOnlyLinesWithRules.setText("Show only \"to\" entries with rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drShowOnlyLinesWithRules, gridBagConstraints);
        this.drFromList.setOpaque(false);
        this.drFromList.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drFromList, gridBagConstraints);
        this.jLabel1.setText("From Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.jLabel1, gridBagConstraints);
        this.toLabel.setText("To Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.toLabel, gridBagConstraints);
        this.drWidths.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drWidths, gridBagConstraints);
        this.drLengths.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drLengths, gridBagConstraints);
        this.drSpacings.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.bottom.add((Component)this.drSpacings, gridBagConstraints);
        this.drSpacingsRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.bottom.add((Component)this.drSpacingsRule, gridBagConstraints);
        this.drLengthsLabel.setText("and Length >");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drLengthsLabel, gridBagConstraints);
        this.drWidthsLabel.setText("If Width >");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.drWidthsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bottom.add((Component)this.drSpacingsList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.bottom.add((Component)this.multiSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.bottom.add((Component)this.wideSeparator, gridBagConstraints);
        this.drLayerWLabel.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 14, 0, 0);
        this.bottom.add((Component)this.drLayerWLabel, gridBagConstraints);
        this.drLayerWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.bottom.add((Component)this.drLayerWidth, gridBagConstraints);
        this.drLayerWidthRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bottom.add((Component)this.drLayerWidthRule, gridBagConstraints);
        this.wideNameLabel.setText("Wide rules:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.wideNameLabel, gridBagConstraints);
        this.wideValueLabel.setText("Distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.wideValueLabel, gridBagConstraints);
        this.wideRuleLabel.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.wideRuleLabel, gridBagConstraints);
        this.multiCutValueLabel.setText("Distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.multiCutValueLabel, gridBagConstraints);
        this.multiCutRuleLabel.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.multiCutRuleLabel, gridBagConstraints);
        this.drAddRule.setText("Add Wide Rule");
        this.drAddRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesignRulesPanel.this.drAddRuleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.drAddRule, gridBagConstraints);
        this.drDeleteRule.setText("Delete Wide Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.bottom.add((Component)this.drDeleteRule, gridBagConstraints);
        this.drLayerALabel.setText("Area:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 14, 0, 4);
        this.bottom.add((Component)this.drLayerALabel, gridBagConstraints);
        this.drLayerAreaRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bottom.add((Component)this.drLayerAreaRule, gridBagConstraints);
        this.ruleLabel.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.ruleLabel, gridBagConstraints);
        this.drLayerArea.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.bottom.add((Component)this.drLayerArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.bottom.add((Component)this.normalSeparator, gridBagConstraints);
        this.valueLabel.setText("Min. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottom.add((Component)this.valueLabel, gridBagConstraints);
        this.drLayerEALabel.setText("Enclosure Area:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 14, 0, 4);
        this.bottom.add((Component)this.drLayerEALabel, gridBagConstraints);
        this.drLayerEAreaRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bottom.add((Component)this.drLayerEAreaRule, gridBagConstraints);
        this.drLayerEnclosure.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.bottom.add((Component)this.drLayerEnclosure, gridBagConstraints);
        this.drNormalUnconnectedRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bottom.add((Component)this.drNormalUnconnectedRule, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.bottom, gridBagConstraints);
        this.top.setLayout(new GridBagLayout());
        this.top.setBorder(BorderFactory.createTitledBorder("Node Rules"));
        this.top.setAlignmentX(0.0f);
        this.top.setAlignmentY(0.0f);
        this.top.setPreferredSize(new Dimension(167, 104));
        this.drNodeList.setOpaque(false);
        this.drNodeList.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.drNodeList, gridBagConstraints);
        this.jLabel4.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText("Min. Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Rule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel8, gridBagConstraints);
        this.drNodeWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.drNodeWidth, gridBagConstraints);
        this.drNodeRule.setColumns(9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.drNodeRule, gridBagConstraints);
        this.drNodeHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.drNodeHeight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.top, gridBagConstraints);
    }

    private void drAddRuleActionPerformed(ActionEvent evt) {
        int dindex = this.getLayerFromToIndex();
        if (dindex == -1) {
            return;
        }
        int soFar = this.drSpacingsList.getItemCount();
        double maxW = TextUtils.atof(this.drWidths.getText().trim());
        double minLen = TextUtils.atof(this.drLengths.getText().trim());
        double value = TextUtils.atof(this.drSpacings.getText());
        String ruleText = this.drSpacingsRule.getText();
        if (ruleText.length() > 0 && value > 0.0 && (maxW > 0.0 || minLen > 0.0)) {
            this.drSpacingsList.addItem("Rule " + (soFar + 1));
            DRCTemplate wr = new DRCTemplate(this.drSpacingsRule.getText(), this.foundry.getMode(), DRCTemplate.DRCRuleType.CONSPA, maxW, minLen, null, null, new double[]{value}, -1);
            this.drRules.addRule(dindex, wr, DRCTemplate.DRCRuleType.SPACING, true);
            this.wideSpacingRules.add(wr);
            wr.ruleType = DRCTemplate.DRCRuleType.UCONSPA;
            this.drRules.addRule(dindex, wr, DRCTemplate.DRCRuleType.SPACING, true);
        } else {
            soFar = 0;
        }
        if (this.wideSpacingRules.size() > 0) {
            this.drSpacingsList.setSelectedIndex(soFar);
        }
        this.drAddRule.setEnabled(this.drRules.doesAllowMultipleWideRules(this.getLayerFromToIndex()));
    }

    private static class DRCDocumentListener
    implements DocumentListener {
        private DesignRulesPanel frame;
        private JTextField field;
        private DRCDocType type;

        DRCDocumentListener(DesignRulesPanel dialog, JTextField text, DRCDocType type) {
            this.frame = dialog;
            this.field = text;
            this.type = type;
        }

        private void update() {
            switch (this.type) {
                case NODE: {
                    this.frame.editChangedOnNodeRules(this.field);
                    break;
                }
                case MINIMUM: {
                    this.frame.editChangedOnMinRules(this.field);
                    break;
                }
                case SPACING: {
                    this.frame.designRulesEditChanged(this.field);
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DRCDocType {
        NODE,
        MINIMUM,
        SPACING;

    }
}

