/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class DXFTab
extends ProjSettingsPanel {
    private TextUtils.UnitScale[] scales;
    private Setting artworkDXFLayerSetting = Artwork.tech().findLayer("Graphics").getDXFLayerSetting();
    private Setting dxfScaleSetting = IOTool.getDXFScaleSetting();
    private JPanel dxf;
    private JTextField dxfLayerName;
    private JComboBox dxfScale;
    private JLabel header;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JSeparator jSeparator1;

    public DXFTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.dxfLayerName);
    }

    public JPanel getPanel() {
        return this.dxf;
    }

    public String getName() {
        return "DXF";
    }

    public void init() {
        this.dxfLayerName.setText(this.getString(this.artworkDXFLayerSetting));
        this.scales = TextUtils.UnitScale.getUnitScales();
        for (int i = 0; i < this.scales.length; ++i) {
            this.dxfScale.addItem(this.scales[i].getName() + "Meter");
        }
        this.dxfScale.setSelectedItem(TextUtils.UnitScale.findFromIndex(this.getInt(this.dxfScaleSetting)).getName() + "Meter");
    }

    public void term() {
        this.setString(this.artworkDXFLayerSetting, this.dxfLayerName.getText());
        this.setInt(this.dxfScaleSetting, this.scales[this.dxfScale.getSelectedIndex()].getIndex());
    }

    private void initComponents() {
        this.dxf = new JPanel();
        this.dxfLayerName = new JTextField();
        this.jLabel17 = new JLabel();
        this.dxfScale = new JComboBox();
        this.header = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DXFTab.this.closeDialog(evt);
            }
        });
        this.dxf.setLayout(new GridBagLayout());
        this.dxfLayerName.setColumns(8);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.dxfLayerName, gridBagConstraints);
        this.jLabel17.setText("DXF Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.jLabel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.dxfScale, gridBagConstraints);
        this.header.setText("DXF Input will accpt all of these layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.dxf.add((Component)this.header, gridBagConstraints);
        this.jLabel1.setText("DXF Output will use the first layer in the list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dxf.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.dxf.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText(" (separate layer names with a comma)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 4);
        this.dxf.add((Component)this.jLabel2, gridBagConstraints);
        this.getContentPane().add((Component)this.dxf, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

