/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.MTDRCTool;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTDRCAreaTool
extends MTDRCTool {
    public MTDRCAreaTool(DRC.DRCPreferences dp, Cell c, Consumer<MTDRCTool.MTDRCResult> consumer) {
        super("Design-Rule Area Check " + c, dp, c, consumer);
    }

    @Override
    boolean checkArea() {
        return true;
    }

    static int checkMinArea(Layer theLayer, Cell topC, DRC.ReportInfo rI, DRCRules areaRules, CellLayersContainer cellLayersC, Job job, String msg) {
        DRCTemplate minAreaRule = areaRules.getMinValue(theLayer, DRCTemplate.DRCRuleType.MINAREA);
        DRCTemplate enclosedAreaRule = areaRules.getMinValue(theLayer, DRCTemplate.DRCRuleType.MINENCLOSEDAREA);
        DRCTemplate spaceRule = areaRules.getSpacingRule(theLayer, null, theLayer, null, true, -1, -1.0, -1.0);
        if (minAreaRule == null && enclosedAreaRule == null && spaceRule == null) {
            return 0;
        }
        if (msg != null) {
            System.out.println("Min Area DRC for " + msg + " in thread " + Thread.currentThread().getName());
        }
        LayerAreaEnumerator quickArea = new LayerAreaEnumerator(theLayer, minAreaRule, enclosedAreaRule, spaceRule, topC, rI, GeometryHandler.GHMode.ALGO_SWEEP, cellLayersC, job);
        HierarchyEnumerator.enumerateCell(topC, VarContext.globalContext, (HierarchyEnumerator.Visitor)quickArea);
        return rI.errorLogger.getNumErrors() + rI.errorLogger.getNumWarnings();
    }

    @Override
    public MTDRCTool.MTDRCResult runTaskInternal(Layer theLayer) {
        ErrorLogger errorLogger = DRC.getDRCErrorLogger(true, ", Layer " + theLayer.getName());
        String msg = "Cell " + this.topCell.getName() + " , layer " + theLayer.getName();
        DRC.ReportInfo reportInfo = new DRC.ReportInfo(errorLogger, this.topCell.getTechnology(), this.dp, false);
        Date lastAreaGoodDate = DRC.getLastDRCDateBasedOnBits(this.topCell, false, -1, !reportInfo.inMemory);
        if (DRC.isCellDRCDateGood(this.topCell, lastAreaGoodDate)) {
            System.out.println("The cell seems to be MinArea OK. Should I run the code?");
        }
        int totalNumErrors = MTDRCAreaTool.checkMinArea(theLayer, this.topCell, reportInfo, this.rules, this.cellLayersCon, this, msg);
        HashSet<Cell> goodAreaDRCDate = new HashSet<Cell>();
        HashSet<Cell> cleanAreaDRCDate = new HashSet<Cell>();
        long endTime = System.currentTimeMillis();
        int errorCount = errorLogger.getNumErrors();
        int warnCount = errorLogger.getNumWarnings();
        System.out.println(errorCount + " errors and " + warnCount + " warnings found in " + msg + " (took " + TextUtils.getElapsedTime(endTime - this.startTime) + " in thread " + Thread.currentThread().getName() + ")");
        long accuEndTime = System.currentTimeMillis() - this.globalStartTime;
        System.out.println("Accumulative time " + TextUtils.getElapsedTime(accuEndTime));
        if (totalNumErrors == 0) {
            goodAreaDRCDate.add(this.topCell);
        } else {
            cleanAreaDRCDate.add(this.topCell);
            errorLogger.termLogging(true);
        }
        return new MTDRCTool.MTDRCResult(errorCount, warnCount, !this.checkAbort(), new HashSet<Cell>(), new HashSet<Cell>(), goodAreaDRCDate, cleanAreaDRCDate, null);
    }

    private static class LayerAreaEnumerator
    extends HierarchyEnumerator.Visitor {
        private Layer theLayer;
        private Job job;
        private Map<Cell, GeometryHandlerLayerBucket> cellsMap;
        private Layer.Function.Set thisLayerFunction;
        private GeometryHandler.GHMode mode;
        private Collection<PrimitiveNode> nodesList;
        private Collection<ArcProto> arcsList;
        private CellLayersContainer cellLayersCon;
        private DRCTemplate minAreaRule;
        private DRCTemplate enclosedAreaRule;
        private DRCTemplate spacingRule;
        private DRCTemplate minAreaEnclosedRule;
        private Cell topCell;
        private DRC.ReportInfo reportInfo;

        LayerAreaEnumerator(Layer layer, DRCTemplate minAreaR, DRCTemplate enclosedAreaR, DRCTemplate spaceR, Cell topC, DRC.ReportInfo rI, GeometryHandler.GHMode m, CellLayersContainer cellLayersC, Job j) {
            this.minAreaRule = minAreaR;
            this.enclosedAreaRule = enclosedAreaR;
            this.spacingRule = spaceR;
            this.topCell = topC;
            this.reportInfo = rI;
            this.theLayer = layer;
            this.thisLayerFunction = DRC.getMultiLayersSet(this.theLayer);
            this.mode = m;
            this.cellsMap = new HashMap<Cell, GeometryHandlerLayerBucket>();
            this.nodesList = new ArrayList<PrimitiveNode>();
            this.cellLayersCon = cellLayersC;
            this.job = j;
            this.minAreaEnclosedRule = this.minAreaRule;
            if (this.enclosedAreaRule != null && (this.minAreaRule == null || this.enclosedAreaRule.getValue(0) < this.minAreaRule.getValue(0))) {
                this.minAreaEnclosedRule = this.enclosedAreaRule;
            }
            block0: for (PrimitiveNode node : this.topCell.getTechnology().getNodesCollection()) {
                for (Technology.NodeLayer nLayer : node.getNodeLayers()) {
                    if (!this.thisLayerFunction.contains(nLayer.getLayer().getFunction(), this.theLayer.getFunctionExtras())) continue;
                    this.nodesList.add(node);
                    continue block0;
                }
            }
            this.arcsList = new ArrayList<ArcProto>();
            block2: for (ArcProto ap : this.topCell.getTechnology().getArcsCollection()) {
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    if (ap.getLayer(i) != this.theLayer) continue;
                    this.arcsList.add(ap);
                    continue block2;
                }
            }
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            Set<String> set = this.cellLayersCon.getLayersSet(cell);
            if (set != null && !set.contains(this.theLayer.getName())) {
                return false;
            }
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            if (bucket != null) {
                assert (bucket.merged);
                return false;
            }
            bucket = new GeometryHandlerLayerBucket(this.mode);
            this.cellsMap.put(cell, bucket);
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                boolean notFound;
                ArcInst ai = it.next();
                Network aNet = info.getNetlist().getNetwork(ai, 0);
                if (aNet == null) continue;
                ArcProto ap = ai.getProto();
                boolean bl = notFound = !this.arcsList.contains(ap);
                if (notFound) continue;
                Technology tech = ap.getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, this.thisLayerFunction)) {
                    bucket.addElementLocal(poly, this.theLayer);
                }
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            boolean isTopCell = cell == this.topCell;
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            bucket.mergeGeometry(cell, this.cellsMap);
            if (isTopCell) {
                for (Layer layer : bucket.local.getKeySet()) {
                    this.checkMinAreaLayerWithLoops(bucket.local, this.topCell, layer);
                }
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            boolean notFound;
            if (this.job.checkAbort()) {
                return false;
            }
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            if (ni.isCellInstance()) {
                return true;
            }
            NodeProto np = ni.getProto();
            if (!np.getTechnology().isLayout()) {
                return false;
            }
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(info.getCell());
            AffineTransform trans = ni.rotateOut();
            PrimitiveNode pNp = (PrimitiveNode)np;
            boolean bl = notFound = !this.nodesList.contains(pNp);
            if (notFound) {
                return false;
            }
            Technology tech = pNp.getTechnology();
            for (Poly poly : tech.getShapeOfNode(ni, false, true, this.thisLayerFunction)) {
                poly.roundPoints();
                poly.transform(trans);
                bucket.addElementLocal(poly, this.theLayer);
            }
            return true;
        }

        private int checkMinAreaLayerWithLoops(GeometryHandler merge, Cell cell, Layer layer) {
            if (this.minAreaRule == null && this.enclosedAreaRule == null && this.spacingRule == null) {
                return 0;
            }
            PolySweepMerge m = (PolySweepMerge)merge;
            List<Area> areas = m.getAreas(layer);
            GenMath.MutableInteger errorFound = new GenMath.MutableInteger(0);
            for (Area area : areas) {
                List<PolyBase> list = PolyBase.getLoopsFromArea(area, layer);
                boolean minPass = true;
                for (PolyBase p : list) {
                    double a = p.getArea();
                    boolean bl = this.minAreaEnclosedRule == null ? true : (minPass = a >= this.minAreaEnclosedRule.getValue(0));
                    if (!minPass) break;
                    if (this.spacingRule != null) {
                        Rectangle2D bnd = p.getBounds2D();
                        boolean bl2 = minPass = bnd.getWidth() >= this.spacingRule.getValue(0);
                        if (minPass) {
                            boolean bl3 = minPass = bnd.getHeight() >= this.spacingRule.getValue(1);
                        }
                    }
                    if (minPass) continue;
                    break;
                }
                if (minPass) continue;
                List<PolyBase.PolyBaseTree> roots = PolyBase.getTreesFromLoops(list);
                for (PolyBase.PolyBaseTree obj : roots) {
                    this.traversePolyTree(layer, obj, 0, cell, errorFound);
                }
            }
            return errorFound.intValue();
        }

        private void traversePolyTree(Layer layer, PolyBase.PolyBaseTree obj, int level, Cell cell, GenMath.MutableInteger count) {
            List<PolyBase.PolyBaseTree> sons = obj.getSons();
            for (PolyBase.PolyBaseTree son : sons) {
                this.traversePolyTree(layer, son, level + 1, cell, count);
            }
            boolean minAreaCheck = level % 2 == 0;
            boolean checkMin = false;
            boolean checkNotch = false;
            DRC.DRCErrorType errorType = DRC.DRCErrorType.MINAREAERROR;
            double minVal = 0.0;
            String ruleName = "";
            if (minAreaCheck) {
                if (this.minAreaRule == null) {
                    return;
                }
                minVal = this.minAreaRule.getValue(0);
                ruleName = this.minAreaRule.ruleName;
                checkMin = true;
            } else {
                errorType = DRC.DRCErrorType.ENCLOSEDAREAERROR;
                if (this.enclosedAreaRule != null) {
                    minVal = this.enclosedAreaRule.getValue(0);
                    ruleName = this.enclosedAreaRule.ruleName;
                    checkMin = true;
                }
                checkNotch = this.spacingRule != null;
            }
            PolyBase poly = obj.getPoly();
            if (checkMin) {
                double area = poly.getArea();
                if (!DBMath.isGreaterThan(minVal, area)) {
                    return;
                }
                count.increment();
                DRC.createDRCErrorLogger(this.reportInfo, errorType, null, cell, minVal, area, ruleName, poly, null, layer, null, null, null);
            }
            if (checkNotch) {
                Rectangle2D bnd = poly.getBounds2D();
                if (bnd.getWidth() < this.spacingRule.getValue(0)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.NOTCHERROR, "(X axis)", cell, this.spacingRule.getValue(0), bnd.getWidth(), this.spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
                if (bnd.getHeight() < this.spacingRule.getValue(1)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.reportInfo, DRC.DRCErrorType.NOTCHERROR, "(Y axis)", cell, this.spacingRule.getValue(1), bnd.getHeight(), this.spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeometryHandlerLayerBucket {
        GeometryHandler local;
        boolean merged = false;

        GeometryHandlerLayerBucket(GeometryHandler.GHMode mode) {
            this.local = GeometryHandler.createGeometryHandler(mode, 1);
        }

        void addElementLocal(Poly poly, Layer layer) {
            this.local.add(layer, poly);
        }

        void mergeGeometry(Cell cell, Map<Cell, GeometryHandlerLayerBucket> cellsMap) {
            if (!this.merged) {
                this.merged = true;
                Iterator<NodeInst> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (!ni.isCellInstance()) continue;
                    AffineTransform trans = ni.transformOut();
                    Cell protoCell = (Cell)ni.getProto();
                    GeometryHandlerLayerBucket bucket = cellsMap.get(protoCell);
                    if (bucket == null) continue;
                    this.local.addAll(bucket.local, trans);
                }
                this.local.postProcess(true);
            } else assert (false);
        }
    }
}

