/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.MultiTaskJob;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.CheckCellLayerEnumerator;
import com.sun.electric.tool.drc.DRC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MTDRCTool
extends MultiTaskJob<Layer, MTDRCResult, MTDRCResult> {
    protected DRC.DRCPreferences dp;
    protected Cell topCell;
    protected long globalStartTime;
    protected CellLayersContainer cellLayersCon = new CellLayersContainer();
    protected final boolean printLog = Job.getDebug();
    protected DRCRules rules;

    protected MTDRCTool(String jobName, DRC.DRCPreferences dp, Cell c, Consumer<MTDRCResult> consumer) {
        super(jobName, DRC.getDRCTool(), consumer);
        this.dp = dp;
        this.topCell = c;
        this.rules = this.topCell.getTechnology().getFactoryDesignRules();
    }

    @Override
    public void prepareTasks() {
        Technology tech = this.topCell.getTechnology();
        this.cellLayersCon = new CellLayersContainer();
        CheckCellLayerEnumerator layerCellCheck = new CheckCellLayerEnumerator(this.cellLayersCon);
        HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)layerCellCheck);
        Set<String> layers = this.cellLayersCon.getLayersSet(this.topCell);
        this.globalStartTime = System.currentTimeMillis();
        for (String layerS : layers) {
            Layer layer = tech.findLayer(layerS);
            this.startTask(layer.getName(), layer);
        }
        if (!this.checkArea()) {
            this.startTask("Node Min Size.", null);
        }
    }

    @Override
    public MTDRCResult mergeTaskResults(Map<Layer, MTDRCResult> taskResults) {
        MTDRCResult p;
        int numTE = 0;
        int numTW = 0;
        HashSet<Cell> goodSpacingSet = new HashSet<Cell>();
        HashSet<Cell> goodAreaSet = new HashSet<Cell>();
        HashSet<Cell> cleanSpacingSet = new HashSet<Cell>();
        HashSet<Cell> cleanAreaSet = new HashSet<Cell>();
        boolean runFine = true;
        for (Map.Entry<Layer, MTDRCResult> e : taskResults.entrySet()) {
            p = e.getValue();
            numTE += p.numErrors;
            numTW += p.numWarns;
            if (!p.runfine) {
                runFine = false;
            }
            cleanSpacingSet.addAll(p.cleanSpacingDRCDate);
            cleanAreaSet.addAll(p.cleanAreaDRCDate);
        }
        for (Map.Entry<Layer, MTDRCResult> e : taskResults.entrySet()) {
            p = e.getValue();
            for (Cell c : p.goodSpacingDRCDate) {
                if (cleanSpacingSet.contains(c)) continue;
                goodSpacingSet.add(c);
            }
            for (Cell c : p.goodAreaDRCDate) {
                if (cleanAreaSet.contains(c)) continue;
                goodAreaSet.add(c);
            }
        }
        System.out.println("Finished " + (runFine ? "without" : "with") + " problems.");
        System.out.println("Total DRC Errors: " + numTE);
        System.out.println("Total DRC Warnings: " + numTW);
        long accuEndTime = System.currentTimeMillis() - this.globalStartTime;
        System.out.println("Total Time: " + TextUtils.getElapsedTime(accuEndTime));
        if (runFine) {
            int activeSpacingBits = DRC.getActiveBits(this.topCell.getTechnology(), this.dp);
            DRC.addDRCUpdate(activeSpacingBits, goodSpacingSet, cleanSpacingSet, goodAreaSet, cleanAreaSet, null, this.dp);
        }
        return new MTDRCResult(numTE, numTW, runFine, null, null, null, null, null);
    }

    @Override
    public MTDRCResult runTask(Layer taskKey) {
        if (this.skipLayer(taskKey)) {
            return null;
        }
        return this.runTaskInternal(taskKey);
    }

    abstract MTDRCResult runTaskInternal(Layer var1);

    abstract boolean checkArea();

    static boolean skipLayerInvalidForMinArea(Layer theLayer) {
        return theLayer == null || theLayer.getFunction().isContact();
    }

    boolean skipLayer(Layer theLayer) {
        if (theLayer == null) {
            return false;
        }
        if (theLayer.getFunction().isDiff() && theLayer.getName().toLowerCase().equals("p-active-well")) {
            return true;
        }
        if (theLayer.getFunction().isGatePoly()) {
            return true;
        }
        return this.checkArea() && MTDRCTool.skipLayerInvalidForMinArea(theLayer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MTDRCResult {
        private int numErrors;
        private int numWarns;
        private boolean runfine;
        private HashSet<Cell> goodSpacingDRCDate;
        private HashSet<Cell> goodAreaDRCDate;
        private HashSet<Cell> cleanSpacingDRCDate;
        private HashSet<Cell> cleanAreaDRCDate;

        MTDRCResult(int numE, int numW, boolean notAborted, HashSet<Cell> goodSpacingDRCD, HashSet<Cell> cleanSpacingDRCD, HashSet<Cell> goodAreaDRCD, HashSet<Cell> cleanAreaDRCD, HashMap<Geometric, List<Variable>> newVars) {
            this.numErrors = numE;
            this.numWarns = numW;
            this.runfine = notAborted;
            this.goodSpacingDRCDate = goodSpacingDRCD;
            this.cleanSpacingDRCDate = cleanSpacingDRCD;
            this.goodAreaDRCDate = goodAreaDRCD;
            this.cleanAreaDRCDate = cleanAreaDRCD;
            assert (newVars == null);
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public int getNumWarnings() {
            return this.numWarns;
        }
    }
}

