/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalRouterAnalysis {
    AnalysisRegionResult[][] regionResult;
    AnalysisRouteResult[] routeResult;

    public GlobalRouterAnalysis(int num_hor, int num_vert, int num_segments) {
        this.regionResult = new AnalysisRegionResult[num_hor][num_vert];
        for (int x = 0; x < this.regionResult.length; ++x) {
            for (int y = 0; y < this.regionResult[x].length; ++y) {
                this.regionResult[x][y] = new AnalysisRegionResult();
            }
        }
        this.routeResult = new AnalysisRouteResult[num_segments];
        for (int i = 0; i < this.routeResult.length; ++i) {
            this.routeResult[i] = new AnalysisRouteResult();
        }
    }

    public void analyseGRresult(GlobalRouterV3.RegionToRoute[] regions, List<GlobalRouterV3.RouteToStitch> routes) {
        for (int i = 0; i < regions.length; ++i) {
            int x = i % this.regionResult.length;
            int y = (int)Math.floor(i / this.regionResult.length);
            this.regionResult[x][y].num_segments = regions[y * this.regionResult.length + x].segments_to_route.size();
            for (SegPart sp2 : regions[y * this.regionResult.length + x].segments_to_route) {
                double dx = Math.abs(sp2.segment_part.get((int)(sp2.segment_part.size() - 1)).x - sp2.segment_part.get((int)0).x);
                double dy = Math.abs(sp2.segment_part.get((int)(sp2.segment_part.size() - 1)).y - sp2.segment_part.get((int)0).y);
                this.regionResult[x][y].wire_length += dx + dy;
            }
        }
        for (GlobalRouterV3.RouteToStitch rts : routes) {
            this.routeResult[rts.id].num_corners = 0;
            int part_size = rts.coarse_route.get((int)0).segment_part.size();
            RoutingFrameLeeMoore.ManhattenAlignment last_dir = rts.coarse_route.get((int)0).segment_part.get((int)(part_size - 1)).alignment;
            for (int i = 1; i < rts.coarse_route.size() - 1; ++i) {
                part_size = rts.coarse_route.get((int)i).segment_part.size();
                RoutingFrameLeeMoore.ManhattenAlignment cur_dir = rts.coarse_route.get((int)i).segment_part.get((int)(part_size - 1)).alignment;
                if (cur_dir != last_dir) {
                    ++this.routeResult[rts.id].num_corners;
                }
                last_dir = cur_dir;
            }
            for (SegPart sp3 : rts.coarse_route) {
                double dx = Math.abs(sp3.segment_part.get((int)(sp3.segment_part.size() - 1)).x - sp3.segment_part.get((int)0).x);
                double dy = Math.abs(sp3.segment_part.get((int)(sp3.segment_part.size() - 1)).y - sp3.segment_part.get((int)0).y);
                this.routeResult[rts.id].route_length += dx + dy;
            }
        }
    }

    class AnalysisRouteResult {
        int num_corners;
        double route_length;

        AnalysisRouteResult() {
        }
    }

    class AnalysisRegionResult {
        int num_segments;
        double wire_length;

        AnalysisRegionResult() {
        }
    }
}

