/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class MeasureListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static MeasureListener theOne = new MeasureListener();
    private static double lastMeasuredDistanceX = 0.0;
    private static double lastMeasuredDistanceY = 0.0;
    private static double lastValidMeasuredDistanceX = 0.0;
    private static double lastValidMeasuredDistanceY = 0.0;
    private static boolean measuring = false;
    private static List<Highlight> lastHighlights = new ArrayList<Highlight>();
    private Point2D dbStart;
    private int gridOffX = 0;
    private int gridOffY = 0;
    private Robot robot = null;

    private MeasureListener() {
    }

    public static Dimension2D getLastMeasuredDistance() {
        Dimension2D.Double dim = new Dimension2D.Double(lastValidMeasuredDistanceX, lastValidMeasuredDistanceY);
        return dim;
    }

    private void startMeasure(Point2D dbStart) {
        lastValidMeasuredDistanceX = lastMeasuredDistanceX;
        lastValidMeasuredDistanceY = lastMeasuredDistanceY;
        this.dbStart = dbStart;
        measuring = true;
        lastHighlights.clear();
    }

    private void dragOutMeasure(EditWindow wnd, Point2D dbPoint) {
        if (measuring && this.dbStart != null) {
            Point2D start = this.dbStart;
            Point2D end = dbPoint;
            Highlighter highlighter = wnd.getRulerHighlighter();
            for (Highlight h : lastHighlights) {
                highlighter.remove(h);
            }
            lastHighlights.clear();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            Technology tech = cell.getTechnology();
            if (User.isCadenceMeasurementStyle()) {
                Point stScreen = wnd.databaseToScreen(start);
                Point enScreen = wnd.databaseToScreen(end);
                double dbDist = start.distance(end);
                double screenDist = Math.sqrt((stScreen.x - enScreen.x) * (stScreen.x - enScreen.x) + (stScreen.y - enScreen.y) * (stScreen.y - enScreen.y));
                if (dbDist > 0.0 && screenDist > 0.0) {
                    double dbLargeTickSize = 8.0 / screenDist * dbDist;
                    double dbSmallTickSize = 3.0 / screenDist * dbDist;
                    int lineAngle = DBMath.figureAngle(start, end);
                    int tickAngle = (lineAngle + 900) % 3600;
                    lastHighlights.add(highlighter.addLine(start, end, cell));
                    double tickX = start.getX() + DBMath.cos(tickAngle) * dbLargeTickSize;
                    double tickY = start.getY() + DBMath.sin(tickAngle) * dbLargeTickSize;
                    Point2D.Double tickLocation = new Point2D.Double(tickX, tickY);
                    lastHighlights.add(highlighter.addLine(start, tickLocation, cell));
                    lastHighlights.add(highlighter.addMessage(cell, "0", tickLocation));
                    tickX = end.getX() + DBMath.cos(tickAngle) * dbLargeTickSize;
                    tickY = end.getY() + DBMath.sin(tickAngle) * dbLargeTickSize;
                    tickLocation = new Point2D.Double(tickX, tickY);
                    lastHighlights.add(highlighter.addLine(end, tickLocation, cell));
                    lastHighlights.add(highlighter.addMessage(cell, TextUtils.formatDistance(dbDist, tech), tickLocation));
                    double minorTickDist = Math.min(wnd.getGridXSpacing(), wnd.getGridYSpacing());
                    int numMinorTicks = (int)(dbDist / minorTickDist);
                    while ((double)numMinorTicks >= screenDist / 10.0) {
                        numMinorTicks = (int)(dbDist / (minorTickDist *= 2.0));
                    }
                    for (int i = 1; i <= numMinorTicks; ++i) {
                        double distSoFar = minorTickDist * (double)i;
                        double minorTickX = start.getX() + distSoFar * DBMath.cos(lineAngle);
                        double minorTickY = start.getY() + distSoFar * DBMath.sin(lineAngle);
                        tickX = minorTickX + DBMath.cos(tickAngle) * dbSmallTickSize;
                        tickY = minorTickY + DBMath.sin(tickAngle) * dbSmallTickSize;
                        tickLocation = new Point2D.Double(tickX, tickY);
                        lastHighlights.add(highlighter.addLine(new Point2D.Double(minorTickX, minorTickY), tickLocation, cell));
                        if (!(distSoFar > dbDist - minorTickDist)) {
                            if (i % 5 != 0) continue;
                            lastHighlights.add(highlighter.addMessage(cell, TextUtils.formatDistance(distSoFar, tech), tickLocation));
                            continue;
                        }
                        break;
                    }
                }
            } else {
                lastHighlights.add(highlighter.addMessage(cell, "(" + TextUtils.formatDistance(start.getX(), tech) + "," + TextUtils.formatDistance(start.getY(), tech) + ")", start));
                lastHighlights.add(highlighter.addMessage(cell, "(" + TextUtils.formatDistance(end.getX(), tech) + "," + TextUtils.formatDistance(end.getY(), tech) + ")", end));
                lastHighlights.add(highlighter.addLine(start, end, cell));
                lastMeasuredDistanceX = Math.abs(start.getX() - end.getX());
                lastMeasuredDistanceY = Math.abs(start.getY() - end.getY());
                Point2D.Double center = new Point2D.Double((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0);
                double dist = start.distance(end);
                String show = TextUtils.formatDistance(dist, tech) + " (dX=" + TextUtils.formatDistance(lastMeasuredDistanceX, tech) + " dY=" + TextUtils.formatDistance(lastMeasuredDistanceY, tech) + ")";
                lastHighlights.add(highlighter.addMessage(cell, show, center, 1));
            }
            highlighter.finished();
            wnd.clearDoingAreaDrag();
            wnd.repaint();
        }
    }

    public void reset() {
        WindowFrame wf;
        if (measuring) {
            measuring = false;
        }
        if ((wf = WindowFrame.getCurrentWindowFrame()).getContent() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)wf.getContent();
            Highlighter highlighter = wnd.getRulerHighlighter();
            highlighter.clear();
            highlighter.finished();
            wnd.repaint();
        } else if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            Iterator<Panel> it = ww.getPanels();
            while (it.hasNext()) {
                Panel p = it.next();
                p.clearMeasurements();
            }
        }
    }

    private void finishMeasure(EditWindow wnd) {
        Highlighter highlighter = wnd.getRulerHighlighter();
        if (measuring) {
            for (Highlight h : lastHighlights) {
                highlighter.remove(h);
            }
            lastHighlights.clear();
            measuring = false;
        } else {
            highlighter.clear();
        }
        highlighter.finished();
        wnd.repaint();
    }

    public void mousePressed(MouseEvent evt) {
        boolean ctrl;
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            EditWindow.gridAlign(dbMouse);
            if (this.isLeftMouse(evt)) {
                if (measuring && ctrl && this.dbStart != null) {
                    dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
                }
                this.startMeasure(dbMouse);
            }
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.finishMeasure(wnd);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        boolean ctrl;
        this.gridMouse(evt);
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            if (ctrl && this.dbStart != null) {
                dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
            }
            EditWindow.gridAlign(dbMouse);
            this.dragOutMeasure(wnd, dbMouse);
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.mouseDragged(evt);
    }

    private void gridMouse(MouseEvent evt) {
        if (User.isGridAlignMeasurementCursor() && evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            int mouseX = evt.getX() + this.gridOffX;
            int mouseY = evt.getY() + this.gridOffY;
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            Point2D.Double align = new Point2D.Double(dbMouse.getX(), dbMouse.getY());
            EditWindow.gridAlign(align);
            Point newPos = wnd.databaseToScreen(align);
            this.gridOffX = mouseX - newPos.x;
            this.gridOffY = mouseY - newPos.y;
            try {
                if (this.robot == null) {
                    this.robot = new Robot();
                }
            }
            catch (AWTException e) {
                // empty catch block
            }
            SwingUtilities.convertPointToScreen(newPos, wnd);
            if (this.robot != null) {
                this.robot.mouseMove(newPos.x, newPos.y);
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (chr == 27) {
                this.finishMeasure(wnd);
            }
        }
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return Client.isOSMac() ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint) {
        double xdist = Math.abs(mousePoint.getX() - startPoint.getX());
        double ydist = Math.abs(mousePoint.getY() - startPoint.getY());
        if (ydist > xdist) {
            return new Point2D.Double(startPoint.getX(), mousePoint.getY());
        }
        return new Point2D.Double(mousePoint.getX(), startPoint.getY());
    }
}

