/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ComplexSample;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class HSpiceOut
extends Input<Stimuli> {
    private static final boolean DEBUGCONDITIONS = false;
    private boolean isTRACDCBinary;
    private boolean isTRACDCBinarySwapped;
    private String fileBase;
    private List<String> trFiles;
    private String swExtension;
    private String icExtension;
    private String acExtension;
    private String mtExtension;
    private String paExtension;
    private String[] signalNames;
    private Signal<?>[][] allSignals;
    private String[] sweepNames;
    private int binaryTRACDCSize;
    private int binaryTRACDCPosition;
    private boolean eofReached;
    private byte[] binaryTRACDCBuffer;

    HSpiceOut() {
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        this.trFiles = new ArrayList<String>();
        String fileNameNoPath = TextUtils.getFileNameWithoutExtension(TextUtils.URLtoString(fileURL)) + ".tr";
        String topDirName = TextUtils.getFilePath(fileURL);
        File topDir = new File(topDirName);
        String[] fileList = topDir.list();
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].startsWith(fileNameNoPath)) continue;
            this.trFiles.add(topDirName + fileList[i]);
        }
        Collections.sort(this.trFiles, TextUtils.STRING_NUMBER_ORDER);
        if (this.trFiles.size() > 1) {
            System.out.println("Reading " + this.trFiles.size() + " 'tr' files...");
        }
        this.swExtension = "sw0";
        this.icExtension = "ic0";
        this.acExtension = "ac0";
        this.mtExtension = "mt0";
        this.paExtension = "pa0";
        this.fileBase = fileURL.getFile();
        int dotPos = this.fileBase.lastIndexOf(46);
        if (dotPos > 0) {
            String extension = this.fileBase.substring(dotPos + 1);
            this.fileBase = this.fileBase.substring(0, dotPos);
            if (extension.startsWith("sw") || extension.startsWith("ic") || extension.startsWith("ac") || extension.startsWith("mt") || extension.startsWith("pa")) {
                this.swExtension = "sw" + extension.substring(2);
                this.icExtension = "ic" + extension.substring(2);
                this.acExtension = "ac" + extension.substring(2);
                this.mtExtension = "mt" + extension.substring(2);
                this.paExtension = "pa" + extension.substring(2);
            }
        }
        List<PALine> paList = this.readPAFile(fileURL);
        this.addTRData(sd, paList, fileURL);
        this.addDCData(sd, paList, fileURL);
        this.addACData(sd, paList, fileURL);
        this.addMeasurementData(sd, fileURL);
        return sd;
    }

    private void addMeasurementData(Stimuli sd, URL fileURL) throws IOException {
        List mData;
        String nextLine;
        URL mtURL = null;
        try {
            mtURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.mtExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (mtURL == null) {
            return;
        }
        if (!TextUtils.URLExists(mtURL)) {
            return;
        }
        if (this.openTextInput(mtURL)) {
            return;
        }
        System.out.println("Reading HSpice measurements file: " + mtURL.getFile());
        SignalCollection sc = Stimuli.newSignalCollection(sd, "MEASUREMENTS");
        ArrayList<String> measurementNames = new ArrayList<String>();
        HashMap measurementData = new HashMap();
        String lastLine = null;
        while ((nextLine = lastLine) != null || (nextLine = this.lineReader.readLine()) != null) {
            String mName;
            int i;
            if (nextLine.startsWith("$") || nextLine.startsWith(".")) continue;
            String[] keywords = this.breakMTLine(nextLine, false);
            if (keywords.length == 0) break;
            if (measurementNames.size() == 0) {
                int i2;
                for (i2 = 0; i2 < keywords.length; ++i2) {
                    measurementNames.add(keywords[i2]);
                }
                while ((lastLine = this.lineReader.readLine()) != null) {
                    keywords = this.breakMTLine(lastLine, true);
                    if (keywords.length == 0) {
                        lastLine = null;
                        break;
                    }
                    if (TextUtils.isANumber(keywords[0])) break;
                    for (i2 = 0; i2 < keywords.length; ++i2) {
                        if (keywords[i2].length() <= 0) continue;
                        measurementNames.add(keywords[i2]);
                    }
                }
                for (String mName2 : measurementNames) {
                    measurementData.put(mName2, new ArrayList());
                }
                continue;
            }
            int index = 0;
            for (i = 0; i < keywords.length; ++i) {
                if (keywords[i].length() == 0) continue;
                mName = (String)measurementNames.get(index++);
                mData = (List)measurementData.get(mName);
                mData.add(new Double(TextUtils.atof(keywords[i])));
            }
            while (index < measurementNames.size() && (lastLine = this.lineReader.readLine()) != null && (keywords = this.breakMTLine(lastLine, true)).length != 0) {
                for (i = 0; i < keywords.length; ++i) {
                    if (keywords[i].length() == 0) continue;
                    mName = (String)measurementNames.get(index++);
                    mData = (List)measurementData.get(mName);
                    mData.add(new Double(TextUtils.atof(keywords[i])));
                }
            }
            lastLine = null;
        }
        List argMeas = (List)measurementData.get(measurementNames.get(0));
        double[] time = new double[argMeas.size()];
        for (int i = 0; i < argMeas.size(); ++i) {
            time[i] = (Double)argMeas.get(i);
        }
        ArrayList<MutableSignal<ScalarSample>> measData = new ArrayList<MutableSignal<ScalarSample>>();
        for (String mName : measurementNames) {
            mData = (List)measurementData.get(mName);
            double[] values2 = new double[mData.size()];
            for (int i = 0; i < mData.size(); ++i) {
                values2[i] = (Double)mData.get(i);
            }
            if (mName.equals("alter#")) {
                mName = "alter";
            }
            MutableSignal<ScalarSample> as = ScalarSample.createSignal(sc, sd, mName, null, time, values2);
            measData.add(as);
        }
        this.closeInput();
    }

    private String[] breakMTLine(String line, boolean continuation) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 1;
        while (line.length() > i + 1) {
            int end = i + 17;
            if (end > line.length()) {
                end = line.length();
            }
            while (end < line.length() && line.charAt(end - 1) != ' ') {
                ++end;
            }
            String part = line.substring(i, end).trim();
            if (part.length() > 0) {
                strings.add(part.trim());
            }
            i = end;
        }
        int actualSize = strings.size();
        String[] retVal = new String[actualSize];
        for (int i2 = 0; i2 < actualSize; ++i2) {
            retVal[i2] = (String)strings.get(i2);
        }
        return retVal;
    }

    private void addTRData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        int numFiles = this.trFiles.size();
        for (int i = 0; i < numFiles; ++i) {
            String trFile = this.trFiles.get(i);
            URL trURL = null;
            try {
                trURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), trFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (trURL == null) {
                return;
            }
            if (!TextUtils.URLExists(trURL)) {
                return;
            }
            this.readTRDCACFile(sd, trURL, paList, "TRANS SIGNALS", i, numFiles);
        }
    }

    private void addDCData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL swURL = null;
        try {
            swURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.swExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (swURL != null && TextUtils.URLExists(swURL)) {
            this.readTRDCACFile(sd, swURL, paList, "DC SIGNALS", 0, 1);
            return;
        }
        URL icURL = null;
        try {
            icURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.icExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (icURL != null && TextUtils.URLExists(icURL)) {
            System.out.println("WARNING: Cannot read old DC format file (." + this.icExtension + ")...must provide new format (." + this.swExtension + "): " + this.fileBase + "." + this.icExtension);
            return;
        }
    }

    private void addACData(Stimuli sd, List<PALine> paList, URL fileURL) throws IOException {
        URL acURL = null;
        try {
            acURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.acExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (acURL == null) {
            return;
        }
        if (!TextUtils.URLExists(acURL)) {
            return;
        }
        this.readTRDCACFile(sd, acURL, paList, "AC SIGNALS", 0, 1);
    }

    private List<PALine> readPAFile(URL fileURL) throws IOException {
        String nextLine;
        URL paURL = null;
        try {
            paURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), this.fileBase + "." + this.paExtension);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (paURL == null) {
            return null;
        }
        if (!TextUtils.URLExists(paURL)) {
            return null;
        }
        if (this.openTextInput(paURL)) {
            return null;
        }
        ArrayList<PALine> paList = new ArrayList<PALine>();
        while ((nextLine = this.lineReader.readLine()) != null) {
            String trimLine = nextLine.trim();
            int spacePos = trimLine.indexOf(32);
            if (spacePos <= 0) continue;
            PALine pl = new PALine();
            pl.number = TextUtils.atoi(trimLine, 0, 10);
            pl.string = HSpiceOut.removeLeadingX(trimLine.substring(spacePos + 1).trim());
            paList.add(pl);
        }
        this.closeInput();
        return paList;
    }

    private void readTRDCACFile(Stimuli sd, URL fileURL, List<PALine> paList, String analysisTitle, int fileNum, int numFiles) throws IOException {
        int sweepsThisFile;
        int i;
        int l;
        int j;
        int k;
        int k2;
        int j2;
        SignalCollection sc;
        if (this.openBinaryInput(fileURL)) {
            return;
        }
        this.eofReached = false;
        this.resetBinaryTRACDCReader();
        if (fileNum == 0) {
            sc = Stimuli.newSignalCollection(sd, analysisTitle);
        } else {
            sc = sd.findSignalCollection(analysisTitle);
            if (sc == null) {
                return;
            }
        }
        HSpiceOut.startProgressDialog("HSpice " + analysisTitle + " analysis", fileURL.getFile());
        if (fileNum == 0) {
            System.out.println("Reading HSpice " + analysisTitle + " file: " + fileURL.getFile());
        } else {
            System.out.println("Also reading file: " + fileURL.getFile());
        }
        int nodcnt = this.getHSpiceInt();
        if (!this.isTRACDCBinary) {
            this.closeInput();
            if (this.openTextInput(fileURL)) {
                return;
            }
            this.eofReached = false;
            this.resetBinaryTRACDCReader();
            int nodcntTxt = this.getHSpiceInt();
            if (nodcnt != nodcntTxt) {
                System.out.println("WARNING: Binary interpretation saw " + nodcnt + " nodes but text sees " + nodcntTxt);
            }
        }
        int numnoi = this.getHSpiceInt();
        int cndcnt = this.getHSpiceInt();
        StringBuffer line = new StringBuffer();
        for (int j3 = 0; j3 < 4; ++j3) {
            line.append((char)this.getByteFromFile());
        }
        int multiplier = TextUtils.atoi(line.toString(), 0, 10);
        int numSignals = numnoi + (nodcnt += multiplier * 10000) - 1;
        if (numSignals <= 0) {
            System.out.println("Error reading " + fileURL.getFile());
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        int version = this.getHSpiceInt();
        if (version != 9007 && version != 9601) {
            System.out.println("Warning: may not be able to read HSpice files of type " + version);
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 76; ++j2) {
            k2 = this.getByteFromFile();
            line.append((char)k2);
            if (this.isTRACDCBinary || k2 != 10 && k2 != 13) continue;
            --j2;
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 16; ++j2) {
            line.append((char)this.getByteFromFile());
        }
        line = new StringBuffer();
        for (j2 = 0; j2 < 72; ++j2) {
            k2 = this.getByteFromFile();
            line.append((char)k2);
            if (this.isTRACDCBinary || k2 != 10 && k2 != 13) continue;
            --j2;
        }
        int sweepcnt = this.getHSpiceInt();
        if (cndcnt == 0) {
            sweepcnt = 0;
        }
        line = new StringBuffer();
        for (int j4 = 0; j4 < 76; ++j4) {
            k = this.getByteFromFile();
            line.append((char)k);
            if (this.isTRACDCBinary || k != 10 && k != 13) continue;
            --j4;
        }
        if (fileNum == 0) {
            this.signalNames = new String[numSignals];
        } else if (numSignals != this.signalNames.length) {
            System.out.println("Error: file " + fileURL.getFile() + " has " + numSignals + " in it, but previous files have " + this.signalNames.length);
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        int[] signalTypes = new int[numSignals];
        for (k = 0; k <= numSignals; ++k) {
            line = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                int l2 = this.getByteFromFile();
                line.append((char)l2);
                if (this.isTRACDCBinary || l2 != 10 && l2 != 13) continue;
                --j;
            }
            if (k == 0) continue;
            int l3 = k - nodcnt;
            if (k < nodcnt) {
                l3 = k + numnoi - 1;
            }
            String lineStr = line.toString().trim();
            signalTypes[l3] = TextUtils.atoi(lineStr, 0, 10);
        }
        boolean paMissingWarned = false;
        for (int k3 = 0; k3 <= numSignals; ++k3) {
            line = new StringBuffer();
            while (true) {
                int l4;
                if ((l4 = this.getByteFromFile()) == 10 || l4 == 13) {
                    continue;
                }
                if (l4 == 32) {
                    if (line.length() == 0) {
                        while ((l4 = this.getByteFromFile()) == 32) {
                        }
                    }
                    break;
                }
                line.append((char)l4);
                if (version == 9007 && line.length() >= 16) break;
            }
            int j5 = line.length();
            l = (j5 + 16) / 16 * 16 - 1;
            if (version == 9007) {
                l = (j5 + 15) / 16 * 16 - 1;
            }
            while (j5 < l) {
                i = this.getByteFromFile();
                if (!(this.isTRACDCBinary || i != 10 && i != 13)) {
                    --j5;
                }
                ++j5;
            }
            if (k3 == 0) continue;
            int startPos = 0;
            int openPos = line.indexOf("(");
            if (openPos >= 0) {
                startPos = openPos + 1;
            }
            for (j5 = startPos; j5 < line.length() && line.charAt(j5) != ':' && TextUtils.isDigit(line.charAt(j5)); ++j5) {
            }
            if (j5 < line.length() && line.charAt(j5) == ':') {
                l = TextUtils.atoi(line.toString().substring(startPos), 0, 10);
                PALine foundPALine = null;
                if (paList == null) {
                    if (!paMissingWarned) {
                        System.out.println("Warning: there should be a ." + this.paExtension + " file with extra signal names");
                    }
                    paMissingWarned = true;
                } else {
                    for (PALine paLine : paList) {
                        if (paLine.number != l) continue;
                        foundPALine = paLine;
                        break;
                    }
                }
                if (foundPALine != null) {
                    StringBuffer newSB = new StringBuffer();
                    newSB.append(line.substring(0, startPos));
                    newSB.append(foundPALine.string);
                    newSB.append(line.substring(j5 + 1));
                    line = newSB;
                }
            } else if (line.indexOf(".") >= 0) {
                String fixedLine = HSpiceOut.removeLeadingX(line.toString());
                line = new StringBuffer();
                line.append(fixedLine);
            }
            openPos = line.indexOf("(");
            if (openPos >= 0) {
                StringBuffer newSB;
                String parenPrefix = line.substring(0, openPos + 1);
                int lastDot = line.lastIndexOf(".");
                if (lastDot >= 0) {
                    newSB = new StringBuffer();
                    if (parenPrefix.equalsIgnoreCase("v(") && line.charAt(line.length() - 1) == ')') {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(line.substring(lastDot + 1, line.length() - 1));
                    } else {
                        newSB.append(line.substring(openPos + 1, lastDot + 1));
                        newSB.append(parenPrefix);
                        newSB.append(line.substring(lastDot + 1));
                    }
                    line = newSB;
                } else if (parenPrefix.equalsIgnoreCase("v(") && line.charAt(line.length() - 1) == ')') {
                    newSB = new StringBuffer();
                    newSB.append(line.substring(openPos + 1, line.length() - 1));
                    line = newSB;
                }
            }
            l = k3 < nodcnt ? k3 + numnoi - 1 : k3 - nodcnt;
            String sigName = line.toString();
            if (fileNum == 0) {
                this.signalNames[l] = sigName;
                continue;
            }
            if (sigName.equals(this.signalNames[l])) continue;
            System.out.println("Error: file " + fileURL.getFile() + " signal " + (l + 1) + " is '" + sigName + "', but previous files call that signal '" + this.signalNames[l] + "'");
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        for (int c = 0; c < cndcnt; ++c) {
            int j6 = 0;
            line = new StringBuffer();
            while (true) {
                if ((l = this.getByteFromFile()) == 10 || l == 13) {
                    continue;
                }
                if (l == 32) break;
                line.append((char)l);
                if (++j6 >= 16) break;
            }
            l = (j6 + 15) / 16 * 16 - 1;
            while (j6 < l) {
                i = this.getByteFromFile();
                if (!(this.isTRACDCBinary || i != 10 && i != 13)) {
                    --j6;
                }
                ++j6;
            }
        }
        line = new StringBuffer();
        if (!this.isTRACDCBinary) {
            int l5;
            j = 0;
            while ((l5 = this.getByteFromFile()) != 10 && l5 != 13) {
                if (j < 4) {
                    line.append((char)l5);
                }
                ++j;
            }
        } else {
            for (j = 0; j < 4; ++j) {
                line.append((char)this.getByteFromFile());
            }
        }
        if (!line.toString().equals("$&%#")) {
            System.out.println("HSpice header improperly terminated (got " + line.toString() + ")");
            this.closeInput();
            HSpiceOut.stopProgressDialog();
            return;
        }
        this.resetBinaryTRACDCReader();
        String constantPrefix = null;
        boolean hasPrefix = true;
        for (int k4 = 0; k4 < numSignals; ++k4) {
            String name = this.signalNames[k4];
            int dotPos = name.indexOf(46);
            if (dotPos < 0) continue;
            String prefix = name.substring(0, dotPos);
            if (constantPrefix == null) {
                constantPrefix = prefix;
            }
            if (constantPrefix.equals(prefix)) continue;
            hasPrefix = false;
            break;
        }
        if (!hasPrefix) {
            constantPrefix = null;
        } else {
            String fileName = fileURL.getFile();
            int pos = fileName.lastIndexOf(File.separatorChar);
            if (pos >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.lastIndexOf(47)) >= 0) {
                fileName = fileName.substring(pos + 1);
            }
            if ((pos = fileName.indexOf(46)) >= 0) {
                fileName = fileName.substring(0, pos);
            }
            constantPrefix = fileName.equals(constantPrefix) ? constantPrefix + "." : null;
        }
        boolean isComplex = analysisTitle.equals("AC SIGNALS");
        int n = sweepsThisFile = sweepcnt > 0 ? sweepcnt : 1;
        if (fileNum == 0) {
            int sweepTotal = sweepsThisFile * numFiles;
            this.allSignals = new Signal[numSignals][sweepTotal];
            this.sweepNames = new String[sweepTotal];
        }
        int sweepCounter = sweepcnt;
        int sweepIndex = 0;
        while (true) {
            block94: {
                String sweepName = "";
                if (sweepcnt > 0) {
                    float sweepValue = this.getHSpiceFloat(false);
                    if (this.eofReached) {
                        System.out.println("EOF before sweep data");
                        break;
                    }
                    sweepName = TextUtils.formatDouble(sweepValue);
                    for (int i2 = 2; i2 < cndcnt; ++i2) {
                        float anotherSweepValue = this.getHSpiceFloat(false);
                        if (this.eofReached) {
                            System.out.println("EOF reading sweep header");
                            break;
                        }
                        sweepName = sweepName + "," + TextUtils.formatDouble(anotherSweepValue);
                    }
                    this.sweepNames[fileNum * sweepsThisFile + sweepIndex] = (sweepsThisFile > 1 ? "TR" + fileNum + "-" : "") + sweepName;
                } else if (numFiles > 1) {
                    this.sweepNames[fileNum] = fileNum + 1 + "";
                }
                for (int k5 = 0; k5 < numSignals; ++k5) {
                    String name = this.signalNames[k5];
                    if (constantPrefix != null && name.startsWith(constantPrefix)) {
                        name = name.substring(constantPrefix.length());
                    }
                    String context = null;
                    int lastDotPos = name.lastIndexOf(46);
                    if (lastDotPos >= 0) {
                        context = name.substring(0, lastDotPos);
                        name = name.substring(lastDotPos + 1);
                    }
                    if (sweepcnt > 0) {
                        name = name + "[" + sweepName + "]";
                    }
                    SignalCollection scToUse = sc;
                    if (sweepcnt > 0) {
                        scToUse = null;
                    }
                    this.allSignals[k5][fileNum * sweepsThisFile + sweepIndex] = isComplex ? ComplexSample.createComplexSignal(scToUse, sd, name, context) : ScalarSample.createSignal(scToUse, sd, name, context);
                }
                block22: do {
                    float time = this.getHSpiceFloat(true);
                    if (this.eofReached) break block94;
                    for (int k6 = 0; k6 < numSignals; ++k6) {
                        MutableSignal signal;
                        if (isComplex) {
                            signal = (MutableSignal)this.allSignals[(k6 + numnoi) % numSignals][fileNum * sweepsThisFile + sweepIndex];
                            float realPart = this.getHSpiceFloat(false);
                            float imagPart = this.getHSpiceFloat(false);
                            if (signal.getSample(time) == null) {
                                signal.addSample(time, new ComplexSample(realPart, imagPart));
                            }
                        } else {
                            signal = (MutableSignal)this.allSignals[(k6 + numnoi) % numSignals][fileNum * sweepsThisFile + sweepIndex];
                            double val = this.getHSpiceFloat(false);
                            if (signal.getSample(time) == null) {
                                signal.addSample(time, new ScalarSample(val));
                            }
                        }
                        if (!this.eofReached) continue;
                        System.out.println("EOF in the middle of the data (at " + k6 + " out of " + numSignals + ")");
                        continue block22;
                    }
                } while (!this.eofReached);
                System.out.println("EOF before the end of the data");
            }
            if (--sweepCounter <= 0) break;
            ++sweepIndex;
            this.eofReached = false;
        }
        if (sweepcnt > 0 || numFiles > 1 && fileNum == numFiles - 1) {
            for (int k7 = 0; k7 < numSignals; ++k7) {
                String name = this.signalNames[k7];
                if (constantPrefix != null && name.startsWith(constantPrefix)) {
                    name = name.substring(constantPrefix.length());
                }
                String context = null;
                int lastDotPos = name.lastIndexOf(46);
                if (lastDotPos >= 0) {
                    context = name.substring(0, lastDotPos);
                    name = name.substring(lastDotPos + 1);
                }
                int total = 0;
                for (int i3 = 0; i3 < this.allSignals[k7].length; ++i3) {
                    if (this.allSignals[k7][i3] == null) continue;
                    ++total;
                }
                Signal[] signalCopy = new Signal[total];
                int j7 = 0;
                for (int i4 = 0; i4 < this.allSignals[k7].length; ++i4) {
                    if (this.allSignals[k7][i4] == null) continue;
                    signalCopy[j7] = this.allSignals[k7][i4];
                    ++j7;
                }
                if (isComplex) {
                    SweptSample.createSignal(sc, sd, name, context, false, signalCopy);
                    continue;
                }
                SweptSample.createSignal(sc, sd, name, context, false, signalCopy);
            }
            sc.setSweepNames(this.sweepNames);
        }
        this.closeInput();
        HSpiceOut.stopProgressDialog();
        if (fileNum == numFiles - 1) {
            System.out.println("Done reading " + analysisTitle + " analysis");
        }
    }

    private void resetBinaryTRACDCReader() {
        this.binaryTRACDCSize = 0;
        this.binaryTRACDCPosition = 0;
    }

    private boolean readBinaryTRACDCBlock(boolean firstbyteread) throws IOException {
        int amtread;
        int i;
        if (!firstbyteread) {
            if (this.dataInputStream.read() == -1) {
                return true;
            }
            this.updateProgressDialog(1);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(3);
        int blocks = 0;
        for (i = 0; i < 4; ++i) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            blocks = this.isTRACDCBinarySwapped ? blocks >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : blocks << 8 | uval;
        }
        this.updateProgressDialog(4);
        for (i = 0; i < 4; ++i) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int bytes = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            bytes = this.isTRACDCBinarySwapped ? bytes >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : bytes << 8 | uval;
        }
        this.updateProgressDialog(4);
        if (bytes > 8192) {
            System.out.println("ERROR: block is " + bytes + " long, but limit is 8192");
            bytes = 8192;
        }
        if ((amtread = this.dataInputStream.read(this.binaryTRACDCBuffer, 0, bytes)) != bytes) {
            System.out.println("Expected to read " + bytes + " bytes but got only " + amtread);
            return true;
        }
        this.updateProgressDialog(bytes);
        int trailer = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            trailer = this.isTRACDCBinarySwapped ? trailer >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : trailer << 8 | uval;
        }
        if (trailer != bytes) {
            System.out.println("Block trailer claims block had " + trailer + " bytes but block really had " + bytes);
            return true;
        }
        this.updateProgressDialog(4);
        this.binaryTRACDCPosition = 0;
        this.binaryTRACDCSize = bytes;
        return false;
    }

    private int getByteFromFile() throws IOException {
        int i;
        if (this.byteCount == 0L) {
            i = this.dataInputStream.read();
            if (i == -1) {
                return i;
            }
            this.updateProgressDialog(1);
            if (i == 0 || i == 4) {
                this.isTRACDCBinary = true;
                this.isTRACDCBinarySwapped = false;
                if (i == 4) {
                    this.isTRACDCBinarySwapped = true;
                }
                this.binaryTRACDCBuffer = new byte[8192];
                if (this.readBinaryTRACDCBlock(true)) {
                    return -1;
                }
            } else {
                this.isTRACDCBinary = false;
                return i;
            }
        }
        if (this.isTRACDCBinary) {
            if (this.binaryTRACDCPosition >= this.binaryTRACDCSize && this.readBinaryTRACDCBlock(false)) {
                return -1;
            }
            byte val = this.binaryTRACDCBuffer[this.binaryTRACDCPosition];
            ++this.binaryTRACDCPosition;
            return val & 0xFF;
        }
        i = this.dataInputStream.read();
        this.updateProgressDialog(1);
        return i;
    }

    private int getHSpiceInt() throws IOException {
        StringBuffer line = new StringBuffer();
        for (int j = 0; j < 4; ++j) {
            line.append((char)this.getByteFromFile());
        }
        return TextUtils.atoi(line.toString().trim(), 0, 10);
    }

    private float getHSpiceFloat(boolean testEOFValue) throws IOException {
        if (!this.isTRACDCBinary) {
            StringBuffer line = new StringBuffer();
            for (int j = 0; j < 11; ++j) {
                int l = this.getByteFromFile();
                if (l == -1) {
                    this.eofReached = true;
                    return 0.0f;
                }
                line.append((char)l);
                if (l != 10 && l != 13) continue;
                --j;
            }
            String result2 = line.toString();
            if (testEOFValue && result2.equals("0.10000E+31")) {
                this.eofReached = true;
                return 0.0f;
            }
            return (float)TextUtils.atof(result2);
        }
        int fi0 = this.getByteFromFile();
        int fi1 = this.getByteFromFile();
        int fi2 = this.getByteFromFile();
        int fi3 = this.getByteFromFile();
        if (fi0 < 0 || fi1 < 0 || fi2 < 0 || fi3 < 0) {
            this.eofReached = true;
            return 0.0f;
        }
        int fi = 0;
        fi = this.isTRACDCBinarySwapped ? fi3 << 24 | fi2 << 16 | fi1 << 8 | fi0 : (fi0 &= 0xFF) << 24 | (fi1 &= 0xFF) << 16 | (fi2 &= 0xFF) << 8 | (fi3 &= 0xFF);
        float f2 = Float.intBitsToFloat(fi);
        if (testEOFValue && (double)f2 > 1.0E30 && (double)f2 < 1.00000002E30) {
            this.eofReached = true;
            return 0.0f;
        }
        return f2;
    }

    static String removeLeadingX(String name) {
        int dotPos = -1;
        while (name.indexOf(46, dotPos + 1) >= 0) {
            int xPos = dotPos + 1;
            if (name.length() > xPos && name.charAt(xPos) == 'x') {
                name = name.substring(0, xPos) + name.substring(xPos + 1);
            }
            if ((dotPos = name.indexOf(46, xPos)) >= 0) continue;
            break;
        }
        return name;
    }

    private static class PALine {
        int number;
        String string;

        private PALine() {
        }
    }
}

