/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Gerber
extends Output {
    private static final int LEFTDIGITS = 2;
    private static final int RIGHTDIGITS = 5;
    private Map<Layer, List<PolyBase>> cellGeoms;
    private double scaleFactor;
    private double offX;
    private double offY;
    private GerberPreferences localPrefs;

    private Gerber(GerberPreferences hp) {
        this.localPrefs = hp;
    }

    protected void start() {
        this.cellGeoms = new HashMap<Layer, List<PolyBase>>();
    }

    protected void done(Cell cell) {
        this.writeLine("G04 Gerber for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + " *");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.writeLine("G04 Cell created on " + TextUtils.formatDate(cell.getCreationDate()) + " *");
            this.writeLine("G04 Last revised on " + TextUtils.formatDate(cell.getRevisionDate()) + " *");
            this.writeLine("G04 Generated automatically by the Electric VLSI Design System, version " + Version.getVersion() + " *");
            this.writeLine("G04 File written on " + TextUtils.formatDate(new Date()) + " *");
        } else {
            this.writeLine("G04 Generated automatically by the Electric VLSI Design System *");
        }
        this.emitCopyright("G04 ", " *");
        this.writeLine("%ASAXBY*%");
        String numberFormat = "25";
        this.writeLine("%FSLAX" + numberFormat + "Y" + numberFormat + "*%");
        this.writeLine("%MOMM*%");
        this.writeLine("%SFA1.0B1.0*%");
        this.writeLine("%ADD10C,.025*%");
        this.writeLine("G54D10*");
        for (Layer layer : this.cellGeoms.keySet()) {
            List<PolyBase> geoms = this.cellGeoms.get(layer);
            this.writeLine("%LN" + layer.getName() + "*%");
            this.writeLine("%LPD*%");
            for (PolyBase poly : geoms) {
                this.emitPoly(poly);
            }
        }
        this.writeLine("M02*");
    }

    private GerberVisitor makeGerberVisitor() {
        return new GerberVisitor(this);
    }

    private void emitPoly(PolyBase poly) {
        Poly.Type style = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            Rectangle2D box = poly.getBox();
            if (box != null) {
                if (box.getWidth() == 0.0) {
                    if (box.getHeight() != 0.0) {
                        this.emitLine(box.getMinX(), box.getMinY(), box.getMinX(), box.getMaxY());
                    }
                    return;
                }
                if (box.getHeight() == 0.0) {
                    this.emitLine(box.getMinX(), box.getMinY(), box.getMaxX(), box.getMinY());
                    return;
                }
            }
            if (points.length <= 1) {
                return;
            }
            if (points.length == 2) {
                this.emitLine(points[0].getX(), points[0].getY(), points[1].getX(), points[1].getY());
                return;
            }
            this.emitFilledPolygon(points);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            Rectangle2D box = poly.getBox();
            if (box != null) {
                if (box.getHeight() == 0.0) {
                    if (box.getWidth() == 0.0) {
                        this.movePen(box.getMinX(), box.getMinY());
                        this.drawPen(box.getMinX(), box.getMinY());
                    } else {
                        this.movePen(box.getMinX(), box.getMinY());
                        this.drawPen(box.getMaxX(), box.getMinY());
                    }
                    return;
                }
                if (box.getWidth() == 0.0) {
                    this.movePen(box.getMinX(), box.getMinY());
                    this.drawPen(box.getMinX(), box.getMaxY());
                    return;
                }
                this.movePen(box.getMinX(), box.getMinY());
                this.drawPen(box.getMinX(), box.getMaxY());
                this.drawPen(box.getMaxX(), box.getMaxY());
                this.drawPen(box.getMaxX(), box.getMinY());
                if (style == Poly.Type.CLOSED || points.length == 5) {
                    this.drawPen(box.getMinX(), box.getMinY());
                }
                return;
            }
            this.movePen(points[0].getX(), points[0].getY());
            for (int k = 1; k < points.length; ++k) {
                this.drawPen(points[k].getX(), points[k].getY());
            }
            if (style == Poly.Type.CLOSED) {
                this.drawPen(points[0].getX(), points[0].getY());
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int k = 0; k < points.length; k += 2) {
                this.emitLine(points[k].getX(), points[k].getY(), points[k + 1].getX(), points[k + 1].getY());
            }
            return;
        }
        if (style == Poly.Type.CROSS || style == Poly.Type.BIGCROSS) {
            double x2 = poly.getCenterX();
            double y = poly.getCenterY();
            this.emitLine(x2 - 5.0, y, x2 + 5.0, y);
            this.emitLine(x2, y + 5.0, x2, y - 5.0);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            Rectangle2D box = poly.getBounds2D();
            this.emitLine(box.getMinX(), box.getMinY(), box.getMinX(), box.getMaxY());
            this.emitLine(box.getMinX(), box.getMaxY(), box.getMaxX(), box.getMaxY());
            this.emitLine(box.getMaxX(), box.getMaxY(), box.getMaxX(), box.getMinY());
            this.emitLine(box.getMaxX(), box.getMinY(), box.getMinX(), box.getMinY());
            this.emitLine(box.getMaxX(), box.getMaxY(), box.getMinX(), box.getMinY());
            this.emitLine(box.getMaxX(), box.getMinY(), box.getMinX(), box.getMaxY());
            return;
        }
    }

    void emitLine(double x1, double y1, double x2, double y2) {
        this.movePen(x1, y1);
        this.drawPen(x2, y2);
    }

    private void emitFilledPolygon(Point2D[] points) {
        if (points.length <= 1) {
            return;
        }
        this.writeLine("G36*");
        double firstX = points[0].getX();
        double firstY = points[0].getY();
        this.movePen(firstX, firstY);
        for (int i = 1; i < points.length; ++i) {
            this.drawPen(points[i].getX(), points[i].getY());
        }
        int last2 = points.length - 1;
        if (points[last2].getX() != firstX || points[last2].getY() != firstY) {
            this.drawPen(firstX, firstY);
        }
        this.writeLine("G37*");
    }

    private void movePen(double x2, double y) {
        this.writeLine("X" + this.makeXCoord(x2) + "Y" + this.makeYCoord(y) + "D02*");
    }

    private void drawPen(double x2, double y) {
        this.writeLine("X" + this.makeXCoord(x2) + "Y" + this.makeYCoord(y) + "D01*");
    }

    private String makeXCoord(double v) {
        return this.makeCoord(v + this.offX);
    }

    private String makeYCoord(double v) {
        return this.makeCoord(v + this.offY);
    }

    private String makeCoord(double v) {
        String rightStr;
        String leftStr;
        double trueV = v * this.scaleFactor;
        String vStr = trueV + "";
        int dotPos = vStr.indexOf(46);
        if (dotPos < 0) {
            leftStr = vStr;
            rightStr = "";
        } else {
            leftStr = vStr.substring(0, dotPos);
            rightStr = vStr.substring(dotPos + 1);
        }
        while (leftStr.length() < 2) {
            leftStr = "0" + leftStr;
        }
        if (leftStr.length() > 2) {
            System.out.println("WARNING: Cannot represent the value " + vStr + " with just " + 2 + " digits to the left of the decimal point");
            leftStr = leftStr.substring(leftStr.length() - 2);
        }
        while (rightStr.length() < 5) {
            rightStr = rightStr + "0";
        }
        if (rightStr.length() > 5) {
            rightStr = rightStr.substring(0, 5);
        }
        return leftStr + rightStr;
    }

    private void writeLine(String line) {
        this.printWriter.print(line + "\n");
    }

    private class GerberVisitor
    extends HierarchyEnumerator.Visitor {
        private Gerber outGeom;

        GerberVisitor(Gerber outGeom) {
            this.outGeom = outGeom;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform trans = info.getTransformToRoot();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                Technology tech = prim.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni);
                AffineTransform nodeTrans = ni.rotateOut(trans);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    poly.transform(nodeTrans);
                    List<PolyBase> layerList = this.getListForLayer(poly.getLayer());
                    layerList.add(poly);
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    poly.transform(trans);
                    List<PolyBase> layerList = this.getListForLayer(poly.getLayer());
                    layerList.add(poly);
                }
            }
        }

        private List<PolyBase> getListForLayer(Layer layer) {
            ArrayList layerList = (ArrayList)this.outGeom.cellGeoms.get(layer);
            if (layerList == null) {
                layerList = new ArrayList();
                this.outGeom.cellGeoms.put(layer, layerList);
            }
            return layerList;
        }
    }

    public static class GerberPreferences
    extends Output.OutputPreferences {
        public GerberPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Gerber out = new Gerber(this);
            out.scaleFactor = cell.getTechnology().getScale() / 1000000.0;
            ERectangle bounds = cell.getBounds();
            out.offX = -bounds.getMinX();
            out.offY = -bounds.getMinY();
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            GerberVisitor visitor = out.makeGerberVisitor();
            out.start();
            HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
            out.done(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

