/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LESizer2 {
    private LESizer.Alg optimizationAlg;
    private PrintStream out;
    private Job job;
    private LENetlister2 netlist;
    private ErrorLogger errorLogger;

    protected LESizer2(LESizer.Alg alg, LENetlister2 netlist, Job job, ErrorLogger errorLogger) {
        this.optimizationAlg = alg;
        this.netlist = netlist;
        this.job = job;
        this.errorLogger = errorLogger;
        this.out = new PrintStream(System.out);
    }

    protected boolean optimizeLoops(float maxDeltaX, int N, boolean verbose, float alpha, float keeperRatio) {
        float currentLoopDeltaX;
        float lastLoopDeltaX = currentLoopDeltaX = maxDeltaX + 1.0f;
        int divergingIters = 0;
        ElapseTimer timer = ElapseTimer.createInstance();
        int loopcount = 0;
        while (currentLoopDeltaX > maxDeltaX && loopcount < N) {
            if (((LETool.AnalyzeCell)this.job).checkAbort(null)) {
                return false;
            }
            currentLoopDeltaX = 0.0f;
            timer.start();
            System.out.print("  Iteration " + loopcount);
            if (verbose) {
                System.out.println(":");
            }
            Iterator<LENodable> lit = this.netlist.getSizeableNodables();
            while (lit.hasNext()) {
                float deltaX;
                float currentX;
                LENodable loopLeno;
                NodeInst ni;
                String msg;
                LENodable leno = lit.next();
                if (!leno.isLeGate()) continue;
                LENetwork outputNet = leno.outputNetwork;
                ArrayList<LENodable> drivers = new ArrayList<LENodable>();
                ArrayList<LENodable> arrayedDrivers = new ArrayList<LENodable>();
                for (LEPin pin : outputNet.getAllPins()) {
                    if (pin.getDir() != LEPin.Dir.OUTPUT) continue;
                    LENodable loopLeno2 = pin.getInstance();
                    if (leno.getType() == loopLeno2.getType() && leno.parallelGroup == loopLeno2.parallelGroup) {
                        drivers.add(loopLeno2);
                        if (leno.parallelGroup > 0 && loopcount == 0 && leno.su != loopLeno2.su) {
                            msg = "\nError: LEGATE \"" + leno.getName() + "\" drives in parallel with \"" + loopLeno2.getName() + "\" but has a different step-up";
                            System.out.println(msg);
                            ni = leno.getNodable().getNodeInst();
                            if (ni != null) {
                                this.errorLogger.logError(msg, ni, ni.getParent(), leno.context, 0);
                            }
                        }
                    }
                    if (loopLeno2.getNodable().getNodeInst() != leno.getNodable().getNodeInst() || !loopLeno2.context.getInstPath(".").equals(leno.context.getInstPath("."))) continue;
                    arrayedDrivers.add(loopLeno2);
                }
                float newX = 0.0f;
                if (leno.getType() == LENodable.Type.LEKEEPER) {
                    HashMap<String, ArrayList<LENodable>> drivingGroups = new HashMap<String, ArrayList<LENodable>>();
                    float smallestX = 0.0f;
                    for (LEPin pin : outputNet.getAllPins()) {
                        ArrayList<LENodable> groupList;
                        if (pin.getDir() != LEPin.Dir.OUTPUT || (loopLeno = pin.getInstance()).getType() != LENodable.Type.LEGATE && loopLeno.getType() != LENodable.Type.STATICGATE) continue;
                        int i = loopLeno.parallelGroup;
                        Integer integer = new Integer(i);
                        if (i <= 0) {
                            if (smallestX == 0.0f) {
                                smallestX = loopLeno.leX;
                            }
                            if (loopLeno.leX < smallestX) {
                                smallestX = loopLeno.leX;
                            }
                        }
                        if ((groupList = (ArrayList<LENodable>)drivingGroups.get(integer.toString())) == null) {
                            groupList = new ArrayList<LENodable>();
                            drivingGroups.put(integer.toString(), groupList);
                        }
                        groupList.add(loopLeno);
                    }
                    Set keys = drivingGroups.keySet();
                    for (String str : keys) {
                        List groupList = (List)drivingGroups.get(str);
                        if (groupList == null) continue;
                        float sizeX = 0.0f;
                        for (LENodable loopLeno3 : groupList) {
                            sizeX += loopLeno3.leX;
                        }
                        if (smallestX == 0.0f) {
                            smallestX = sizeX;
                        }
                        if (!(sizeX < smallestX)) continue;
                        smallestX = sizeX;
                    }
                    if (!keys.iterator().hasNext() && loopcount == 0) {
                        String msg2 = "\nError: LEKEEPER \"" + leno.getName() + "\" does not fight against any drivers";
                        System.out.println(msg2);
                        NodeInst ni2 = leno.getNodable().getNodeInst();
                        if (ni2 != null) {
                            this.errorLogger.logError(msg2, ni2, ni2.getParent(), leno.context, 0);
                        }
                    }
                    newX = leno.parallelGroup <= 0 ? smallestX * this.netlist.getKeeperRatio() / (float)arrayedDrivers.size() : smallestX * this.netlist.getKeeperRatio() / (float)drivers.size();
                }
                if (leno.getType() == LENodable.Type.LEGATE) {
                    float totalcap = 0.0f;
                    int numLoads = 0;
                    for (LEPin pin : outputNet.getAllPins()) {
                        loopLeno = pin.getInstance();
                        float load = loopLeno.leX * pin.getLE() * loopLeno.getMfactor();
                        if (pin.getDir() == LEPin.Dir.OUTPUT) {
                            load *= alpha;
                        }
                        totalcap += load;
                        if (loopLeno == leno) continue;
                        ++numLoads;
                    }
                    if (numLoads == 0 && loopcount == 0) {
                        msg = "\nError: LEGATE \"" + leno.getName() + "\" has no loads: will be ignored";
                        System.out.println(msg);
                        ni = leno.getNodable().getNodeInst();
                        if (ni != null) {
                            this.errorLogger.logError(msg, ni, ni.getParent(), leno.context, 1);
                        }
                    }
                    if (numLoads == 0) continue;
                    newX = leno.parallelGroup <= 0 ? totalcap / leno.su / (float)arrayedDrivers.size() : totalcap / leno.su / (float)drivers.size();
                    newX /= leno.getMfactor();
                }
                if ((currentX = leno.leX) == 0.0f && newX == 0.0f) {
                    deltaX = 0.0f;
                } else {
                    if (currentX == 0.0f) {
                        currentX = 0.001f;
                    }
                    deltaX = Math.abs((newX - currentX) / currentX);
                }
                float f2 = currentLoopDeltaX = deltaX > currentLoopDeltaX ? deltaX : currentLoopDeltaX;
                if (verbose) {
                    this.out.println("Optimized " + leno.getName() + ": size:  " + TextUtils.formatDouble(leno.leX, 3) + "x ==> " + TextUtils.formatDouble(newX, 3) + "x");
                }
                leno.leX = newX;
            }
            timer.end();
            System.out.println("  ...done (" + timer + "), delta: " + currentLoopDeltaX);
            if (verbose) {
                System.out.println("-----------------------------------");
            }
            ++loopcount;
            if (currentLoopDeltaX >= lastLoopDeltaX) {
                if (divergingIters > 2) {
                    System.out.println("  Sizing diverging, aborting");
                    return false;
                }
                ++divergingIters;
            }
            lastLoopDeltaX = currentLoopDeltaX;
        }
        return true;
    }
}

