/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.BindingInitializer;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Location;
import gnu.mapping.OutPort;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;

    public LetExp(Expression[] expressionArray) {
        this.inits = expressionArray;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression expression) {
        this.body = expression;
    }

    protected boolean mustCompile() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext callContext) throws Throwable {
        Object object2;
        this.setIndexes();
        int n = ScopeExp.nesting(this);
        int n2 = this.frameSize;
        Object[] objectArray = new Object[n2];
        Object[][] objectArray2 = callContext.evalFrames;
        if (objectArray2 == null) {
            callContext.evalFrames = objectArray2 = new Object[n + 10][];
        } else if (n >= objectArray2.length) {
            object2 = new Object[n + 10][];
            System.arraycopy(objectArray2, 0, object2, 0, objectArray2.length);
            callContext.evalFrames = objectArray2 = object2;
        }
        objectArray2[n] = objectArray;
        try {
            n2 = 0;
            object2 = this.firstDecl();
            while (object2 != null) {
                Expression expression = this.inits[n2];
                if (expression != QuoteExp.undefined_exp) {
                    Object object3 = expression.eval(callContext);
                    Type type = ((Declaration)object2).type;
                    if (type != null && type != Type.pointer_type) {
                        object3 = type.coerceFromObject(object3);
                    }
                    if (((Declaration)object2).isIndirectBinding()) {
                        Location location2 = ((Declaration)object2).makeIndirectLocationFor();
                        location2.set(object3);
                        object3 = location2;
                    }
                    objectArray[n2] = object3;
                }
                object2 = ((Declaration)object2).nextDecl();
                ++n2;
            }
            this.body.apply(callContext);
        }
        finally {
            objectArray2[n] = null;
        }
    }

    void store_rest(Compilation compilation, int n, Declaration declaration) {
        if (declaration != null) {
            this.store_rest(compilation, n + 1, declaration.nextDecl());
            if (declaration.needsInit()) {
                if (declaration.isIndirectBinding()) {
                    CodeAttr codeAttr = compilation.getCode();
                    if (this.inits[n] == QuoteExp.undefined_exp) {
                        Object object2 = declaration.getSymbol();
                        compilation.compileConstant(object2, Target.pushObject);
                        codeAttr.emitInvokeStatic(BindingInitializer.makeLocationMethod(object2));
                    } else {
                        declaration.pushIndirectBinding(compilation);
                    }
                }
                declaration.compileStore(compilation);
            }
        }
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Target target2;
            Expression expression = this.inits[n];
            boolean bl = declaration.needsInit();
            if (bl) {
                declaration.allocateVariable(codeAttr);
            }
            if (!bl || declaration.isIndirectBinding() && expression == QuoteExp.undefined_exp) {
                target2 = Target.Ignore;
            } else {
                Type type = declaration.getType();
                target2 = CheckedTarget.getInstance(type);
                if (expression == QuoteExp.undefined_exp) {
                    if (type instanceof PrimType) {
                        expression = new QuoteExp(new Byte(0));
                    } else if (type != null && type != Type.pointer_type) {
                        expression = QuoteExp.nullExp;
                    }
                }
            }
            expression.compileWithPosition(compilation, target2);
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.enterScope(this.getVarScope());
        this.store_rest(compilation, 0, this.firstDecl());
        this.body.compileWithPosition(compilation, target);
        this.popScope(codeAttr);
    }

    public final Type getType() {
        return this.body.getType();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLetExp(this);
    }

    public void walkInitializers(ExpWalker expWalker) {
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Expression expression;
            Expression expression2 = this.inits[n];
            this.inits[n] = expression = expWalker.walk(expression2);
            if (declaration.value == expression2) {
                declaration.value = expression;
            }
            ++n;
            declaration = declaration.nextDecl();
        }
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.walkInitializers(expWalker);
        if (expWalker.exitValue == null) {
            this.body = expWalker.walk(this.body);
        }
    }

    public void print(OutPort outPort) {
        this.print(outPort, "(Let", ")");
    }

    public void print(OutPort outPort, String string, String string2) {
        outPort.startLogicalBlock(string + "#" + this.id, string2, 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.startLogicalBlock("(", false, ")");
        int n = 0;
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (n > 0) {
                outPort.writeSpaceFill();
            }
            outPort.startLogicalBlock("(", false, ")");
            declaration.printInfo(outPort);
            if (this.inits != null) {
                outPort.writeSpaceFill();
                outPort.print('=');
                outPort.writeSpaceFill();
                if (n >= this.inits.length) {
                    outPort.print("<missing init>");
                } else if (this.inits[n] == null) {
                    outPort.print("<null>");
                } else {
                    this.inits[n].print(outPort);
                }
                ++n;
            }
            outPort.endLogicalBlock(")");
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(string2);
    }
}

