/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Location;
import gnu.bytecode.Type;
import gnu.expr.ClassToInfoMap;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ModuleContext;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleManager;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.FieldLocation;
import gnu.mapping.WrappedException;
import gnu.text.Path;
import java.io.IOException;
import java.net.URL;

public class ModuleInfo {
    public String className;
    Class moduleClass;
    static ClassToInfoMap mapClassToInfo = new ClassToInfoMap();
    String uri;
    ModuleExp exp;
    Compilation comp;
    ModuleInfo[] dependencies;
    int numDependencies;
    public String sourcePath;
    Path sourceAbsPath;
    String sourceAbsPathname;
    public long lastCheckedTime;
    public long lastModifiedTime;

    public String getNamespaceUri() {
        return this.uri;
    }

    public void setNamespaceUri(String string) {
        this.uri = string;
    }

    public Compilation getCompilation() {
        return this.comp;
    }

    public void setCompilation(Compilation compilation) {
        ModuleExp moduleExp;
        compilation.minfo = this;
        this.comp = compilation;
        this.exp = moduleExp = compilation.mainLambda;
        if (moduleExp != null) {
            Path path;
            String string;
            this.sourcePath = string = moduleExp.getFileName();
            this.sourceAbsPath = path = ModuleInfo.absPath(string);
        }
    }

    public static Path absPath(String string) {
        return Path.valueOf(string).getCanonical();
    }

    public Path getSourceAbsPath() {
        return this.sourceAbsPath;
    }

    public void setSourceAbsPath(Path path) {
        this.sourceAbsPath = path;
        this.sourceAbsPathname = null;
    }

    public String getSourceAbsPathname() {
        String string = this.sourceAbsPathname;
        if (string == null && this.sourceAbsPath != null) {
            this.sourceAbsPathname = string = this.sourceAbsPath.toString();
        }
        return string;
    }

    public synchronized void addDependency(ModuleInfo moduleInfo) {
        if (this.dependencies == null) {
            this.dependencies = new ModuleInfo[8];
        } else if (this.numDependencies == this.dependencies.length) {
            ModuleInfo[] moduleInfoArray = new ModuleInfo[2 * this.numDependencies];
            System.arraycopy(this.dependencies, 0, moduleInfoArray, 0, this.numDependencies);
            this.dependencies = moduleInfoArray;
        }
        this.dependencies[this.numDependencies++] = moduleInfo;
    }

    public ClassType getClassType() {
        if (this.moduleClass != null) {
            return (ClassType)Type.make(this.moduleClass);
        }
        if (this.comp != null && this.comp.mainClass != null) {
            return this.comp.mainClass;
        }
        return ClassType.make(this.className);
    }

    public synchronized ModuleExp getModuleExp() {
        ModuleExp moduleExp = this.exp;
        if (moduleExp == null) {
            if (this.comp != null) {
                return this.comp.mainLambda;
            }
            ClassType classType = ClassType.make(this.className);
            moduleExp = new ModuleExp();
            moduleExp.type = classType;
            moduleExp.setName(classType.getName());
            moduleExp.flags |= 0x40000;
            moduleExp.info = this;
            this.exp = moduleExp;
        }
        return moduleExp;
    }

    public synchronized ModuleExp setupModuleExp() {
        Object object2;
        ClassType classType;
        Class clazz;
        ModuleExp moduleExp = this.getModuleExp();
        if ((moduleExp.flags & 0x40000) == 0) {
            return moduleExp;
        }
        moduleExp.setFlag(false, 262144);
        if (this.moduleClass != null) {
            clazz = this.moduleClass;
            classType = (ClassType)Type.make(clazz);
        } else {
            classType = ClassType.make(this.className);
            clazz = classType.getReflectClass();
        }
        Object object3 = null;
        Language language = Language.getDefaultLanguage();
        for (object2 = classType.getFields(); object2 != null; object2 = ((Field)object2).getNext()) {
            int n = ((Field)object2).getFlags();
            if ((n & 1) == 0) continue;
            try {
                if ((n & 8) == 0 && object3 == null) {
                    object3 = this.getInstance();
                }
                Object object4 = clazz.getField(((Location)object2).getName()).get(object3);
                Declaration declaration = language.declFromField(moduleExp, object4, (Field)object2);
                if ((n & 0x10) != 0 && (!(object4 instanceof gnu.mapping.Location) || object4 instanceof FieldLocation)) {
                    declaration.noteValue(new QuoteExp(object4));
                    continue;
                }
                declaration.noteValue(null);
                continue;
            }
            catch (Exception exception) {
                throw new WrappedException(exception);
            }
        }
        for (object2 = moduleExp.firstDecl(); object2 != null; object2 = ((Declaration)object2).nextDecl()) {
            ModuleInfo.makeDeclInModule2(moduleExp, (Declaration)object2);
        }
        return moduleExp;
    }

    public Class getModuleClass() throws ClassNotFoundException {
        Class clazz = this.moduleClass;
        if (clazz != null) {
            return clazz;
        }
        this.moduleClass = clazz = ClassType.getContextClass(this.className);
        return clazz;
    }

    public Class getModuleClassRaw() {
        return this.moduleClass;
    }

    public void setModuleClass(Class clazz) {
        this.moduleClass = clazz;
        this.className = clazz.getName();
        mapClassToInfo.put(clazz, this);
    }

    public static ModuleInfo findFromInstance(Object object2) {
        return ModuleContext.getContext().findFromInstance(object2);
    }

    public static ModuleInfo find(ClassType classType) {
        if (classType.isExisting()) {
            try {
                return ModuleManager.findWithClass(classType.getReflectClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ModuleManager.getInstance().findWithClassName(classType.getName());
    }

    public static void register(Object object2) {
        ModuleContext.getContext().setInstance(object2);
    }

    public Object getInstance() {
        return ModuleContext.getContext().findInstance(this);
    }

    public Object getRunInstance() {
        Object object2 = this.getInstance();
        if (object2 instanceof Runnable) {
            ((Runnable)object2).run();
        }
        return object2;
    }

    static void makeDeclInModule2(ModuleExp moduleExp, Declaration declaration) {
        Object object2 = declaration.getConstantValue();
        if (object2 instanceof FieldLocation) {
            FieldLocation fieldLocation = (FieldLocation)object2;
            Declaration declaration2 = fieldLocation.getDeclaration();
            ReferenceExp referenceExp = new ReferenceExp(declaration2);
            declaration.setAlias(true);
            referenceExp.setDontDereference(true);
            referenceExp.setFlag(8);
            declaration.setValue(referenceExp);
            if (declaration2.isProcedureDecl()) {
                declaration.setProcedureDecl(true);
            }
            if (declaration2.getFlag(32768)) {
                declaration.setSyntax();
            }
            if (!declaration.getFlag(2048)) {
                ClassType classType = fieldLocation.getDeclaringClass();
                String string = classType.getName();
                for (Declaration declaration3 = moduleExp.firstDecl(); declaration3 != null; declaration3 = declaration3.nextDecl()) {
                    if (!string.equals(declaration3.getType().getName()) || !declaration3.getFlag(0x40000000)) continue;
                    referenceExp.setContextDecl(declaration3);
                    break;
                }
            }
        }
    }

    public int getState() {
        return this.comp == null ? 14 : this.comp.getState();
    }

    public void loadByStages(int n) {
        int n2 = this.getState();
        if (n2 + 1 >= n) {
            return;
        }
        this.loadByStages(n - 2);
        n2 = this.getState();
        if (n2 >= n) {
            return;
        }
        this.comp.setState(n2 + 1);
        int n3 = this.numDependencies;
        for (int i = 0; i < n3; ++i) {
            ModuleInfo moduleInfo = this.dependencies[i];
            moduleInfo.loadByStages(n);
        }
        n2 = this.getState();
        if (n2 >= n) {
            return;
        }
        this.comp.setState(n2 & 0xFFFFFFFE);
        this.comp.process(n);
    }

    public boolean loadEager(int n) {
        if (this.comp == null && this.className != null) {
            return false;
        }
        int n2 = this.getState();
        if (n2 >= n) {
            return true;
        }
        if ((n2 & 1) != 0) {
            return false;
        }
        this.comp.setState(n2 + 1);
        int n3 = this.numDependencies;
        for (int i = 0; i < n3; ++i) {
            ModuleInfo moduleInfo = this.dependencies[i];
            if (moduleInfo.loadEager(n)) continue;
            if (this.getState() == n2 + 1) {
                this.comp.setState(n2);
            }
            return false;
        }
        if (this.getState() == n2 + 1) {
            this.comp.setState(n2);
        }
        this.comp.process(n);
        return this.getState() == n;
    }

    public void clearClass() {
        this.moduleClass = null;
        this.numDependencies = 0;
        this.dependencies = null;
    }

    public boolean checkCurrent(ModuleManager moduleManager, long l) {
        if (this.sourceAbsPath == null) {
            return true;
        }
        if (this.lastCheckedTime + moduleManager.lastModifiedCacheTime >= l) {
            return this.moduleClass != null || this.comp != null;
        }
        this.lastCheckedTime = l;
        long l2 = this.sourceAbsPath.getLastModified();
        long l3 = this.lastModifiedTime;
        this.lastModifiedTime = l2;
        if (this.moduleClass == null && this.className != null) {
            try {
                this.moduleClass = ClassType.getContextClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        if (l3 == 0L && this.moduleClass != null) {
            URL uRL;
            String string = this.className;
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if ((uRL = this.moduleClass.getResource(string = string + ".class")) != null) {
                try {
                    l3 = uRL.openConnection().getLastModified();
                }
                catch (IOException iOException) {
                    uRL = null;
                }
            }
            if (uRL == null) {
                return true;
            }
        }
        if (this.className == null || l2 > l3) {
            this.moduleClass = null;
            return false;
        }
        int n = this.numDependencies;
        while (--n >= 0) {
            ModuleInfo moduleInfo = this.dependencies[n];
            if (moduleInfo.checkCurrent(moduleManager, l)) continue;
            this.moduleClass = null;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ModuleInfo[");
        if (this.moduleClass != null) {
            stringBuffer.append("class: ");
            stringBuffer.append(this.moduleClass);
        } else if (this.className != null) {
            stringBuffer.append("class-name: ");
            stringBuffer.append(this.className);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

