/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.AbstractHashTable;
import gnu.kawa.util.AbstractWeakHashTable;
import gnu.kawa.util.WeakHashNode;
import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityHashMap<K, V>
extends AbstractHashTable<WeakHashNode<K, V>, K, V> {
    ReferenceQueue<K> rqueue = new ReferenceQueue();

    public WeakIdentityHashMap() {
        super(64);
    }

    public WeakIdentityHashMap(int n) {
        super(n);
    }

    @Override
    protected int getEntryHashCode(WeakHashNode<K, V> weakHashNode) {
        return weakHashNode.hash;
    }

    @Override
    protected WeakHashNode<K, V> getEntryNext(WeakHashNode<K, V> weakHashNode) {
        return weakHashNode.next;
    }

    @Override
    protected void setEntryNext(WeakHashNode<K, V> weakHashNode, WeakHashNode<K, V> weakHashNode2) {
        weakHashNode.next = weakHashNode2;
    }

    @Override
    protected K getEntryKey(WeakHashNode<K, V> weakHashNode) {
        return (K)weakHashNode.get();
    }

    @Override
    protected V getEntryValue(WeakHashNode<K, V> weakHashNode) {
        return weakHashNode.value;
    }

    @Override
    protected void setEntryValue(WeakHashNode<K, V> weakHashNode, V v) {
        weakHashNode.value = v;
    }

    protected WeakHashNode<K, V>[] allocEntries(int n) {
        return new WeakHashNode[n];
    }

    @Override
    public int hash(K k) {
        return System.identityHashCode(k);
    }

    @Override
    protected boolean matches(K k, K k2) {
        return k == k2;
    }

    @Override
    protected WeakHashNode<K, V> makeEntry(K k, int n, V v) {
        WeakHashNode weakHashNode = new WeakHashNode(k, this.rqueue, n);
        weakHashNode.value = v;
        return weakHashNode;
    }

    @Override
    public V get(K k, V v) {
        this.cleanup();
        return super.get(k, v);
    }

    @Override
    public V put(K k, int n, V v) {
        this.cleanup();
        return super.put(k, n, v);
    }

    @Override
    public V remove(K k) {
        this.cleanup();
        return super.remove(k);
    }

    void cleanup() {
        AbstractWeakHashTable.cleanup(this, this.rqueue);
    }
}

