/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xslt;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeElement;
import gnu.kawa.xslt.XSLT;
import gnu.lists.Consumer;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.InPort;
import gnu.mapping.Symbol;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.xml.XMLParser;
import gnu.xml.XName;
import gnu.xquery.lang.XQParser;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;

public class XslTranslator
extends Lexer
implements Consumer {
    boolean inTemplate;
    Declaration consumerDecl;
    StringBuffer nesting = new StringBuffer(100);
    ModuleExp mexp;
    Compilation comp;
    boolean inAttribute;
    Object attributeType;
    StringBuffer attributeValue = new StringBuffer(100);
    boolean preserveSpace;
    XSLT interpreter;
    InPort in;
    LambdaExp templateLambda;
    static final String XSL_TRANSFORM_URI = "http://www.w3.org/1999/XSL/Transform";
    static final ClassType typeXSLT = ClassType.make("gnu.kawa.xslt.XSLT");
    static final ClassType typeTemplateTable = ClassType.make("gnu.kawa.xslt.TemplateTable");
    static final Method defineTemplateMethod = typeXSLT.getDeclaredMethod("defineTemplate", 5);
    static final Method runStylesheetMethod = typeXSLT.getDeclaredMethod("runStylesheet", 0);
    static final PrimProcedure defineTemplateProc = new PrimProcedure(defineTemplateMethod);
    static final PrimProcedure runStylesheetProc = new PrimProcedure(runStylesheetMethod);
    static final Method applyTemplatesMethod = typeXSLT.getDeclaredMethod("applyTemplates", 2);
    static final PrimProcedure applyTemplatesProc = new PrimProcedure(applyTemplatesMethod);

    XslTranslator(InPort inPort, SourceMessages sourceMessages, XSLT xSLT) {
        super(inPort, sourceMessages);
        this.interpreter = xSLT;
        this.in = inPort;
    }

    void maybeSkipWhitespace() {
        Expression expression;
        if (this.preserveSpace) {
            return;
        }
        int n = this.comp.exprStack.size();
        while (--n >= 0 && (expression = (Expression)this.comp.exprStack.elementAt(n)) instanceof QuoteExp) {
            Object object2 = ((QuoteExp)expression).getValue();
            String string = object2 == null ? "" : object2.toString();
            int n2 = string.length();
            while (--n2 >= 0) {
                char c = string.charAt(n2);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                return;
            }
        }
        this.comp.exprStack.setSize(n + 1);
    }

    public String popMatchingAttribute(String string, String string2, int n) {
        int n2 = this.comp.exprStack.size();
        for (int i = n; i < n2; ++i) {
            Object e = this.comp.exprStack.elementAt(n);
            if (!(e instanceof ApplyExp)) {
                return null;
            }
            ApplyExp applyExp = (ApplyExp)e;
            Expression expression = applyExp.getFunction();
            if (applyExp.getFunction() != MakeAttribute.makeAttributeExp) {
                return null;
            }
            Expression[] expressionArray = applyExp.getArgs();
            if (expressionArray.length != 2) {
                return null;
            }
            Expression expression2 = expressionArray[0];
            if (!(expression2 instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression2).getValue();
            if (!(object2 instanceof Symbol)) {
                return null;
            }
            Symbol symbol = (Symbol)object2;
            if (symbol.getLocalPart() != string2 || symbol.getNamespaceURI() != string) continue;
            this.comp.exprStack.removeElementAt(i);
            return (String)((QuoteExp)expressionArray[1]).getValue();
        }
        return null;
    }

    Expression popTemplateBody(int n) {
        int n2 = this.comp.exprStack.size() - n;
        Expression[] expressionArray = new Expression[n2];
        while (--n2 >= 0) {
            expressionArray[n2] = (Expression)this.comp.exprStack.pop();
        }
        return new ApplyExp(AppendValues.appendValues, expressionArray);
    }

    public static String isXslTag(Object object2) {
        if (object2 instanceof QuoteExp) {
            object2 = ((QuoteExp)object2).getValue();
        }
        if (!(object2 instanceof Symbol)) {
            return null;
        }
        Symbol symbol = (Symbol)object2;
        if (symbol.getNamespaceURI() != XSL_TRANSFORM_URI) {
            return null;
        }
        return symbol.getLocalName();
    }

    void append(Expression expression) {
    }

    public void startElement(Object object2) {
        this.maybeSkipWhitespace();
        String string = XslTranslator.isXslTag(object2);
        if (string == "template") {
            if (this.templateLambda != null) {
                this.error("nested xsl:template");
            }
            this.templateLambda = new LambdaExp();
        } else if (string == "text") {
            this.preserveSpace = false;
        }
        if (object2 instanceof XName) {
            XName xName = (XName)object2;
            object2 = Symbol.make(xName.getNamespaceURI(), xName.getLocalPart(), xName.getPrefix());
        }
        this.nesting.append((char)this.comp.exprStack.size());
        this.push(object2);
    }

    public void startAttribute(Object object2) {
        if (this.inAttribute) {
            this.error('f', "internal error - attribute inside attribute");
        }
        this.attributeType = object2;
        this.attributeValue.setLength(0);
        this.nesting.append((char)this.comp.exprStack.size());
        this.inAttribute = true;
    }

    public void endAttribute() {
        Expression[] expressionArray = new Expression[]{new QuoteExp(this.attributeType), new QuoteExp((Object)this.attributeValue.toString())};
        this.push(new ApplyExp(MakeAttribute.makeAttributeExp, expressionArray));
        this.nesting.setLength(this.nesting.length() - 1);
        this.inAttribute = false;
    }

    public void endElement() {
        this.maybeSkipWhitespace();
        int n = this.nesting.length() - 1;
        char c = this.nesting.charAt(n);
        this.nesting.setLength(n);
        Expression expression = (Expression)this.comp.exprStack.elementAt(c);
        String string = XslTranslator.isXslTag(expression);
        if (string == "value-of") {
            String string2 = this.popMatchingAttribute("", "select", c + '\u0001');
            if (string2 != null) {
                Expression expression2 = this.parseXPath(string2);
                expression2 = new ApplyExp(XQParser.makeText, new Expression[]{expression2});
                this.comp.exprStack.pop();
                this.push(expression2);
                return;
            }
        } else if (string == "copy-of") {
            String string3 = this.popMatchingAttribute("", "select", c + '\u0001');
            if (string3 != null) {
                Expression expression3 = this.parseXPath(string3);
                this.comp.exprStack.pop();
                this.push(expression3);
                return;
            }
        } else if (string == "apply-templates") {
            String string4 = this.popMatchingAttribute("", "select", c + '\u0001');
            String string5 = this.popMatchingAttribute("", "mode", c + '\u0001');
            Expression[] expressionArray = new Expression[]{new QuoteExp((Object)string4), this.resolveQNameExpression(string5)};
            this.comp.exprStack.pop();
            this.push(new ApplyExp(new QuoteExp(applyTemplatesProc), expressionArray));
        } else if (string == "if") {
            String string6 = this.popMatchingAttribute("", "test", c + '\u0001');
            Expression expression4 = this.parseXPath(string6);
            expression4 = XQParser.booleanValue(expression4);
            Expression expression5 = this.popTemplateBody(c + '\u0001');
            this.comp.exprStack.pop();
            this.push(new IfExp(expression4, expression5, QuoteExp.voidExp));
        } else if (string == "stylesheet" || string == "transform") {
            String string7 = this.popMatchingAttribute("", "version", c + '\u0001');
            this.push(new ApplyExp(new QuoteExp(runStylesheetProc), Expression.noExpressions));
            Expression expression6 = this.popTemplateBody(c + '\u0001');
            this.push(expression6);
            this.mexp.body = expression6;
        } else if (string == "template") {
            String string8 = this.popMatchingAttribute("", "match", c + '\u0001');
            String string9 = this.popMatchingAttribute("", "name", c + '\u0001');
            String string10 = this.popMatchingAttribute("", "priority", c + '\u0001');
            String string11 = this.popMatchingAttribute("", "mode", c + '\u0001');
            this.templateLambda.body = this.popTemplateBody(c + '\u0001');
            this.comp.exprStack.pop();
            Expression[] expressionArray = new Expression[5];
            double d = 0.0;
            expressionArray[0] = this.resolveQNameExpression(string9);
            expressionArray[1] = new QuoteExp((Object)string8);
            expressionArray[2] = new QuoteExp(DFloNum.make(d));
            expressionArray[3] = this.resolveQNameExpression(string11);
            expressionArray[4] = this.templateLambda;
            this.push(new ApplyExp(new QuoteExp(defineTemplateProc), expressionArray));
            this.templateLambda = null;
        } else if (string == "text") {
            this.preserveSpace = false;
            Expression[] expressionArray = new Expression[this.comp.exprStack.size() - c - 1];
            int n2 = expressionArray.length;
            while (--n2 >= 0) {
                expressionArray[n2] = (Expression)this.comp.exprStack.pop();
            }
            this.comp.exprStack.pop();
            ApplyExp applyExp = new ApplyExp(XQParser.makeText, expressionArray);
            this.push(applyExp);
            this.mexp.body = applyExp;
        } else {
            Expression[] expressionArray = new Expression[this.comp.exprStack.size() - c];
            int n3 = expressionArray.length;
            while (--n3 >= 0) {
                expressionArray[n3] = (Expression)this.comp.exprStack.pop();
            }
            MakeElement makeElement = new MakeElement();
            ApplyExp applyExp = new ApplyExp(new QuoteExp(makeElement), expressionArray);
            this.push(applyExp);
            this.mexp.body = applyExp;
        }
    }

    Expression parseXPath(String string) {
        SourceMessages sourceMessages = this.comp.getMessages();
        try {
            Expression expression;
            XQParser xQParser = new XQParser(new CharArrayInPort(string), sourceMessages, this.interpreter);
            Vector<Expression> vector = new Vector<Expression>(20);
            while ((expression = xQParser.parse(this.comp)) != null) {
                vector.addElement(expression);
            }
            int n = vector.size();
            if (n == 0) {
                return QuoteExp.voidExp;
            }
            if (n == 1) {
                return (Expression)vector.elementAt(0);
            }
            throw new InternalError("too many xpath expressions");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("caught " + throwable);
        }
    }

    public void write(int n) {
        if (this.inAttribute) {
            this.attributeValue.appendCodePoint(n);
        } else {
            String string;
            if (n < 65536) {
                string = String.valueOf(n);
            } else {
                char[] cArray = new char[]{(char)((n - 65536 >> 10) + 55296), (char)((n & 0x3FF) + 56320)};
                string = new String(cArray);
            }
            this.push(string);
        }
    }

    public Consumer append(char c) {
        if (this.inAttribute) {
            this.attributeValue.append(c);
        } else {
            this.push(String.valueOf(c));
        }
        return this;
    }

    public Consumer append(CharSequence charSequence) {
        if (this.inAttribute) {
            this.attributeValue.append(charSequence);
        } else {
            this.push(((Object)charSequence).toString());
        }
        return this;
    }

    public Consumer append(CharSequence charSequence, int n, int n2) {
        return this.append(charSequence.subSequence(n, n2));
    }

    void push(Expression expression) {
        this.comp.exprStack.push(expression);
    }

    void push(Object object2) {
        this.push(new QuoteExp(object2));
    }

    public void writeBoolean(boolean bl) {
        if (this.inAttribute) {
            this.attributeValue.append(bl);
        } else {
            this.push(bl ? QuoteExp.trueExp : QuoteExp.falseExp);
        }
    }

    public void writeFloat(float f) {
        if (this.inAttribute) {
            this.attributeValue.append(f);
        } else {
            this.push(DFloNum.make(f));
        }
    }

    public void writeDouble(double d) {
        if (this.inAttribute) {
            this.attributeValue.append(d);
        } else {
            this.push(DFloNum.make(d));
        }
    }

    public void writeInt(int n) {
        if (this.inAttribute) {
            this.attributeValue.append(n);
        } else {
            this.push(IntNum.make(n));
        }
    }

    public void writeLong(long l) {
        if (this.inAttribute) {
            this.attributeValue.append(l);
        } else {
            this.push(IntNum.make(l));
        }
    }

    public void startDocument() {
    }

    public void startDocument(ModuleExp moduleExp) {
        this.mexp = moduleExp;
        this.startDocument();
    }

    public void endDocument() {
    }

    public void writeObject(Object object2) {
        if (this.inAttribute) {
            this.attributeValue.append(object2);
        } else {
            this.push(object2);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.inAttribute) {
            this.attributeValue.append(cArray, n, n2);
        } else {
            this.push(new String(cArray, n, n2));
        }
    }

    public void write(String string) {
        if (this.inAttribute) {
            this.attributeValue.append(string);
        } else {
            this.push(string);
        }
    }

    public void write(CharSequence charSequence, int n, int n2) {
        this.write(((Object)charSequence.subSequence(n, n2)).toString());
    }

    public boolean ignoring() {
        return false;
    }

    public Expression getExpression() {
        return (Expression)this.comp.exprStack.pop();
    }

    public void error(char c, String string) {
        this.getMessages().error(c, string);
    }

    Expression resolveQNameExpression(String string) {
        if (string == null) {
            return QuoteExp.nullExp;
        }
        return new QuoteExp(Symbol.make(null, string));
    }

    public void parse(Compilation compilation) throws IOException {
        this.comp = compilation;
        if (compilation.exprStack == null) {
            compilation.exprStack = new Stack();
        }
        ModuleExp moduleExp = compilation.pushNewModule(this);
        compilation.mustCompileHere();
        this.startDocument(moduleExp);
        XMLParser.parse((LineBufferedReader)this.in, this.getMessages(), (Consumer)this);
        this.endDocument();
        compilation.pop(moduleExp);
    }
}

