/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;

public class GapVector
extends AbstractSequence
implements Sequence {
    public SimpleVector base;
    public int gapStart;
    public int gapEnd;

    public GapVector(SimpleVector simpleVector) {
        this.base = simpleVector;
        this.gapStart = 0;
        this.gapEnd = simpleVector.size;
    }

    protected GapVector() {
    }

    public int size() {
        return this.base.size - (this.gapEnd - this.gapStart);
    }

    public boolean hasNext(int n) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        return n2 < this.base.size;
    }

    public int getNextKind(int n) {
        return this.hasNext(n) ? this.base.getElementKind() : 0;
    }

    public Object get(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.base.get(n);
    }

    public Object set(int n, Object object2) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.base.set(n, object2);
    }

    public void fill(Object object2) {
        this.base.fill(this.gapEnd, this.base.size, object2);
        this.base.fill(0, this.gapStart, object2);
    }

    public void fillPosRange(int n, int n2, Object object2) {
        int n3;
        int n4 = n == -1 ? this.base.size : n >>> 1;
        int n5 = n2 == -1 ? this.base.size : n2 >>> 1;
        int n6 = this.gapStart < n5 ? this.gapStart : n5;
        for (n3 = n4; n3 < n6; ++n3) {
            this.base.setBuffer(n3, object2);
        }
        for (n3 = this.gapEnd; n3 < n5; ++n3) {
            this.base.setBuffer(n3, object2);
        }
    }

    protected void shiftGap(int n) {
        int n2 = n - this.gapStart;
        if (n2 > 0) {
            this.base.shift(this.gapEnd, this.gapStart, n2);
        } else if (n2 < 0) {
            this.base.shift(n, this.gapEnd + n2, -n2);
        }
        this.gapEnd += n2;
        this.gapStart = n;
    }

    protected final void gapReserve(int n) {
        this.gapReserve(this.gapStart, n);
    }

    protected void gapReserve(int n, int n2) {
        if (n2 > this.gapEnd - this.gapStart) {
            int n3;
            int n4;
            int n5 = this.base.size;
            int n6 = n5 < 16 ? 16 : 2 * n5;
            if (n6 < (n4 = (n3 = n5 - (this.gapEnd - this.gapStart)) + n2)) {
                n6 = n4;
            }
            int n7 = n6 - n3 + n;
            this.base.resizeShift(this.gapStart, this.gapEnd, n, n7);
            this.gapStart = n;
            this.gapEnd = n7;
        } else if (n != this.gapStart) {
            this.shiftGap(n);
        }
    }

    public int getSegment(int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n > n3) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n + n2 > n3) {
            n2 = n3 - n;
        }
        if (n + n2 <= this.gapStart) {
            return n;
        }
        if (n >= this.gapStart) {
            return n + (this.gapEnd - this.gapStart);
        }
        if (this.gapStart - n > n2 >> 1) {
            this.shiftGap(n + n2);
            return n;
        }
        this.shiftGap(n);
        return n + (this.gapEnd - this.gapStart);
    }

    protected int addPos(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        this.add(n2, object2);
        return n2 + 1 << 1 | 1;
    }

    public void add(int n, Object object2) {
        this.gapReserve(n, 1);
        this.base.set(n, object2);
        ++this.gapStart;
    }

    protected void removePosRange(int n, int n2) {
        n2 >>>= 1;
        if ((n >>>= 1) > this.gapEnd) {
            this.shiftGap(n - this.gapEnd + this.gapStart);
        } else if (n2 < this.gapStart) {
            this.shiftGap(n2);
        }
        if (n < this.gapStart) {
            this.base.clearBuffer(n, this.gapStart - n);
            this.gapStart = n;
        }
        if (n2 > this.gapEnd) {
            this.base.clearBuffer(this.gapEnd, n2 - this.gapEnd);
            this.gapEnd = n2;
        }
    }

    public int createPos(int n, boolean bl) {
        if (n > this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return n << 1 | (bl ? 1 : 0);
    }

    protected boolean isAfterPos(int n) {
        return (n & 1) != 0;
    }

    protected int nextIndex(int n) {
        int n2;
        int n3 = n2 = n == -1 ? this.base.size : n >>> 1;
        if (n2 > this.gapStart) {
            n2 -= this.gapEnd - this.gapStart;
        }
        return n2;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n3 < this.gapStart) {
            int n5 = n4 > this.gapStart ? n4 : this.gapStart;
            this.consumePosRange(n, n5 << 1, consumer);
        }
        if (n4 > this.gapEnd) {
            n3 = n3 < this.gapEnd ? this.gapEnd : n3;
            this.consumePosRange(n3 << 1, n2, consumer);
        }
    }
}

