/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.QuoteExp;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XDataType;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.text.Path;
import gnu.xquery.lang.XQuery;

public class BooleanValue
extends Procedure1
implements CanInline {
    public static final BooleanValue booleanValue = new BooleanValue("boolean-value");

    public BooleanValue(String string) {
        super(string);
    }

    public static boolean booleanValue(Object object2) {
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 instanceof Number && (object2 instanceof RealNum || !(object2 instanceof Numeric))) {
            double d = ((Number)object2).doubleValue();
            return d != 0.0 && !Double.isNaN(d);
        }
        if (object2 instanceof SeqPosition) {
            return true;
        }
        if (object2 instanceof String || object2 instanceof Path || object2 instanceof UntypedAtomic) {
            return object2.toString().length() > 0;
        }
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            Object object3 = values.getPosNext(0);
            if (object3 == Sequence.eofValue) {
                return false;
            }
            int n = values.nextDataIndex(0);
            if (n < 0) {
                return BooleanValue.booleanValue(object3);
            }
            if (object3 instanceof SeqPosition) {
                return true;
            }
        }
        throw new WrongType("fn:boolean", 1, object2, "boolean-convertible-value");
    }

    public static boolean not(Object object2) {
        return !BooleanValue.booleanValue(object2);
    }

    public Object apply1(Object object2) {
        return BooleanValue.booleanValue(object2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 1) {
            Expression expression = expressionArray[0];
            Type type = expression.getType();
            if (type == XDataType.booleanType) {
                return expression;
            }
            if (type == null) {
                applyExp.setType(XDataType.booleanType);
            }
            if (expression instanceof QuoteExp) {
                Object object2 = ((QuoteExp)expression).getValue();
                try {
                    return BooleanValue.booleanValue(object2) ? XQuery.trueExp : XQuery.falseExp;
                }
                catch (Throwable throwable) {
                    String string = "cannot convert to a boolean";
                    inlineCalls.getMessages().error('e', string);
                    return new ErrorExp(string);
                }
            }
        }
        return applyExp;
    }
}

